/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class StringSerializer
extends SimpleTypeSerializer<String> {
    public StringSerializer() {
        super(DataType.STRING);
    }

    @Override
    public String readValue(ByteBuf buffer, GraphBinaryReader context) {
        int length = buffer.readInt();
        return buffer.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    @Override
    public ByteBuf writeValue(String value, ByteBufAllocator allocator, GraphBinaryWriter context) {
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        return allocator.buffer(4 + stringBytes.length).writeInt(stringBytes.length).writeBytes(stringBytes);
    }
}

