/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Year;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class SingleTypeSerializer<T>
extends SimpleTypeSerializer<T> {
    public static final SingleTypeSerializer<Integer> IntSerializer = new SingleTypeSerializer<Integer>(4, DataType.INT, ByteBuf::readInt, (v, b) -> b.writeInt(v.intValue()));
    public static final SingleTypeSerializer<Long> LongSerializer = new SingleTypeSerializer<Long>(8, DataType.LONG, ByteBuf::readLong, (v, b) -> b.writeLong(v.longValue()));
    public static final SingleTypeSerializer<Double> DoubleSerializer = new SingleTypeSerializer<Double>(8, DataType.DOUBLE, ByteBuf::readDouble, (v, b) -> b.writeDouble(v.doubleValue()));
    public static final SingleTypeSerializer<Float> FloatSerializer = new SingleTypeSerializer<Float>(4, DataType.FLOAT, ByteBuf::readFloat, (v, b) -> b.writeFloat(v.floatValue()));
    public static final SingleTypeSerializer<Short> ShortSerializer = new SingleTypeSerializer<Short>(2, DataType.SHORT, ByteBuf::readShort, (v, b) -> b.writeShort((int)v.shortValue()));
    public static final SingleTypeSerializer<Boolean> BooleanSerializer = new SingleTypeSerializer<Boolean>(1, DataType.BOOLEAN, ByteBuf::readBoolean, (v, b) -> b.writeBoolean(v.booleanValue()));
    public static final SingleTypeSerializer<Byte> ByteSerializer = new SingleTypeSerializer<Byte>(1, DataType.BYTE, ByteBuf::readByte, (v, b) -> b.writeByte((int)v.byteValue()));
    public static final SingleTypeSerializer<Year> YearSerializer = new SingleTypeSerializer<Year>(4, DataType.YEAR, bb -> Year.of(bb.readInt()), (v, b) -> b.writeInt(v.getValue()));
    private final int byteLength;
    private final Function<ByteBuf, T> readFunc;
    private final BiConsumer<T, ByteBuf> writeFunc;

    private SingleTypeSerializer(int byteLength, DataType dataType, Function<ByteBuf, T> readFunc, BiConsumer<T, ByteBuf> writeFunc) {
        super(dataType);
        this.byteLength = byteLength;
        this.readFunc = readFunc;
        this.writeFunc = writeFunc;
    }

    @Override
    public T readValue(ByteBuf buffer, GraphBinaryReader context) {
        return this.readFunc.apply(buffer);
    }

    @Override
    public ByteBuf writeValue(T value, ByteBufAllocator allocator, GraphBinaryWriter context) {
        ByteBuf buffer = allocator.buffer(this.byteLength);
        this.writeFunc.accept(value, buffer);
        return buffer;
    }
}

