/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class OffsetTimeSerializer
extends SimpleTypeSerializer<OffsetTime> {
    public OffsetTimeSerializer() {
        super(DataType.OFFSETTIME);
    }

    @Override
    OffsetTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        LocalTime ldt = context.readValue(buffer, LocalTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return OffsetTime.of(ldt, zo);
    }

    @Override
    public ByteBuf writeValue(OffsetTime value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        CompositeByteBuf result = allocator.compositeBuffer(2);
        result.addComponent(true, context.writeValue(value.toLocalTime(), allocator, false));
        result.addComponent(true, context.writeValue(value.getOffset(), allocator, false));
        return result;
    }
}

