/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class GraphSerializer
extends SimpleTypeSerializer<Graph> {
    private static final Method openMethod = GraphSerializer.detectGraphOpenMethod();

    public GraphSerializer() {
        super(DataType.GRAPH);
    }

    @Override
    Graph readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        if (null == openMethod) {
            throw new SerializationException("TinkerGraph is an optional dependency to gremlin-driver - if deserializing Graph instances it must be explicitly added as a dependency");
        }
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("gremlin.tinkergraph.defaultVertexPropertyCardinality", (Object)"list");
        try {
            Graph graph = (Graph)openMethod.invoke(null, conf);
            int vertexCount = context.readValue(buffer, Integer.class, false);
            for (int ix = 0; ix < vertexCount; ++ix) {
                Vertex v = graph.addVertex(new Object[]{T.id, context.read(buffer), T.label, context.readValue(buffer, String.class, false)});
                int vertexPropertyCount = context.readValue(buffer, Integer.class, false);
                for (int iy = 0; iy < vertexPropertyCount; ++iy) {
                    Object id = context.read(buffer);
                    String label = context.readValue(buffer, String.class, false);
                    Object val = context.read(buffer);
                    context.read(buffer);
                    VertexProperty vp = v.property(VertexProperty.Cardinality.list, label, val, new Object[]{T.id, id});
                    List edgeProperties = context.readValue(buffer, ArrayList.class, false);
                    for (Property p : edgeProperties) {
                        vp.property(p.key(), p.value());
                    }
                }
            }
            int edgeCount = context.readValue(buffer, Integer.class, false);
            for (int ix = 0; ix < edgeCount; ++ix) {
                Object id = context.read(buffer);
                String label = context.readValue(buffer, String.class, false);
                Object inId = context.read(buffer);
                Vertex inV = (Vertex)graph.vertices(new Object[]{inId}).next();
                context.read(buffer);
                Object outId = context.read(buffer);
                Vertex outV = (Vertex)graph.vertices(new Object[]{outId}).next();
                context.read(buffer);
                context.read(buffer);
                Edge e = outV.addEdge(label, inV, new Object[]{T.id, id});
                List edgeProperties = context.readValue(buffer, ArrayList.class, false);
                for (Property p : edgeProperties) {
                    e.property(p.key(), p.value());
                }
            }
            return graph;
        }
        catch (Exception ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf writeValue(Graph value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        List vertexList = IteratorUtils.list((Iterator)value.vertices(new Object[0]));
        List edgeList = IteratorUtils.list((Iterator)value.edges(new Object[0]));
        CompositeByteBuf result = allocator.compositeBuffer(2 + edgeList.size() + vertexList.size());
        result.addComponent(true, context.writeValue(vertexList.size(), allocator, false));
        for (Vertex v : vertexList) {
            List vertexProperties = IteratorUtils.list((Iterator)v.properties(new String[0]));
            CompositeByteBuf vbb = allocator.compositeBuffer(3 + vertexProperties.size());
            vbb.addComponent(true, context.write(v.id(), allocator));
            vbb.addComponent(true, context.writeValue(v.label(), allocator, false));
            vbb.addComponent(true, context.writeValue(vertexProperties.size(), allocator, false));
            for (VertexProperty vp : vertexProperties) {
                CompositeByteBuf vpbb = allocator.compositeBuffer(5);
                vpbb.addComponent(true, context.write(vp.id(), allocator));
                vpbb.addComponent(true, context.writeValue(vp.label(), allocator, false));
                vpbb.addComponent(true, context.write(vp.value(), allocator));
                vpbb.addComponent(true, context.write(null, allocator));
                vpbb.addComponent(true, context.writeValue(IteratorUtils.list((Iterator)vp.properties(new String[0])), allocator, false));
                vbb.addComponent(true, (ByteBuf)vpbb);
            }
            result.addComponent(true, (ByteBuf)vbb);
        }
        result.addComponent(true, context.writeValue(edgeList.size(), allocator, false));
        for (Edge e : edgeList) {
            CompositeByteBuf ebb = allocator.compositeBuffer(8);
            ebb.addComponent(true, context.write(e.id(), allocator));
            ebb.addComponent(true, context.writeValue(e.label(), allocator, false));
            ebb.addComponent(true, context.write(e.inVertex().id(), allocator));
            ebb.addComponent(true, context.write(null, allocator));
            ebb.addComponent(true, context.write(e.outVertex().id(), allocator));
            ebb.addComponent(true, context.write(null, allocator));
            ebb.addComponent(true, context.write(null, allocator));
            ebb.addComponent(true, context.writeValue(IteratorUtils.list((Iterator)e.properties(new String[0])), allocator, false));
            result.addComponent(true, (ByteBuf)ebb);
        }
        return result;
    }

    private static Map<String, List<VertexProperty>> indexedVertexProperties(Vertex v) {
        HashMap<String, List<VertexProperty>> index = new HashMap<String, List<VertexProperty>>();
        v.properties(new String[0]).forEachRemaining(vp -> {
            if (!index.containsKey(vp.key())) {
                index.put(vp.key(), new ArrayList());
            }
            ((List)index.get(vp.key())).add(vp);
        });
        return index;
    }

    private static Method detectGraphOpenMethod() {
        Class<?> graphClazz = GraphSerializer.detectTinkerGraph();
        if (null == graphClazz) {
            return null;
        }
        try {
            return graphClazz.getMethod("open", Configuration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException(nsme);
        }
    }

    private static Class<?> detectTinkerGraph() {
        try {
            return Class.forName("org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }
}

