/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class EnumSerializer<E extends Enum>
extends SimpleTypeSerializer<E> {
    public static final EnumSerializer<SackFunctions.Barrier> BarrierSerializer = new EnumSerializer<SackFunctions.Barrier>(DataType.BARRIER, SackFunctions.Barrier::valueOf);
    public static final EnumSerializer<VertexProperty.Cardinality> CardinalitySerializer = new EnumSerializer<VertexProperty.Cardinality>(DataType.CARDINALITY, VertexProperty.Cardinality::valueOf);
    public static final EnumSerializer<Column> ColumnSerializer = new EnumSerializer<Column>(DataType.COLUMN, Column::valueOf);
    public static final EnumSerializer<Direction> DirectionSerializer = new EnumSerializer<Direction>(DataType.DIRECTION, Direction::valueOf);
    public static final EnumSerializer<Operator> OperatorSerializer = new EnumSerializer<Operator>(DataType.OPERATOR, Operator::valueOf);
    public static final EnumSerializer<Order> OrderSerializer = new EnumSerializer<Order>(DataType.ORDER, Order::valueOf);
    public static final EnumSerializer<TraversalOptionParent.Pick> PickSerializer = new EnumSerializer<TraversalOptionParent.Pick>(DataType.PICK, TraversalOptionParent.Pick::valueOf);
    public static final EnumSerializer<Pop> PopSerializer = new EnumSerializer<Pop>(DataType.POP, Pop::valueOf);
    public static final EnumSerializer<Scope> ScopeSerializer = new EnumSerializer<Scope>(DataType.SCOPE, Scope::valueOf);
    public static final EnumSerializer<T> TSerializer = new EnumSerializer<T>(DataType.T, T::valueOf);
    private final Function<String, E> readFunc;

    private EnumSerializer(DataType dataType, Function<String, E> readFunc) {
        super(dataType);
        this.readFunc = readFunc;
    }

    @Override
    E readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return (E)((Enum)this.readFunc.apply((String)context.read(buffer)));
    }

    @Override
    public ByteBuf writeValue(E value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        return context.write(((Enum)value).name(), allocator);
    }
}

