/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;

public class BulkSetSerializer
extends SimpleTypeSerializer<BulkSet> {
    public BulkSetSerializer() {
        super(DataType.BULKSET);
    }

    @Override
    BulkSet readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        BulkSet result = new BulkSet();
        for (int i = 0; i < length; ++i) {
            result.add(context.read(buffer), buffer.readLong());
        }
        return result;
    }

    @Override
    public ByteBuf writeValue(BulkSet value, ByteBufAllocator allocator, GraphBinaryWriter context) throws SerializationException {
        Map raw = value.asBulk();
        CompositeByteBuf result = allocator.compositeBuffer(1 + raw.size() * 2);
        result.addComponent(true, allocator.buffer(4).writeInt(raw.size()));
        for (Object key : raw.keySet()) {
            result.addComponents(true, new ByteBuf[]{context.write(key, allocator), allocator.buffer(8).writeLong(value.get(key))});
        }
        return result;
    }
}

