/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.repl.ConstructorCleaner;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.apache.xbean.asm5.ClassReader;
import org.apache.xbean.asm5.ClassVisitor;
import org.apache.xbean.asm5.ClassWriter;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001-\u00111#\u0012=fGV$xN]\"mCN\u001cHj\\1eKJT!a\u0001\u0003\u0002\tI,\u0007\u000f\u001c\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!aC\"mCN\u001cHj\\1eKJ\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003\u000f1{wmZ5oO\"A\u0011\u0004\u0001B\u0001B\u0003%!$\u0001\u0003d_:4\u0007CA\u000b\u001c\u0013\taBAA\u0005Ta\u0006\u00148nQ8oM\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\u0005dY\u0006\u001c8/\u0016:j!\t\u0001cE\u0004\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O!\u0012aa\u0015;sS:<'BA\u0013#\u0011!Q\u0003A!A!\u0002\u0013a\u0011A\u00029be\u0016tG\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003I)8/\u001a:DY\u0006\u001c8\u000fU1uQ\u001aK'o\u001d;\u0011\u0005\u0005r\u0013BA\u0018#\u0005\u001d\u0011un\u001c7fC:DQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD#B\u001a6m]B\u0004C\u0001\u001b\u0001\u001b\u0005\u0011\u0001\"B\r1\u0001\u0004Q\u0002\"\u0002\u00101\u0001\u0004y\u0002\"\u0002\u00161\u0001\u0004a\u0001\"\u0002\u00171\u0001\u0004i\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\u0004kJLW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0002\u0012a\u00018fi&\u0011\u0011I\u0010\u0002\u0004+JK\u0005BB\"\u0001A\u0003%A(\u0001\u0003ve&\u0004\u0003bB#\u0001\u0005\u0004%\tAR\u0001\nI&\u0014Xm\u0019;pef,\u0012a\u0012\t\u0003\u001b!K!a\n\b\t\r)\u0003\u0001\u0015!\u0003H\u0003)!\u0017N]3di>\u0014\u0018\u0010\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u00031\u0001\u0018M]3oi2{\u0017\rZ3s+\u0005q\u0005CA(S\u001b\u0005\u0001&BA)\u0005\u0003\u0011)H/\u001b7\n\u0005M\u0003&!\u0005)be\u0016tGo\u00117bgNdu.\u00193fe\"1Q\u000b\u0001Q\u0001\n9\u000bQ\u0002]1sK:$Hj\\1eKJ\u0004\u0003\u0002C,\u0001\u0001\u0004%\tA\u0001-\u0002=!$H\u000f]+sY\u000e{gN\\3di&|g\u000eV5nK>,H/T5mY&\u001cX#A-\u0011\u0005\u0005R\u0016BA.#\u0005\rIe\u000e\u001e\u0005\t;\u0002\u0001\r\u0011\"\u0001\u0003=\u0006\u0011\u0003\u000e\u001e;q+Jd7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;NS2d\u0017n]0%KF$\"a\u00182\u0011\u0005\u0005\u0002\u0017BA1#\u0005\u0011)f.\u001b;\t\u000f\rd\u0016\u0011!a\u00013\u0006\u0019\u0001\u0010J\u0019\t\r\u0015\u0004\u0001\u0015)\u0003Z\u0003}AG\u000f\u001e9Ve2\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^'jY2L7\u000f\t\u0005\bO\u0002\u0001\r\u0011\"\u0001i\u0003)1\u0017\u000e\\3TsN$X-\\\u000b\u0002SB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0003MNT!A\u001c\u0004\u0002\r!\fGm\\8q\u0013\t\u00018N\u0001\u0006GS2,7+_:uK6DqA\u001d\u0001A\u0002\u0013\u00051/\u0001\bgS2,7+_:uK6|F%Z9\u0015\u0005}#\bbB2r\u0003\u0003\u0005\r!\u001b\u0005\u0007m\u0002\u0001\u000b\u0015B5\u0002\u0017\u0019LG.Z*zgR,W\u000e\t\u0005\u0006q\u0002!\t%_\u0001\fO\u0016$(+Z:pkJ\u001cW\r\u0006\u0002{{B\u0011Qh_\u0005\u0003yz\u00121!\u0016*M\u0011\u0015qx\u000f1\u0001 \u0003\u0011q\u0017-\\3\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004\u0005aq-\u001a;SKN|WO]2fgR!\u0011QAA\b!\u0015\t9!a\u0003{\u001b\t\tIA\u0003\u0002R!%!\u0011QBA\u0005\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000by|\b\u0019A\u0010\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\u0005Ia-\u001b8e\u00072\f7o\u001d\u000b\u0005\u0003/\t)\u0004\r\u0003\u0002\u001a\u0005\r\u0002#\u0002\u0011\u0002\u001c\u0005}\u0011bAA\u000fQ\t)1\t\\1tgB!\u0011\u0011EA\u0012\u0019\u0001!A\"!\n\u0002\u0012\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00132#\u0011\tI#a\f\u0011\u0007\u0005\nY#C\u0002\u0002.\t\u0012qAT8uQ&tw\rE\u0002\"\u0003cI1!a\r#\u0005\r\te.\u001f\u0005\u0007}\u0006E\u0001\u0019A\u0010\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005)s-\u001a;DY\u0006\u001c8OR5mK&s\u0007/\u001e;TiJ,\u0017-\u001c$s_6DE\u000f\u001e9TKJ4XM\u001d\u000b\u0005\u0003{\tI\u0005\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005E\u0001\u0003S>LA!a\u0012\u0002B\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\tY%a\u000eA\u0002}\tq\u0002]1uQ&sG)\u001b:fGR|'/\u001f\u0005\b\u0003\u001f\u0002A\u0011BA)\u0003\u0015:W\r^\"mCN\u001ch)\u001b7f\u0013:\u0004X\u000f^*ue\u0016\fWN\u0012:p[\u001aKG.Z*zgR,W\u000e\u0006\u0003\u0002>\u0005M\u0003bBA&\u0003\u001b\u0002\ra\b\u0005\b\u0003/\u0002A\u0011AA-\u0003A1\u0017N\u001c3DY\u0006\u001c8\u000fT8dC2d\u0017\u0010\u0006\u0003\u0002\\\u0005-\u0004#B\u0011\u0002^\u0005\u0005\u0014bAA0E\t1q\n\u001d;j_:\u0004D!a\u0019\u0002hA)\u0001%a\u0007\u0002fA!\u0011\u0011EA4\t1\tI'!\u0016\u0002\u0002\u0003\u0005)\u0011AA\u0014\u0005\ryFE\r\u0005\u0007}\u0006U\u0003\u0019A\u0010\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005)\"/Z1e\u0003:$GK]1og\u001a|'/\\\"mCN\u001cHCBA:\u0003\u007f\n\t\tE\u0003\"\u0003k\nI(C\u0002\u0002x\t\u0012Q!\u0011:sCf\u00042!IA>\u0013\r\tiH\t\u0002\u0005\u0005f$X\r\u0003\u0004\u007f\u0003[\u0002\ra\b\u0005\t\u0003\u0007\u000bi\u00071\u0001\u0002>\u0005\u0011\u0011N\u001c\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003%)(\u000f\\#oG>$W\rF\u0002 \u0003\u0017Cq!!$\u0002\u0006\u0002\u0007q$A\u0002tiJ\u0004")
public class ExecutorClassLoader
extends ClassLoader
implements Logging {
    private final String classUri;
    private final boolean userClassPathFirst;
    private final URI uri;
    private final String directory;
    private final ParentClassLoader parentLoader;
    private int httpUrlConnectionTimeoutMillis;
    private FileSystem fileSystem;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public URI uri() {
        return this.uri;
    }

    public String directory() {
        return this.directory;
    }

    public ParentClassLoader parentLoader() {
        return this.parentLoader;
    }

    public int httpUrlConnectionTimeoutMillis() {
        return this.httpUrlConnectionTimeoutMillis;
    }

    public void httpUrlConnectionTimeoutMillis_$eq(int x$1) {
        this.httpUrlConnectionTimeoutMillis = x$1;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public void fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    @Override
    public URL getResource(String name) {
        return this.parentLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.parentLoader().getResources(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> findClass(String name) {
        Class clazz;
        boolean bl = this.userClassPathFirst;
        if (bl) {
            return (Class)this.findClassLocally(name).getOrElse((Function0)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorClassLoader $outer;
                private final String name$1;

                public final Class<Object> apply() {
                    return this.$outer.parentLoader().loadClass(this.name$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.name$1 = name$1;
                }
            });
        }
        if (false != bl) throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        try {
            clazz = this.parentLoader().loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class a;
            Class clazz3;
            Option<Class<?>> classOption;
            Option<Class<?>> option = classOption = this.findClassLocally(name);
            None$ none$ = None$.MODULE$;
            Option<Class<?>> option2 = option;
            if (none$ == null) {
                if (option2 == null) throw new ClassNotFoundException(name);
            } else if (none$.equals(option2)) {
                throw new ClassNotFoundException(name);
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            clazz = clazz3 = (a = (Class)some.x());
        }
        return clazz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream getClassFileInputStreamFromHttpServer(String pathInDirectory) {
        URL uRL;
        if (SparkEnv$.MODULE$.get().securityManager().isAuthenticationEnabled()) {
            URI uri = new URI(new StringBuilder().append((Object)this.classUri).append((Object)"/").append((Object)this.urlEncode(pathInDirectory)).toString());
            URI newuri = Utils$.MODULE$.constructURIForAuthentication(uri, SparkEnv$.MODULE$.get().securityManager());
            uRL = newuri.toURL();
        } else {
            uRL = new URL(new StringBuilder().append((Object)this.classUri).append((Object)"/").append((Object)this.urlEncode(pathInDirectory)).toString());
        }
        URL url = uRL;
        HttpURLConnection connection = (HttpURLConnection)Utils$.MODULE$.setupSecureURLConnection(url.openConnection(), SparkEnv$.MODULE$.get().securityManager());
        if (this.httpUrlConnectionTimeoutMillis() != -1) {
            connection.setConnectTimeout(this.httpUrlConnectionTimeoutMillis());
            connection.setReadTimeout(this.httpUrlConnectionTimeoutMillis());
        }
        connection.connect();
        try {
            if (connection.getResponseCode() == 200) return connection.getInputStream();
            try {
                connection.getErrorStream().close();
                throw new ClassNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class file not found at URL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
            }
            catch (IOException iOException) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Exception while closing error stream";
                    }
                }, iOException);
            }
            throw new ClassNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class file not found at URL ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        }
        catch (Throwable throwable) {
            Throwable e;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || (e = (Throwable)option.get()) instanceof ClassNotFoundException) {
                throw throwable;
            }
            connection.disconnect();
            throw e;
        }
    }

    private InputStream getClassFileInputStreamFromFileSystem(String pathInDirectory) {
        Path path = new Path(this.directory(), pathInDirectory);
        if (this.fileSystem().exists(path)) {
            return this.fileSystem().open(path);
        }
        throw new ClassNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class file not found at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
    }

    /*
     * Loose catch block
     */
    public Option<Class<?>> findClassLocally(String name) {
        None$ none$;
        block18: {
            Some some;
            block16: {
                None$ none$2;
                String pathInDirectory = new StringBuilder().append((Object)name.replace('.', '/')).append((Object)".class").toString();
                InputStream inputStream = null;
                inputStream = this.fileSystem() == null ? this.getClassFileInputStreamFromHttpServer(pathInDirectory) : this.getClassFileInputStreamFromFileSystem(pathInDirectory);
                byte[] bytes = this.readAndTransformClass(name, inputStream);
                some = new Some(this.defineClass(name, bytes, 0, bytes.length));
                if (inputStream == null) break block16;
                inputStream.close();
                catch (Exception exception) {
                    None$ none$3;
                    block17: {
                        this.logError((Function0<String>)new Serializable(this, name){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ExecutorClassLoader $outer;
                            private final String name$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to check existence of class ", " on REPL class server at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.$outer.uri()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.name$2 = name$2;
                            }
                        }, exception);
                        none$3 = None$.MODULE$;
                        if (inputStream == null) break block17;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {
                            this.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Exception while closing inputStream";
                                }
                            }, exception2);
                        }
                    }
                    none$ = none$3;
                    break block18;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logDebug((Function0<String>)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ExecutorClassLoader $outer;
                        private final String name$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not load class ", " from REPL class server at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2, this.$outer.uri()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.name$2 = name$2;
                        }
                    }, classNotFoundException);
                    none$2 = None$.MODULE$;
                    {
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Exception exception2) {
                                    this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                None$ none$4 = none$2;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                    }
                }
                none$ = none$4;
                break block18;
                catch (Exception exception) {
                    this.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                }
            }
            none$ = some;
        }
        return none$;
    }

    public byte[] readAndTransformClass(String name, InputStream in) {
        if (name.startsWith("line") && name.endsWith("$iw$")) {
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(3);
            ConstructorCleaner cleaner = new ConstructorCleaner(name, (ClassVisitor)cw);
            cr.accept((ClassVisitor)cleaner, 0);
            return cw.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        boolean done = false;
        while (!done) {
            int num = in.read(bytes);
            if (num >= 0) {
                bos.write(bytes, 0, num);
                continue;
            }
            done = true;
        }
        return bos.toByteArray();
    }

    public String urlEncode(String str) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('/')).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String part) {
                return URLEncoder.encode(part, "UTF-8");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("/");
    }

    public ExecutorClassLoader(SparkConf conf, String classUri, ClassLoader parent, boolean userClassPathFirst) {
        this.classUri = classUri;
        this.userClassPathFirst = userClassPathFirst;
        Logging.class.$init$((Logging)this);
        this.uri = new URI(classUri);
        this.directory = this.uri().getPath();
        this.parentLoader = new ParentClassLoader(parent);
        this.httpUrlConnectionTimeoutMillis = -1;
        this.fileSystem = ((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http", "https", "ftp"}))).contains((Object)this.uri().getScheme()) ? null : FileSystem.get((URI)this.uri(), (Configuration)SparkHadoopUtil$.MODULE$.get().newConfiguration(conf));
    }
}

