/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\t'\u00064X-\u00192mK\"Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\no>\u0014H-\u00138eKb,\u0012\u0001\t\t\u0005C\u0011:#F\u0004\u0002\u0010E%\u00111\u0005E\u0001\u0007!J,G-\u001a4\n\u0005\u00152#aA'ba*\u00111\u0005\u0005\t\u0003C!J!!\u000b\u0014\u0003\rM#(/\u001b8h!\ty1&\u0003\u0002-!\t\u0019\u0011J\u001c;\t\u00119\u0002!\u0011!Q\u0001\n\u0001\n!b^8sI&sG-\u001a=!\u0011%\u0001\u0004A!b\u0001\n\u00031\u0011'A\u0006x_J$g+Z2u_J\u001cX#\u0001\u001a\u0011\u0007=\u0019T'\u0003\u00025!\t)\u0011I\u001d:bsB\u0011qBN\u0005\u0003oA\u0011QA\u00127pCRD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAM\u0001\ro>\u0014HMV3di>\u00148\u000f\t\u0005\u0007w\u0001!\tA\u0002\u001f\u0002\rqJg.\u001b;?)\rit\b\u0011\t\u0003}\u0001i\u0011A\u0001\u0005\u0006=i\u0002\r\u0001\t\u0005\u0006ai\u0002\rA\r\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0003!qW/\\,pe\u0012\u001cX#\u0001\u0016\t\r\u0015\u0003\u0001\u0015!\u0003+\u0003%qW/\\,pe\u0012\u001c\b\u0005C\u0004H\u0001\t\u0007I\u0011B\"\u0002\u0015Y,7\r^8s'&TX\r\u0003\u0004J\u0001\u0001\u0006IAK\u0001\fm\u0016\u001cGo\u001c:TSj,\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0011]|'\u000f\u001a'jgR,\u0012!\u0014\t\u0004\u001fM:\u0003BB(\u0001A\u0003%Q*A\u0005x_J$G*[:uA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001D<pe\u00124Vm\u0019(pe6\u001cX#A*\u0011\u0007=\u0019D\u000b\u0005\u0002\u0010+&\u0011a\u000b\u0005\u0002\u0007\t>,(\r\\3\t\ra\u0003\u0001\u0015!\u0003T\u000359xN\u001d3WK\u000etuN]7tA!)1\b\u0001C\u00015R\u0011Qh\u0017\u0005\u00069f\u0003\r!X\u0001\u0006[>$W\r\u001c\t\u0005C\u0011:#\u0007K\u0002Z?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002eC\n)1+\u001b8dK\u0006\na-A\u00032]Ur\u0003\u0007C\u0003i\u0001\u0011%\u0011.\u0001\td_NLg.Z*j[&d\u0017M]5usR\u0019AK\u001b7\t\u000b-<\u0007\u0019\u0001\u001a\u0002\u0005Y\f\u0004\"B7h\u0001\u0004\u0011\u0014A\u0001<3\u0011\u0015y\u0007\u0001\"\u0015q\u000351wN]7biZ+'o]5p]V\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!!K:\t\u000be\u0004A\u0011\u0001>\u0002\tM\fg/\u001a\u000b\u0005wz\fI\u0001\u0005\u0002\u0010y&\u0011Q\u0010\u0005\u0002\u0005+:LG\u000f\u0003\u0004\u0000q\u0002\u0007\u0011\u0011A\u0001\u0003g\u000e\u0004B!a\u0001\u0002\u00065\ta!C\u0002\u0002\b\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRDa!a\u0003y\u0001\u00049\u0013\u0001\u00029bi\"DC\u0001_0\u0002\u0010\u0005\u0012\u0011\u0011C\u0001\u0006c9\"d\u0006\r\u0005\b\u0003+\u0001A\u0011AA\f\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002\u001a\u0005\u0015\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}A!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003G\tiB\u0001\u0004WK\u000e$xN\u001d\u0005\b\u0003O\t\u0019\u00021\u0001(\u0003\u00119xN\u001d3)\u000b\u0005Mq,a\u000b\"\u0005\u00055\u0012!B\u0019/c9\u0002\u0004bBA\u0019\u0001\u0011\u0005\u00111G\u0001\rM&tGmU=o_:LXn\u001d\u000b\u0007\u0003k\ti$a\u0010\u0011\t=\u0019\u0014q\u0007\t\u0006\u001f\u0005er\u0005V\u0005\u0004\u0003w\u0001\"A\u0002+va2,'\u0007C\u0004\u0002(\u0005=\u0002\u0019A\u0014\t\u000f\u0005\u0005\u0013q\u0006a\u0001U\u0005\u0019a.^7)\u000b\u0005=r,a\u000b\t\u000f\u0005E\u0002\u0001\"\u0001\u0002HQ1\u0011QGA%\u0003\u001bB\u0001\"a\u0013\u0002F\u0001\u0007\u0011\u0011D\u0001\u0007m\u0016\u001cGo\u001c:\t\u000f\u0005\u0005\u0013Q\ta\u0001U!*\u0011QI0\u0002,!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013AC4fiZ+7\r^8sgV\tQ\fK\u0003\u0002R}\u000bI&\t\u0002\u0002\\\u0005)\u0011G\f\u001a/a!\"\u0001aXA\u0016\u000f\u001d\t\tG\u0001E\u0001\u0003G\nQbV8sIJ2VmY'pI\u0016d\u0007c\u0001 \u0002f\u00191\u0011A\u0001E\u0001\u0003O\u001ab!!\u001a\u000f\u0003S\"\u0002\u0003\u0002\r\u0002luJ1!!\u001c\u001a\u0005\u0019au.\u00193fe\"91(!\u001a\u0005\u0002\u0005EDCAA2\u0011!\t)(!\u001a\u0005\n\u0005]\u0014A\u00042vS2$wk\u001c:e\u0013:$W\r\u001f\u000b\u0004A\u0005e\u0004B\u0002/\u0002t\u0001\u0007Q\f\u0003\u0005\u0002~\u0005\u0015D\u0011BA@\u0003A\u0011W/\u001b7e/>\u0014HMV3di>\u00148\u000fF\u00023\u0003\u0003Ca\u0001XA>\u0001\u0004iv\u0001CAC\u0003KBI!a\"\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\t\u0005%\u00151R\u0007\u0003\u0003K2\u0001\"!$\u0002f!%\u0011q\u0012\u0002\r'\u00064X\rT8bIZ\u000bt\fM\n\u0004\u0003\u0017s\u0001bB\u001e\u0002\f\u0012\u0005\u00111\u0013\u000b\u0003\u0003\u000fC\u0011\"a&\u0002\f\n\u0007I\u0011\u00019\u0002#\u0019|'/\\1u-\u0016\u00148/[8o-Fz\u0006\u0007\u0003\u0005\u0002\u001c\u0006-\u0005\u0015!\u0003r\u0003I1wN]7biZ+'o]5p]Z\u000bt\f\r\u0011\t\u0013\u0005}\u00151\u0012b\u0001\n\u0003\u0001\u0018!D2mCN\u001ch*Y7f-Fz\u0006\u0007\u0003\u0005\u0002$\u0006-\u0005\u0015!\u0003r\u00039\u0019G.Y:t\u001d\u0006lWMV\u0019`a\u00012q!a*\u0002\f\u0002\u000bIK\u0001\u0003ECR\f7CBAS\u001d\u0005-F\u0003E\u0002\u0010\u0003[K1!a,\u0011\u0005\u001d\u0001&o\u001c3vGRD1\"a\n\u0002&\nU\r\u0011\"\u0001\u00024V\tq\u0005\u0003\u0006\u00028\u0006\u0015&\u0011#Q\u0001\n\u001d\nQa^8sI\u0002B!\"a\u0013\u0002&\nU\r\u0011\"\u00012\u0011)\ti,!*\u0003\u0012\u0003\u0006IAM\u0001\bm\u0016\u001cGo\u001c:!\u0011\u001dY\u0014Q\u0015C\u0001\u0003\u0003$b!a1\u0002H\u0006%\u0007\u0003BAc\u0003Kk!!a#\t\u000f\u0005\u001d\u0012q\u0018a\u0001O!9\u00111JA`\u0001\u0004\u0011\u0004BCAg\u0003K\u000b\t\u0011\"\u0001\u0002P\u0006!1m\u001c9z)\u0019\t\u0019-!5\u0002T\"I\u0011qEAf!\u0003\u0005\ra\n\u0005\n\u0003\u0017\nY\r%AA\u0002IB!\"a6\u0002&F\u0005I\u0011AAm\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a7+\u0007\u001d\nin\u000b\u0002\u0002`B!\u0011\u0011]Au\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018!C;oG\",7m[3e\u0015\t\u0011\u0007#\u0003\u0003\u0002l\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011q^AS#\u0003%\t!!=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001f\u0016\u0004e\u0005u\u0007\"CA|\u0003K\u000b\t\u0011\"\u0011q\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\"I\u00111`AS\u0003\u0003%\taQ\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003\u007f\f)+!A\u0005\u0002\t\u0005\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u0007\u0011I\u0001E\u0002\u0010\u0005\u000bI1Aa\u0002\u0011\u0005\r\te.\u001f\u0005\n\u0005\u0017\ti0!AA\u0002)\n1\u0001\u001f\u00132\u0011)\u0011y!!*\u0002\u0002\u0013\u0005#\u0011C\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0003\t\u0007\u0005+\u0011YBa\u0001\u000e\u0005\t]!b\u0001B\r!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tu!q\u0003\u0002\t\u0013R,'/\u0019;pe\"Q!\u0011EAS\u0003\u0003%\tAa\t\u0002\u0011\r\fg.R9vC2$BA!\n\u0003,A\u0019qBa\n\n\u0007\t%\u0002CA\u0004C_>dW-\u00198\t\u0015\t-!qDA\u0001\u0002\u0004\u0011\u0019\u0001\u0003\u0006\u00030\u0005\u0015\u0016\u0011!C!\u0005c\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002U!Q!QGAS\u0003\u0003%\tEa\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001d\u0005\u000b\u0005w\t)+!A\u0005B\tu\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003&\t}\u0002B\u0003B\u0006\u0005s\t\t\u00111\u0001\u0003\u0004\u001dQ!1IAF\u0003\u0003E\tA!\u0012\u0002\t\u0011\u000bG/\u0019\t\u0005\u0003\u000b\u00149E\u0002\u0006\u0002(\u0006-\u0015\u0011!E\u0001\u0005\u0013\u001aRAa\u0012\u0003LQ\u0001\u0002B!\u0014\u0003T\u001d\u0012\u00141Y\u0007\u0003\u0005\u001fR1A!\u0015\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0016\u0003P\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fm\u00129\u0005\"\u0001\u0003ZQ\u0011!Q\t\u0005\u000b\u0005k\u00119%!A\u0005F\t]\u0002B\u0003B0\u0005\u000f\n\t\u0011\"!\u0003b\u0005)\u0011\r\u001d9msR1\u00111\u0019B2\u0005KBq!a\n\u0003^\u0001\u0007q\u0005C\u0004\u0002L\tu\u0003\u0019\u0001\u001a\t\u0015\t%$qIA\u0001\n\u0003\u0013Y'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5$Q\u000f\t\u0006\u001f\t=$1O\u0005\u0004\u0005c\u0002\"AB(qi&|g\u000eE\u0003\u0010\u0003s9#\u0007\u0003\u0006\u0003x\t\u001d\u0014\u0011!a\u0001\u0003\u0007\f1\u0001\u001f\u00131\u0011)\u0011YHa\u0012\u0002\u0002\u0013%!QP\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0000A\u0019!O!!\n\u0007\t\r5O\u0001\u0004PE*,7\r\u001e\u0005\t\u0005\u000f\u000bY\t\"\u0001\u0003\n\u0006!An\\1e)\u0015i$1\u0012BG\u0011\u001dy(Q\u0011a\u0001\u0003\u0003Aq!a\u0003\u0003\u0006\u0002\u0007q\u0005C\u0004z\u0003\u0017#\tA!%\u0015\u000fm\u0014\u0019J!&\u0003\u0018\"9qPa$A\u0002\u0005\u0005\u0001bBA\u0006\u0005\u001f\u0003\ra\n\u0005\u00079\n=\u0005\u0019A/\t\u0011\t\u001d\u0015Q\rC!\u00057#R!\u0010BO\u0005?Cqa BM\u0001\u0004\t\t\u0001C\u0004\u0002\f\te\u0005\u0019A\u0014)\u000b\teu,a\u0004\t\u0015\tm\u0014QMA\u0001\n\u0013\u0011i\bK\u0003\u0002f}\u000by\u0001K\u0003\u0002`}\u000by\u0001")
public class Word2VecModel
implements Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    private final String[] wordList;
    private final double[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    public int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private double[] wordVecNorms() {
        return this.wordVecNorms;
    }

    private double cosineSimilarity(float[] v1, float[] v2) {
        Predef$.MODULE$.require(v1.length == v2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vectors should have the same length";
            }
        });
        int n = v1.length;
        float norm1 = BLAS.getInstance().snrm2(n, v1, 1);
        float norm2 = BLAS.getInstance().snrm2(n, v2, 1);
        if (norm1 == 0.0f || norm2 == 0.0f) {
            return 0.0;
        }
        return BLAS.getInstance().sdot(n, v1, 1, v2, 1) / norm1 / norm2;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            int ind = BoxesRunTime.unboxToInt((Object)some.x());
            float[] vec = (float[])Predef$.MODULE$.floatArrayOps(this.wordVectors()).slice(ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
            Vector vector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(float x$7) {
                    return this.apply$mcDF$sp(x$7);
                }

                public double apply$mcDF$sp(float x$7) {
                    return x$7;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            return vector;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not in vocabulary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num);
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        Predef$.MODULE$.require(num > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of similar words should > 0";
            }
        });
        float[] fVector = (float[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$8) {
                return this.apply$mcFD$sp(x$8);
            }

            public float apply$mcFD$sp(double x$8) {
                return (float)x$8;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = (float[])Array$.MODULE$.fill(this.numWords(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        float alpha = 1.0f;
        float beta = 0.0f;
        BLAS.getInstance().sgemv("T", this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), this.numWords(), alpha, this.wordVectors(), this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), fVector, 1, beta, cosineVec, 1);
        double[] cosVec = (double[])Predef$.MODULE$.floatArrayOps(cosineVec).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$9) {
                return this.apply$mcDF$sp(x$9);
            }

            public double apply$mcDF$sp(float x$9) {
                return x$9;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int ind = 0; ind < this.numWords(); ++ind) {
            int n = ind;
            cosVec[n] = cosVec[n] / this.wordVecNorms()[ind];
        }
        return (Tuple2[])((TraversableOnce)((TraversableLike)((IterableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.wordList()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(cosVec), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$10) {
                return -x$10._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(num + 1)).tail()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;

            public final Tuple2<String, float[]> apply(Tuple2<String, Object> x0$4) {
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    int ind = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)word, Predef$.MODULE$.floatArrayOps(this.$outer.wordVectors()).slice(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind, this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind + this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$6) {
                return x$6._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Seq wl;
            Seq seq;
            Seq wl2 = seq = (wl = (Seq)tuple2._1());
            this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
            double[] wordVecNorms = new double[this.numWords()];
            for (int i = 0; i < this.numWords(); ++i) {
                float[] vec = (float[])Predef$.MODULE$.floatArrayOps(wordVectors).slice(i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
                wordVecNorms[i] = BLAS.getInstance().snrm2(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), vec, 1);
            }
            this.wordVecNorms = wordVecNorms;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

