/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.OneHotEncoder$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u00015\u0011Qb\u00148f\u0011>$XI\\2pI\u0016\u0014(BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\n\u001b;A\u0011q\u0002E\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\f)J\fgn\u001d4pe6,'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"a\u0003%bg&s\u0007/\u001e;D_2\u0004\"aE\u000e\n\u0005q!\"\u0001\u0004%bg>+H\u000f];u\u0007>d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011)H/\u001b7\n\u0005\tz\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C!K\u0005\u0019Q/\u001b3\u0016\u0003\u0019\u0002\"aJ\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y%B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005k&$\u0007\u0005C\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003\tAQ\u0001\n\u001aA\u0002\u0019BQa\r\u0001\u0005\u0002e\"\u0012!\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0002=\u0003!!'o\u001c9MCN$X#A\u001f\u0011\u0005yzT\"\u0001\f\n\u0005\u00013\"\u0001\u0004\"p_2,\u0017M\u001c)be\u0006l\u0007B\u0002\"\u0001A\u00035Q(A\u0005ee>\u0004H*Y:uA!)A\t\u0001C\u0001\u000b\u0006Y1/\u001a;Ee>\u0004H*Y:u)\t1u)D\u0001\u0001\u0011\u0015A5\t1\u0001J\u0003\u00151\u0018\r\\;f!\tA#*\u0003\u0002LS\t9!i\\8mK\u0006t\u0007\"B'\u0001\t\u0003q\u0015aC:fi&s\u0007/\u001e;D_2$\"AR(\t\u000b!c\u0005\u0019\u0001\u0014\t\u000bE\u0003A\u0011\u0001*\u0002\u0019M,GoT;uaV$8i\u001c7\u0015\u0005\u0019\u001b\u0006\"\u0002%Q\u0001\u00041\u0003\"B+\u0001\t\u00032\u0016a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\u0005]{\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0015!\u0018\u0010]3t\u0015\taf!A\u0002tc2L!AX-\u0003\u0015M#(/^2u)f\u0004X\rC\u0003a)\u0002\u0007q+\u0001\u0004tG\",W.\u0019\u0005\u0006E\u0002!\teY\u0001\niJ\fgn\u001d4pe6$\"\u0001\u001a5\u0011\u0005\u00154W\"A.\n\u0005\u001d\\&!\u0003#bi\u00064%/Y7f\u0011\u0015I\u0017\r1\u0001e\u0003\u001d!\u0017\r^1tKRDQa\u001b\u0001\u0005B1\fAaY8qsR\u0011Q'\u001c\u0005\u0006]*\u0004\ra\\\u0001\u0006Kb$(/\u0019\t\u0003}AL!!\u001d\f\u0003\u0011A\u000b'/Y7NCBD#\u0001A:\u0011\u0005Q<X\"A;\u000b\u0005Y4\u0011AC1o]>$\u0018\r^5p]&\u0011\u00010\u001e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\u0006u\nA\ta_\u0001\u000e\u001f:,\u0007j\u001c;F]\u000e|G-\u001a:\u0011\u0005Ybh!B\u0001\u0003\u0011\u0003i8C\u0002?\u007f\u0003\u0007\tI\u0001\u0005\u0002)\u007f&\u0019\u0011\u0011A\u0015\u0003\r\u0005s\u0017PU3g!\u0011q\u0012QA\u001b\n\u0007\u0005\u001dqDA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007!\nY!C\u0002\u0002\u000e%\u0012AbU3sS\u0006d\u0017N_1cY\u0016Daa\r?\u0005\u0002\u0005EA#A>\t\u000f\u0005UA\u0010\"\u0011\u0002\u0018\u0005!An\\1e)\r)\u0014\u0011\u0004\u0005\b\u00037\t\u0019\u00021\u0001'\u0003\u0011\u0001\u0018\r\u001e5)\r\u0005M\u0011qDA\u0013!\r!\u0018\u0011E\u0005\u0004\u0003G)(!B*j]\u000e,\u0017EAA\u0014\u0003\u0015\tdF\u000e\u00181\u0011%\tY\u0003`A\u0001\n\u0013\ti#A\u0006sK\u0006$'+Z:pYZ,GCAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA\u0001\\1oO*\u0011\u0011\u0011H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0005M\"AB(cU\u0016\u001cG\u000fK\u0003}\u0003?\t)\u0003K\u0003z\u0003?\t)\u0003")
public class OneHotEncoder
extends Transformer
implements HasInputCol,
HasOutputCol,
DefaultParamsWritable {
    private final String uid;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static MLReader<OneHotEncoder> read() {
        return OneHotEncoder$.MODULE$.read();
    }

    public static OneHotEncoder load(String string) {
        return OneHotEncoder$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    public OneHotEncoder setDropLast(boolean value) {
        return (OneHotEncoder)this.set(this.dropLast(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public OneHotEncoder setInputCol(String value) {
        return (OneHotEncoder)this.set(this.inputCol(), value);
    }

    public OneHotEncoder setOutputCol(String value) {
        return (OneHotEncoder)this.set(this.outputCol(), value);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String inputColName = this.$(this.inputCol());
        String outputColName = this.$(this.outputCol());
        SchemaUtils$.MODULE$.checkColumnType(schema, inputColName, (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.outputColName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$1}));
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values() : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(int x$2) {
                            return ((Object)BoxesRunTime.boxToInteger((int)x$2)).toString();
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values() : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$3) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoder $outer;
            public final String inputColName$1;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputColName$1 = inputColName$1;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup(this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup(this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(outputFields);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        String inputColName = this.$(this.inputCol());
        String outputColName = this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$(this.dropLast()));
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            int numAttrs = (int)BoxesRunTime.unboxToDouble((Object)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Row x$4) {
                    return x$4.getDouble(0);
                }
            }, ClassTag$.MODULE$.Double()).aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this, inputColName){
                public static final long serialVersionUID = 0L;
                public final String inputColName$2;

                public final double apply(double m, double x) {
                    return this.apply$mcDDD$sp(m, x);
                }

                public double apply$mcDDD$sp(double m, double x) {
                    Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final double x$6;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values from column ", " must be indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$2, BoxesRunTime.boxToDouble((double)this.x$6)}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x$6 = x$6;
                        }
                    });
                    return scala.math.package$.MODULE$.max(m, x);
                }
                {
                    this.inputColName$2 = inputColName$2;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double m0, double m1) {
                    return this.apply$mcDDD$sp(m0, m1);
                }

                public double apply$mcDDD$sp(double m0, double m1) {
                    return scala.math.package$.MODULE$.max(m0, m1);
                }
            }, ClassTag$.MODULE$.Double())) + 1;
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(int x$5) {
                    return ((Object)BoxesRunTime.boxToInteger((int)x$5)).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        Metadata metadata = outputAttrGroup.toMetadata();
        int size = outputAttrGroup.size();
        double[] oneValue = new double[]{1.0};
        double[] emptyValues = (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        int[] emptyIndices = (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneHotEncoder.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1(OneHotEncoder $outer) {
            }
        }
        UserDefinedFunction encode = functions$.MODULE$.udf((Function1)new Serializable(this, size, oneValue, emptyValues, emptyIndices){
            public static final long serialVersionUID = 0L;
            private final int size$1;
            private final double[] oneValue$1;
            private final double[] emptyValues$1;
            private final int[] emptyIndices$1;

            public final Vector apply(double label) {
                return label < (double)this.size$1 ? Vectors$.MODULE$.sparse(this.size$1, new int[]{(int)label}, this.oneValue$1) : Vectors$.MODULE$.sparse(this.size$1, this.emptyIndices$1, this.emptyValues$1);
            }
            {
                this.size$1 = size$1;
                this.oneValue$1 = oneValue$1;
                this.emptyValues$1 = emptyValues$1;
                this.emptyIndices$1 = emptyIndices$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), encode.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).as(outputColName, metadata)}));
    }

    @Override
    public OneHotEncoder copy(ParamMap extra) {
        return (OneHotEncoder)this.defaultCopy(extra);
    }

    public OneHotEncoder(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.dropLast = new BooleanParam(this, "dropLast", "whether to drop the last category");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.dropLast().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
    }

    public OneHotEncoder() {
        this(Identifiable$.MODULE$.randomUID("oneHot"));
    }
}

