/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.api.r;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.sql.DataFrame;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkRWrappers$ {
    public static final SparkRWrappers$ MODULE$;

    static {
        new SparkRWrappers$();
    }

    public PipelineModel fitRModelFormula(String value, DataFrame df, String family, double lambda, double alpha, boolean standardize, String solver) {
        String string;
        block4: {
            Predictor predictor;
            RFormula formula;
            block3: {
                block2: {
                    formula = new RFormula().setFormula(value);
                    string = family;
                    if (!"gaussian".equals(string)) break block2;
                    predictor = new LinearRegression().setRegParam(lambda).setElasticNetParam(alpha).setFitIntercept(formula.hasIntercept()).setStandardization(standardize).setSolver(solver);
                    break block3;
                }
                if (!"binomial".equals(string)) break block4;
                predictor = new LogisticRegression().setRegParam(lambda).setElasticNetParam(alpha).setFitIntercept(formula.hasIntercept()).setStandardization(standardize);
            }
            LinearRegression estimator = predictor;
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{formula, estimator}));
            return pipeline.fit(df);
        }
        throw new MatchError((Object)string);
    }

    public double[] getModelCoefficients(PipelineModel model) {
        Transformer transformer;
        block4: {
            double[] dArray;
            block3: {
                block2: {
                    transformer = (Transformer)Predef$.MODULE$.refArrayOps((Object[])model.stages()).last();
                    if (!(transformer instanceof LinearRegressionModel)) break block2;
                    LinearRegressionModel linearRegressionModel = (LinearRegressionModel)transformer;
                    double[] coefficientStandardErrorsR = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().coefficientStandardErrors()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().coefficientStandardErrors()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    double[] tValuesR = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().tValues()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().tValues()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    double[] pValuesR = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().pValues()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(linearRegressionModel.summary().pValues()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    dArray = linearRegressionModel.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(new double[]{linearRegressionModel.intercept()}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(linearRegressionModel.coefficients().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(coefficientStandardErrorsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(tValuesR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(pValuesR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(linearRegressionModel.coefficients().toArray()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(coefficientStandardErrorsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(tValuesR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(pValuesR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    break block3;
                }
                if (!(transformer instanceof LogisticRegressionModel)) break block4;
                LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)transformer;
                dArray = logisticRegressionModel.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps(new double[]{logisticRegressionModel.intercept()}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(logisticRegressionModel.coefficients().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : logisticRegressionModel.coefficients().toArray();
            }
            return dArray;
        }
        throw new MatchError((Object)transformer);
    }

    public double[] getModelDevianceResiduals(PipelineModel model) {
        Transformer transformer = (Transformer)Predef$.MODULE$.refArrayOps((Object[])model.stages()).last();
        if (transformer instanceof LinearRegressionModel) {
            LinearRegressionModel linearRegressionModel = (LinearRegressionModel)transformer;
            double[] dArray = linearRegressionModel.summary().devianceResiduals();
            return dArray;
        }
        if (transformer instanceof LogisticRegressionModel) {
            throw new UnsupportedOperationException("No deviance residuals available for LogisticRegressionModel");
        }
        throw new MatchError((Object)transformer);
    }

    public String[] getModelFeatures(PipelineModel model) {
        Transformer transformer;
        block4: {
            String[] stringArray;
            block3: {
                block2: {
                    transformer = (Transformer)Predef$.MODULE$.refArrayOps((Object[])model.stages()).last();
                    if (!(transformer instanceof LinearRegressionModel)) break block2;
                    LinearRegressionModel linearRegressionModel = (LinearRegressionModel)transformer;
                    AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(linearRegressionModel.summary().predictions().schema().apply(linearRegressionModel.summary().featuresCol()));
                    stringArray = linearRegressionModel.getFitIntercept() ? (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"(Intercept)"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])attrs.attributes().get()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Attribute x$1) {
                            return (String)x$1.name().get();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Predef$.MODULE$.refArrayOps((Object[])attrs.attributes().get()).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Attribute x$2) {
                            return (String)x$2.name().get();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    break block3;
                }
                if (!(transformer instanceof LogisticRegressionModel)) break block4;
                LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)transformer;
                AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(logisticRegressionModel.summary().predictions().schema().apply(logisticRegressionModel.summary().featuresCol()));
                stringArray = logisticRegressionModel.getFitIntercept() ? (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"(Intercept)"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])attrs.attributes().get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Attribute x$3) {
                        return (String)x$3.name().get();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Predef$.MODULE$.refArrayOps((Object[])attrs.attributes().get()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Attribute x$4) {
                        return (String)x$4.name().get();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            return stringArray;
        }
        throw new MatchError((Object)transformer);
    }

    public String getModelName(PipelineModel model) {
        Transformer transformer;
        block4: {
            String string;
            block3: {
                block2: {
                    transformer = (Transformer)Predef$.MODULE$.refArrayOps((Object[])model.stages()).last();
                    if (!(transformer instanceof LinearRegressionModel)) break block2;
                    string = "LinearRegressionModel";
                    break block3;
                }
                if (!(transformer instanceof LogisticRegressionModel)) break block4;
                string = "LogisticRegressionModel";
            }
            return string;
        }
        throw new MatchError((Object)transformer);
    }

    private SparkRWrappers$() {
        MODULE$ = this;
    }
}

