/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.hive.HiveInspectors;
import org.apache.spark.sql.hive.HiveInspectors$class;
import org.apache.spark.sql.hive.orc.OrcRelation$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0001\u0003\u0001\tq!aD(sG>+H\u000f];u/JLG/\u001a:\u000b\u0005\r!\u0011aA8sG*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0018!\t\u0001R#D\u0001\u0012\u0015\t\u00112#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u000b\u0007\u0003%)\u00070Z2vi&|g.\u0003\u0002\u0017#\taq*\u001e;qkR<&/\u001b;feB\u0011\u0001$G\u0007\u0002\t%\u0011!\u0004\u0002\u0002\u000f\u0011&4X-\u00138ta\u0016\u001cGo\u001c:t\u0011!a\u0002A!A!\u0002\u0013q\u0012\u0001\u00029bi\"\u001c\u0001\u0001\u0005\u0002 K9\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\u00051\u0001K]3eK\u001aL!AJ\u0014\u0003\rM#(/\u001b8h\u0015\t!\u0013\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003!\u0011WoY6fi&#\u0007c\u0001\u0011,[%\u0011A&\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001r\u0013BA\u0018\"\u0005\rIe\u000e\u001e\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005QA-\u0019;b'\u000eDW-\\1\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U2\u0011!\u0002;za\u0016\u001c\u0018BA\u001c5\u0005)\u0019FO];diRK\b/\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u000591m\u001c8uKb$\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002@\u0015\u00051\u0001.\u00193p_BL!!\u0011\u001f\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0015;\u0005*\u0013&\u0011\u0005\u0019\u0003Q\"\u0001\u0002\t\u000bq\u0011\u0005\u0019\u0001\u0010\t\u000b%\u0012\u0005\u0019\u0001\u0016\t\u000bE\u0012\u0005\u0019\u0001\u001a\t\u000be\u0012\u0005\u0019\u0001\u001e\t\u000f1\u0003!\u0019!C\u0005\u001b\u0006Q1/\u001a:jC2L'0\u001a:\u0016\u00039\u0003\"a\u0014,\u000e\u0003AS!aA)\u000b\u0005I\u001b\u0016AA5p\u0015\t!V+\u0001\u0002rY*\u0011QAP\u0005\u0003/B\u0013\u0001b\u0014:d'\u0016\u0014H-\u001a\u0005\u00073\u0002\u0001\u000b\u0011\u0002(\u0002\u0017M,'/[1mSj,'\u000f\t\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003!\u0019HO];di>KU#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017aD8cU\u0016\u001cG/\u001b8ta\u0016\u001cGo\u001c:\u000b\u0005\t,\u0016AB:fe\u0012,''\u0003\u0002e?\ni2+\u001a;uC\ndWm\u0015;sk\u000e$xJ\u00196fGRLen\u001d9fGR|'\u000f\u0003\u0004g\u0001\u0001\u0006I!X\u0001\ngR\u0014Xo\u0019;P\u0013\u0002Bq\u0001\u001b\u0001A\u0002\u0013%\u0011.\u0001\rsK\u000e|'\u000fZ,sSR,'/\u00138ti\u0006tG/[1uK\u0012,\u0012A\u001b\t\u0003A-L!\u0001\\\u0011\u0003\u000f\t{w\u000e\\3b]\"9a\u000e\u0001a\u0001\n\u0013y\u0017\u0001\b:fG>\u0014Hm\u0016:ji\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;fI~#S-\u001d\u000b\u0003aN\u0004\"\u0001I9\n\u0005I\f#\u0001B+oSRDq\u0001^7\u0002\u0002\u0003\u0007!.A\u0002yIEBaA\u001e\u0001!B\u0013Q\u0017!\u0007:fG>\u0014Hm\u0016:ji\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;fI\u0002B\u0001\u0002\u001f\u0001\t\u0006\u0004%I!_\u0001\re\u0016\u001cwN\u001d3Xe&$XM]\u000b\u0002uB11P`A\u0001\u0003\u0017i\u0011\u0001 \u0006\u0003{z\na!\\1qe\u0016$\u0017BA@}\u00051\u0011VmY8sI^\u0013\u0018\u000e^3s!\u0011\t\u0019!a\u0002\u000e\u0005\u0005\u0015!B\u0001*?\u0013\u0011\tI!!\u0002\u0003\u00199+H\u000e\\,sSR\f'\r\\3\u0011\t\u0005\r\u0011QB\u0005\u0005\u0003\u001f\t)A\u0001\u0005Xe&$\u0018M\u00197f\u0011%\t\u0019\u0002\u0001E\u0001B\u0003&!0A\u0007sK\u000e|'\u000fZ,sSR,'\u000f\t\u0005\b\u0003/\u0001A\u0011IA\r\u0003\u00159(/\u001b;f)\r\u0001\u00181\u0004\u0005\t\u0003;\t)\u00021\u0001\u0002 \u0005\u0019!o\\<\u0011\t\u0005\u0005\u00121E\u0007\u0002\r%\u0019\u0011Q\u0005\u0004\u0003\u0007I{w\u000fC\u0004\u0002*\u0001!I!a\u000b\u0002\u001b]\u0014\u0018\r](sGN#(/^2u)\u001d\u0001\u0018QFA\u001c\u0003wA\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\u0007gR\u0014Xo\u0019;\u0011\u0007=\u000b\u0019$C\u0002\u00026A\u0013\u0011b\u0014:d'R\u0014Xo\u0019;\t\u000f\u0005e\u0012q\u0005a\u0001;\u0006\u0011q.\u001b\u0005\t\u0003;\t9\u00031\u0001\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003\u000f\n\tEA\u0006J]R,'O\\1m%><\b\"CA&\u0001\t\u0007I\u0011AA'\u0003=\u0019\u0017m\u00195fI>\u00138m\u0015;sk\u000e$XCAA\u0019\u0011!\t\t\u0006\u0001Q\u0001\n\u0005E\u0012\u0001E2bG\",Gm\u0014:d'R\u0014Xo\u0019;!\u0011!\t)\u0006\u0001C)\r\u0005]\u0013!D<sSR,\u0017J\u001c;fe:\fG\u000eF\u0002q\u00033B\u0001\"!\b\u0002T\u0001\u0007\u0011Q\b\u0005\b\u0003;\u0002A\u0011IA0\u0003\u0015\u0019Gn\\:f)\u0005\u0001\b")
public class OrcOutputWriter
extends OutputWriter
implements HiveInspectors {
    private final String path;
    private final Option<Object> bucketId;
    private final StructType dataSchema;
    private final TaskAttemptContext context;
    private final OrcSerde serializer;
    private final SettableStructObjectInspector structOI;
    private boolean recordWriterInstantiated;
    private RecordWriter<NullWritable, Writable> recordWriter;
    private final OrcStruct cachedOrcStruct;
    private volatile boolean bitmap$0;

    private RecordWriter recordWriter$lzycompute() {
        OrcOutputWriter orcOutputWriter = this;
        synchronized (orcOutputWriter) {
            if (!this.bitmap$0) {
                this.recordWriterInstantiated_$eq(true);
                Configuration conf = this.context.getConfiguration();
                String uniqueWriteJobId = conf.get("spark.sql.sources.writeJobUUID");
                TaskAttemptID taskAttemptId = this.context.getTaskAttemptID();
                int partition = taskAttemptId.getTaskID().getId();
                String bucketString = (String)this.bucketId.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int id) {
                        return BucketingUtils$.MODULE$.bucketIdToString(id);
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                String name = conf.get(OrcRelation$.MODULE$.ORC_COMPRESSION());
                String compressionExtension = (String)OrcRelation$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                int arg$macro$1 = partition;
                String arg$macro$2 = uniqueWriteJobId;
                String arg$macro$3 = bucketString;
                String arg$macro$4 = compressionExtension;
                String filename = new StringOps("part-r-%05d-%s%s%s.orc").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3, arg$macro$4}));
                this.recordWriter = new OrcOutputFormat().getRecordWriter(new Path(this.path, filename).getFileSystem(conf), (JobConf)conf, new Path(this.path, filename).toString(), (Progressable)Reporter.NULL);
                this.bitmap$0 = true;
            }
            return this.recordWriter;
        }
    }

    @Override
    public DataType javaClassToDataType(Class<?> clz) {
        return HiveInspectors$class.javaClassToDataType(this, clz);
    }

    @Override
    public Object unwrap(Object data, ObjectInspector oi) {
        return HiveInspectors$class.unwrap(this, data, oi);
    }

    @Override
    public Function1<Object, Object> wrapperFor(ObjectInspector oi, DataType dataType) {
        return HiveInspectors$class.wrapperFor(this, oi, dataType);
    }

    @Override
    public Function3<Object, MutableRow, Object, BoxedUnit> unwrapperFor(org.apache.hadoop.hive.serde2.objectinspector.StructField field) {
        return HiveInspectors$class.unwrapperFor(this, field);
    }

    @Override
    public Object wrap(Object a, ObjectInspector oi, DataType dataType) {
        return HiveInspectors$class.wrap(this, a, oi, dataType);
    }

    @Override
    public Object[] wrap(InternalRow row, Seq<ObjectInspector> inspectors2, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors$class.wrap((HiveInspectors)this, row, inspectors2, cache, dataTypes);
    }

    @Override
    public Object[] wrap(Seq<Object> row, Seq<ObjectInspector> inspectors2, Object[] cache, DataType[] dataTypes) {
        return HiveInspectors$class.wrap((HiveInspectors)this, row, inspectors2, cache, dataTypes);
    }

    @Override
    public ObjectInspector toInspector(DataType dataType) {
        return HiveInspectors$class.toInspector((HiveInspectors)this, dataType);
    }

    @Override
    public ObjectInspector toInspector(Expression expr) {
        return HiveInspectors$class.toInspector((HiveInspectors)this, expr);
    }

    @Override
    public DataType inspectorToDataType(ObjectInspector inspector) {
        return HiveInspectors$class.inspectorToDataType(this, inspector);
    }

    @Override
    public HiveInspectors.typeInfoConversions typeInfoConversions(DataType dt) {
        return HiveInspectors$class.typeInfoConversions(this, dt);
    }

    private OrcSerde serializer() {
        return this.serializer;
    }

    private SettableStructObjectInspector structOI() {
        return this.structOI;
    }

    private boolean recordWriterInstantiated() {
        return this.recordWriterInstantiated;
    }

    private void recordWriterInstantiated_$eq(boolean x$1) {
        this.recordWriterInstantiated = x$1;
    }

    private RecordWriter<NullWritable, Writable> recordWriter() {
        return this.bitmap$0 ? this.recordWriter : this.recordWriter$lzycompute();
    }

    public void write(Row row) {
        throw new UnsupportedOperationException("call writeInternal");
    }

    private void wrapOrcStruct(OrcStruct struct, SettableStructObjectInspector oi, InternalRow row) {
        List fieldRefs = oi.getAllStructFieldRefs();
        for (int i = 0; i < fieldRefs.size(); ++i) {
            oi.setStructFieldData((Object)struct, (org.apache.hadoop.hive.serde2.objectinspector.StructField)fieldRefs.get(i), this.wrap(row.get(i, this.dataSchema.apply(i).dataType()), ((org.apache.hadoop.hive.serde2.objectinspector.StructField)fieldRefs.get(i)).getFieldObjectInspector(), this.dataSchema.apply(i).dataType()));
        }
    }

    public OrcStruct cachedOrcStruct() {
        return this.cachedOrcStruct;
    }

    public void writeInternal(InternalRow row) {
        this.wrapOrcStruct(this.cachedOrcStruct(), this.structOI(), row);
        this.recordWriter().write((Object)NullWritable.get(), (Object)this.serializer().serialize((Object)this.cachedOrcStruct(), (ObjectInspector)this.structOI()));
    }

    public void close() {
        if (this.recordWriterInstantiated()) {
            this.recordWriter().close(Reporter.NULL);
        }
    }

    public OrcOutputWriter(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
        this.path = path;
        this.bucketId = bucketId;
        this.dataSchema = dataSchema;
        this.context = context;
        HiveInspectors$class.$init$(this);
        Properties table = new Properties();
        table.setProperty("columns", Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames()).mkString(","));
        table.setProperty("columns.types", ((TraversableOnce)dataSchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$2) {
                return x$2.dataType().catalogString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(":"));
        OrcSerde serde = new OrcSerde();
        Configuration configuration = context.getConfiguration();
        serde.initialize(configuration, table);
        this.serializer = serde;
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)dataSchema.catalogString());
        this.structOI = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)((StructTypeInfo)typeInfo));
        this.recordWriterInstantiated = false;
        this.cachedOrcStruct = (OrcStruct)this.structOI().create();
    }
}

