/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.SparkOrcNewRecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.orc.OrcFilters$;
import org.apache.spark.sql.hive.orc.OrcOptions;
import org.apache.spark.sql.hive.orc.OrcOutputWriter;
import org.apache.spark.sql.hive.orc.OrcRelation$;
import org.apache.spark.sql.hive.orc.OrcTableScan$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ub!B\u0001\u0003\u0001\u0019q!!\u0004#fM\u0006,H\u000e^*pkJ\u001cWM\u0003\u0002\u0004\t\u0005\u0019qN]2\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\u0015\u0001q\"F\u000f$!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001b\r\u0005IQ\r_3dkRLwN\\\u0005\u00039]\u0011!BR5mK\u001a{'/\\1u!\tq\u0012%D\u0001 \u0015\t\u0001c!A\u0004t_V\u00148-Z:\n\u0005\tz\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"\u0001\u0005\u0013\n\u0005\u0015\n\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0014\u0001\t\u0003I\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003\tAQ!\f\u0001\u0005B9\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003=\u0002\"\u0001M\u001a\u000f\u0005A\t\u0014B\u0001\u001a\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\n\u0002\"B\u001c\u0001\t\u0003r\u0013\u0001\u0003;p'R\u0014\u0018N\\4\t\u000be\u0002A\u0011\t\u001e\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005w\u0011Su\nE\u0002\u0011yyJ!!P\t\u0003\r=\u0003H/[8o!\ty$)D\u0001A\u0015\t\te!A\u0003usB,7/\u0003\u0002D\u0001\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u0015C\u0004\u0019\u0001$\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dCU\"\u0001\u0004\n\u0005%3!\u0001D*qCJ\\7+Z:tS>t\u0007\"B&9\u0001\u0004a\u0015aB8qi&|gn\u001d\t\u0005a5{s&\u0003\u0002Ok\t\u0019Q*\u00199\t\u000bAC\u0004\u0019A)\u0002\u000b\u0019LG.Z:\u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0003II!!W\t\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-\u0012!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0002gg*\u0011!MC\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011|&A\u0003$jY\u0016\u001cF/\u0019;vg\")a\r\u0001C!O\u0006a\u0001O]3qCJ,wK]5uKR)\u0001n\u001b7ukB\u0011a#[\u0005\u0003U^\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ!R3A\u0002\u0019CQ!\\3A\u00029\f1A[8c!\ty'/D\u0001q\u0015\t\t\u0018-A\u0005nCB\u0014X\rZ;dK&\u00111\u000f\u001d\u0002\u0004\u0015>\u0014\u0007\"B&f\u0001\u0004a\u0005\"\u0002<f\u0001\u0004q\u0014A\u00033bi\u0006\u001c6\r[3nC\")\u0001\u0010\u0001C!s\u0006Y!-^5mIJ+\u0017\rZ3s)=Q\u00181CA\u000b\u0003/\tY\"a\b\u0002,\u00055\u0002#\u0002\t|{\u0006\u0005\u0011B\u0001?\u0012\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u0017}&\u0011qp\u0006\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)!+a\u0001\u0002\b%\u0019\u0011Q\u0001/\u0003\u0011%#XM]1u_J\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005E\u00111\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003Fo\u0002\u0007a\tC\u0003wo\u0002\u0007a\b\u0003\u0004\u0002\u001a]\u0004\rAP\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u0011QD<A\u0002y\naB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002\"]\u0004\r!a\t\u0002\u000f\u0019LG\u000e^3sgB!!KWA\u0013!\rq\u0012qE\u0005\u0004\u0003Sy\"A\u0002$jYR,'\u000fC\u0003Lo\u0002\u0007A\nC\u0004\u00020]\u0004\r!!\r\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9$Y\u0001\u0005G>tg-\u0003\u0003\u0002<\u0005U\"!D\"p]\u001aLw-\u001e:bi&|g\u000e")
public class DefaultSource
implements FileFormat,
DataSourceRegister,
Serializable {
    public Map<String, String> prepareRead(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return FileFormat.class.prepareRead((FileFormat)this, (SparkSession)sparkSession, options, files);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return FileFormat.class.buildWriter((FileFormat)this, (SQLContext)sqlContext, (StructType)dataSchema, options);
    }

    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toUri().toString();
            }
        }, Seq$.MODULE$.canBuildFrom())), (Option<Configuration>)new Some((Object)sparkSession.sessionState().newHadoopConf()));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options);
        Configuration configuration = job.getConfiguration();
        configuration.set(OrcRelation$.MODULE$.ORC_COMPRESSION(), orcOptions.compressionCodec());
        Configuration configuration2 = configuration;
        if (configuration2 instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration2;
            jobConf.setOutputFormat(OrcOutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            configuration2.setClass("mapred.output.format.class", OrcOutputFormat.class, OutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, bucketId, dataSchema, context);
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(requiredSchema, (Filter[])filters.toArray(ClassTag$.MODULE$.apply(Filter.class))).foreach((Function1)new Serializable(this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final void apply(SearchArgument f) {
                    this.hadoopConf$1.set(OrcTableScan$.MODULE$.SARG_PUSHDOWN(), f.toKryo());
                    this.hadoopConf$1.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, true);
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, requiredSchema, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<InternalRow> iterator;
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                Option<StructType> maybePhysicalSchema = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.filePath()}))), (Option<Configuration>)new Some((Object)conf));
                if (maybePhysicalSchema.isEmpty()) {
                    iterator = package$.MODULE$.Iterator().empty();
                } else {
                    StructType physicalSchema = (StructType)maybePhysicalSchema.get();
                    OrcRelation$.MODULE$.setRequiredColumns(conf, physicalSchema, this.requiredSchema$1);
                    Job job = Job.getInstance((Configuration)conf);
                    FileInputFormat.setInputPaths((Job)job, (String)file.filePath());
                    FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                    Reader orcReader = OrcFile.createReader((Path)new Path(new URI(file.filePath())), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                    SparkOrcNewRecordReader orcRecordReader = new SparkOrcNewRecordReader(orcReader, conf, fileSplit.getStart(), fileSplit.getLength());
                    iterator = OrcRelation$.MODULE$.unwrapOrcStructs(conf, this.requiredSchema$1, (Option<StructObjectInspector>)new Some((Object)((StructObjectInspector)orcRecordReader.getObjectInspector())), (Iterator<Writable>)new RecordReaderIterator((RecordReader)orcRecordReader));
                }
                return iterator;
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    public DefaultSource() {
        FileFormat.class.$init$((FileFormat)this);
    }
}

