/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.", extended="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011\u0011bU;cgR\u0014\u0018N\\4\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t9\u0001K]8ek\u000e$\bC\u0001\r\u001f\u0013\ty\u0012D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\r\u0019HO]\u000b\u0002GA\u0011\u0011\u0003J\u0005\u0003K\t\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011!9\u0003A!E!\u0002\u0013\u0019\u0013\u0001B:ue\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0004a>\u001c\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\tA|7\u000f\t\u0005\t[\u0001\u0011)\u001a!C\u0001E\u0005\u0019A.\u001a8\t\u0011=\u0002!\u0011#Q\u0001\n\r\nA\u0001\\3oA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0011\u0003\u0001\u0005\u0006CA\u0002\ra\t\u0005\u0006SA\u0002\ra\t\u0005\u0006[A\u0002\ra\t\u0005\u0006c\u0001!\t\u0001\u000f\u000b\u0004geR\u0004\"B\u00118\u0001\u0004\u0019\u0003\"B\u00158\u0001\u0004\u0019\u0003\"\u0002\u001f\u0001\t\u0003j\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0004\u0002\u000bQL\b/Z:\n\u0005\r\u0003%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b\u0015\u0003A\u0011\t$\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001H!\rA\u0005k\u0015\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA(\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0015*\u0003\u0007M+\u0017O\u0003\u0002P3A\u0011q\bV\u0005\u0003+\u0002\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b]\u0003A\u0011\t-\u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u0017\t\u0004\u0011B\u001b\u0003\"B.\u0001\t\u0003b\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003B/aE\u000e\u0004\"\u0001\u00070\n\u0005}K\"aA!os\")\u0011M\u0017a\u0001;\u000611\u000f\u001e:j]\u001eDQ!\u000b.A\u0002uCQ!\f.A\u0002uCQ!\u001a\u0001\u0005B\u0019\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u001dl'\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k\u0005\u000591m\u001c3fO\u0016t\u0017B\u00017j\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00028e\u0001\u0004y\u0017aA2uqB\u0011\u0001\u000e]\u0005\u0003c&\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003tI\u0002\u0007q-\u0001\u0002fm\"9Q\u000fAA\u0001\n\u00031\u0018\u0001B2paf$BaM<ys\"9\u0011\u0005\u001eI\u0001\u0002\u0004\u0019\u0003bB\u0015u!\u0003\u0005\ra\t\u0005\b[Q\u0004\n\u00111\u0001$\u0011\u001dY\b!%A\u0005\u0002q\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001~U\t\u0019cpK\u0001\u0000!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0011$\u0001\u0006b]:|G/\u0019;j_:LA!!\u0004\u0002\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0011\u0005E\u0001!%A\u0005\u0002q\fabY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001}\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\u0007\u0001\u0003\u0003%\t%a\u0007\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\t1\fgn\u001a\u0006\u0003\u0003O\tAA[1wC&!\u00111FA\u0011\u0005\u0019\u0019FO]5oO\"I\u0011q\u0006\u0001\u0002\u0002\u0013\u0005\u0011\u0011G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003g\u00012\u0001GA\u001b\u0013\r\t9$\u0007\u0002\u0004\u0013:$\b\"CA\u001e\u0001\u0005\u0005I\u0011AA\u001f\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!XA \u0011)\t\t%!\u000f\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0004\"CA#\u0001\u0005\u0005I\u0011IA$\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA%!\u0015\tY%!\u0015^\u001b\t\tiEC\u0002\u0002Pe\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019&!\u0014\u0003\u0011%#XM]1u_JD\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\u0002\u0011\r\fg.R9vC2$B!a\u0017\u0002bA\u0019\u0001$!\u0018\n\u0007\u0005}\u0013DA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0013QKA\u0001\u0002\u0004i\u0006\"CA3\u0001\u0005\u0005I\u0011IA4\u0003\u0019)\u0017/^1mgR!\u00111LA5\u0011%\t\t%a\u0019\u0002\u0002\u0003\u0007Q\fK\u0006\u0001\u0003[\n\u0019(!\u001e\u0002z\u0005m\u0004cA\t\u0002p%\u0019\u0011\u0011\u000f\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qO\u0001\u0002\\}3UKT\"`QM$(\u000f\f\u0011q_N\\F\u0006\t7f]vK\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!_\u001a\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;!gR\f'\u000f^:!CR\u0004\u0003\r]8tA\u0002\ng\u000e\u001a\u0011jg\u0002zg\r\t7f]\u001e$\b\u000e\t1mK:\u0004G\u0006I8sAQDW\rI:mS\u000e,\u0007e\u001c4!Ef$X\rI1se\u0006L\b\u0005\u001e5bi\u0002\u001aH/\u0019:ug\u0002\nG\u000f\t1q_N\u0004\u0007%\u00198eA%\u001c\be\u001c4!Y\u0016tw\r\u001e5!A2,g\u000e\u0019\u0018\u0002\u0011\u0015DH/\u001a8eK\u0012\f#!! \u0002\u0003/R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO1\u0002S'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!W\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu\u0005\f\u0011.g%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-AUb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A-T\u0001\u0005I\u0004\n\u0003\u0003\u0013\u0011\u0011!E\u0001\u0003\u0007\u000b\u0011bU;cgR\u0014\u0018N\\4\u0011\u0007E\t)I\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAD'\u0015\t))!#\u001e!!\tY)!%$G\r\u001aTBAAG\u0015\r\ty)G\u0001\beVtG/[7f\u0013\u0011\t\u0019*!$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00042\u0003\u000b#\t!a&\u0015\u0005\u0005\r\u0005BCAN\u0003\u000b\u000b\t\u0011\"\u0012\u0002\u001e\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001e!Q\u0011\u0011UAC\u0003\u0003%\t)a)\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fM\n)+a*\u0002*\"1\u0011%a(A\u0002\rBa!KAP\u0001\u0004\u0019\u0003BB\u0017\u0002 \u0002\u00071\u0005\u0003\u0006\u0002.\u0006\u0015\u0015\u0011!CA\u0003_\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00022\u0006u\u0006#\u0002\r\u00024\u0006]\u0016bAA[3\t1q\n\u001d;j_:\u0004b\u0001GA]G\r\u001a\u0013bAA^3\t1A+\u001e9mKNB\u0011\"a0\u0002,\u0006\u0005\t\u0019A\u001a\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002D\u0006\u0015\u0015\u0011!C\u0005\u0003\u000b\f1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0019\t\u0005\u0003?\tI-\u0003\u0003\u0002L\u0006\u0005\"AB(cU\u0016\u001cG\u000f")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring substring) {
        return Substring$.MODULE$.unapply(substring);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), IntegerType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        Expression expression2 = this.pos();
        Expression expression3 = this.len();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        DataType dataType2;
        block4: {
            Object object;
            block3: {
                block2: {
                    dataType2 = this.str().dataType();
                    if (!StringType$.MODULE$.equals(dataType2)) break block2;
                    object = ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
                    break block3;
                }
                if (!BinaryType$.MODULE$.equals(dataType2)) break block4;
                object = ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
            }
            return object;
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Substring $outer;

            public final String apply(String string, String pos, String len) {
                DataType dataType2;
                block4: {
                    String string2;
                    block3: {
                        block2: {
                            dataType2 = this.$outer.str().dataType();
                            if (!StringType$.MODULE$.equals(dataType2)) break block2;
                            string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".substringSQL(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, pos, len}));
                            break block3;
                        }
                        if (!BinaryType$.MODULE$.equals(dataType2)) break block4;
                        string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".subStringSQL(", ", ", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteArray.class.getName(), string, pos, len}));
                    }
                    return string2;
                }
                throw new MatchError((Object)dataType2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.len();
                break;
            }
            case 1: {
                expression = this.pos();
                break;
            }
            case 0: {
                expression = this.str();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes$class.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

