/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;

public final class UDTRegistration$
implements Serializable,
Logging {
    public static final UDTRegistration$ MODULE$;
    private Map<String, String> udtMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new UDTRegistration$();
    }

    private Map udtMap$lzycompute() {
        UDTRegistration$ uDTRegistration$ = this;
        synchronized (uDTRegistration$) {
            if (!this.bitmap$0) {
                this.udtMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"org.apache.spark.ml.linalg.Vector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseVector", (Object)"org.apache.spark.ml.linalg.VectorUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.Matrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.DenseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT"), new Tuple2((Object)"org.apache.spark.ml.linalg.SparseMatrix", (Object)"org.apache.spark.ml.linalg.MatrixUDT")}));
                this.bitmap$0 = true;
            }
            return this.udtMap;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Map<String, String> udtMap() {
        return this.bitmap$0 ? this.udtMap : this.udtMap$lzycompute();
    }

    public boolean exists(String userClassName) {
        return this.udtMap().contains((Object)userClassName);
    }

    public void register(String userClass, String udtClass) {
        if (this.udtMap().contains((Object)userClass)) {
            this.logWarning((Function0<String>)new Serializable(userClass){
                public static final long serialVersionUID = 0L;
                private final String userClass$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot register UDT for ", ", which is already registered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userClass$2}));
                }
                {
                    this.userClass$2 = userClass$2;
                }
            });
        } else {
            this.udtMap().$plus$eq(new Tuple2((Object)userClass, (Object)udtClass));
        }
    }

    public Option<Class<?>> getUDTFor(String userClass) {
        return this.udtMap().get((Object)userClass).map((Function1)new Serializable(userClass){
            public static final long serialVersionUID = 0L;
            private final String userClass$1;

            public final Class<?> apply(String udtClassName) {
                if (Utils$.MODULE$.classIsLoadable(udtClassName)) {
                    Class udtClass = Utils$.MODULE$.classForName(udtClassName);
                    if (UserDefinedType.class.isAssignableFrom(udtClass)) {
                        return udtClass;
                    }
                    throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not an UserDefinedType. Please make sure registering "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{udtClass.getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"an UserDefinedType for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.userClass$1}))).toString());
                }
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not load in UserDefinedType ", " for user class ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{udtClassName, this.userClass$1})));
            }
            {
                this.userClass$1 = userClass$1;
            }
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UDTRegistration$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

