/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim, keyValueDelim]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for pairDelim and ':' for keyValueDelim.", extended=" > SELECT _FUNC_('a:1,b:2,c:3',',',':');\\n map(\"a\":\"1\",\"b\":\"2\",\"c\":\"3\") ")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001>\u00111b\u0015;sS:<Gk\\'ba*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001!QQRd\t\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t)\u0002$D\u0001\u0017\u0015\t9\"!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005EY\u0012B\u0001\u000f\u0003\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\b!J|G-^2u!\tqB%\u0003\u0002&?\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0005\u0001BK\u0002\u0013\u0005\u0001&\u0001\u0003uKb$X#A\u0015\u0011\u0005EQ\u0013BA\u0016\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t[\u0001\u0011\t\u0012)A\u0005S\u0005)A/\u001a=uA!Aq\u0006\u0001BK\u0002\u0013\u0005\u0001&A\u0005qC&\u0014H)\u001a7j[\"A\u0011\u0007\u0001B\tB\u0003%\u0011&\u0001\u0006qC&\u0014H)\u001a7j[\u0002B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001K\u0001\u000eW\u0016Lh+\u00197vK\u0012+G.[7\t\u0011U\u0002!\u0011#Q\u0001\n%\nab[3z-\u0006dW/\u001a#fY&l\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0005siZD\b\u0005\u0002\u0012\u0001!)qE\u000ea\u0001S!)qF\u000ea\u0001S!)1G\u000ea\u0001S!)q\u0007\u0001C\u0001}Q\u0019\u0011hP!\t\u000b\u0001k\u0004\u0019A\u0015\u0002\u000b\rD\u0017\u000e\u001c3\t\u000b=j\u0004\u0019A\u0015\t\u000b]\u0002A\u0011A\"\u0015\u0005e\"\u0005\"\u0002!C\u0001\u0004I\u0003\"\u0002$\u0001\t\u0003:\u0015\u0001C2iS2$'/\u001a8\u0016\u0003!\u00032!S)*\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N\u001d\u00051AH]8pizJ\u0011\u0001I\u0005\u0003!~\tq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A{\u0002\"B+\u0001\t\u00032\u0016AC5oaV$H+\u001f9fgV\tq\u000bE\u0002J#b\u0003\"!\u0017/\u000e\u0003iS!a\u0017\u0004\u0002\u000bQL\b/Z:\n\u0005uS&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015y\u0006\u0001\"\u0011a\u0003!!\u0017\r^1UsB,W#A1\u0011\u0005e\u0013\u0017BA2[\u0005!!\u0015\r^1UsB,\u0007\"B3\u0001\t\u00032\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#A4\u0011\u0005!\\W\"A5\u000b\u0005)$\u0011\u0001C1oC2L8/[:\n\u00051L'a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000b9\u0004A\u0011I8\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tA\u001cXo\u001e\t\u0003=EL!A]\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003u[\u0002\u0007\u0001/A\u0002tiJDQA^7A\u0002A\fa\u0001Z3mS6\f\u0004\"\u0002=n\u0001\u0004\u0001\u0018A\u00023fY&l'\u0007C\u0003{\u0001\u0011\u000530\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\u0005aB\u0001\u0010\u007f\u0013\tyx$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f~A\u0011\"!\u0003\u0001\u0003\u0003%\t!a\u0003\u0002\t\r|\u0007/\u001f\u000b\bs\u00055\u0011qBA\t\u0011!9\u0013q\u0001I\u0001\u0002\u0004I\u0003\u0002C\u0018\u0002\bA\u0005\t\u0019A\u0015\t\u0011M\n9\u0001%AA\u0002%B\u0011\"!\u0006\u0001#\u0003%\t!a\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0004\u0016\u0004S\u0005m1FAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dr$\u0001\u0006b]:|G/\u0019;j_:LA!a\u000b\u0002\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005=\u0002!%A\u0005\u0002\u0005]\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003/\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u00028\u0001\t\t\u0011\"\u0011\u0002:\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u000f\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!A.\u00198h\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA\u0002\u0003\u007fA\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0003c\u0001\u0010\u0002R%\u0019\u00111K\u0010\u0003\u0007%sG\u000fC\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u00019\u0002\\!Q\u0011QLA+\u0003\u0003\u0005\r!a\u0014\u0002\u0007a$\u0013\u0007C\u0005\u0002b\u0001\t\t\u0011\"\u0011\u0002d\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002fA)\u0011qMA7a6\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wz\u0012AC2pY2,7\r^5p]&!\u0011qNA5\u0005!IE/\u001a:bi>\u0014\b\"CA:\u0001\u0005\u0005I\u0011AA;\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA<\u0003{\u00022AHA=\u0013\r\tYh\b\u0002\b\u0005>|G.Z1o\u0011%\ti&!\u001d\u0002\u0002\u0003\u0007\u0001\u000fC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u00061Q-];bYN$B!a\u001e\u0002\u0006\"I\u0011QLA@\u0003\u0003\u0005\r\u0001\u001d\u0015\f\u0001\u0005%\u0015qRAI\u0003+\u000b9\nE\u0002\u0012\u0003\u0017K1!!$\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a%\u0002\u0003szf)\u0016(D?\"\"X\r\u001f;\\Y\u0001\u0002\u0018-\u001b:EK2LW\u000e\f\u0011lKf4\u0016\r\\;f\t\u0016d\u0017.\\/*A5\u00023I]3bi\u0016\u001c\b%\u0019\u0011nCB\u0004\u0013M\u001a;fe\u0002\u001a\b\u000f\\5ui&tw\r\t;iK\u0002\"X\r\u001f;!S:$x\u000eI6fs>2\u0018\r\\;fAA\f\u0017N]:!kNLgn\u001a\u0011eK2LW.\u001b;feNt\u0003\u0005R3gCVdG\u000f\t3fY&l\u0017\u000e^3sg\u0002\n'/\u001a\u0011(Y\u001d\u0002cm\u001c:!a\u0006L'\u000fR3mS6\u0004\u0013M\u001c3!Oi:\u0003EZ8sA-,\u0017PV1mk\u0016$U\r\\5n]\u0005AQ\r\u001f;f]\u0012,G-\t\u0002\u0002\u001a\u0006A\u0005E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Cj\nDF\u0019\u001e3Y\rT4g\n\u0017(Y\u001dbsEO\u0014*wqs\u0007%\\1qQ\t\n'E\u000f\u00122E1\u0012#M\t\u001e#e\tb#e\u0019\u0012;EM\u0012\u0013\u0006I\u0004\n\u0003;\u0013\u0011\u0011!E\u0001\u0003?\u000b1b\u0015;sS:<Gk\\'baB\u0019\u0011#!)\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u001bR!!)\u0002&\u000e\u0002\u0002\"a*\u0002.&J\u0013&O\u0007\u0003\u0003SS1!a+ \u0003\u001d\u0011XO\u001c;j[\u0016LA!a,\u0002*\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f]\n\t\u000b\"\u0001\u00024R\u0011\u0011q\u0014\u0005\u000b\u0003o\u000b\t+!A\u0005F\u0005e\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0002BCA_\u0003C\u000b\t\u0011\"!\u0002@\u0006)\u0011\r\u001d9msR9\u0011(!1\u0002D\u0006\u0015\u0007BB\u0014\u0002<\u0002\u0007\u0011\u0006\u0003\u00040\u0003w\u0003\r!\u000b\u0005\u0007g\u0005m\u0006\u0019A\u0015\t\u0015\u0005%\u0017\u0011UA\u0001\n\u0003\u000bY-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u00055\u0017\u0011\u001c\t\u0006=\u0005=\u00171[\u0005\u0004\u0003#|\"AB(qi&|g\u000e\u0005\u0004\u001f\u0003+L\u0013&K\u0005\u0004\u0003/|\"A\u0002+va2,7\u0007C\u0005\u0002\\\u0006\u001d\u0017\u0011!a\u0001s\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u0005}\u0017\u0011UA\u0001\n\u0013\t\t/A\u0006sK\u0006$'+Z:pYZ,GCAAr!\u0011\ti$!:\n\t\u0005\u001d\u0018q\b\u0002\u0007\u001f\nTWm\u0019;")
public class StringToMap
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.text(), this.pairDelim(), this.keyValueDelim()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new MapType(StringType$.MODULE$, StringType$.MODULE$, false);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()}))).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$30) {
                return !x$30.foldable();
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s delimiters must be foldable."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()}))) : ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Object nullSafeEval(Object str, Object delim1, Object delim2) {
        UTF8String[][] array = (UTF8String[][])Predef$.MODULE$.refArrayOps((Object[])((UTF8String)str).split((UTF8String)delim1, -1)).map((Function1)new Serializable(this, delim2){
            public static final long serialVersionUID = 0L;
            private final Object delim2$1;

            public final UTF8String[] apply(UTF8String kv) {
                UTF8String[] arr = kv.split((UTF8String)this.delim2$1, 2);
                return arr.length < 2 ? (UTF8String[])((Object[])new UTF8String[]{arr[0], null}) : arr;
            }
            {
                this.delim2$1 = delim2$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(UTF8String.class))));
        return ArrayBasedMapData$.MODULE$.apply((Object[])Predef$.MODULE$.refArrayOps((Object[])array).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(UTF8String[] x$31) {
                return x$31[0];
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())), (Object[])Predef$.MODULE$.refArrayOps((Object[])array).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(UTF8String[] x$32) {
                return x$32[1];
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any())));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.keyValueDelim();
                break;
            }
            case 1: {
                expression = this.pairDelim();
                break;
            }
            case 0: {
                expression = this.text();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        CodegenFallback$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

