/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionStrategy
extends ZkClientConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(DefaultConnectionStrategy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String serverAddress, int timeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException, InterruptedException, TimeoutException {
        SolrZooKeeper zk = new SolrZooKeeper(serverAddress, timeout, watcher);
        boolean success = false;
        try {
            updater.update(zk);
            success = true;
        }
        finally {
            if (!success) {
                zk.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect(String serverAddress, int zkClientTimeout, Watcher watcher, ZkClientConnectionStrategy.ZkUpdate updater) throws IOException {
        log.info("Connection expired - starting a new one...");
        SolrZooKeeper zk = new SolrZooKeeper(serverAddress, zkClientTimeout, watcher);
        boolean success = false;
        try {
            updater.update(zk);
            success = true;
            log.info("Reconnected to ZooKeeper");
        }
        catch (Exception e) {
            SolrException.log(log, "Reconnect to ZooKeeper failed", e);
            log.info("Reconnect to ZooKeeper failed");
        }
        finally {
            if (!success) {
                try {
                    zk.close();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

