/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.tuscany;

import java.util.List;
import org.apache.servicemix.sca.tuscany.BootstrapHelper;
import org.apache.tuscany.common.monitor.MonitorFactory;
import org.apache.tuscany.common.monitor.impl.NullMonitorFactory;
import org.apache.tuscany.core.builder.ContextFactoryBuilder;
import org.apache.tuscany.core.builder.HierarchicalWireBuilder;
import org.apache.tuscany.core.builder.impl.DefaultWireBuilder;
import org.apache.tuscany.core.config.ConfigurationException;
import org.apache.tuscany.core.config.ModuleComponentConfigurationLoader;
import org.apache.tuscany.core.context.AggregateContext;
import org.apache.tuscany.core.context.CoreRuntimeException;
import org.apache.tuscany.core.context.SystemAggregateContext;
import org.apache.tuscany.core.runtime.RuntimeContext;
import org.apache.tuscany.core.runtime.RuntimeContextImpl;
import org.apache.tuscany.model.assembly.AssemblyModelContext;
import org.apache.tuscany.model.assembly.ModuleComponent;
import org.osoa.sca.ModuleContext;
import org.osoa.sca.SCA;
import org.osoa.sca.ServiceRuntimeException;

public class TuscanyRuntime
extends SCA {
    private final Monitor monitor;
    private final Object sessionKey = new Object();
    private final RuntimeContext runtime;
    private final AggregateContext moduleContext;
    private final ModuleComponent moduleComponent;
    private static final String SYSTEM_MODULE_COMPONENT = "org.apache.tuscany.core.system";

    public TuscanyRuntime(String name, String uri) throws ConfigurationException {
        this(name, uri, Thread.currentThread().getContextClassLoader(), (MonitorFactory)new NullMonitorFactory());
    }

    public TuscanyRuntime(String name, String uri, ClassLoader classLoader, MonitorFactory monitorFactory) throws ConfigurationException {
        this.monitor = (Monitor)monitorFactory.getMonitor(Monitor.class);
        AssemblyModelContext modelContext = BootstrapHelper.getModelContext(classLoader);
        List loaders = modelContext.getAssemblyLoader().getLoaders();
        List<ContextFactoryBuilder> configBuilders = BootstrapHelper.getBuilders();
        this.runtime = new RuntimeContextImpl(monitorFactory, loaders, configBuilders, (HierarchicalWireBuilder)new DefaultWireBuilder());
        this.runtime.start();
        this.monitor.started((AggregateContext)this.runtime);
        SystemAggregateContext systemContext = this.runtime.getSystemContext();
        ModuleComponentConfigurationLoader loader = BootstrapHelper.getConfigurationLoader(systemContext, modelContext);
        ModuleComponent systemModuleComponent = loader.loadSystemModuleComponent(SYSTEM_MODULE_COMPONENT, SYSTEM_MODULE_COMPONENT);
        AggregateContext context = BootstrapHelper.registerModule((AggregateContext)systemContext, systemModuleComponent);
        context.fireEvent(5, null);
        AggregateContext rootContext = this.runtime.getRootContext();
        this.moduleComponent = loader.loadModuleComponent(name, uri);
        this.moduleContext = BootstrapHelper.registerModule(rootContext, this.moduleComponent);
    }

    public ModuleComponent getModuleComponent() {
        return this.moduleComponent;
    }

    public AggregateContext getModuleContext() {
        return this.moduleContext;
    }

    public void start() {
        TuscanyRuntime.setModuleContext((ModuleContext)((ModuleContext)this.moduleContext));
        try {
            this.moduleContext.fireEvent(5, null);
            this.moduleContext.fireEvent(1, null);
            this.moduleContext.fireEvent(3, this.sessionKey);
            this.monitor.started(this.moduleContext);
        }
        catch (CoreRuntimeException e) {
            TuscanyRuntime.setModuleContext(null);
            this.monitor.startFailed(this.moduleContext, e);
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        TuscanyRuntime.setModuleContext(null);
        this.moduleContext.fireEvent(2, null);
        this.moduleContext.fireEvent(4, this.sessionKey);
        this.moduleContext.fireEvent(6, null);
        this.moduleContext.stop();
        this.monitor.stopped(this.moduleContext);
        this.runtime.stop();
        this.monitor.stopped((AggregateContext)this.runtime);
    }

    public static interface Monitor {
        public void started(AggregateContext var1);

        public void startFailed(AggregateContext var1, CoreRuntimeException var2);

        public void stopped(AggregateContext var1);
    }
}

