/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.tuscany;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.apache.tuscany.common.resource.ResourceLoader;
import org.apache.tuscany.common.resource.impl.ResourceLoaderImpl;
import org.apache.tuscany.core.builder.ContextFactoryBuilder;
import org.apache.tuscany.core.config.ConfigurationException;
import org.apache.tuscany.core.config.ModuleComponentConfigurationLoader;
import org.apache.tuscany.core.config.impl.StAXModuleComponentConfigurationLoaderImpl;
import org.apache.tuscany.core.context.AggregateContext;
import org.apache.tuscany.core.context.SystemAggregateContext;
import org.apache.tuscany.core.loader.StAXLoaderRegistry;
import org.apache.tuscany.core.loader.StAXUtil;
import org.apache.tuscany.core.system.assembly.impl.SystemAssemblyFactoryImpl;
import org.apache.tuscany.core.system.builder.SystemContextFactoryBuilder;
import org.apache.tuscany.core.system.builder.SystemEntryPointBuilder;
import org.apache.tuscany.core.system.builder.SystemExternalServiceBuilder;
import org.apache.tuscany.core.system.loader.SystemSCDLModelLoader;
import org.apache.tuscany.model.assembly.AssemblyFactory;
import org.apache.tuscany.model.assembly.AssemblyModelContext;
import org.apache.tuscany.model.assembly.Extensible;
import org.apache.tuscany.model.assembly.ModuleComponent;
import org.apache.tuscany.model.assembly.impl.AssemblyModelContextImpl;
import org.apache.tuscany.model.assembly.loader.AssemblyModelLoader;
import org.apache.tuscany.model.scdl.loader.impl.SCDLAssemblyModelLoaderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapHelper {
    private static final boolean useStax = true;
    private static final String SYSTEM_LOADER_COMPONENT = "tuscany.loader";

    public static AssemblyModelContext getModelContext(ClassLoader classLoader) {
        SystemAssemblyFactoryImpl modelFactory = new SystemAssemblyFactoryImpl();
        ArrayList<SystemSCDLModelLoader> scdlLoaders = new ArrayList<SystemSCDLModelLoader>();
        scdlLoaders.add(new SystemSCDLModelLoader());
        SCDLAssemblyModelLoaderImpl modelLoader = new SCDLAssemblyModelLoaderImpl(scdlLoaders);
        ResourceLoaderImpl resourceLoader = new ResourceLoaderImpl(classLoader);
        return new AssemblyModelContextImpl((AssemblyFactory)modelFactory, (AssemblyModelLoader)modelLoader, (ResourceLoader)resourceLoader);
    }

    public static List<ContextFactoryBuilder> getBuilders() {
        ArrayList<ContextFactoryBuilder> configBuilders = new ArrayList<ContextFactoryBuilder>();
        configBuilders.add((ContextFactoryBuilder)new SystemContextFactoryBuilder());
        configBuilders.add((ContextFactoryBuilder)new SystemEntryPointBuilder());
        configBuilders.add((ContextFactoryBuilder)new SystemExternalServiceBuilder());
        return configBuilders;
    }

    public static ModuleComponentConfigurationLoader getConfigurationLoader(SystemAggregateContext systemContext, AssemblyModelContext modelContext) throws ConfigurationException {
        BootstrapHelper.bootstrapStaxLoader(systemContext, modelContext);
        return new StAXModuleComponentConfigurationLoaderImpl(modelContext, XMLInputFactory.newInstance(), (StAXLoaderRegistry)systemContext.resolveInstance(StAXLoaderRegistry.class));
    }

    private static AggregateContext bootstrapStaxLoader(SystemAggregateContext systemContext, AssemblyModelContext modelContext) throws ConfigurationException {
        AggregateContext loaderContext = (AggregateContext)systemContext.getContext(SYSTEM_LOADER_COMPONENT);
        if (loaderContext == null) {
            ModuleComponent loaderComponent = StAXUtil.bootstrapLoader((String)SYSTEM_LOADER_COMPONENT, (AssemblyModelContext)modelContext);
            loaderContext = BootstrapHelper.registerModule((AggregateContext)systemContext, loaderComponent);
            loaderContext.fireEvent(5, null);
        }
        return loaderContext;
    }

    public static AggregateContext registerModule(AggregateContext parent, ModuleComponent component) throws ConfigurationException {
        parent.registerModelObject((Extensible)component);
        return (AggregateContext)parent.getContext(component.getName());
    }
}

