/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.handler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.Source;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.sca.ScaServiceUnit;
import org.apache.servicemix.sca.assembly.JbiBinding;
import org.apache.tuscany.model.assembly.ExternalService;

public class ExternalJbiServiceClient {
    private ExternalService externalService;
    private JbiBinding jbiBinding;
    private ScaServiceUnit serviceUnit = ScaServiceUnit.getCurrentScaServiceUnit();

    public ExternalJbiServiceClient(ExternalService externalService) {
        this.externalService = externalService;
        this.jbiBinding = (JbiBinding)this.externalService.getBindings().get(0);
    }

    public Object invoke(Method method, Object[] args) {
        if (args == null || args.length != 1) {
            throw new IllegalStateException("args should have exactly one object");
        }
        try {
            Object payload = args[0];
            Class<?> inputClass = method.getParameterTypes()[0];
            Class<?> outputClass = method.getReturnType();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{inputClass, outputClass});
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            context.createMarshaller().marshal(payload, (OutputStream)baos);
            DeliveryChannel channel = this.serviceUnit.getComponent().getComponentContext().getDeliveryChannel();
            InOut inout = channel.createExchangeFactory().createInOutExchange();
            inout.setService(this.jbiBinding.getServiceName());
            NormalizedMessage in = inout.createMessage();
            inout.setInMessage(in);
            in.setContent((Source)new StringSource(baos.toString()));
            boolean sent = channel.sendSync((MessageExchange)inout);
            NormalizedMessage out = inout.getOutMessage();
            Object response = context.createUnmarshaller().unmarshal(out.getContent());
            inout.setStatus(ExchangeStatus.DONE);
            channel.send((MessageExchange)inout);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

