/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca.builder;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.servicemix.sca.assembly.JbiBinding;
import org.apache.servicemix.sca.config.ExternalJbiServiceContextFactory;
import org.apache.servicemix.sca.handler.ExternalJbiServiceClient;
import org.apache.tuscany.core.builder.BuilderException;
import org.apache.tuscany.core.builder.ContextFactoryBuilder;
import org.apache.tuscany.core.builder.ObjectFactory;
import org.apache.tuscany.core.config.JavaIntrospectionHelper;
import org.apache.tuscany.core.context.QualifiedName;
import org.apache.tuscany.core.injection.SingletonObjectFactory;
import org.apache.tuscany.core.invocation.Interceptor;
import org.apache.tuscany.core.invocation.InvocationConfiguration;
import org.apache.tuscany.core.invocation.MethodHashMap;
import org.apache.tuscany.core.invocation.ProxyConfiguration;
import org.apache.tuscany.core.invocation.impl.InvokerInterceptor;
import org.apache.tuscany.core.invocation.spi.ProxyFactory;
import org.apache.tuscany.core.invocation.spi.ProxyFactoryFactory;
import org.apache.tuscany.core.message.MessageFactory;
import org.apache.tuscany.core.runtime.RuntimeContext;
import org.apache.tuscany.core.system.annotation.Autowire;
import org.apache.tuscany.model.assembly.AssemblyModelObject;
import org.apache.tuscany.model.assembly.ConfiguredService;
import org.apache.tuscany.model.assembly.ExternalService;
import org.apache.tuscany.model.assembly.Service;
import org.apache.tuscany.model.assembly.ServiceContract;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Scope;

@Scope(value="MODULE")
public class ExternalJbiServiceBuilder
implements ContextFactoryBuilder {
    private RuntimeContext runtimeContext;
    private ProxyFactoryFactory proxyFactoryFactory;
    private MessageFactory messageFactory;
    private ContextFactoryBuilder policyBuilder;

    @Init(eager=true)
    public void init() {
        this.runtimeContext.addBuilder((ContextFactoryBuilder)this);
    }

    @Autowire
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    @Autowire
    public void setProxyFactoryFactory(ProxyFactoryFactory factory) {
        this.proxyFactoryFactory = factory;
    }

    @Autowire
    public void setMessageFactory(MessageFactory msgFactory) {
        this.messageFactory = msgFactory;
    }

    public void setPolicyBuilder(ContextFactoryBuilder builder) {
        this.policyBuilder = builder;
    }

    public void build(AssemblyModelObject object) throws BuilderException {
        if (!(object instanceof ExternalService)) {
            return;
        }
        ExternalService externalService = (ExternalService)object;
        if (externalService.getBindings().size() < 1 || !(externalService.getBindings().get(0) instanceof JbiBinding)) {
            return;
        }
        ExternalJbiServiceClient externalJbiServiceClient = new ExternalJbiServiceClient(externalService);
        ExternalJbiServiceContextFactory config = new ExternalJbiServiceContextFactory(externalService.getName(), (ObjectFactory)new SingletonObjectFactory((Object)externalJbiServiceClient));
        ConfiguredService configuredService = externalService.getConfiguredService();
        Service service = configuredService.getService();
        ServiceContract serviceContract = service.getServiceContract();
        MethodHashMap iConfigMap = new MethodHashMap();
        ProxyFactory proxyFactory = this.proxyFactoryFactory.createProxyFactory();
        Set javaMethods = JavaIntrospectionHelper.getAllUniqueMethods((Class)serviceContract.getInterface());
        for (Method method : javaMethods) {
            InvocationConfiguration iConfig = new InvocationConfiguration(method);
            iConfigMap.put(method, iConfig);
        }
        QualifiedName qName = new QualifiedName(externalService.getName() + "/" + service.getName());
        ProxyConfiguration pConfiguration = new ProxyConfiguration(qName, (Map)iConfigMap, serviceContract.getInterface().getClassLoader(), this.messageFactory);
        proxyFactory.setBusinessInterface(serviceContract.getInterface());
        proxyFactory.setProxyConfiguration(pConfiguration);
        config.addTargetProxyFactory(service.getName(), proxyFactory);
        configuredService.setProxyFactory((Object)proxyFactory);
        if (this.policyBuilder != null) {
            this.policyBuilder.build((AssemblyModelObject)configuredService);
        }
        for (InvocationConfiguration iConfig : iConfigMap.values()) {
            iConfig.addTargetInterceptor((Interceptor)new InvokerInterceptor());
        }
        externalService.getConfiguredService().setContextFactory((Object)config);
    }
}

