/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.Source;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.sca.ScaServiceUnit;
import org.apache.tuscany.core.context.EntryPointContext;
import org.apache.tuscany.model.assembly.ConfiguredReference;
import org.apache.tuscany.model.assembly.ConfiguredService;
import org.apache.tuscany.model.assembly.EntryPoint;

public class ScaEndpoint
extends Endpoint
implements ExchangeProcessor {
    protected ServiceEndpoint activated;
    protected EntryPoint entryPoint;
    protected Map<Class, Method> methodMap;
    protected JAXBContext jaxbContext;
    protected DeliveryChannel channel;

    public ScaEndpoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public MessageExchange.Role getRole() {
        return MessageExchange.Role.PROVIDER;
    }

    public void activate() throws Exception {
        this.logger = this.serviceUnit.getComponent().getLogger();
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        this.activated = ctx.activateEndpoint(this.service, this.endpoint);
        this.channel = ctx.getDeliveryChannel();
        ConfiguredReference referenceValue = this.entryPoint.getConfiguredReference();
        ConfiguredService targetServiceEndpoint = (ConfiguredService)referenceValue.getTargetConfiguredServices().get(0);
        Class serviceInterface = targetServiceEndpoint.getService().getServiceContract().getInterface();
        ArrayList classes = new ArrayList();
        this.methodMap = new HashMap<Class, Method>();
        for (Method mth : serviceInterface.getMethods()) {
            Class<?>[] params = mth.getParameterTypes();
            if (params.length != 1) {
                throw new IllegalStateException("Supports only methods with one parameter");
            }
            this.methodMap.put(params[0], mth);
            classes.add(mth.getReturnType());
            classes.add(params[0]);
        }
        this.jaxbContext = JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
    }

    public void deactivate() throws Exception {
        ServiceEndpoint ep = this.activated;
        this.activated = null;
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        ctx.deactivateEndpoint(ep);
    }

    public ExchangeProcessor getProcessor() {
        return this;
    }

    public void process(MessageExchange exchange) throws Exception {
        Object output;
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        Object input = this.jaxbContext.createUnmarshaller().unmarshal(exchange.getMessage("in").getContent());
        Method method = this.methodMap.get(input.getClass());
        if (method == null) {
            throw new IllegalStateException("Could not determine invoked web method");
        }
        boolean oneWay = method.getReturnType() == null;
        try {
            EntryPointContext entryPointContext = (EntryPointContext)((ScaServiceUnit)this.serviceUnit).getTuscanyRuntime().getModuleContext().getContext(this.entryPoint.getName());
            InvocationHandler handler = (InvocationHandler)entryPointContext.getImplementationInstance();
            output = handler.invoke(null, method, new Object[]{input});
        }
        catch (UndeclaredThrowableException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (oneWay) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.channel.send(exchange);
        } else {
            NormalizedMessage msg = exchange.createMessage();
            exchange.setMessage(msg, "out");
            StringWriter writer = new StringWriter();
            this.jaxbContext.createMarshaller().marshal(output, (Writer)writer);
            msg.setContent((Source)new StringSource(writer.toString()));
            this.channel.send(exchange);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

