/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.sca;

import java.io.File;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.BaseComponent;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.sca.ScaServiceUnit;

public class ScaDeployer
extends AbstractDeployer {
    public static final String SCA_MODULE_FILE = "sca.module";

    public ScaDeployer(BaseComponent component) {
        super((ServiceMixComponent)component);
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File module = new File(serviceUnitRootPath, SCA_MODULE_FILE);
        return module.exists() && module.isFile();
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        File module = new File(serviceUnitRootPath, SCA_MODULE_FILE);
        if (!module.exists() || !module.isFile()) {
            throw this.failure("deploy", "No sca.module found", null);
        }
        try {
            ScaServiceUnit su = new ScaServiceUnit();
            su.setComponent(this.component);
            su.setName(serviceUnitName);
            su.setRootPath(serviceUnitRootPath);
            su.init();
            return su;
        }
        catch (Exception e) {
            throw this.failure("deploy", "Error loading sca module", e);
        }
    }
}

