/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.jms.impl.AmqpMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.BytesMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MapMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.ObjectMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.StreamMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TextMessageImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpSequence;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

class MessageFactory {
    private final SessionImpl _session;

    MessageFactory(SessionImpl session) {
        this._session = session;
    }

    public MessageImpl createMessage(DestinationImpl destination, Message msg) {
        MessageImpl message;
        Section section;
        List payload = msg.getPayload();
        Header header = null;
        MessageAnnotations messageAnnotations = null;
        Properties properties = null;
        ApplicationProperties appProperties = null;
        Iterator iter = payload.iterator();
        ArrayList<Section> body = new ArrayList<Section>();
        Section section2 = section = iter.hasNext() ? (Section)iter.next() : null;
        if (section instanceof Header) {
            header = (Header)section;
            Section section3 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof DeliveryAnnotations) {
            Section section4 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof MessageAnnotations) {
            messageAnnotations = (MessageAnnotations)section;
            Section section5 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof Properties) {
            properties = (Properties)section;
            Section section6 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof ApplicationProperties) {
            appProperties = (ApplicationProperties)section;
            Section section7 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        while (section != null && !(section instanceof Footer)) {
            body.add(section);
            section = iter.hasNext() ? (Section)iter.next() : null;
        }
        Footer footer = (Footer)section;
        if (body.size() == 1) {
            Section bodySection = (Section)body.get(0);
            if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof Map) {
                message = new MapMessageImpl(header, messageAnnotations, properties, appProperties, (Map)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof List) {
                message = new StreamMessageImpl(header, messageAnnotations, properties, appProperties, (List)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof String) {
                message = new TextMessageImpl(header, messageAnnotations, properties, appProperties, (String)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof Binary) {
                Binary value = (Binary)((AmqpValue)bodySection).getValue();
                message = new BytesMessageImpl(header, messageAnnotations, properties, appProperties, new Data(value), footer, this._session);
            } else {
                message = bodySection instanceof Data ? (properties != null && ObjectMessageImpl.CONTENT_TYPE.equals(properties.getContentType()) ? new ObjectMessageImpl(header, messageAnnotations, properties, appProperties, (Data)bodySection, footer, this._session) : new BytesMessageImpl(header, messageAnnotations, properties, appProperties, (Data)bodySection, footer, this._session)) : (bodySection instanceof AmqpSequence ? new StreamMessageImpl(header, messageAnnotations, properties, appProperties, ((AmqpSequence)bodySection).getValue(), footer, this._session) : new AmqpMessageImpl(header, messageAnnotations, properties, appProperties, body, footer, this._session));
            }
        } else {
            message = new AmqpMessageImpl(header, messageAnnotations, properties, appProperties, body, footer, this._session);
        }
        message.setReadOnly();
        return message;
    }
}

