/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintStream;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class SurefireStarter {
    private final ProviderConfiguration providerConfiguration;
    private final StartupConfiguration startupConfiguration;
    private static final String SUREFIRE_TEST_CLASSPATH = "surefire.test.class.path";
    private final StartupReportConfiguration startupReportConfiguration;

    public SurefireStarter(StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, StartupReportConfiguration startupReportConfiguration) {
        this.providerConfiguration = providerConfiguration;
        this.startupConfiguration = startupConfiguration;
        this.startupReportConfiguration = startupReportConfiguration;
    }

    public RunResult runSuitesInProcessWhenForked(Object testSet) throws SurefireExecutionException {
        this.writeSurefireTestClasspathProperty();
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        ClassLoader testsClassLoader = classpathConfiguration.createTestClassLoaderConditionallySystem(this.startupConfiguration.useSystemClassLoader());
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object forkingReporterFactory = this.createForkingReporterFactory(surefireReflector);
        return this.invokeProvider(testSet, testsClassLoader, surefireClassLoader, forkingReporterFactory);
    }

    private Object createForkingReporterFactory(SurefireReflector surefireReflector) {
        Boolean trimStackTrace = this.providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        PrintStream originalSystemOut = this.providerConfiguration.getReporterConfiguration().getOriginalSystemOut();
        return surefireReflector.createForkingReporterFactory(trimStackTrace, originalSystemOut);
    }

    public RunResult runSuitesInProcessWhenForked() throws SurefireExecutionException {
        ClassLoader testsClassLoader = this.createInProcessTestClassLoader();
        ClassLoader surefireClassLoader = this.createSurefireClassloader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object factory = this.createForkingReporterFactory(surefireReflector);
        return this.invokeProvider(null, testsClassLoader, surefireClassLoader, factory);
    }

    public RunResult runSuitesInProcess() throws SurefireExecutionException {
        ClassLoader testsClassLoader = this.createInProcessTestClassLoader();
        ClassLoader surefireClassLoader = this.createSurefireClassloader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object factory = surefireReflector.createReportingReporterFactory(this.startupReportConfiguration);
        return this.invokeProvider(null, testsClassLoader, surefireClassLoader, factory);
    }

    private ClassLoader createSurefireClassloader(ClassLoader testsClassLoader) throws SurefireExecutionException {
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        return classpathConfiguration.createSurefireClassLoader(testsClassLoader);
    }

    private ClassLoader createInProcessTestClassLoader() throws SurefireExecutionException {
        this.writeSurefireTestClasspathProperty();
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        if (this.startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
            ClassLoader testsClassLoader = this.getClass().getClassLoader();
            System.setProperty("surefire.real.class.path", System.getProperty("java.class.path"));
            classpathConfiguration.getTestClasspath().writeToSystemProperty("java.class.path");
            return testsClassLoader;
        }
        return classpathConfiguration.createTestClassLoader();
    }

    private void writeSurefireTestClasspathProperty() {
        ClasspathConfiguration classpathConfiguration = this.startupConfiguration.getClasspathConfiguration();
        classpathConfiguration.getTestClasspath().writeToSystemProperty(SUREFIRE_TEST_CLASSPATH);
    }

    private RunResult invokeProvider(Object testSet, ClassLoader testsClassLoader, ClassLoader surefireClassLoader, Object factory) {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        ProviderFactory providerFactory = new ProviderFactory(this.startupConfiguration, this.providerConfiguration, surefireClassLoader, testsClassLoader, factory);
        SurefireProvider provider = providerFactory.createProvider();
        try {
            RunResult runResult = provider.invoke(testSet);
            return runResult;
        }
        catch (TestSetFailedException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        catch (ReporterException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        finally {
            if (System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }
}

