/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.svnexe.command.AbstractFileCheckingConsumer;

public class SvnUpdateConsumer
extends AbstractFileCheckingConsumer {
    private static final String UPDATED_TO_REVISION_TOKEN = "Updated to revision";
    private static final String AT_REVISION_TOKEN = "At revision";
    private static final String EXPORTED_REVISION_TOKEN = "Exported revision";
    private static final String RESTORED_TOKEN = "Restored";
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();

    public SvnUpdateConsumer(ScmLogger logger, File workingDirectory) {
        super(logger, workingDirectory);
    }

    @Override
    protected void parseLine(String line) {
        ScmFileStatus status;
        line = line.trim();
        String statusString = line.substring(0, 1);
        String file = line.substring(3).trim();
        if (file.startsWith(this.workingDirectory.getAbsolutePath())) {
            file = file.length() == this.workingDirectory.getAbsolutePath().length() ? "." : file.substring(this.workingDirectory.getAbsolutePath().length() + 1);
        }
        if (line.startsWith(UPDATED_TO_REVISION_TOKEN)) {
            String revisionString = line.substring(UPDATED_TO_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(AT_REVISION_TOKEN)) {
            String revisionString = line.substring(AT_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(EXPORTED_REVISION_TOKEN)) {
            String revisionString = line.substring(EXPORTED_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(RESTORED_TOKEN)) {
            return;
        }
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("U") || statusString.equals("M")) {
            status = ScmFileStatus.UPDATED;
        } else if (statusString.equals("D")) {
            status = ScmFileStatus.DELETED;
        } else {
            return;
        }
        this.addFile(new ScmFile(file, status));
        List<ChangeFile> changeFiles = Arrays.asList(new ChangeFile(line, Integer.valueOf(this.revision).toString()));
        ChangeSet changeSet = new ChangeSet(null, null, null, changeFiles);
        this.changeSets.add(changeSet);
    }

    public List<ScmFile> getUpdatedFiles() {
        return this.getFiles();
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void setChangeSets(List<ChangeSet> changeSets) {
        this.changeSets = changeSets;
    }
}

