/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;

public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private ByteArrayOutputStream data;
    private Map serviceEntries = new HashMap();

    public boolean canTransformResource(String resource) {
        if (resource.startsWith(SERVICES_PATH)) {
            this.data = (ByteArrayOutputStream)this.serviceEntries.get(resource);
            if (this.data == null) {
                this.data = new ByteArrayOutputStream();
                this.serviceEntries.put(resource, this.data);
            }
            return true;
        }
        return false;
    }

    public void processResource(InputStream is) throws IOException {
        IOUtil.copy((InputStream)is, (OutputStream)this.data);
        is.close();
    }

    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        Iterator i = this.serviceEntries.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            ByteArrayOutputStream data = (ByteArrayOutputStream)this.serviceEntries.get(key);
            jos.putNextEntry(new JarEntry(key));
            IOUtil.copy((InputStream)new ByteArrayInputStream(data.toByteArray()), (OutputStream)jos);
            data.reset();
        }
    }
}

