/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class DefaultShader
extends AbstractLogEnabled
implements Shader {
    public void shade(Set jars, File uberJar, List filters, List relocators, List resourceTransformers) throws IOException {
        HashSet resources = new HashSet();
        RelocatorRemapper remapper = new RelocatorRemapper(relocators);
        uberJar.getParentFile().mkdirs();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(uberJar));
        Iterator i = jars.iterator();
        while (i.hasNext()) {
            File jar = (File)i.next();
            List jarFilters = this.getFilters(jar, filters);
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> j = jarFile.entries();
            while (j.hasMoreElements()) {
                JarEntry entry = j.nextElement();
                String name = entry.getName();
                if ("META-INF/INDEX.LIST".equals(name)) continue;
                String mappedName = remapper.map(name);
                InputStream is = jarFile.getInputStream(entry);
                if (!entry.isDirectory() && !this.isFiltered(jarFilters, name)) {
                    String dir;
                    int idx = mappedName.lastIndexOf(47);
                    if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                        this.addDirectory(resources, jos, dir);
                    }
                    if (name.endsWith(".class")) {
                        this.addRemappedClass(remapper, jos, jar, name, is);
                    } else if (!this.resourceTransformed(resourceTransformers, mappedName, is)) {
                        if (resources.contains(mappedName)) continue;
                        this.addResource(resources, jos, mappedName, is);
                    }
                }
                IOUtil.close((InputStream)is);
            }
            jarFile.close();
        }
        i = resourceTransformers.iterator();
        while (i.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)i.next();
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(jos);
        }
        IOUtil.close((OutputStream)jos);
    }

    private List getFilters(File jar, List filters) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)filters.get(i);
            if (!filter.canFilter(jar)) continue;
            list.add(filter);
        }
        return list;
    }

    private void addDirectory(Set resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, File jar, String name, InputStream is) throws IOException {
        if (!remapper.hasRelocators()) {
            try {
                jos.putNextEntry(new JarEntry(name));
                IOUtil.copy((InputStream)is, (OutputStream)jos);
            }
            catch (ZipException e) {
                this.getLogger().warn("We have a duplicate " + name + " in " + jar);
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(cr, 0);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper);
        cr.accept((ClassVisitor)cv, 8);
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        try {
            jos.putNextEntry(new JarEntry(mappedName + ".class"));
            IOUtil.copy((byte[])renamedClass, (OutputStream)jos);
        }
        catch (ZipException e) {
            this.getLogger().warn("We have a duplicate " + mappedName + " in " + jar);
        }
    }

    private boolean isFiltered(List filters, String name) {
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)filters.get(i);
            if (!filter.isFiltered(name)) continue;
            return true;
        }
        return false;
    }

    private boolean resourceTransformed(List resourceTransformers, String name, InputStream is) throws IOException {
        boolean resourceTransformed = false;
        Iterator k = resourceTransformers.iterator();
        while (k.hasNext()) {
            ResourceTransformer transformer = (ResourceTransformer)k.next();
            if (!transformer.canTransformResource(name)) continue;
            transformer.processResource(is);
            resourceTransformed = true;
            break;
        }
        return resourceTransformed;
    }

    private void addResource(Set resources, JarOutputStream jos, String name, InputStream is) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        IOUtil.copy((InputStream)is, (OutputStream)jos);
        resources.add(name);
    }

    class RelocatorRemapper
    extends Remapper {
        List relocators;

        public RelocatorRemapper(List relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                Iterator i = this.relocators.iterator();
                while (i.hasNext()) {
                    Relocator r = (Relocator)i.next();
                    if (r.canRelocatePath(name)) {
                        value = r.relocatePath(name);
                        break;
                    }
                    if (!r.canRelocateClass(name)) continue;
                    value = r.relocateClass(name);
                    break;
                }
                return value;
            }
            return object;
        }

        public String map(String name) {
            String value = name;
            Iterator i = this.relocators.iterator();
            while (i.hasNext()) {
                Relocator r = (Relocator)i.next();
                if (!r.canRelocatePath(name)) continue;
                value = r.relocatePath(name);
                break;
            }
            return value;
        }
    }
}

