/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import org.apache.kafka.common.TopicPartition;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)Q\u0005\u0001C\u0005M!)q\u0007\u0001C\u00011!)A\b\u0001C\u00011\tQ\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'\u000fV3ti*\u0011\u0001\"C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0004\u0002'\rdW-\u00198NKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0015\u0003e\u0001\"A\u0004\u000e\n\u0005my!\u0001B+oSRD#AA\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013!\u00026v]&$(\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%?\t1!)\u001a4pe\u0016\fabZ3u\u001b\u0016$(/[2WC2,X\r\u0006\u0002(UA\u0011a\u0002K\u0005\u0003S=\u00111!\u00118z\u0011\u0015Y3\u00011\u0001-\u0003\u0011q\u0017-\\3\u0011\u00055\"dB\u0001\u00183!\tys\"D\u00011\u0015\t\t4\"\u0001\u0004=e>|GOP\u0005\u0003g=\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111gD\u0001\u001ai\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0005sA\u0011aDO\u0005\u0003w}\u0011A\u0001V3ti\u0006qB/Z:u\u001b\u0016$(/[2GC&dW\r\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0003\u000be\u0002")
public class AbstractFetcherManagerTest {
    @Before
    public void cleanMetricRegistry() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)metricName -> {
            AbstractFetcherManagerTest.$anonfun$cleanMetricRegistry$1(metricName);
            return BoxedUnit.UNIT;
        });
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x$1))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        InitialFetchState initialFetchState = new InitialFetchState(new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        fetcher.start();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        fetcher.addPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetAndEpoch(fetchOffset, leaderEpoch))})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply(fetchOffset, leaderEpoch, (ReplicaState)Truncating$.MODULE$)));
        fetcher.removePartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)fetcher.fetchState(tp)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{fetcher});
        fetcherManager.addFetcherForPartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assert.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        EasyMock.verify((Object[])new Object[]{fetcher});
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)EasyMock.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    public static final /* synthetic */ void $anonfun$cleanMetricRegistry$1(MetricName metricName) {
        Metrics.defaultRegistry().removeMetric(metricName);
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, MetricName x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

