/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\"E\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001A\u0002\u0013\u0005Q\u000bC\u0004_\u0001\u0001\u0007I\u0011A0\t\r\u0015\u0004\u0001\u0015)\u0003W\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDqa\u001b\u0001A\u0002\u0013\u0005A\u000e\u0003\u0004o\u0001\u0001\u0006K\u0001\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u0019a\b\u0001)A\u0005c\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0003\u0001\u0001\u0006Ia \u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\u0005\u0001A\u0003%\u00111\u0002\u0005\n\u0003'\u0001!\u0019!C\u0001\u0003+A\u0001\"a\t\u0001A\u0003%\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t9\u0004\u0001C\u0001\u0003OAq!!\u0011\u0001\t\u0003\t9\u0003C\u0004\u0002L\u0001!\t!a\n\t\u000f\u0005=\u0003\u0001\"\u0001\u0002(!9\u00111\u000b\u0001\u0005\u0002\u0005\u001d\u0002bBA,\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003W\u0002A\u0011AA\u0014\u0011\u001d\ty\u0007\u0001C\u0001\u0003OAq!a\u001d\u0001\t\u0003\t9\u0003C\u0004\u0002x\u0001!\t!a\n\t\u000f\u0005m\u0004\u0001\"\u0001\u0002(!9\u0011q\u0010\u0001\u0005\u0002\u0005\u001d\u0002bBAB\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u000f\u0003A\u0011AA\u0014\u0011\u001d\tY\t\u0001C\u0001\u0003OAq!a&\u0001\t\u0003\t9\u0003C\u0004\u0002\u001c\u0002!\t!a\n\t\u000f\u0005}\u0005\u0001\"\u0001\u0002(!9\u00111\u0015\u0001\u0005\u0002\u0005\u001d\u0002bBAX\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003g\u0003A\u0011AA\u0014\u0011\u001d\t9\f\u0001C\u0001\u0003OAq!a/\u0001\t\u0003\t9\u0003C\u0004\u0002@\u0002!\t!a\n\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002(!9\u0011q\u0019\u0001\u0005\u0002\u0005\u001d\u0002bBAf\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u001f\u0004A\u0011AA\u0014\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003OAq!a6\u0001\t\u0003\t9\u0003C\u0004\u0002\\\u0002!\t!a\n\t\u000f\u0005}\u0007\u0001\"\u0001\u0002(!9\u00111\u001d\u0001\u0005\u0002\u0005\u001d\u0002bBAt\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003g\u0004A\u0011AA\u0014\u0011\u001d\t9\u0010\u0001C\u0001\u0003OAqAa\u0001\u0001\t\u0003\t9\u0003C\u0004\u0003\b\u0001!\t!a\n\t\u000f\t-\u0001\u0001\"\u0001\u0002(!9!q\u0002\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011%\u0011i\u0007AI\u0001\n\u0013\u0011y\u0007C\u0005\u0003\u0006\u0002\t\n\u0011\"\u0003\u0003\b\"9!1\u0012\u0001\u0005\n\t5\u0005\"\u0003BV\u0001E\u0005I\u0011\u0002BD\u0011%\u0011i\u000bAI\u0001\n\u0013\u0011y\u000bC\u0005\u00034\u0002\t\n\u0011\"\u0003\u00030\"9!1\u0012\u0001\u0005\n\tU\u0006b\u0002Bf\u0001\u0011%!Q\u001a\u0002\u0019!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:UKN$(BA#G\u0003\rawn\u001a\u0006\u0002\u000f\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001K!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011\u0001R\u0001\u0007Y><G)\u001b:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0005%|'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005\u0001\u001c\u0007CA&b\u0013\t\u0011GJ\u0001\u0003V]&$\bb\u00023\u0004\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\rgR\fG/Z'b]\u0006<WM]\u000b\u0002QB\u00111+[\u0005\u0003U\u0012\u0013A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\u0018\u0001E:uCR,W*\u00198bO\u0016\u0014x\fJ3r)\t\u0001W\u000eC\u0004e\r\u0005\u0005\t\u0019\u00015\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001r!\t\u0011(0D\u0001t\u0015\t!X/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000fZT!a\u001e=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0018aA8sO&\u00111p\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#W#A@\u0011\u0007-\u000b\t!C\u0002\u0002\u00041\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u0003Ii\u0017\r\u001f)jI\u0016C\b/\u001b:bi&|g.T:\u0016\u0005\u0005-\u0001cA&\u0002\u000e%\u0019\u0011q\u0002'\u0003\u0007%sG/A\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0003uS6,WCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fg\u0006)Q\u000f^5mg&!\u0011\u0011EA\u000e\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0003H#\u00011)\u0007A\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004_\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\tyC\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011#a\u000f\u0011\t\u00055\u0012QH\u0005\u0005\u0003\u007f\tyCA\u0003BMR,'/\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007f\u0001\n\u0002FA!\u0011QFA$\u0013\u0011\tI%a\f\u0003\tQ+7\u000f^\u0001'i\u0016\u001cH/\u00119qK:$G\u000b\u001f8NCJ\\WM],ji\"tu\u000e\u0015:pIV\u001cWM]*uCR,\u0007fA\n\u0002F\u0005qB/Z:u!J|G-^2feN+\u0017/^3oG\u0016<&/\u00199Be>,h\u000e\u001a\u0015\u0004)\u0005\u0015\u0013!\f;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWmV5uQ^\u0013\u0018\r]!s_VtGMQ1uG\"\u0014VmY8sI\"\u001aQ#!\u0012\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f\u0013:4\u0018\r\\5e/J\f\u0007/\u0011:pk:$\u0007f\u0002\f\u0002F\u0005m\u0013QL\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM:\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\tI'a\u0019\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0003)\"Xm\u001d;O_Z\u000bG.\u001b3bi&|gn\u00148GSJ\u001cH/\u00128uef<\u0006.\u001a8M_\u0006$\u0017N\\4M_\u001eD3aFA#\u0003m!Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000f\u001a\"v[B\u001cX\t]8dQ\"\u001a\u0001$!\u0012\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u00043\u0005\u0015\u0013\u0001\t;fgRd\u0015m\u001d;Ti\u0006\u0014G.Z(gMN,GoQ8na2,G/\u001a3Uq:D3AGA#\u00039\"Xm\u001d;O_:l\u0015\r^2iS:<G\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$X*\u001a;bI\u0006$\u0018MT8u\u0007\u0006\u001c\u0007.\u001a3)\u0007m\t)%\u0001\u0010uKN$\bK]3qCJ,W\u000b\u001d3bi\u0016$u.Z:O_RlU\u000f^1uK\"\u001aA$!\u0012\u0002=U\u0004H-\u0019;f!J|G-^2feR\u0013\u0018M\\:bGRLwN\\*uCR,\u0007fA\u000f\u0002F\u0005aC/Z:u\u001fV$xJZ*fcV,gnY3BMR,'oQ8oiJ|GNU3d_J$W\t]8dQ\n+X\u000e\u001d\u0015\u0004=\u0005\u0015\u0013\u0001\r;fgRtuN\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00119qK:$w+\u001b;i\u001f:<w.\u001b8h)J\fgn]1di&|g\u000eK\u0004 \u0003\u000b\nY&a$$\u0005\u0005E\u0005\u0003BA1\u0003'KA!!&\u0002d\tA\u0012J\u001c<bY&$G\u000b\u001f8Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002_Q,7\u000f\u001e+sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bIJ+Wn\u001c<fg>+Ho\u00144SC:<Wm\u00158baNDw\u000e^:)\u0007\u0001\n)%\u0001\tuKN$H+Y6f':\f\u0007o\u001d5pi\"\u001a\u0011%!\u0012\u0002/Q,7\u000f\u001e*fG>4XM\u001d$s_6\u001cf.\u00199tQ>$\bf\u0001\u0012\u0002F\u0005iB/Z:u%\u0016lwN^3FqBL'/\u001a3QS\u0012\u001cxJ\u001c*fY>\fG\rK\u0004$\u0003\u000b\nY&a*$\u0005\u0005%\u0006\u0003BA1\u0003WKA!!,\u0002d\tQRK\\6o_^t\u0007K]8ek\u000e,'/\u00133Fq\u000e,\u0007\u000f^5p]\u0006iC/Z:u\u0003\u000e\u001cW\r\u001d;BaB,g\u000eZ,ji\"|W\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$Xm\u00148SKBd\u0017nY1)\u0007\u0011\n)%A\u0015uKN$\u0018iY2faR\f\u0005\u000f]3oI^KG\u000f[*fcV,gnY3HCB\u001cxJ\u001c*fa2L7-\u0019\u0015\u0004K\u0005\u0015\u0013!\u0007;fgR$U\r\\3uKNs\u0017\r]:i_R\u001c()\u001a4pe\u0016D3AJA#\u00031!Xm\u001d;UeVt7-\u0019;fQ\r9\u0013QI\u0001'i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKR\fe\r^3s)J,hnY1uS>t\u0007f\u0001\u0015\u0002F\u0005!C/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^!gi\u0016\u0014XI^5di&|g\u000eK\u0002*\u0003\u000b\n\u0001\u0003^3tiR\u0013XO\\2bi\u0016DU-\u00193)\u0007)\n)%A\u0018uKN$Hj\\1e\rJ|Wn\u00158baNDw\u000e\u001e*f[>4Xm\u001d(p]J+G/Y5oK\u0012\u0004&o\u001c3vG\u0016\u00148\u000fK\u0002,\u0003\u000b\n\u0011\u0005^3tiN[\u0017\u000e]*oCB\u001c\bn\u001c;JM>3gm]3u+:\u001c\u0007.\u00198hK\u0012D3\u0001LA#\u0003=!Xm\u001d;Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\u0017\u0002F\u0005AB/Z:u!&$W\t\u001f9je\u0006$\u0018n\u001c8US6,w.\u001e;)\u000f9\n)%a\u0017\u0002(\u00069B/Z:u\r&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004_\u0005\u0015\u0013A\f;fgR\u0004&o\u001c3vG\u0016\u00148oV5uQ>swm\\5oOR\u0013\u0018M\\:bGRLwN\\:E_:$X\t\u001f9je\u0016D3\u0001MA#\u00035\"Xm\u001d;TKF,XM\\2f\u001d>$h+\u00197jI\u0006$X\r\u001a$pe\u001e\u0013x.\u001e9NKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0015\u0004c\u0005\u0015\u0013\u0001\b;fgR|E\u000eZ#q_\u000eDgi\u001c:D_:$(o\u001c7SK\u000e|'\u000f\u001a\u0015\be\u0005\u0015\u00131LAvG\t\ti\u000f\u0005\u0003\u0002b\u0005=\u0018\u0002BAy\u0003G\u0012q\u0003\u0015:pIV\u001cWM\u001d$f]\u000e,G-\u0012=dKB$\u0018n\u001c8\u0002-Q,7\u000f^\"p_J$\u0017N\\1u_J4UM\\2j]\u001eD3aMA#\u0003\u0001\"Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dK\u0012\fe\r^3s%\u0016dw.\u00193)\u000fQ\n)%a\u0017\u0002|\u000e\u0012\u0011Q \t\u0005\u0003C\ny0\u0003\u0003\u0003\u0002\u0005\r$!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0003u!Xm\u001d;M_\u0006$gI]8n\u000b6\u0004H/_*oCB\u001c\bn\u001c;GS2,\u0007fA\u001b\u0002F\u0005\tC/Z:u\u0019>\fGM\u0012:p[R\u0013XO\\2bi\u0016$7K\\1qg\"|GOR5mK\"\u001aa'!\u0012\u0002?Q,7\u000f\u001e'pC\u00124%o\\7D_J\u0014X\u000f\u001d;T]\u0006\u00048\u000f[8u\r&dW\rK\u00028\u0003\u000b\n1\u0004^3ti\u0006\u0003\b/\u001a8e\u000b6\u0004H/_\"p]R\u0014x\u000e\u001c\"bi\u000eD\u0007f\u0001\u001d\u0002F\u0005YB/Z:u\u0019>\fGM\u0012:p[\u000e{'O];qiNs\u0017\r]:i_R$2\u0001\u0019B\f\u0011\u001d\u0011I\"\u000fa\u0001\u00057\tq\"\\1lK\u001aKG.Z\"peJ,\b\u000f\u001e\t\u0007\u0017\nu!\u0011\u00051\n\u0007\t}AJA\u0005Gk:\u001cG/[8ocA!!1\u0005B\u0017\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012\u0001C2iC:tW\r\\:\u000b\u0007\t-\",A\u0002oS>LAAa\f\u0003&\tYa)\u001b7f\u0007\"\fgN\\3m\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015!\tU\"\u0011\tB#\u0005\u000f\u0012\tF!\u0019\u0003f\t%\u0004CB&\u00038\tmr0C\u0002\u0003:1\u0013a\u0001V;qY\u0016\u0014\u0004cA*\u0003>%\u0019!q\b#\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\r\t\r#\b1\u0001i\u0003\u001di\u0017\r\u001d9j]\u001eDQ! \u001eA\u0002}DqA!\u0013;\u0001\u0004\u0011Y%A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004\u0017\n5\u0013b\u0001B(\u0019\n)1\u000b[8si\"9!1\u000b\u001eA\u0002\tU\u0013aC2p]R\u0014x\u000e\u001c+za\u0016\u0004BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057\u001a\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0003`\te#!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"1!1\r\u001eA\u0002}\faa\u001c4gg\u0016$\b\"\u0003B4uA\u0005\t\u0019AA\u0006\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000e\u0003\u0005\u0003li\u0002\n\u00111\u0001\u0000\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u000fbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tE$\u0006BA\u0006\u0005gZ#A!\u001e\u0011\t\t]$\u0011Q\u0007\u0003\u0005sRAAa\u001f\u0003~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u007fb\u0015AC1o]>$\u0018\r^5p]&!!1\u0011B=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IIK\u0002\u0000\u0005g\na!\u00199qK:$G#\u00051\u0003\u0010\nE%1\u0013BK\u00053\u0013YJ!(\u0003(\")a-\u0010a\u0001Q\")Q0\u0010a\u0001\u007f\"9!\u0011J\u001fA\u0002\t-\u0003b\u0002BL{\u0001\u0007\u00111B\u0001\u0004g\u0016\f\bB\u0002B2{\u0001\u0007q\u0010\u0003\u0005\u0003lu\u0002\n\u00111\u0001\u0000\u0011%\u0011y*\u0010I\u0001\u0002\u0004\u0011\t+A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\rY%1U\u0005\u0004\u0005Kc%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005Sk\u0004\u0013!a\u0001\u0005C\u000bA\"[:Ge>l7\t\\5f]R\f\u0001#\u00199qK:$G\u0005Z3gCVdG\u000f\n\u001c\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012:TC\u0001BYU\u0011\u0011\tKa\u001d\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012BD#\u00041\u00038\ne&1\u0018B_\u0005\u007f\u0013I\rC\u0003g\u0003\u0002\u0007\u0001\u000eC\u0003~\u0003\u0002\u0007q\u0010C\u0004\u0003J\u0005\u0003\rAa\u0013\t\r\t\r\u0014\t1\u0001\u0000\u0011\u001d\u0011\t-\u0011a\u0001\u0005\u0007\fQAY1uG\"\u0004BAa\u0016\u0003F&!!q\u0019B-\u0005-\u0011VmY8sI\n\u000bGo\u00195\t\u000f\t%\u0016\t1\u0001\u0003\"\u000612-\u001e:sK:$8K\\1qg\"|Go\u00144gg\u0016$8/\u0006\u0002\u0003PB)!\u0011\u001bBn\u007f6\u0011!1\u001b\u0006\u0005\u0005+\u00149.A\u0005j[6,H/\u00192mK*\u0019!\u0011\u001c'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003^\nM'aA*fi\u0002")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91)));
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109)));
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), false);
        appendInfo.append(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), 2000L, 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = offset;
        boolean x$6 = false;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$8, x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstOffset());
    }

    @Test
    public void testControlRecordBumpsEpoch() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long lastStableOffset = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
        Tuple2 tuple23 = tuple22;
        CompletedTxn completedTxn2 = (CompletedTxn)tuple23._1();
        long lastStableOffset2 = tuple23._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)completedTxn2.firstOffset());
        Assert.assertEquals((long)1L, (long)completedTxn2.lastOffset());
        Assert.assertEquals((long)2L, (long)lastStableOffset2);
        Assert.assertTrue((boolean)completedTxn2.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn2.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)logOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testNonMatchingTxnFirstOffsetMetadataNotCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch, seq, seq, this.time().milliseconds(), offset, offset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(offset - 23429L, 990000L, 234224);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 0, 5, this.time().milliseconds(), 15L, 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        nextAppendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), true);
        appendInfo.append(producerEpoch, 1, 5, this.time().milliseconds(), 16L, 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.append(producerEpoch, 6, 10, this.time().milliseconds(), 26L, 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            short x$19 = bumpedEpoch;
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            boolean x$24 = this.append$default$8();
            this.append(x$17, x$18, x$19, x$20, x$21, x$23, x$22, x$24);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            boolean x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        short x$35 = bumpedEpoch;
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        boolean x$40 = this.append$default$8();
        this.append(x$33, x$34, x$35, x$36, x$37, x$39, x$38, x$40);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = false;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateManager x$1 = recoveredMapping;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 2L;
        long x$6 = 70001L;
        boolean x$7 = false;
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            short x$3 = epoch;
            int x$4 = outOfOrderSequence;
            long x$5 = 1L;
            long x$6 = 1L;
            boolean x$7 = true;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = outOfOrderSequence;
        long x$13 = 1L;
        long x$14 = 1L;
        boolean x$15 = false;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, x$11, x$12, x$13, x$14, x$16, x$15);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        boolean x$82 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$52, x$72, x$62, x$82);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
    }

    @Test
    public void testFirstUnstableOffsetAfterEviction() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        ProducerStateManager x$92 = this.stateManager();
        long x$102 = 2L;
        short x$11 = epoch;
        int x$12 = 0;
        long x$13 = 106L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$92, x$102, x$11, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().truncateHead(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)106)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
    }

    @Test
    public void testTruncateHead() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        long anotherPid = 2L;
        this.append(this.stateManager(), anotherPid, epoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), anotherPid, epoch, 1, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        this.stateManager().truncateHead(2L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4})), this.currentSnapshotOffsets());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        Option maybeEntry = this.stateManager().lastEntry(anotherPid);
        Assert.assertTrue((boolean)maybeEntry.isDefined());
        Assert.assertEquals((long)3L, (long)((ProducerStateEntry)maybeEntry.get()).lastDataOffset());
        this.stateManager().truncateHead(3L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{anotherPid})), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), this.currentSnapshotOffsets());
        Assert.assertEquals((long)4L, (long)this.stateManager().mapEndOffset());
        this.stateManager().truncateHead(5L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.stateManager().activeProducers().keySet());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        Assert.assertEquals((long)5L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testLoadFromSnapshotRemovesNonRetainedProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)1L, (long)this.stateManager().activeProducers().size());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(pid1));
        Option entry = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
            recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
            this.append(recoveredMapping, pid2, epoch, 1, 4L, 5L, this.append$default$7(), this.append$default$8());
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = anotherPid;
        short x$112 = epoch;
        int x$122 = sequence;
        long x$132 = 105L;
        boolean x$142 = true;
        long x$152 = this.append$default$6();
        boolean x$162 = this.append$default$8();
        this.append(x$9, x$10, x$112, x$122, x$132, x$152, x$142, x$162);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        ProducerStateManager x$1 = stateManager;
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = stateManager;
        long x$10 = this.producerId();
        short x$11 = epoch;
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        boolean x$16 = this.append$default$8();
        this.append(x$9, x$10, x$11, x$12, x$13, x$15, x$14, x$16);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = epoch;
        int x$4 = sequence;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        }
        catch (TransactionCoordinatorFencedException e) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        short x$3 = producerEpoch;
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$8();
        this.append(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            file.truncate(0L);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        this.testLoadFromCorruptSnapshot((Function1<FileChannel, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, true);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, true);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(producerEpoch, seq, seq, timestamp, offset, offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, boolean isFromClient) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, isFromClient);
        producerAppendInfo.append(batch);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private boolean append$default$8() {
        return true;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$2) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (ValidationType)ValidationType.Full$.MODULE$);
        producerAppendInfo.append(producerEpoch$2, 0, 0, this.time().milliseconds(), startOffset, startOffset, true);
        LogOffsetMetadata logOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.maybeCacheTxnFirstOffsetMetadata(logOffsetMetadata);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }
}

