/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.data;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public final class Bytes
implements Comparable<Bytes>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] data;
    private final int offset;
    private final int length;
    public static final Bytes EMPTY = new Bytes(new byte[0]);
    private Integer hashCode = null;

    public Bytes() {
        this.data = Bytes.EMPTY.data;
        this.offset = 0;
        this.length = 0;
    }

    private Bytes(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    private Bytes(byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new IndexOutOfBoundsException(" Bad offset and/or length data.length = " + data.length + " offset = " + offset + " length = " + length);
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public byte byteAt(int i) {
        if (i < 0) {
            throw new IndexOutOfBoundsException("i < 0, " + i);
        }
        if (i >= this.length) {
            throw new IndexOutOfBoundsException("i >= length, " + i + " >= " + this.length);
        }
        return this.data[this.offset + i];
    }

    public int length() {
        return this.length;
    }

    public Bytes subSequence(int start, int end) {
        if (start > end || start < 0 || end > this.length) {
            throw new IndexOutOfBoundsException("Bad start and/end start = " + start + " end=" + end + " offset=" + this.offset + " length=" + this.length);
        }
        return new Bytes(this.data, this.offset + start, end - start);
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, this.offset, copy, 0, this.length);
        return copy;
    }

    public String toString() {
        return new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.data, this.offset, this.length).asReadOnlyBuffer();
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.data, this.offset, this.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.length <= 32) {
            int end = this.offset + this.length;
            for (int i = this.offset; i < end; ++i) {
                out.write(this.data[i]);
            }
        } else {
            out.write(this.toArray());
        }
    }

    @Override
    public final int compareTo(Bytes other) {
        int minLen = Math.min(this.length(), other.length());
        for (int i = 0; i < minLen; ++i) {
            int b;
            int a = this.byteAt(i) & 0xFF;
            if (a == (b = other.byteAt(i) & 0xFF)) continue;
            return a - b;
        }
        return this.length() - other.length();
    }

    public final boolean equals(Object other) {
        if (other instanceof Bytes) {
            Bytes ob = (Bytes)other;
            if (this == other) {
                return true;
            }
            if (this.length() != ob.length()) {
                return false;
            }
            return this.compareTo(ob) == 0;
        }
        return false;
    }

    public final int hashCode() {
        if (this.hashCode == null) {
            int hash = 1;
            for (int i = 0; i < this.length(); ++i) {
                hash = 31 * hash + this.byteAt(i);
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public static final Bytes of(byte[] array) {
        Objects.requireNonNull(array);
        if (array.length == 0) {
            return EMPTY;
        }
        byte[] copy = new byte[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return new Bytes(copy);
    }

    public static final Bytes of(byte[] data, int offset, int length) {
        Objects.requireNonNull(data);
        if (length == 0) {
            return EMPTY;
        }
        byte[] copy = new byte[length];
        System.arraycopy(data, offset, copy, 0, length);
        return new Bytes(copy);
    }

    public static final Bytes of(ByteBuffer bb) {
        byte[] data;
        Objects.requireNonNull(bb);
        if (bb.remaining() == 0) {
            return EMPTY;
        }
        if (bb.hasArray()) {
            data = Arrays.copyOfRange(bb.array(), bb.position() + bb.arrayOffset(), bb.limit() + bb.arrayOffset());
        } else {
            data = new byte[bb.remaining()];
            bb.duplicate().get(data);
        }
        return new Bytes(data);
    }

    public static final Bytes of(CharSequence cs) {
        if (cs instanceof String) {
            return Bytes.of((String)cs);
        }
        Objects.requireNonNull(cs);
        if (cs.length() == 0) {
            return EMPTY;
        }
        ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cs));
        if (bb.hasArray()) {
            return new Bytes(bb.array(), bb.position() + bb.arrayOffset(), bb.limit());
        }
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        return new Bytes(data);
    }

    public static final Bytes of(String s) {
        Objects.requireNonNull(s);
        if (s.length() == 0) {
            return EMPTY;
        }
        byte[] data = s.getBytes(StandardCharsets.UTF_8);
        return new Bytes(data);
    }

    public static final Bytes of(String s, Charset c) {
        Objects.requireNonNull(s);
        Objects.requireNonNull(c);
        if (s.length() == 0) {
            return EMPTY;
        }
        byte[] data = s.getBytes(c);
        return new Bytes(data);
    }

    public static BytesBuilder builder() {
        return new BytesBuilder();
    }

    public static BytesBuilder builder(int initialCapacity) {
        return new BytesBuilder(initialCapacity);
    }

    public static class BytesBuilder {
        private byte[] ba;
        private int len;

        BytesBuilder(int initialCapacity) {
            this.ba = new byte[initialCapacity];
            this.len = 0;
        }

        BytesBuilder() {
            this(32);
        }

        private void ensureCapacity(int min) {
            if (this.ba.length < min) {
                int newLen = this.ba.length * 2;
                if (newLen < min) {
                    newLen = min;
                }
                this.ba = Arrays.copyOf(this.ba, newLen);
            }
        }

        public BytesBuilder append(CharSequence cs) {
            if (cs instanceof String) {
                return this.append((String)cs);
            }
            ByteBuffer bb = StandardCharsets.UTF_8.encode(CharBuffer.wrap(cs));
            int length = bb.remaining();
            this.ensureCapacity(this.len + length);
            bb.get(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(String s) {
            return this.append(s.getBytes(StandardCharsets.UTF_8));
        }

        public BytesBuilder append(Bytes b) {
            this.ensureCapacity(this.len + b.length());
            System.arraycopy(b.data, b.offset, this.ba, this.len, b.length);
            this.len += b.length();
            return this;
        }

        public BytesBuilder append(byte[] bytes) {
            this.ensureCapacity(this.len + bytes.length);
            System.arraycopy(bytes, 0, this.ba, this.len, bytes.length);
            this.len += bytes.length;
            return this;
        }

        public BytesBuilder append(int b) {
            this.ensureCapacity(this.len + 1);
            this.ba[this.len] = (byte)b;
            ++this.len;
            return this;
        }

        public BytesBuilder append(byte[] bytes, int offset, int length) {
            this.ensureCapacity(this.len + length);
            System.arraycopy(bytes, offset, this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(InputStream in, int length) throws IOException {
            this.ensureCapacity(this.len + length);
            new DataInputStream(in).readFully(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public BytesBuilder append(ByteBuffer bb) {
            int length = bb.remaining();
            this.ensureCapacity(this.len + length);
            bb.duplicate().get(this.ba, this.len, length);
            this.len += length;
            return this;
        }

        public void setLength(int newLen) {
            Preconditions.checkArgument((newLen >= 0 ? 1 : 0) != 0, (Object)("Negative length passed : " + newLen));
            if (newLen > this.ba.length) {
                this.ba = Arrays.copyOf(this.ba, newLen);
            }
            if (newLen > this.len) {
                Arrays.fill(this.ba, this.len, newLen, (byte)0);
            }
            this.len = newLen;
        }

        public int getLength() {
            return this.len;
        }

        public Bytes toBytes() {
            return Bytes.of(this.ba, 0, this.len);
        }
    }
}

