/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;

public class NacosServiceName {
    public static final String NAME_SEPARATOR = ":";
    public static final String VALUE_SEPARATOR = ",";
    public static final String WILDCARD = "*";
    public static final String DEFAULT_PARAM_VALUE = "";
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private String category;
    private String serviceInterface;
    private String version;
    private String group;
    private String value;

    public NacosServiceName() {
    }

    public NacosServiceName(URL url) {
        this.serviceInterface = url.getParameter("interface");
        this.category = this.isConcrete(this.serviceInterface) ? "providers" : url.getParameter("category");
        this.version = url.getParameter("version", DEFAULT_PARAM_VALUE);
        this.group = url.getParameter("group", DEFAULT_PARAM_VALUE);
        this.value = this.toValue();
    }

    public NacosServiceName(String value) {
        this.value = value;
        String[] segments = StringUtils.splitPreserveAllTokens((String)value, (String)NAME_SEPARATOR);
        this.category = segments[0];
        this.serviceInterface = segments[1];
        this.version = segments[2];
        this.group = segments[3];
    }

    public static NacosServiceName valueOf(URL url) {
        return new NacosServiceName(url);
    }

    public boolean isConcrete() {
        return this.isConcrete(this.serviceInterface) && this.isConcrete(this.version) && this.isConcrete(this.group);
    }

    public boolean isCompatible(NacosServiceName concreteServiceName) {
        if (!concreteServiceName.isConcrete()) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.category, (CharSequence)concreteServiceName.category) && !ArrayUtils.contains((Object[])StringUtils.splitPreserveAllTokens((String)this.category, (String)VALUE_SEPARATOR), (Object)concreteServiceName.category)) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.serviceInterface, (CharSequence)concreteServiceName.serviceInterface)) {
            return false;
        }
        if (this.isWildcard(this.version)) {
            return true;
        }
        if (this.isWildcard(this.group)) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)this.version, (CharSequence)concreteServiceName.version) && !this.matchRange(this.version, concreteServiceName.version)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.group, (CharSequence)concreteServiceName.group) || this.matchRange(this.group, concreteServiceName.group);
    }

    private boolean matchRange(String range, String value) {
        if (StringUtils.isBlank((CharSequence)range)) {
            return true;
        }
        if (!this.isRange(range)) {
            return false;
        }
        Object[] values = StringUtils.split((String)range, (String)VALUE_SEPARATOR);
        return ArrayUtils.contains((Object[])values, (Object)value);
    }

    private boolean isConcrete(String value) {
        return !this.isWildcard(value) && !this.isRange(value);
    }

    private boolean isWildcard(String value) {
        return WILDCARD.equals(value);
    }

    private boolean isRange(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)VALUE_SEPARATOR)) {
            String[] values = StringUtils.split((String)value, (String)VALUE_SEPARATOR);
            return ArrayUtils.getLength((Object)values) > 1;
        }
        return false;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.toValue();
        }
        return this.value;
    }

    private String toValue() {
        return this.category + NAME_SEPARATOR + this.serviceInterface + NAME_SEPARATOR + this.version + NAME_SEPARATOR + this.group;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NacosServiceName)) {
            return false;
        }
        NacosServiceName that = (NacosServiceName)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public String toString() {
        return this.getValue();
    }
}

