/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Comparator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.NodeBuilder;
import org.apache.cassandra.utils.btree.UpdateFunction;

final class Builder {
    private final NodeBuilder rootBuilder = new NodeBuilder();

    Builder() {
    }

    public <V> Object[] update(Object[] btree, Comparator<V> comparator, Iterable<V> source, UpdateFunction<V> updateF) {
        NodeBuilder next;
        assert (updateF != null);
        NodeBuilder current = this.rootBuilder;
        current.reset(btree, BTree.POSITIVE_INFINITY, updateF, comparator);
        block0: for (V key : source) {
            while (true) {
                if (updateF.abortEarly()) {
                    this.rootBuilder.clear();
                    return null;
                }
                NodeBuilder next2 = current.update(key);
                if (next2 == null) continue block0;
                current = next2;
            }
        }
        while ((next = current.finish()) != null) {
            current = next;
        }
        assert (current.isRoot());
        Object[] r = current.toNode();
        current.clear();
        return r;
    }

    public <V> Object[] build(Iterable<V> source, UpdateFunction<V> updateF, int size) {
        assert (updateF != null);
        NodeBuilder current = this.rootBuilder;
        while ((size >>= BTree.FAN_SHIFT) > 0) {
            current = current.ensureChild();
        }
        current.reset(BTree.EMPTY_LEAF, BTree.POSITIVE_INFINITY, updateF, null);
        for (V key : source) {
            current.addNewKey(updateF.apply(key));
        }
        current = current.ascendToRoot();
        Object[] r = current.toNode();
        current.clear();
        return r;
    }
}

