/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.cache.CachingOptions;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.compress.CompressionParameters;

public class CFPropDefs
extends PropertyDefinitions {
    public static final String KW_COMMENT = "comment";
    public static final String KW_READREPAIRCHANCE = "read_repair_chance";
    public static final String KW_DCLOCALREADREPAIRCHANCE = "dclocal_read_repair_chance";
    public static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    public static final String KW_MINCOMPACTIONTHRESHOLD = "min_threshold";
    public static final String KW_MAXCOMPACTIONTHRESHOLD = "max_threshold";
    public static final String KW_CACHING = "caching";
    public static final String KW_DEFAULT_TIME_TO_LIVE = "default_time_to_live";
    public static final String KW_MIN_INDEX_INTERVAL = "min_index_interval";
    public static final String KW_MAX_INDEX_INTERVAL = "max_index_interval";
    public static final String KW_SPECULATIVE_RETRY = "speculative_retry";
    public static final String KW_BF_FP_CHANCE = "bloom_filter_fp_chance";
    public static final String KW_MEMTABLE_FLUSH_PERIOD = "memtable_flush_period_in_ms";
    public static final String KW_COMPACTION = "compaction";
    public static final String KW_COMPRESSION = "compression";
    public static final String COMPACTION_STRATEGY_CLASS_KEY = "class";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    private Class<? extends AbstractCompactionStrategy> compactionStrategyClass = null;

    public void validate() throws ConfigurationException, SyntaxException {
        Map<String, String> compressionOptions;
        if (this.compactionStrategyClass != null) {
            return;
        }
        this.validate(keywords, obsoleteKeywords);
        Map<String, String> compactionOptions = this.getCompactionOptions();
        if (!compactionOptions.isEmpty()) {
            String strategy = compactionOptions.get(COMPACTION_STRATEGY_CLASS_KEY);
            if (strategy == null) {
                throw new ConfigurationException("Missing sub-option 'class' for the 'compaction' option.");
            }
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(strategy);
            compactionOptions.remove(COMPACTION_STRATEGY_CLASS_KEY);
            CFMetaData.validateCompactionOptions(this.compactionStrategyClass, compactionOptions);
        }
        if (!(compressionOptions = this.getCompressionOptions()).isEmpty()) {
            String sstableCompressionClass = compressionOptions.get("sstable_compression");
            if (sstableCompressionClass == null) {
                throw new ConfigurationException("Missing sub-option 'sstable_compression' for the 'compression' option.");
            }
            Integer chunkLength = 65536;
            if (compressionOptions.containsKey("chunk_length_kb")) {
                chunkLength = CompressionParameters.parseChunkLength(compressionOptions.get("chunk_length_kb"));
            }
            HashMap<String, String> remainingOptions = new HashMap<String, String>(compressionOptions);
            remainingOptions.remove("sstable_compression");
            remainingOptions.remove("chunk_length_kb");
            CompressionParameters cp = new CompressionParameters(sstableCompressionClass, chunkLength, remainingOptions);
            cp.validate();
        }
        this.validateMinimumInt(KW_DEFAULT_TIME_TO_LIVE, 0, 0);
        Integer minIndexInterval = this.getInt(KW_MIN_INDEX_INTERVAL, null);
        Integer maxIndexInterval = this.getInt(KW_MAX_INDEX_INTERVAL, null);
        if (minIndexInterval != null && minIndexInterval < 1) {
            throw new ConfigurationException("min_index_interval must be greater than 0");
        }
        if (maxIndexInterval != null && minIndexInterval != null && maxIndexInterval < minIndexInterval) {
            throw new ConfigurationException("max_index_interval must be greater than min_index_interval");
        }
        CFMetaData.SpeculativeRetry.fromString(this.getString(KW_SPECULATIVE_RETRY, CFMetaData.SpeculativeRetry.RetryType.NONE.name()));
    }

    public Class<? extends AbstractCompactionStrategy> getCompactionStrategy() {
        return this.compactionStrategyClass;
    }

    public Map<String, String> getCompactionOptions() throws SyntaxException {
        Map<String, String> compactionOptions = this.getMap(KW_COMPACTION);
        if (compactionOptions == null) {
            return Collections.emptyMap();
        }
        return compactionOptions;
    }

    public Map<String, String> getCompressionOptions() throws SyntaxException {
        Map<String, String> compressionOptions = this.getMap(KW_COMPRESSION);
        if (compressionOptions == null) {
            return Collections.emptyMap();
        }
        return compressionOptions;
    }

    public CachingOptions getCachingOptions() throws SyntaxException, ConfigurationException {
        CachingOptions options = null;
        Object val = this.properties.get(KW_CACHING);
        if (val == null) {
            return null;
        }
        if (val instanceof Map) {
            options = CachingOptions.fromMap(this.getMap(KW_CACHING));
        } else if (val instanceof String) {
            options = CachingOptions.fromString(this.getSimple(KW_CACHING));
            logger.warn("Setting caching options with deprecated syntax.");
        }
        return options;
    }

    public Integer getDefaultTimeToLive() throws SyntaxException {
        return this.getInt(KW_DEFAULT_TIME_TO_LIVE, 0);
    }

    public void applyToCFMetadata(CFMetaData cfm) throws ConfigurationException, SyntaxException {
        CachingOptions cachingOptions;
        if (this.hasProperty(KW_COMMENT).booleanValue()) {
            cfm.comment(this.getString(KW_COMMENT, ""));
        }
        cfm.readRepairChance(this.getDouble(KW_READREPAIRCHANCE, cfm.getReadRepairChance()));
        cfm.dcLocalReadRepairChance(this.getDouble(KW_DCLOCALREADREPAIRCHANCE, cfm.getDcLocalReadRepairChance()));
        cfm.gcGraceSeconds(this.getInt(KW_GCGRACESECONDS, cfm.getGcGraceSeconds()));
        int minCompactionThreshold = CFPropDefs.toInt(KW_MINCOMPACTIONTHRESHOLD, this.getCompactionOptions().get(KW_MINCOMPACTIONTHRESHOLD), cfm.getMinCompactionThreshold());
        int maxCompactionThreshold = CFPropDefs.toInt(KW_MAXCOMPACTIONTHRESHOLD, this.getCompactionOptions().get(KW_MAXCOMPACTIONTHRESHOLD), cfm.getMaxCompactionThreshold());
        if (minCompactionThreshold <= 0 || maxCompactionThreshold <= 0) {
            throw new ConfigurationException("Disabling compaction by setting compaction thresholds to 0 has been deprecated, set the compaction option 'enabled' to false instead.");
        }
        cfm.minCompactionThreshold(minCompactionThreshold);
        cfm.maxCompactionThreshold(maxCompactionThreshold);
        cfm.defaultTimeToLive(this.getInt(KW_DEFAULT_TIME_TO_LIVE, cfm.getDefaultTimeToLive()));
        cfm.speculativeRetry(CFMetaData.SpeculativeRetry.fromString(this.getString(KW_SPECULATIVE_RETRY, cfm.getSpeculativeRetry().toString())));
        cfm.memtableFlushPeriod(this.getInt(KW_MEMTABLE_FLUSH_PERIOD, cfm.getMemtableFlushPeriod()));
        cfm.minIndexInterval(this.getInt(KW_MIN_INDEX_INTERVAL, cfm.getMinIndexInterval()));
        cfm.maxIndexInterval(this.getInt(KW_MAX_INDEX_INTERVAL, cfm.getMaxIndexInterval()));
        if (this.compactionStrategyClass != null) {
            cfm.compactionStrategyClass(this.compactionStrategyClass);
            cfm.compactionStrategyOptions(new HashMap<String, String>(this.getCompactionOptions()));
        }
        cfm.bloomFilterFpChance(this.getDouble(KW_BF_FP_CHANCE, cfm.getBloomFilterFpChance()));
        if (!this.getCompressionOptions().isEmpty()) {
            cfm.compressionParameters(CompressionParameters.create(this.getCompressionOptions()));
        }
        if ((cachingOptions = this.getCachingOptions()) != null) {
            cfm.caching(cachingOptions);
        }
    }

    public String toString() {
        return String.format("CFPropDefs(%s)", this.properties.toString());
    }

    private void validateMinimumInt(String field, int minimumValue, int defaultValue) throws SyntaxException, ConfigurationException {
        Integer val = this.getInt(field, null);
        if (val != null && val < minimumValue) {
            throw new ConfigurationException(String.format("%s cannot be smaller than %s, (default %s)", field, minimumValue, defaultValue));
        }
    }

    static {
        keywords.add(KW_COMMENT);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_DCLOCALREADREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_CACHING);
        keywords.add(KW_DEFAULT_TIME_TO_LIVE);
        keywords.add(KW_MIN_INDEX_INTERVAL);
        keywords.add(KW_MAX_INDEX_INTERVAL);
        keywords.add(KW_SPECULATIVE_RETRY);
        keywords.add(KW_BF_FP_CHANCE);
        keywords.add(KW_COMPACTION);
        keywords.add(KW_COMPRESSION);
        keywords.add(KW_MEMTABLE_FLUSH_PERIOD);
        obsoleteKeywords.add("index_interval");
        obsoleteKeywords.add("replicate_on_write");
        obsoleteKeywords.add("populate_io_cache_on_flush");
    }
}

