/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.DataOutputStreamAndChannel;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamWriter;
import org.apache.cassandra.streaming.compress.CompressedStreamWriter;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Ref;

public class OutgoingFileMessage
extends StreamMessage {
    public static StreamMessage.Serializer<OutgoingFileMessage> serializer = new StreamMessage.Serializer<OutgoingFileMessage>(){

        @Override
        public OutgoingFileMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            throw new UnsupportedOperationException("Not allowed to call deserialize on an outgoing file");
        }

        @Override
        public void serialize(OutgoingFileMessage message, DataOutputStreamAndChannel out, int version, StreamSession session) throws IOException {
            message.serialize(out, version, session);
            session.fileSent(message.header);
        }
    };
    public final FileMessageHeader header;
    private final Ref<SSTableReader> ref;
    private final String filename;
    private boolean completed = false;

    public OutgoingFileMessage(Ref<SSTableReader> ref, int sequenceNumber, long estimatedKeys, List<Pair<Long, Long>> sections, long repairedAt) {
        super(StreamMessage.Type.FILE);
        this.ref = ref;
        SSTableReader sstable = ref.get();
        this.filename = sstable.getFilename();
        this.header = new FileMessageHeader(sstable.metadata.cfId, sequenceNumber, sstable.descriptor.version.toString(), estimatedKeys, sections, sstable.compression ? sstable.getCompressionMetadata() : null, repairedAt);
    }

    public synchronized void serialize(DataOutputStreamAndChannel out, int version, StreamSession session) throws IOException {
        if (this.completed) {
            return;
        }
        CompressionInfo compressionInfo = FileMessageHeader.serializer.serialize(this.header, out, version);
        SSTableReader reader = this.ref.get();
        StreamWriter writer = compressionInfo == null ? new StreamWriter(reader, this.header.sections, session) : new CompressedStreamWriter(reader, this.header.sections, compressionInfo, session);
        writer.write(out.getChannel());
    }

    public synchronized void complete() {
        if (!this.completed) {
            this.completed = true;
            this.ref.release();
        }
    }

    public String toString() {
        return "File (" + this.header + ", file: " + this.filename + ")";
    }
}

