/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFPropDefs {
    private static final Logger logger = LoggerFactory.getLogger(CFPropDefs.class);
    public static final String KW_COMPARATOR = "comparator";
    public static final String KW_COMMENT = "comment";
    public static final String KW_READREPAIRCHANCE = "read_repair_chance";
    public static final String KW_DCLOCALREADREPAIRCHANCE = "dclocal_read_repair_chance";
    public static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    public static final String KW_DEFAULTVALIDATION = "default_validation";
    public static final String KW_MINCOMPACTIONTHRESHOLD = "min_compaction_threshold";
    public static final String KW_MAXCOMPACTIONTHRESHOLD = "max_compaction_threshold";
    public static final String KW_COMPACTION_STRATEGY_CLASS = "compaction_strategy_class";
    public static final String KW_CACHING = "caching";
    public static final String KW_ROWS_PER_PARTITION_TO_CACHE = "rows_per_partition_to_cache";
    public static final String KW_DEFAULT_TIME_TO_LIVE = "default_time_to_live";
    public static final String KW_SPECULATIVE_RETRY = "speculative_retry";
    public static final String KW_BF_FP_CHANCE = "bloom_filter_fp_chance";
    public static final String KW_MEMTABLE_FLUSH_PERIOD = "memtable_flush_period_in_ms";
    public static final Map<String, String> comparators = new HashMap<String, String>();
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    public static final Set<String> allowedKeywords = new HashSet<String>();
    public static final String COMPACTION_OPTIONS_PREFIX = "compaction_strategy_options";
    public static final String COMPRESSION_PARAMETERS_PREFIX = "compression_parameters";
    public final Map<String, String> properties = new HashMap<String, String>();
    public Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    public final Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public final Map<String, String> compressionParameters = new HashMap<String, String>();

    public void validate() throws InvalidRequestException, ConfigurationException {
        Integer defaultTimeToLive;
        this.compactionStrategyClass = CFMetaData.DEFAULT_COMPACTION_STRATEGY_CLASS;
        HashSet<String> propsToRemove = new HashSet<String>();
        for (String property : this.properties.keySet()) {
            if (!property.contains(":")) continue;
            String key = property.split(":")[1];
            String val = this.properties.get(property);
            if (property.startsWith(COMPACTION_OPTIONS_PREFIX)) {
                this.compactionStrategyOptions.put(key, val);
                propsToRemove.add(property);
            }
            if (!property.startsWith(COMPRESSION_PARAMETERS_PREFIX)) continue;
            this.compressionParameters.put(key, val);
            propsToRemove.add(property);
        }
        for (String property : propsToRemove) {
            this.properties.remove(property);
        }
        Iterator<String> iterator = Sets.difference(this.properties.keySet(), allowedKeywords).iterator();
        if (iterator.hasNext()) {
            String bogus = iterator.next();
            throw new InvalidRequestException(bogus + " is not a valid keyword argument for CREATE COLUMNFAMILY");
        }
        for (String obsolete : Sets.intersection(this.properties.keySet(), obsoleteKeywords)) {
            logger.warn("Ignoring obsolete property {}", (Object)obsolete);
        }
        Integer minCompaction = this.getPropertyInt(KW_MINCOMPACTIONTHRESHOLD, null);
        Integer maxCompaction = this.getPropertyInt(KW_MAXCOMPACTIONTHRESHOLD, null);
        if (minCompaction != null && maxCompaction != null) {
            if (minCompaction > maxCompaction && maxCompaction != 0) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD));
            }
        } else if (minCompaction != null) {
            if (minCompaction > 32) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s, (default %s)", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD, 32));
            }
        } else if (maxCompaction != null && maxCompaction < 4 && maxCompaction != 0) {
            throw new InvalidRequestException(String.format("%s cannot be smaller than %s, (default %s)", KW_MAXCOMPACTIONTHRESHOLD, KW_MINCOMPACTIONTHRESHOLD, 4));
        }
        if ((defaultTimeToLive = this.getPropertyInt(KW_DEFAULT_TIME_TO_LIVE, null)) != null) {
            if (defaultTimeToLive < 0) {
                throw new InvalidRequestException(String.format("%s cannot be smaller than %s, (default %s)", KW_DEFAULT_TIME_TO_LIVE, 0, 0));
            }
            if (defaultTimeToLive > 630720000) {
                throw new InvalidRequestException(String.format("%s must be less than or equal to %d (got %s)", KW_DEFAULT_TIME_TO_LIVE, 630720000, defaultTimeToLive));
            }
        }
        CFMetaData.validateCompactionOptions(this.compactionStrategyClass, this.compactionStrategyOptions);
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public AbstractType<?> getComparator() throws ConfigurationException, SyntaxException {
        return TypeParser.parse(comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) != null ? comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) : this.getPropertyString(KW_COMPARATOR, "text"));
    }

    public AbstractType<?> getValidator() throws ConfigurationException, SyntaxException {
        return TypeParser.parse(comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) != null ? comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) : this.getPropertyString(KW_DEFAULTVALIDATION, "text"));
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getPropertyString(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    public Boolean getPropertyBoolean(String key, Boolean defaultValue) {
        String value = this.properties.get(key);
        return value == null ? defaultValue.booleanValue() : value.toLowerCase().matches("(1|true|yes)");
    }

    public Double getPropertyDouble(String key, Double defaultValue) throws InvalidRequestException {
        Double result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    public Integer getPropertyInt(String key, Integer defaultValue) throws InvalidRequestException {
        Integer result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    public Set<String> getPropertySet(String key, Set<String> defaultValue) {
        String value = this.properties.get(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        return Sets.newHashSet((Object[])StringUtils.split((String)value, (char)','));
    }

    public String toString() {
        return String.format("CFPropDefs(%s, compaction: %s, compression: %s)", this.properties.toString(), this.compactionStrategyOptions.toString(), this.compressionParameters.toString());
    }

    static {
        comparators.put("ascii", "AsciiType");
        comparators.put("bigint", "LongType");
        comparators.put("blob", "BytesType");
        comparators.put("boolean", "BooleanType");
        comparators.put("counter", "CounterColumnType");
        comparators.put("decimal", "DecimalType");
        comparators.put("double", "DoubleType");
        comparators.put("float", "FloatType");
        comparators.put("int", "Int32Type");
        comparators.put("text", "UTF8Type");
        comparators.put("timestamp", "DateType");
        comparators.put("uuid", "UUIDType");
        comparators.put("varchar", "UTF8Type");
        comparators.put("varint", "IntegerType");
        keywords.add(KW_COMPARATOR);
        keywords.add(KW_COMMENT);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_DCLOCALREADREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_DEFAULTVALIDATION);
        keywords.add(KW_MINCOMPACTIONTHRESHOLD);
        keywords.add(KW_MAXCOMPACTIONTHRESHOLD);
        keywords.add(KW_COMPACTION_STRATEGY_CLASS);
        keywords.add(KW_CACHING);
        keywords.add(KW_ROWS_PER_PARTITION_TO_CACHE);
        keywords.add(KW_DEFAULT_TIME_TO_LIVE);
        keywords.add(KW_SPECULATIVE_RETRY);
        keywords.add(KW_BF_FP_CHANCE);
        keywords.add(KW_MEMTABLE_FLUSH_PERIOD);
        obsoleteKeywords.add("row_cache_size");
        obsoleteKeywords.add("key_cache_size");
        obsoleteKeywords.add("row_cache_save_period_in_seconds");
        obsoleteKeywords.add("key_cache_save_period_in_seconds");
        obsoleteKeywords.add("memtable_throughput_in_mb");
        obsoleteKeywords.add("memtable_operations_in_millions");
        obsoleteKeywords.add("memtable_flush_after_mins");
        obsoleteKeywords.add("row_cache_provider");
        obsoleteKeywords.add("replicate_on_write");
        obsoleteKeywords.add("populate_io_cache_on_flush");
        allowedKeywords.addAll(keywords);
        allowedKeywords.addAll(obsoleteKeywords);
    }
}

