// $ANTLR 3.5.2 /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g 2018-02-12 11:23:31

    package org.apache.cassandra.cql3;

    import java.util.ArrayList;
    import java.util.Arrays;
    import java.util.Collections;
    import java.util.EnumSet;
    import java.util.HashSet;
    import java.util.HashMap;
    import java.util.LinkedHashMap;
    import java.util.List;
    import java.util.Map;
    import java.util.Set;

    import org.apache.cassandra.auth.Permission;
    import org.apache.cassandra.auth.DataResource;
    import org.apache.cassandra.auth.IResource;
    import org.apache.cassandra.cql3.*;
    import org.apache.cassandra.cql3.statements.*;
    import org.apache.cassandra.cql3.functions.FunctionCall;
    import org.apache.cassandra.db.marshal.CollectionType;
    import org.apache.cassandra.exceptions.ConfigurationException;
    import org.apache.cassandra.exceptions.InvalidRequestException;
    import org.apache.cassandra.exceptions.SyntaxException;
    import org.apache.cassandra.utils.Pair;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CqlParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "B", "BOOLEAN", "C", "COMMENT", 
		"D", "DIGIT", "E", "EXPONENT", "F", "FLOAT", "G", "H", "HEX", "HEXNUMBER", 
		"I", "IDENT", "INTEGER", "J", "K", "K_ADD", "K_ALL", "K_ALLOW", "K_ALTER", 
		"K_AND", "K_APPLY", "K_AS", "K_ASC", "K_ASCII", "K_AUTHORIZE", "K_BATCH", 
		"K_BEGIN", "K_BIGINT", "K_BLOB", "K_BOOLEAN", "K_BY", "K_CLUSTERING", 
		"K_COLUMNFAMILY", "K_COMPACT", "K_CONTAINS", "K_COUNT", "K_COUNTER", "K_CREATE", 
		"K_CUSTOM", "K_DECIMAL", "K_DELETE", "K_DESC", "K_DISTINCT", "K_DOUBLE", 
		"K_DROP", "K_EXISTS", "K_FILTERING", "K_FLOAT", "K_FROM", "K_FROZEN", 
		"K_FULL", "K_GRANT", "K_IF", "K_IN", "K_INDEX", "K_INET", "K_INFINITY", 
		"K_INSERT", "K_INT", "K_INTO", "K_KEY", "K_KEYS", "K_KEYSPACE", "K_KEYSPACES", 
		"K_LIMIT", "K_LIST", "K_MAP", "K_MODIFY", "K_NAN", "K_NORECURSIVE", "K_NOSUPERUSER", 
		"K_NOT", "K_NULL", "K_OF", "K_ON", "K_ORDER", "K_PASSWORD", "K_PERMISSION", 
		"K_PERMISSIONS", "K_PRIMARY", "K_RENAME", "K_REVOKE", "K_SELECT", "K_SET", 
		"K_STATIC", "K_STORAGE", "K_SUPERUSER", "K_TEXT", "K_TIMESTAMP", "K_TIMEUUID", 
		"K_TO", "K_TOKEN", "K_TRIGGER", "K_TRUNCATE", "K_TTL", "K_TUPLE", "K_TYPE", 
		"K_UNLOGGED", "K_UPDATE", "K_USE", "K_USER", "K_USERS", "K_USING", "K_UUID", 
		"K_VALUES", "K_VARCHAR", "K_VARINT", "K_WHERE", "K_WITH", "K_WRITETIME", 
		"L", "LETTER", "M", "MULTILINE_COMMENT", "N", "O", "P", "Q", "QMARK", 
		"QUOTED_NAME", "R", "S", "STRING_LITERAL", "T", "U", "UUID", "V", "W", 
		"WS", "X", "Y", "Z", "'!='", "'('", "')'", "'+'", "','", "'-'", "'.'", 
		"':'", "';'", "'<'", "'<='", "'='", "'>'", "'>='", "'['", "'\\*'", "']'", 
		"'{'", "'}'"
	};
	public static final int EOF=-1;
	public static final int T__141=141;
	public static final int T__142=142;
	public static final int T__143=143;
	public static final int T__144=144;
	public static final int T__145=145;
	public static final int T__146=146;
	public static final int T__147=147;
	public static final int T__148=148;
	public static final int T__149=149;
	public static final int T__150=150;
	public static final int T__151=151;
	public static final int T__152=152;
	public static final int T__153=153;
	public static final int T__154=154;
	public static final int T__155=155;
	public static final int T__156=156;
	public static final int T__157=157;
	public static final int T__158=158;
	public static final int T__159=159;
	public static final int A=4;
	public static final int B=5;
	public static final int BOOLEAN=6;
	public static final int C=7;
	public static final int COMMENT=8;
	public static final int D=9;
	public static final int DIGIT=10;
	public static final int E=11;
	public static final int EXPONENT=12;
	public static final int F=13;
	public static final int FLOAT=14;
	public static final int G=15;
	public static final int H=16;
	public static final int HEX=17;
	public static final int HEXNUMBER=18;
	public static final int I=19;
	public static final int IDENT=20;
	public static final int INTEGER=21;
	public static final int J=22;
	public static final int K=23;
	public static final int K_ADD=24;
	public static final int K_ALL=25;
	public static final int K_ALLOW=26;
	public static final int K_ALTER=27;
	public static final int K_AND=28;
	public static final int K_APPLY=29;
	public static final int K_AS=30;
	public static final int K_ASC=31;
	public static final int K_ASCII=32;
	public static final int K_AUTHORIZE=33;
	public static final int K_BATCH=34;
	public static final int K_BEGIN=35;
	public static final int K_BIGINT=36;
	public static final int K_BLOB=37;
	public static final int K_BOOLEAN=38;
	public static final int K_BY=39;
	public static final int K_CLUSTERING=40;
	public static final int K_COLUMNFAMILY=41;
	public static final int K_COMPACT=42;
	public static final int K_CONTAINS=43;
	public static final int K_COUNT=44;
	public static final int K_COUNTER=45;
	public static final int K_CREATE=46;
	public static final int K_CUSTOM=47;
	public static final int K_DECIMAL=48;
	public static final int K_DELETE=49;
	public static final int K_DESC=50;
	public static final int K_DISTINCT=51;
	public static final int K_DOUBLE=52;
	public static final int K_DROP=53;
	public static final int K_EXISTS=54;
	public static final int K_FILTERING=55;
	public static final int K_FLOAT=56;
	public static final int K_FROM=57;
	public static final int K_FROZEN=58;
	public static final int K_FULL=59;
	public static final int K_GRANT=60;
	public static final int K_IF=61;
	public static final int K_IN=62;
	public static final int K_INDEX=63;
	public static final int K_INET=64;
	public static final int K_INFINITY=65;
	public static final int K_INSERT=66;
	public static final int K_INT=67;
	public static final int K_INTO=68;
	public static final int K_KEY=69;
	public static final int K_KEYS=70;
	public static final int K_KEYSPACE=71;
	public static final int K_KEYSPACES=72;
	public static final int K_LIMIT=73;
	public static final int K_LIST=74;
	public static final int K_MAP=75;
	public static final int K_MODIFY=76;
	public static final int K_NAN=77;
	public static final int K_NORECURSIVE=78;
	public static final int K_NOSUPERUSER=79;
	public static final int K_NOT=80;
	public static final int K_NULL=81;
	public static final int K_OF=82;
	public static final int K_ON=83;
	public static final int K_ORDER=84;
	public static final int K_PASSWORD=85;
	public static final int K_PERMISSION=86;
	public static final int K_PERMISSIONS=87;
	public static final int K_PRIMARY=88;
	public static final int K_RENAME=89;
	public static final int K_REVOKE=90;
	public static final int K_SELECT=91;
	public static final int K_SET=92;
	public static final int K_STATIC=93;
	public static final int K_STORAGE=94;
	public static final int K_SUPERUSER=95;
	public static final int K_TEXT=96;
	public static final int K_TIMESTAMP=97;
	public static final int K_TIMEUUID=98;
	public static final int K_TO=99;
	public static final int K_TOKEN=100;
	public static final int K_TRIGGER=101;
	public static final int K_TRUNCATE=102;
	public static final int K_TTL=103;
	public static final int K_TUPLE=104;
	public static final int K_TYPE=105;
	public static final int K_UNLOGGED=106;
	public static final int K_UPDATE=107;
	public static final int K_USE=108;
	public static final int K_USER=109;
	public static final int K_USERS=110;
	public static final int K_USING=111;
	public static final int K_UUID=112;
	public static final int K_VALUES=113;
	public static final int K_VARCHAR=114;
	public static final int K_VARINT=115;
	public static final int K_WHERE=116;
	public static final int K_WITH=117;
	public static final int K_WRITETIME=118;
	public static final int L=119;
	public static final int LETTER=120;
	public static final int M=121;
	public static final int MULTILINE_COMMENT=122;
	public static final int N=123;
	public static final int O=124;
	public static final int P=125;
	public static final int Q=126;
	public static final int QMARK=127;
	public static final int QUOTED_NAME=128;
	public static final int R=129;
	public static final int S=130;
	public static final int STRING_LITERAL=131;
	public static final int T=132;
	public static final int U=133;
	public static final int UUID=134;
	public static final int V=135;
	public static final int W=136;
	public static final int WS=137;
	public static final int X=138;
	public static final int Y=139;
	public static final int Z=140;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public CqlParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public CqlParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return CqlParser.tokenNames; }
	@Override public String getGrammarFileName() { return "/tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g"; }


	    private final List<ErrorListener> listeners = new ArrayList<ErrorListener>();
	    private final List<ColumnIdentifier> bindVariables = new ArrayList<ColumnIdentifier>();

	    public static final Set<String> reservedTypeNames = new HashSet<String>()
	    {{
	        add("byte");
	        add("smallint");
	        add("complex");
	        add("enum");
	        add("date");
	        add("interval");
	        add("macaddr");
	        add("bitstring");
	    }};

	    public AbstractMarker.Raw newBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.Raw marker = new AbstractMarker.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public AbstractMarker.INRaw newINBindVariables(ColumnIdentifier name)
	    {
	        AbstractMarker.INRaw marker = new AbstractMarker.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.Raw newTupleBindVariables(ColumnIdentifier name)
	    {
	        Tuples.Raw marker = new Tuples.Raw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public Tuples.INRaw newTupleINBindVariables(ColumnIdentifier name)
	    {
	        Tuples.INRaw marker = new Tuples.INRaw(bindVariables.size());
	        bindVariables.add(name);
	        return marker;
	    }

	    public void addErrorListener(ErrorListener listener)
	    {
	        this.listeners.add(listener);
	    }

	    public void removeErrorListener(ErrorListener listener)
	    {
	        this.listeners.remove(listener);
	    }

	    public void displayRecognitionError(String[] tokenNames, RecognitionException e)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, tokenNames, e);
	    }

	    private void addRecognitionError(String msg)
	    {
	        for (int i = 0, m = listeners.size(); i < m; i++)
	            listeners.get(i).syntaxError(this, msg);
	    }

	    public Map<String, String> convertPropertyMap(Maps.Literal map)
	    {
	        if (map == null || map.entries == null || map.entries.isEmpty())
	            return Collections.<String, String>emptyMap();

	        Map<String, String> res = new HashMap<String, String>(map.entries.size());

	        for (Pair<Term.Raw, Term.Raw> entry : map.entries)
	        {
	            // Because the parser tries to be smart and recover on error (to
	            // allow displaying more than one error I suppose), we have null
	            // entries in there. Just skip those, a proper error will be thrown in the end.
	            if (entry.left == null || entry.right == null)
	                break;

	            if (!(entry.left instanceof Constants.Literal))
	            {
	                String msg = "Invalid property name: " + entry.left;
	                if (entry.left instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }
	            if (!(entry.right instanceof Constants.Literal))
	            {
	                String msg = "Invalid property value: " + entry.right + " for property: " + entry.left;
	                if (entry.right instanceof AbstractMarker.Raw)
	                    msg += " (bind variables are not supported in DDL queries)";
	                addRecognitionError(msg);
	                break;
	            }

	            res.put(((Constants.Literal)entry.left).getRawText(), ((Constants.Literal)entry.right).getRawText());
	        }

	        return res;
	    }

	    public void addRawUpdate(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Operation.RawUpdate update)
	    {
	        for (Pair<ColumnIdentifier.Raw, Operation.RawUpdate> p : operations)
	        {
	            if (p.left.equals(key) && !p.right.isCompatibleWith(update))
	                addRecognitionError("Multiple incompatible setting of column " + key);
	        }
	        operations.add(Pair.create(key, update));
	    }



	// $ANTLR start "query"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:212:1: query returns [ParsedStatement stmnt] : st= cqlStatement ( ';' )* EOF ;
	public final ParsedStatement query() throws RecognitionException {
		ParsedStatement stmnt = null;


		ParsedStatement st =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:5: (st= cqlStatement ( ';' )* EOF )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:7: st= cqlStatement ( ';' )* EOF
			{
			pushFollow(FOLLOW_cqlStatement_in_query72);
			st=cqlStatement();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:23: ( ';' )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( (LA1_0==149) ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:213:24: ';'
					{
					match(input,149,FOLLOW_149_in_query75); 
					}
					break;

				default :
					break loop1;
				}
			}

			match(input,EOF,FOLLOW_EOF_in_query79); 
			 stmnt = st; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "query"



	// $ANTLR start "cqlStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:216:1: cqlStatement returns [ParsedStatement stmt] : (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantStatement |st17= revokeStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement );
	public final ParsedStatement cqlStatement() throws RecognitionException {
		ParsedStatement stmt = null;


		SelectStatement.RawStatement st1 =null;
		UpdateStatement.ParsedInsert st2 =null;
		UpdateStatement.ParsedUpdate st3 =null;
		BatchStatement.Parsed st4 =null;
		DeleteStatement.Parsed st5 =null;
		UseStatement st6 =null;
		TruncateStatement st7 =null;
		CreateKeyspaceStatement st8 =null;
		CreateTableStatement.RawStatement st9 =null;
		CreateIndexStatement st10 =null;
		DropKeyspaceStatement st11 =null;
		DropTableStatement st12 =null;
		DropIndexStatement st13 =null;
		AlterTableStatement st14 =null;
		AlterKeyspaceStatement st15 =null;
		GrantStatement st16 =null;
		RevokeStatement st17 =null;
		ListPermissionsStatement st18 =null;
		CreateUserStatement st19 =null;
		AlterUserStatement st20 =null;
		DropUserStatement st21 =null;
		ListUsersStatement st22 =null;
		CreateTriggerStatement st23 =null;
		DropTriggerStatement st24 =null;
		CreateTypeStatement st25 =null;
		AlterTypeStatement st26 =null;
		DropTypeStatement st27 =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:5: (st1= selectStatement |st2= insertStatement |st3= updateStatement |st4= batchStatement |st5= deleteStatement |st6= useStatement |st7= truncateStatement |st8= createKeyspaceStatement |st9= createTableStatement |st10= createIndexStatement |st11= dropKeyspaceStatement |st12= dropTableStatement |st13= dropIndexStatement |st14= alterTableStatement |st15= alterKeyspaceStatement |st16= grantStatement |st17= revokeStatement |st18= listPermissionsStatement |st19= createUserStatement |st20= alterUserStatement |st21= dropUserStatement |st22= listUsersStatement |st23= createTriggerStatement |st24= dropTriggerStatement |st25= createTypeStatement |st26= alterTypeStatement |st27= dropTypeStatement )
			int alt2=27;
			switch ( input.LA(1) ) {
			case K_SELECT:
				{
				alt2=1;
				}
				break;
			case K_INSERT:
				{
				alt2=2;
				}
				break;
			case K_UPDATE:
				{
				alt2=3;
				}
				break;
			case K_BEGIN:
				{
				alt2=4;
				}
				break;
			case K_DELETE:
				{
				alt2=5;
				}
				break;
			case K_USE:
				{
				alt2=6;
				}
				break;
			case K_TRUNCATE:
				{
				alt2=7;
				}
				break;
			case K_CREATE:
				{
				switch ( input.LA(2) ) {
				case K_KEYSPACE:
					{
					alt2=8;
					}
					break;
				case K_COLUMNFAMILY:
					{
					alt2=9;
					}
					break;
				case K_USER:
					{
					alt2=19;
					}
					break;
				case K_TRIGGER:
					{
					alt2=23;
					}
					break;
				case K_TYPE:
					{
					alt2=25;
					}
					break;
				case K_CUSTOM:
				case K_INDEX:
					{
					alt2=10;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DROP:
				{
				switch ( input.LA(2) ) {
				case K_KEYSPACE:
					{
					alt2=11;
					}
					break;
				case K_COLUMNFAMILY:
					{
					alt2=12;
					}
					break;
				case K_INDEX:
					{
					alt2=13;
					}
					break;
				case K_USER:
					{
					alt2=21;
					}
					break;
				case K_TRIGGER:
					{
					alt2=24;
					}
					break;
				case K_TYPE:
					{
					alt2=27;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALTER:
				{
				switch ( input.LA(2) ) {
				case K_COLUMNFAMILY:
					{
					alt2=14;
					}
					break;
				case K_KEYSPACE:
					{
					alt2=15;
					}
					break;
				case K_USER:
					{
					alt2=20;
					}
					break;
				case K_TYPE:
					{
					alt2=26;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_GRANT:
				{
				alt2=16;
				}
				break;
			case K_REVOKE:
				{
				alt2=17;
				}
				break;
			case K_LIST:
				{
				int LA2_13 = input.LA(2);
				if ( (LA2_13==K_USERS) ) {
					alt2=22;
				}
				else if ( (LA2_13==K_ALL||LA2_13==K_ALTER||LA2_13==K_AUTHORIZE||LA2_13==K_CREATE||LA2_13==K_DROP||LA2_13==K_MODIFY||LA2_13==K_SELECT) ) {
					alt2=18;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}
			switch (alt2) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:218:7: st1= selectStatement
					{
					pushFollow(FOLLOW_selectStatement_in_cqlStatement113);
					st1=selectStatement();
					state._fsp--;

					 stmt = st1; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:219:7: st2= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_cqlStatement138);
					st2=insertStatement();
					state._fsp--;

					 stmt = st2; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:220:7: st3= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_cqlStatement163);
					st3=updateStatement();
					state._fsp--;

					 stmt = st3; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:221:7: st4= batchStatement
					{
					pushFollow(FOLLOW_batchStatement_in_cqlStatement188);
					st4=batchStatement();
					state._fsp--;

					 stmt = st4; 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:222:7: st5= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_cqlStatement214);
					st5=deleteStatement();
					state._fsp--;

					 stmt = st5; 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:223:7: st6= useStatement
					{
					pushFollow(FOLLOW_useStatement_in_cqlStatement239);
					st6=useStatement();
					state._fsp--;

					 stmt = st6; 
					}
					break;
				case 7 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:224:7: st7= truncateStatement
					{
					pushFollow(FOLLOW_truncateStatement_in_cqlStatement267);
					st7=truncateStatement();
					state._fsp--;

					 stmt = st7; 
					}
					break;
				case 8 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:225:7: st8= createKeyspaceStatement
					{
					pushFollow(FOLLOW_createKeyspaceStatement_in_cqlStatement290);
					st8=createKeyspaceStatement();
					state._fsp--;

					 stmt = st8; 
					}
					break;
				case 9 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:226:7: st9= createTableStatement
					{
					pushFollow(FOLLOW_createTableStatement_in_cqlStatement307);
					st9=createTableStatement();
					state._fsp--;

					 stmt = st9; 
					}
					break;
				case 10 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:227:7: st10= createIndexStatement
					{
					pushFollow(FOLLOW_createIndexStatement_in_cqlStatement326);
					st10=createIndexStatement();
					state._fsp--;

					 stmt = st10; 
					}
					break;
				case 11 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:228:7: st11= dropKeyspaceStatement
					{
					pushFollow(FOLLOW_dropKeyspaceStatement_in_cqlStatement345);
					st11=dropKeyspaceStatement();
					state._fsp--;

					 stmt = st11; 
					}
					break;
				case 12 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:229:7: st12= dropTableStatement
					{
					pushFollow(FOLLOW_dropTableStatement_in_cqlStatement363);
					st12=dropTableStatement();
					state._fsp--;

					 stmt = st12; 
					}
					break;
				case 13 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:230:7: st13= dropIndexStatement
					{
					pushFollow(FOLLOW_dropIndexStatement_in_cqlStatement384);
					st13=dropIndexStatement();
					state._fsp--;

					 stmt = st13; 
					}
					break;
				case 14 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:231:7: st14= alterTableStatement
					{
					pushFollow(FOLLOW_alterTableStatement_in_cqlStatement405);
					st14=alterTableStatement();
					state._fsp--;

					 stmt = st14; 
					}
					break;
				case 15 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:232:7: st15= alterKeyspaceStatement
					{
					pushFollow(FOLLOW_alterKeyspaceStatement_in_cqlStatement425);
					st15=alterKeyspaceStatement();
					state._fsp--;

					 stmt = st15; 
					}
					break;
				case 16 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:233:7: st16= grantStatement
					{
					pushFollow(FOLLOW_grantStatement_in_cqlStatement442);
					st16=grantStatement();
					state._fsp--;

					 stmt = st16; 
					}
					break;
				case 17 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:234:7: st17= revokeStatement
					{
					pushFollow(FOLLOW_revokeStatement_in_cqlStatement467);
					st17=revokeStatement();
					state._fsp--;

					 stmt = st17; 
					}
					break;
				case 18 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:235:7: st18= listPermissionsStatement
					{
					pushFollow(FOLLOW_listPermissionsStatement_in_cqlStatement491);
					st18=listPermissionsStatement();
					state._fsp--;

					 stmt = st18; 
					}
					break;
				case 19 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:236:7: st19= createUserStatement
					{
					pushFollow(FOLLOW_createUserStatement_in_cqlStatement506);
					st19=createUserStatement();
					state._fsp--;

					 stmt = st19; 
					}
					break;
				case 20 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:237:7: st20= alterUserStatement
					{
					pushFollow(FOLLOW_alterUserStatement_in_cqlStatement526);
					st20=alterUserStatement();
					state._fsp--;

					 stmt = st20; 
					}
					break;
				case 21 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:238:7: st21= dropUserStatement
					{
					pushFollow(FOLLOW_dropUserStatement_in_cqlStatement547);
					st21=dropUserStatement();
					state._fsp--;

					 stmt = st21; 
					}
					break;
				case 22 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:239:7: st22= listUsersStatement
					{
					pushFollow(FOLLOW_listUsersStatement_in_cqlStatement569);
					st22=listUsersStatement();
					state._fsp--;

					 stmt = st22; 
					}
					break;
				case 23 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:240:7: st23= createTriggerStatement
					{
					pushFollow(FOLLOW_createTriggerStatement_in_cqlStatement590);
					st23=createTriggerStatement();
					state._fsp--;

					 stmt = st23; 
					}
					break;
				case 24 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:241:7: st24= dropTriggerStatement
					{
					pushFollow(FOLLOW_dropTriggerStatement_in_cqlStatement607);
					st24=dropTriggerStatement();
					state._fsp--;

					 stmt = st24; 
					}
					break;
				case 25 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:242:7: st25= createTypeStatement
					{
					pushFollow(FOLLOW_createTypeStatement_in_cqlStatement626);
					st25=createTypeStatement();
					state._fsp--;

					 stmt = st25; 
					}
					break;
				case 26 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:243:7: st26= alterTypeStatement
					{
					pushFollow(FOLLOW_alterTypeStatement_in_cqlStatement646);
					st26=alterTypeStatement();
					state._fsp--;

					 stmt = st26; 
					}
					break;
				case 27 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:244:7: st27= dropTypeStatement
					{
					pushFollow(FOLLOW_dropTypeStatement_in_cqlStatement667);
					st27=dropTypeStatement();
					state._fsp--;

					 stmt = st27; 
					}
					break;

			}
			 if (stmt != null) stmt.setBoundVariables(bindVariables); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "cqlStatement"



	// $ANTLR start "useStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:250:1: useStatement returns [UseStatement stmt] : K_USE ks= keyspaceName ;
	public final UseStatement useStatement() throws RecognitionException {
		UseStatement stmt = null;


		String ks =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:5: ( K_USE ks= keyspaceName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:251:7: K_USE ks= keyspaceName
			{
			match(input,K_USE,FOLLOW_K_USE_in_useStatement702); 
			pushFollow(FOLLOW_keyspaceName_in_useStatement706);
			ks=keyspaceName();
			state._fsp--;

			 stmt = new UseStatement(ks); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "useStatement"



	// $ANTLR start "selectStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:260:1: selectStatement returns [SelectStatement.RawStatement expr] : K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? ;
	public final SelectStatement.RawStatement selectStatement() throws RecognitionException {
		SelectStatement.RawStatement expr = null;


		List<RawSelector> sclause =null;
		ColumnIdentifier c =null;
		CFName cf =null;
		List<Relation> wclause =null;
		Term.Raw rows =null;


		        boolean isDistinct = false;
		        boolean isCount = false;
		        ColumnIdentifier countAlias = null;
		        Term.Raw limit = null;
		        Map<ColumnIdentifier.Raw, Boolean> orderings = new LinkedHashMap<ColumnIdentifier.Raw, Boolean>();
		        boolean allowFiltering = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:5: ( K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:7: K_SELECT ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) ) K_FROM cf= columnFamilyName ( K_WHERE wclause= whereClause )? ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )? ( K_LIMIT rows= intValue )? ( K_ALLOW K_FILTERING )?
			{
			match(input,K_SELECT,FOLLOW_K_SELECT_in_selectStatement740); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:16: ( ( K_DISTINCT )? sclause= selectClause | ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? ) )
			int alt5=2;
			int LA5_0 = input.LA(1);
			if ( (LA5_0==IDENT||LA5_0==K_ALL||LA5_0==K_AS||LA5_0==K_ASCII||(LA5_0 >= K_BIGINT && LA5_0 <= K_BOOLEAN)||LA5_0==K_CLUSTERING||(LA5_0 >= K_COMPACT && LA5_0 <= K_CONTAINS)||LA5_0==K_COUNTER||(LA5_0 >= K_CUSTOM && LA5_0 <= K_DECIMAL)||(LA5_0 >= K_DISTINCT && LA5_0 <= K_DOUBLE)||(LA5_0 >= K_EXISTS && LA5_0 <= K_FLOAT)||LA5_0==K_FROZEN||LA5_0==K_INET||LA5_0==K_INT||(LA5_0 >= K_KEY && LA5_0 <= K_KEYS)||LA5_0==K_KEYSPACES||(LA5_0 >= K_LIST && LA5_0 <= K_MAP)||LA5_0==K_NOSUPERUSER||(LA5_0 >= K_PASSWORD && LA5_0 <= K_PERMISSIONS)||(LA5_0 >= K_STATIC && LA5_0 <= K_TIMEUUID)||(LA5_0 >= K_TOKEN && LA5_0 <= K_TRIGGER)||(LA5_0 >= K_TTL && LA5_0 <= K_TYPE)||(LA5_0 >= K_USER && LA5_0 <= K_USERS)||(LA5_0 >= K_UUID && LA5_0 <= K_VARINT)||LA5_0==K_WRITETIME||LA5_0==QUOTED_NAME||LA5_0==156) ) {
				alt5=1;
			}
			else if ( (LA5_0==K_COUNT) ) {
				int LA5_2 = input.LA(2);
				if ( (LA5_2==142) ) {
					alt5=2;
				}
				else if ( (LA5_2==K_AS||LA5_2==K_FROM||LA5_2==145||LA5_2==147) ) {
					alt5=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 5, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 5, 0, input);
				throw nvae;
			}

			switch (alt5) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:18: ( K_DISTINCT )? sclause= selectClause
					{
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:18: ( K_DISTINCT )?
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0==K_DISTINCT) ) {
						int LA3_1 = input.LA(2);
						if ( (LA3_1==IDENT||LA3_1==K_ALL||LA3_1==K_ASCII||(LA3_1 >= K_BIGINT && LA3_1 <= K_BOOLEAN)||LA3_1==K_CLUSTERING||(LA3_1 >= K_COMPACT && LA3_1 <= K_COUNTER)||(LA3_1 >= K_CUSTOM && LA3_1 <= K_DECIMAL)||(LA3_1 >= K_DISTINCT && LA3_1 <= K_DOUBLE)||(LA3_1 >= K_EXISTS && LA3_1 <= K_FLOAT)||LA3_1==K_FROZEN||LA3_1==K_INET||LA3_1==K_INT||(LA3_1 >= K_KEY && LA3_1 <= K_KEYS)||LA3_1==K_KEYSPACES||(LA3_1 >= K_LIST && LA3_1 <= K_MAP)||LA3_1==K_NOSUPERUSER||(LA3_1 >= K_PASSWORD && LA3_1 <= K_PERMISSIONS)||(LA3_1 >= K_STATIC && LA3_1 <= K_TIMEUUID)||(LA3_1 >= K_TOKEN && LA3_1 <= K_TRIGGER)||(LA3_1 >= K_TTL && LA3_1 <= K_TYPE)||(LA3_1 >= K_USER && LA3_1 <= K_USERS)||(LA3_1 >= K_UUID && LA3_1 <= K_VARINT)||LA3_1==K_WRITETIME||LA3_1==QUOTED_NAME||LA3_1==156) ) {
							alt3=1;
						}
						else if ( (LA3_1==K_AS) ) {
							int LA3_4 = input.LA(3);
							if ( (LA3_4==K_FROM||LA3_4==142||LA3_4==145||LA3_4==147) ) {
								alt3=1;
							}
							else if ( (LA3_4==K_AS) ) {
								int LA3_5 = input.LA(4);
								if ( (LA3_5==IDENT||LA3_5==K_ALL||LA3_5==K_AS||LA3_5==K_ASCII||(LA3_5 >= K_BIGINT && LA3_5 <= K_BOOLEAN)||LA3_5==K_CLUSTERING||(LA3_5 >= K_COMPACT && LA3_5 <= K_COUNTER)||(LA3_5 >= K_CUSTOM && LA3_5 <= K_DECIMAL)||(LA3_5 >= K_DISTINCT && LA3_5 <= K_DOUBLE)||(LA3_5 >= K_EXISTS && LA3_5 <= K_FLOAT)||LA3_5==K_FROZEN||LA3_5==K_INET||LA3_5==K_INT||(LA3_5 >= K_KEY && LA3_5 <= K_KEYS)||LA3_5==K_KEYSPACES||(LA3_5 >= K_LIST && LA3_5 <= K_MAP)||LA3_5==K_NOSUPERUSER||(LA3_5 >= K_PASSWORD && LA3_5 <= K_PERMISSIONS)||(LA3_5 >= K_STATIC && LA3_5 <= K_TIMEUUID)||LA3_5==K_TRIGGER||(LA3_5 >= K_TTL && LA3_5 <= K_TYPE)||(LA3_5 >= K_USER && LA3_5 <= K_USERS)||(LA3_5 >= K_UUID && LA3_5 <= K_VARINT)||LA3_5==K_WRITETIME||LA3_5==QUOTED_NAME) ) {
									alt3=1;
								}
							}
						}
					}
					switch (alt3) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:269:20: K_DISTINCT
							{
							match(input,K_DISTINCT,FOLLOW_K_DISTINCT_in_selectStatement746); 
							 isDistinct = true; 
							}
							break;

					}

					pushFollow(FOLLOW_selectClause_in_selectStatement755);
					sclause=selectClause();
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? )
					{
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:18: ( K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )? )
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:19: K_COUNT '(' sclause= selectCountClause ')' ( K_AS c= ident )?
					{
					match(input,K_COUNT,FOLLOW_K_COUNT_in_selectStatement775); 
					match(input,142,FOLLOW_142_in_selectStatement777); 
					pushFollow(FOLLOW_selectCountClause_in_selectStatement781);
					sclause=selectCountClause();
					state._fsp--;

					match(input,143,FOLLOW_143_in_selectStatement783); 
					 isCount = true; 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:81: ( K_AS c= ident )?
					int alt4=2;
					int LA4_0 = input.LA(1);
					if ( (LA4_0==K_AS) ) {
						alt4=1;
					}
					switch (alt4) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:270:82: K_AS c= ident
							{
							match(input,K_AS,FOLLOW_K_AS_in_selectStatement788); 
							pushFollow(FOLLOW_ident_in_selectStatement792);
							c=ident();
							state._fsp--;

							 countAlias = c; 
							}
							break;

					}

					}

					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_selectStatement807); 
			pushFollow(FOLLOW_columnFamilyName_in_selectStatement811);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:7: ( K_WHERE wclause= whereClause )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==K_WHERE) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:272:9: K_WHERE wclause= whereClause
					{
					match(input,K_WHERE,FOLLOW_K_WHERE_in_selectStatement821); 
					pushFollow(FOLLOW_whereClause_in_selectStatement825);
					wclause=whereClause();
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:7: ( K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )* )?
			int alt8=2;
			int LA8_0 = input.LA(1);
			if ( (LA8_0==K_ORDER) ) {
				alt8=1;
			}
			switch (alt8) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:9: K_ORDER K_BY orderByClause[orderings] ( ',' orderByClause[orderings] )*
					{
					match(input,K_ORDER,FOLLOW_K_ORDER_in_selectStatement838); 
					match(input,K_BY,FOLLOW_K_BY_in_selectStatement840); 
					pushFollow(FOLLOW_orderByClause_in_selectStatement842);
					orderByClause(orderings);
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:47: ( ',' orderByClause[orderings] )*
					loop7:
					while (true) {
						int alt7=2;
						int LA7_0 = input.LA(1);
						if ( (LA7_0==145) ) {
							alt7=1;
						}

						switch (alt7) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:273:49: ',' orderByClause[orderings]
							{
							match(input,145,FOLLOW_145_in_selectStatement847); 
							pushFollow(FOLLOW_orderByClause_in_selectStatement849);
							orderByClause(orderings);
							state._fsp--;

							}
							break;

						default :
							break loop7;
						}
					}

					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:7: ( K_LIMIT rows= intValue )?
			int alt9=2;
			int LA9_0 = input.LA(1);
			if ( (LA9_0==K_LIMIT) ) {
				alt9=1;
			}
			switch (alt9) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:274:9: K_LIMIT rows= intValue
					{
					match(input,K_LIMIT,FOLLOW_K_LIMIT_in_selectStatement866); 
					pushFollow(FOLLOW_intValue_in_selectStatement870);
					rows=intValue();
					state._fsp--;

					 limit = rows; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:7: ( K_ALLOW K_FILTERING )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==K_ALLOW) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:275:9: K_ALLOW K_FILTERING
					{
					match(input,K_ALLOW,FOLLOW_K_ALLOW_in_selectStatement885); 
					match(input,K_FILTERING,FOLLOW_K_FILTERING_in_selectStatement887); 
					 allowFiltering = true; 
					}
					break;

			}


			          SelectStatement.Parameters params = new SelectStatement.Parameters(orderings,
			                                                                             isDistinct,
			                                                                             isCount,
			                                                                             countAlias,
			                                                                             allowFiltering);
			          expr = new SelectStatement.RawStatement(cf, params, sclause, wclause, limit);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectStatement"



	// $ANTLR start "selectClause"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:286:1: selectClause returns [List<RawSelector> expr] : (t1= selector ( ',' tN= selector )* | '\\*' );
	public final List<RawSelector> selectClause() throws RecognitionException {
		List<RawSelector> expr = null;


		RawSelector t1 =null;
		RawSelector tN =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:5: (t1= selector ( ',' tN= selector )* | '\\*' )
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==IDENT||LA12_0==K_ALL||LA12_0==K_AS||LA12_0==K_ASCII||(LA12_0 >= K_BIGINT && LA12_0 <= K_BOOLEAN)||LA12_0==K_CLUSTERING||(LA12_0 >= K_COMPACT && LA12_0 <= K_COUNTER)||(LA12_0 >= K_CUSTOM && LA12_0 <= K_DECIMAL)||(LA12_0 >= K_DISTINCT && LA12_0 <= K_DOUBLE)||(LA12_0 >= K_EXISTS && LA12_0 <= K_FLOAT)||LA12_0==K_FROZEN||LA12_0==K_INET||LA12_0==K_INT||(LA12_0 >= K_KEY && LA12_0 <= K_KEYS)||LA12_0==K_KEYSPACES||(LA12_0 >= K_LIST && LA12_0 <= K_MAP)||LA12_0==K_NOSUPERUSER||(LA12_0 >= K_PASSWORD && LA12_0 <= K_PERMISSIONS)||(LA12_0 >= K_STATIC && LA12_0 <= K_TIMEUUID)||(LA12_0 >= K_TOKEN && LA12_0 <= K_TRIGGER)||(LA12_0 >= K_TTL && LA12_0 <= K_TYPE)||(LA12_0 >= K_USER && LA12_0 <= K_USERS)||(LA12_0 >= K_UUID && LA12_0 <= K_VARINT)||LA12_0==K_WRITETIME||LA12_0==QUOTED_NAME) ) {
				alt12=1;
			}
			else if ( (LA12_0==156) ) {
				alt12=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:7: t1= selector ( ',' tN= selector )*
					{
					pushFollow(FOLLOW_selector_in_selectClause924);
					t1=selector();
					state._fsp--;

					 expr = new ArrayList<RawSelector>(); expr.add(t1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:76: ( ',' tN= selector )*
					loop11:
					while (true) {
						int alt11=2;
						int LA11_0 = input.LA(1);
						if ( (LA11_0==145) ) {
							alt11=1;
						}

						switch (alt11) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:287:77: ',' tN= selector
							{
							match(input,145,FOLLOW_145_in_selectClause929); 
							pushFollow(FOLLOW_selector_in_selectClause933);
							tN=selector();
							state._fsp--;

							 expr.add(tN); 
							}
							break;

						default :
							break loop11;
						}
					}

					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:288:7: '\\*'
					{
					match(input,156,FOLLOW_156_in_selectClause945); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectClause"



	// $ANTLR start "selector"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:291:1: selector returns [RawSelector s] : us= unaliasedSelector ( K_AS c= ident )? ;
	public final RawSelector selector() throws RecognitionException {
		RawSelector s = null;


		Selectable.Raw us =null;
		ColumnIdentifier c =null;

		 ColumnIdentifier alias = null; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:5: (us= unaliasedSelector ( K_AS c= ident )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:7: us= unaliasedSelector ( K_AS c= ident )?
			{
			pushFollow(FOLLOW_unaliasedSelector_in_selector978);
			us=unaliasedSelector();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:28: ( K_AS c= ident )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==K_AS) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:293:29: K_AS c= ident
					{
					match(input,K_AS,FOLLOW_K_AS_in_selector981); 
					pushFollow(FOLLOW_ident_in_selector985);
					c=ident();
					state._fsp--;

					 alias = c; 
					}
					break;

			}

			 s = new RawSelector(us, alias); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "selector"



	// $ANTLR start "unaliasedSelector"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:296:1: unaliasedSelector returns [Selectable.Raw s] : (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* ;
	public final Selectable.Raw unaliasedSelector() throws RecognitionException {
		Selectable.Raw s = null;


		ColumnIdentifier.Raw c =null;
		String f =null;
		List<Selectable.Raw> args =null;
		ColumnIdentifier.Raw fi =null;

		 Selectable.Raw tmp = null; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:5: ( (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs ) ( '.' fi= cident )*
			{
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:8: (c= cident | K_WRITETIME '(' c= cident ')' | K_TTL '(' c= cident ')' |f= functionName args= selectionFunctionArgs )
			int alt14=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA14_1 = input.LA(2);
				if ( (LA14_1==K_AS||LA14_1==K_FROM||LA14_1==143||LA14_1==145||LA14_1==147) ) {
					alt14=1;
				}
				else if ( (LA14_1==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case QUOTED_NAME:
				{
				alt14=1;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA14_3 = input.LA(2);
				if ( (LA14_3==K_AS||LA14_3==K_FROM||LA14_3==143||LA14_3==145||LA14_3==147) ) {
					alt14=1;
				}
				else if ( (LA14_3==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA14_4 = input.LA(2);
				if ( (LA14_4==K_AS||LA14_4==K_FROM||LA14_4==143||LA14_4==145||LA14_4==147) ) {
					alt14=1;
				}
				else if ( (LA14_4==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA14_5 = input.LA(2);
				if ( (LA14_5==K_AS||LA14_5==K_FROM||LA14_5==143||LA14_5==145||LA14_5==147) ) {
					alt14=1;
				}
				else if ( (LA14_5==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA14_6 = input.LA(2);
				if ( (LA14_6==K_AS||LA14_6==K_FROM||LA14_6==143||LA14_6==145||LA14_6==147) ) {
					alt14=1;
				}
				else if ( (LA14_6==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA14_7 = input.LA(2);
				if ( (LA14_7==K_AS||LA14_7==K_FROM||LA14_7==143||LA14_7==145||LA14_7==147) ) {
					alt14=1;
				}
				else if ( (LA14_7==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA14_8 = input.LA(2);
				if ( (LA14_8==K_AS||LA14_8==K_FROM||LA14_8==143||LA14_8==145||LA14_8==147) ) {
					alt14=1;
				}
				else if ( (LA14_8==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA14_9 = input.LA(2);
				if ( (LA14_9==K_AS||LA14_9==K_FROM||LA14_9==143||LA14_9==145||LA14_9==147) ) {
					alt14=1;
				}
				else if ( (LA14_9==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA14_10 = input.LA(2);
				if ( (LA14_10==K_AS||LA14_10==K_FROM||LA14_10==143||LA14_10==145||LA14_10==147) ) {
					alt14=1;
				}
				else if ( (LA14_10==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA14_11 = input.LA(2);
				if ( (LA14_11==K_AS||LA14_11==K_FROM||LA14_11==143||LA14_11==145||LA14_11==147) ) {
					alt14=1;
				}
				else if ( (LA14_11==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA14_12 = input.LA(2);
				if ( (LA14_12==K_AS||LA14_12==K_FROM||LA14_12==143||LA14_12==145||LA14_12==147) ) {
					alt14=1;
				}
				else if ( (LA14_12==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA14_13 = input.LA(2);
				if ( (LA14_13==K_AS||LA14_13==K_FROM||LA14_13==143||LA14_13==145||LA14_13==147) ) {
					alt14=1;
				}
				else if ( (LA14_13==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA14_14 = input.LA(2);
				if ( (LA14_14==K_AS||LA14_14==K_FROM||LA14_14==143||LA14_14==145||LA14_14==147) ) {
					alt14=1;
				}
				else if ( (LA14_14==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA14_15 = input.LA(2);
				if ( (LA14_15==K_AS||LA14_15==K_FROM||LA14_15==143||LA14_15==145||LA14_15==147) ) {
					alt14=1;
				}
				else if ( (LA14_15==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA14_16 = input.LA(2);
				if ( (LA14_16==K_AS||LA14_16==K_FROM||LA14_16==143||LA14_16==145||LA14_16==147) ) {
					alt14=1;
				}
				else if ( (LA14_16==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA14_17 = input.LA(2);
				if ( (LA14_17==K_AS||LA14_17==K_FROM||LA14_17==143||LA14_17==145||LA14_17==147) ) {
					alt14=1;
				}
				else if ( (LA14_17==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA14_18 = input.LA(2);
				if ( (LA14_18==K_AS||LA14_18==K_FROM||LA14_18==143||LA14_18==145||LA14_18==147) ) {
					alt14=1;
				}
				else if ( (LA14_18==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA14_19 = input.LA(2);
				if ( (LA14_19==K_AS||LA14_19==K_FROM||LA14_19==143||LA14_19==145||LA14_19==147) ) {
					alt14=1;
				}
				else if ( (LA14_19==142) ) {
					alt14=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_WRITETIME:
				{
				int LA14_20 = input.LA(2);
				if ( (LA14_20==142) ) {
					alt14=2;
				}
				else if ( (LA14_20==K_AS||LA14_20==K_FROM||LA14_20==143||LA14_20==145||LA14_20==147) ) {
					alt14=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TTL:
				{
				int LA14_21 = input.LA(2);
				if ( (LA14_21==142) ) {
					alt14=3;
				}
				else if ( (LA14_21==K_AS||LA14_21==K_FROM||LA14_21==143||LA14_21==145||LA14_21==147) ) {
					alt14=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 14, 21, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TOKEN:
				{
				alt14=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 14, 0, input);
				throw nvae;
			}
			switch (alt14) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:298:10: c= cident
					{
					pushFollow(FOLLOW_cident_in_unaliasedSelector1026);
					c=cident();
					state._fsp--;

					 tmp = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:299:10: K_WRITETIME '(' c= cident ')'
					{
					match(input,K_WRITETIME,FOLLOW_K_WRITETIME_in_unaliasedSelector1072); 
					match(input,142,FOLLOW_142_in_unaliasedSelector1074); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1078);
					c=cident();
					state._fsp--;

					match(input,143,FOLLOW_143_in_unaliasedSelector1080); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, true); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:300:10: K_TTL '(' c= cident ')'
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_unaliasedSelector1106); 
					match(input,142,FOLLOW_142_in_unaliasedSelector1114); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1118);
					c=cident();
					state._fsp--;

					match(input,143,FOLLOW_143_in_unaliasedSelector1120); 
					 tmp = new Selectable.WritetimeOrTTL.Raw(c, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:301:10: f= functionName args= selectionFunctionArgs
					{
					pushFollow(FOLLOW_functionName_in_unaliasedSelector1148);
					f=functionName();
					state._fsp--;

					pushFollow(FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152);
					args=selectionFunctionArgs();
					state._fsp--;

					 tmp = new Selectable.WithFunction.Raw(f, args); 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:10: ( '.' fi= cident )*
			loop15:
			while (true) {
				int alt15=2;
				int LA15_0 = input.LA(1);
				if ( (LA15_0==147) ) {
					alt15=1;
				}

				switch (alt15) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:302:12: '.' fi= cident
					{
					match(input,147,FOLLOW_147_in_unaliasedSelector1167); 
					pushFollow(FOLLOW_cident_in_unaliasedSelector1171);
					fi=cident();
					state._fsp--;

					 tmp = new Selectable.WithFieldSelection.Raw(tmp, fi); 
					}
					break;

				default :
					break loop15;
				}
			}

			 s = tmp; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "unaliasedSelector"



	// $ANTLR start "selectionFunctionArgs"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:305:1: selectionFunctionArgs returns [List<Selectable.Raw> a] : ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' );
	public final List<Selectable.Raw> selectionFunctionArgs() throws RecognitionException {
		List<Selectable.Raw> a = null;


		Selectable.Raw s1 =null;
		Selectable.Raw sn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:5: ( '(' ')' | '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')' )
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==142) ) {
				int LA17_1 = input.LA(2);
				if ( (LA17_1==143) ) {
					alt17=1;
				}
				else if ( (LA17_1==IDENT||LA17_1==K_ALL||LA17_1==K_AS||LA17_1==K_ASCII||(LA17_1 >= K_BIGINT && LA17_1 <= K_BOOLEAN)||LA17_1==K_CLUSTERING||(LA17_1 >= K_COMPACT && LA17_1 <= K_COUNTER)||(LA17_1 >= K_CUSTOM && LA17_1 <= K_DECIMAL)||(LA17_1 >= K_DISTINCT && LA17_1 <= K_DOUBLE)||(LA17_1 >= K_EXISTS && LA17_1 <= K_FLOAT)||LA17_1==K_FROZEN||LA17_1==K_INET||LA17_1==K_INT||(LA17_1 >= K_KEY && LA17_1 <= K_KEYS)||LA17_1==K_KEYSPACES||(LA17_1 >= K_LIST && LA17_1 <= K_MAP)||LA17_1==K_NOSUPERUSER||(LA17_1 >= K_PASSWORD && LA17_1 <= K_PERMISSIONS)||(LA17_1 >= K_STATIC && LA17_1 <= K_TIMEUUID)||(LA17_1 >= K_TOKEN && LA17_1 <= K_TRIGGER)||(LA17_1 >= K_TTL && LA17_1 <= K_TYPE)||(LA17_1 >= K_USER && LA17_1 <= K_USERS)||(LA17_1 >= K_UUID && LA17_1 <= K_VARINT)||LA17_1==K_WRITETIME||LA17_1==QUOTED_NAME) ) {
					alt17=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 17, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 17, 0, input);
				throw nvae;
			}

			switch (alt17) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:306:7: '(' ')'
					{
					match(input,142,FOLLOW_142_in_selectionFunctionArgs1199); 
					match(input,143,FOLLOW_143_in_selectionFunctionArgs1201); 
					 a = Collections.emptyList(); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:307:7: '(' s1= unaliasedSelector ( ',' sn= unaliasedSelector )* ')'
					{
					match(input,142,FOLLOW_142_in_selectionFunctionArgs1211); 
					pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215);
					s1=unaliasedSelector();
					state._fsp--;

					 List<Selectable.Raw> args = new ArrayList<Selectable.Raw>(); args.add(s1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:11: ( ',' sn= unaliasedSelector )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( (LA16_0==145) ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:308:13: ',' sn= unaliasedSelector
							{
							match(input,145,FOLLOW_145_in_selectionFunctionArgs1231); 
							pushFollow(FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235);
							sn=unaliasedSelector();
							state._fsp--;

							 args.add(sn); 
							}
							break;

						default :
							break loop16;
						}
					}

					match(input,143,FOLLOW_143_in_selectionFunctionArgs1248); 
					 a = args; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return a;
	}
	// $ANTLR end "selectionFunctionArgs"



	// $ANTLR start "selectCountClause"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:312:1: selectCountClause returns [List<RawSelector> expr] : ( '\\*' |i= INTEGER );
	public final List<RawSelector> selectCountClause() throws RecognitionException {
		List<RawSelector> expr = null;


		Token i=null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:5: ( '\\*' |i= INTEGER )
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0==156) ) {
				alt18=1;
			}
			else if ( (LA18_0==INTEGER) ) {
				alt18=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}

			switch (alt18) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:313:7: '\\*'
					{
					match(input,156,FOLLOW_156_in_selectCountClause1271); 
					 expr = Collections.<RawSelector>emptyList();
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:314:7: i= INTEGER
					{
					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_selectCountClause1293); 
					 if (!i.getText().equals("1")) addRecognitionError("Only COUNT(1) is supported, got COUNT(" + i.getText() + ")"); expr = Collections.<RawSelector>emptyList();
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "selectCountClause"



	// $ANTLR start "whereClause"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:317:1: whereClause returns [List<Relation> clause] : relation[$clause] ( K_AND relation[$clause] )* ;
	public final List<Relation> whereClause() throws RecognitionException {
		List<Relation> clause = null;


		 clause = new ArrayList<Relation>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:5: ( relation[$clause] ( K_AND relation[$clause] )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:7: relation[$clause] ( K_AND relation[$clause] )*
			{
			pushFollow(FOLLOW_relation_in_whereClause1329);
			relation(clause);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:25: ( K_AND relation[$clause] )*
			loop19:
			while (true) {
				int alt19=2;
				int LA19_0 = input.LA(1);
				if ( (LA19_0==K_AND) ) {
					alt19=1;
				}

				switch (alt19) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:319:26: K_AND relation[$clause]
					{
					match(input,K_AND,FOLLOW_K_AND_in_whereClause1333); 
					pushFollow(FOLLOW_relation_in_whereClause1335);
					relation(clause);
					state._fsp--;

					}
					break;

				default :
					break loop19;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return clause;
	}
	// $ANTLR end "whereClause"



	// $ANTLR start "orderByClause"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:322:1: orderByClause[Map<ColumnIdentifier.Raw, Boolean> orderings] : c= cident ( K_ASC | K_DESC )? ;
	public final void orderByClause(Map<ColumnIdentifier.Raw, Boolean> orderings) throws RecognitionException {
		ColumnIdentifier.Raw c =null;


		        ColumnIdentifier.Raw orderBy = null;
		        boolean reversed = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:5: (c= cident ( K_ASC | K_DESC )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:7: c= cident ( K_ASC | K_DESC )?
			{
			pushFollow(FOLLOW_cident_in_orderByClause1366);
			c=cident();
			state._fsp--;

			 orderBy = c; 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:33: ( K_ASC | K_DESC )?
			int alt20=3;
			int LA20_0 = input.LA(1);
			if ( (LA20_0==K_ASC) ) {
				alt20=1;
			}
			else if ( (LA20_0==K_DESC) ) {
				alt20=2;
			}
			switch (alt20) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:34: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_orderByClause1371); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:327:42: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_orderByClause1375); 
					 reversed = true; 
					}
					break;

			}

			 orderings.put(c, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "orderByClause"



	// $ANTLR start "insertStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:336:1: insertStatement returns [UpdateStatement.ParsedInsert expr] : K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? ;
	public final UpdateStatement.ParsedInsert insertStatement() throws RecognitionException {
		UpdateStatement.ParsedInsert expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw c1 =null;
		ColumnIdentifier.Raw cn =null;
		Term.Raw v1 =null;
		Term.Raw vn =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<ColumnIdentifier.Raw> columnNames  = new ArrayList<ColumnIdentifier.Raw>();
		        List<Term.Raw> values = new ArrayList<Term.Raw>();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:5: ( K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:343:7: K_INSERT K_INTO cf= columnFamilyName '(' c1= cident ( ',' cn= cident )* ')' K_VALUES '(' v1= term ( ',' vn= term )* ')' ( K_IF K_NOT K_EXISTS )? ( usingClause[attrs] )?
			{
			match(input,K_INSERT,FOLLOW_K_INSERT_in_insertStatement1413); 
			match(input,K_INTO,FOLLOW_K_INTO_in_insertStatement1415); 
			pushFollow(FOLLOW_columnFamilyName_in_insertStatement1419);
			cf=columnFamilyName();
			state._fsp--;

			match(input,142,FOLLOW_142_in_insertStatement1431); 
			pushFollow(FOLLOW_cident_in_insertStatement1435);
			c1=cident();
			state._fsp--;

			 columnNames.add(c1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:51: ( ',' cn= cident )*
			loop21:
			while (true) {
				int alt21=2;
				int LA21_0 = input.LA(1);
				if ( (LA21_0==145) ) {
					alt21=1;
				}

				switch (alt21) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:344:53: ',' cn= cident
					{
					match(input,145,FOLLOW_145_in_insertStatement1442); 
					pushFollow(FOLLOW_cident_in_insertStatement1446);
					cn=cident();
					state._fsp--;

					 columnNames.add(cn); 
					}
					break;

				default :
					break loop21;
				}
			}

			match(input,143,FOLLOW_143_in_insertStatement1453); 
			match(input,K_VALUES,FOLLOW_K_VALUES_in_insertStatement1463); 
			match(input,142,FOLLOW_142_in_insertStatement1475); 
			pushFollow(FOLLOW_term_in_insertStatement1479);
			v1=term();
			state._fsp--;

			 values.add(v1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:43: ( ',' vn= term )*
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( (LA22_0==145) ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:346:45: ',' vn= term
					{
					match(input,145,FOLLOW_145_in_insertStatement1485); 
					pushFollow(FOLLOW_term_in_insertStatement1489);
					vn=term();
					state._fsp--;

					 values.add(vn); 
					}
					break;

				default :
					break loop22;
				}
			}

			match(input,143,FOLLOW_143_in_insertStatement1496); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:9: ( K_IF K_NOT K_EXISTS )?
			int alt23=2;
			int LA23_0 = input.LA(1);
			if ( (LA23_0==K_IF) ) {
				alt23=1;
			}
			switch (alt23) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:348:11: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_insertStatement1509); 
					match(input,K_NOT,FOLLOW_K_NOT_in_insertStatement1511); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_insertStatement1513); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:9: ( usingClause[attrs] )?
			int alt24=2;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==K_USING) ) {
				alt24=1;
			}
			switch (alt24) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:349:11: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_insertStatement1530);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}


			          expr = new UpdateStatement.ParsedInsert(cf,
			                                                   attrs,
			                                                   columnNames,
			                                                   values,
			                                                   ifNotExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "insertStatement"



	// $ANTLR start "usingClause"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:359:1: usingClause[Attributes.Raw attrs] : K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* ;
	public final void usingClause(Attributes.Raw attrs) throws RecognitionException {
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:5: ( K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:7: K_USING usingClauseObjective[attrs] ( K_AND usingClauseObjective[attrs] )*
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClause1560); 
			pushFollow(FOLLOW_usingClauseObjective_in_usingClause1562);
			usingClauseObjective(attrs);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:43: ( K_AND usingClauseObjective[attrs] )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==K_AND) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:360:45: K_AND usingClauseObjective[attrs]
					{
					match(input,K_AND,FOLLOW_K_AND_in_usingClause1567); 
					pushFollow(FOLLOW_usingClauseObjective_in_usingClause1569);
					usingClauseObjective(attrs);
					state._fsp--;

					}
					break;

				default :
					break loop25;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClause"



	// $ANTLR start "usingClauseObjective"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:363:1: usingClauseObjective[Attributes.Raw attrs] : ( K_TIMESTAMP ts= intValue | K_TTL t= intValue );
	public final void usingClauseObjective(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:364:5: ( K_TIMESTAMP ts= intValue | K_TTL t= intValue )
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==K_TIMESTAMP) ) {
				alt26=1;
			}
			else if ( (LA26_0==K_TTL) ) {
				alt26=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 26, 0, input);
				throw nvae;
			}

			switch (alt26) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:364:7: K_TIMESTAMP ts= intValue
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective1595);
					ts=intValue();
					state._fsp--;

					 attrs.timestamp = ts; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:365:7: K_TTL t= intValue
					{
					match(input,K_TTL,FOLLOW_K_TTL_in_usingClauseObjective1605); 
					pushFollow(FOLLOW_intValue_in_usingClauseObjective1609);
					t=intValue();
					state._fsp--;

					 attrs.timeToLive = t; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseObjective"



	// $ANTLR start "updateStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:375:1: updateStatement returns [UpdateStatement.ParsedUpdate expr] : K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final UpdateStatement.ParsedUpdate updateStatement() throws RecognitionException {
		UpdateStatement.ParsedUpdate expr = null;


		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations = new ArrayList<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>>();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:5: ( K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:381:7: K_UPDATE cf= columnFamilyName ( usingClause[attrs] )? K_SET columnOperation[operations] ( ',' columnOperation[operations] )* K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_UPDATE,FOLLOW_K_UPDATE_in_updateStatement1643); 
			pushFollow(FOLLOW_columnFamilyName_in_updateStatement1647);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:7: ( usingClause[attrs] )?
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==K_USING) ) {
				alt27=1;
			}
			switch (alt27) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:382:9: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_updateStatement1657);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_SET,FOLLOW_K_SET_in_updateStatement1669); 
			pushFollow(FOLLOW_columnOperation_in_updateStatement1671);
			columnOperation(operations);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:41: ( ',' columnOperation[operations] )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==145) ) {
					alt28=1;
				}

				switch (alt28) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:383:42: ',' columnOperation[operations]
					{
					match(input,145,FOLLOW_145_in_updateStatement1675); 
					pushFollow(FOLLOW_columnOperation_in_updateStatement1677);
					columnOperation(operations);
					state._fsp--;

					}
					break;

				default :
					break loop28;
				}
			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_updateStatement1688); 
			pushFollow(FOLLOW_whereClause_in_updateStatement1692);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==K_IF) ) {
				alt30=1;
			}
			switch (alt30) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_updateStatement1702); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:14: ( K_EXISTS |conditions= updateConditions )
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==K_EXISTS) ) {
						int LA29_1 = input.LA(2);
						if ( (LA29_1==EOF||LA29_1==K_APPLY||LA29_1==K_DELETE||LA29_1==K_INSERT||LA29_1==K_UPDATE||LA29_1==149) ) {
							alt29=1;
						}
						else if ( (LA29_1==K_IN||LA29_1==141||(LA29_1 >= 150 && LA29_1 <= 155)) ) {
							alt29=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 29, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA29_0==IDENT||LA29_0==K_ALL||LA29_0==K_AS||LA29_0==K_ASCII||(LA29_0 >= K_BIGINT && LA29_0 <= K_BOOLEAN)||LA29_0==K_CLUSTERING||(LA29_0 >= K_COMPACT && LA29_0 <= K_COUNTER)||(LA29_0 >= K_CUSTOM && LA29_0 <= K_DECIMAL)||(LA29_0 >= K_DISTINCT && LA29_0 <= K_DOUBLE)||(LA29_0 >= K_FILTERING && LA29_0 <= K_FLOAT)||LA29_0==K_FROZEN||LA29_0==K_INET||LA29_0==K_INT||(LA29_0 >= K_KEY && LA29_0 <= K_KEYS)||LA29_0==K_KEYSPACES||(LA29_0 >= K_LIST && LA29_0 <= K_MAP)||LA29_0==K_NOSUPERUSER||(LA29_0 >= K_PASSWORD && LA29_0 <= K_PERMISSIONS)||(LA29_0 >= K_STATIC && LA29_0 <= K_TIMEUUID)||LA29_0==K_TRIGGER||(LA29_0 >= K_TTL && LA29_0 <= K_TYPE)||(LA29_0 >= K_USER && LA29_0 <= K_USERS)||(LA29_0 >= K_UUID && LA29_0 <= K_VARINT)||LA29_0==K_WRITETIME||LA29_0==QUOTED_NAME) ) {
						alt29=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 29, 0, input);
						throw nvae;
					}

					switch (alt29) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_updateStatement1706); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:385:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_updateStatement1714);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new UpdateStatement.ParsedUpdate(cf,
			                                                  attrs,
			                                                  operations,
			                                                  wclause,
			                                                  conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                                  ifExists);
			     
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "updateStatement"



	// $ANTLR start "updateConditions"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:396:1: updateConditions returns [List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : columnCondition[conditions] ( K_AND columnCondition[conditions] )* ;
	public final List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> updateConditions() throws RecognitionException {
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions = null;


		 conditions = new ArrayList<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:5: ( columnCondition[conditions] ( K_AND columnCondition[conditions] )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:7: columnCondition[conditions] ( K_AND columnCondition[conditions] )*
			{
			pushFollow(FOLLOW_columnCondition_in_updateConditions1756);
			columnCondition(conditions);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:35: ( K_AND columnCondition[conditions] )*
			loop31:
			while (true) {
				int alt31=2;
				int LA31_0 = input.LA(1);
				if ( (LA31_0==K_AND) ) {
					alt31=1;
				}

				switch (alt31) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:398:37: K_AND columnCondition[conditions]
					{
					match(input,K_AND,FOLLOW_K_AND_in_updateConditions1761); 
					pushFollow(FOLLOW_columnCondition_in_updateConditions1763);
					columnCondition(conditions);
					state._fsp--;

					}
					break;

				default :
					break loop31;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return conditions;
	}
	// $ANTLR end "updateConditions"



	// $ANTLR start "deleteStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:409:1: deleteStatement returns [DeleteStatement.Parsed expr] : K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? ;
	public final DeleteStatement.Parsed deleteStatement() throws RecognitionException {
		DeleteStatement.Parsed expr = null;


		List<Operation.RawDeletion> dels =null;
		CFName cf =null;
		List<Relation> wclause =null;
		List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions =null;


		        Attributes.Raw attrs = new Attributes.Raw();
		        List<Operation.RawDeletion> columnDeletions = Collections.emptyList();
		        boolean ifExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:5: ( K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:7: K_DELETE (dels= deleteSelection )? K_FROM cf= columnFamilyName ( usingClauseDelete[attrs] )? K_WHERE wclause= whereClause ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			{
			match(input,K_DELETE,FOLLOW_K_DELETE_in_deleteStatement1800); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:16: (dels= deleteSelection )?
			int alt32=2;
			int LA32_0 = input.LA(1);
			if ( (LA32_0==IDENT||LA32_0==K_ALL||LA32_0==K_AS||LA32_0==K_ASCII||(LA32_0 >= K_BIGINT && LA32_0 <= K_BOOLEAN)||LA32_0==K_CLUSTERING||(LA32_0 >= K_COMPACT && LA32_0 <= K_COUNTER)||(LA32_0 >= K_CUSTOM && LA32_0 <= K_DECIMAL)||(LA32_0 >= K_DISTINCT && LA32_0 <= K_DOUBLE)||(LA32_0 >= K_EXISTS && LA32_0 <= K_FLOAT)||LA32_0==K_FROZEN||LA32_0==K_INET||LA32_0==K_INT||(LA32_0 >= K_KEY && LA32_0 <= K_KEYS)||LA32_0==K_KEYSPACES||(LA32_0 >= K_LIST && LA32_0 <= K_MAP)||LA32_0==K_NOSUPERUSER||(LA32_0 >= K_PASSWORD && LA32_0 <= K_PERMISSIONS)||(LA32_0 >= K_STATIC && LA32_0 <= K_TIMEUUID)||LA32_0==K_TRIGGER||(LA32_0 >= K_TTL && LA32_0 <= K_TYPE)||(LA32_0 >= K_USER && LA32_0 <= K_USERS)||(LA32_0 >= K_UUID && LA32_0 <= K_VARINT)||LA32_0==K_WRITETIME||LA32_0==QUOTED_NAME) ) {
				alt32=1;
			}
			switch (alt32) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:415:18: dels= deleteSelection
					{
					pushFollow(FOLLOW_deleteSelection_in_deleteStatement1806);
					dels=deleteSelection();
					state._fsp--;

					 columnDeletions = dels; 
					}
					break;

			}

			match(input,K_FROM,FOLLOW_K_FROM_in_deleteStatement1819); 
			pushFollow(FOLLOW_columnFamilyName_in_deleteStatement1823);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:417:7: ( usingClauseDelete[attrs] )?
			int alt33=2;
			int LA33_0 = input.LA(1);
			if ( (LA33_0==K_USING) ) {
				alt33=1;
			}
			switch (alt33) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:417:9: usingClauseDelete[attrs]
					{
					pushFollow(FOLLOW_usingClauseDelete_in_deleteStatement1833);
					usingClauseDelete(attrs);
					state._fsp--;

					}
					break;

			}

			match(input,K_WHERE,FOLLOW_K_WHERE_in_deleteStatement1845); 
			pushFollow(FOLLOW_whereClause_in_deleteStatement1849);
			wclause=whereClause();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:7: ( K_IF ( K_EXISTS |conditions= updateConditions ) )?
			int alt35=2;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==K_IF) ) {
				alt35=1;
			}
			switch (alt35) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:9: K_IF ( K_EXISTS |conditions= updateConditions )
					{
					match(input,K_IF,FOLLOW_K_IF_in_deleteStatement1859); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:14: ( K_EXISTS |conditions= updateConditions )
					int alt34=2;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==K_EXISTS) ) {
						int LA34_1 = input.LA(2);
						if ( (LA34_1==EOF||LA34_1==K_APPLY||LA34_1==K_DELETE||LA34_1==K_INSERT||LA34_1==K_UPDATE||LA34_1==149) ) {
							alt34=1;
						}
						else if ( (LA34_1==K_IN||LA34_1==141||(LA34_1 >= 150 && LA34_1 <= 155)) ) {
							alt34=2;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 34, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}
					else if ( (LA34_0==IDENT||LA34_0==K_ALL||LA34_0==K_AS||LA34_0==K_ASCII||(LA34_0 >= K_BIGINT && LA34_0 <= K_BOOLEAN)||LA34_0==K_CLUSTERING||(LA34_0 >= K_COMPACT && LA34_0 <= K_COUNTER)||(LA34_0 >= K_CUSTOM && LA34_0 <= K_DECIMAL)||(LA34_0 >= K_DISTINCT && LA34_0 <= K_DOUBLE)||(LA34_0 >= K_FILTERING && LA34_0 <= K_FLOAT)||LA34_0==K_FROZEN||LA34_0==K_INET||LA34_0==K_INT||(LA34_0 >= K_KEY && LA34_0 <= K_KEYS)||LA34_0==K_KEYSPACES||(LA34_0 >= K_LIST && LA34_0 <= K_MAP)||LA34_0==K_NOSUPERUSER||(LA34_0 >= K_PASSWORD && LA34_0 <= K_PERMISSIONS)||(LA34_0 >= K_STATIC && LA34_0 <= K_TIMEUUID)||LA34_0==K_TRIGGER||(LA34_0 >= K_TTL && LA34_0 <= K_TYPE)||(LA34_0 >= K_USER && LA34_0 <= K_USERS)||(LA34_0 >= K_UUID && LA34_0 <= K_VARINT)||LA34_0==K_WRITETIME||LA34_0==QUOTED_NAME) ) {
						alt34=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 34, 0, input);
						throw nvae;
					}

					switch (alt34) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:16: K_EXISTS
							{
							match(input,K_EXISTS,FOLLOW_K_EXISTS_in_deleteStatement1863); 
							 ifExists = true; 
							}
							break;
						case 2 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:419:48: conditions= updateConditions
							{
							pushFollow(FOLLOW_updateConditions_in_deleteStatement1871);
							conditions=updateConditions();
							state._fsp--;

							}
							break;

					}

					}
					break;

			}


			          return new DeleteStatement.Parsed(cf,
			                                            attrs,
			                                            columnDeletions,
			                                            wclause,
			                                            conditions == null ? Collections.<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>>emptyList() : conditions,
			                                            ifExists);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "deleteStatement"



	// $ANTLR start "deleteSelection"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:430:1: deleteSelection returns [List<Operation.RawDeletion> operations] :t1= deleteOp ( ',' tN= deleteOp )* ;
	public final List<Operation.RawDeletion> deleteSelection() throws RecognitionException {
		List<Operation.RawDeletion> operations = null;


		Operation.RawDeletion t1 =null;
		Operation.RawDeletion tN =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:5: (t1= deleteOp ( ',' tN= deleteOp )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:431:7: t1= deleteOp ( ',' tN= deleteOp )*
			{
			 operations = new ArrayList<Operation.RawDeletion>(); 
			pushFollow(FOLLOW_deleteOp_in_deleteSelection1918);
			t1=deleteOp();
			state._fsp--;

			 operations.add(t1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:11: ( ',' tN= deleteOp )*
			loop36:
			while (true) {
				int alt36=2;
				int LA36_0 = input.LA(1);
				if ( (LA36_0==145) ) {
					alt36=1;
				}

				switch (alt36) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:433:12: ',' tN= deleteOp
					{
					match(input,145,FOLLOW_145_in_deleteSelection1933); 
					pushFollow(FOLLOW_deleteOp_in_deleteSelection1937);
					tN=deleteOp();
					state._fsp--;

					 operations.add(tN); 
					}
					break;

				default :
					break loop36;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return operations;
	}
	// $ANTLR end "deleteSelection"



	// $ANTLR start "deleteOp"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:436:1: deleteOp returns [Operation.RawDeletion op] : (c= cident |c= cident '[' t= term ']' );
	public final Operation.RawDeletion deleteOp() throws RecognitionException {
		Operation.RawDeletion op = null;


		ColumnIdentifier.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:5: (c= cident |c= cident '[' t= term ']' )
			int alt37=2;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA37_1 = input.LA(2);
				if ( (LA37_1==K_FROM||LA37_1==145) ) {
					alt37=1;
				}
				else if ( (LA37_1==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case QUOTED_NAME:
				{
				int LA37_2 = input.LA(2);
				if ( (LA37_2==K_FROM||LA37_2==145) ) {
					alt37=1;
				}
				else if ( (LA37_2==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA37_3 = input.LA(2);
				if ( (LA37_3==K_FROM||LA37_3==145) ) {
					alt37=1;
				}
				else if ( (LA37_3==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA37_4 = input.LA(2);
				if ( (LA37_4==K_FROM||LA37_4==145) ) {
					alt37=1;
				}
				else if ( (LA37_4==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA37_5 = input.LA(2);
				if ( (LA37_5==K_FROM||LA37_5==145) ) {
					alt37=1;
				}
				else if ( (LA37_5==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA37_6 = input.LA(2);
				if ( (LA37_6==K_FROM||LA37_6==145) ) {
					alt37=1;
				}
				else if ( (LA37_6==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA37_7 = input.LA(2);
				if ( (LA37_7==K_FROM||LA37_7==145) ) {
					alt37=1;
				}
				else if ( (LA37_7==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA37_8 = input.LA(2);
				if ( (LA37_8==K_FROM||LA37_8==145) ) {
					alt37=1;
				}
				else if ( (LA37_8==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA37_9 = input.LA(2);
				if ( (LA37_9==K_FROM||LA37_9==145) ) {
					alt37=1;
				}
				else if ( (LA37_9==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA37_10 = input.LA(2);
				if ( (LA37_10==K_FROM||LA37_10==145) ) {
					alt37=1;
				}
				else if ( (LA37_10==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA37_11 = input.LA(2);
				if ( (LA37_11==K_FROM||LA37_11==145) ) {
					alt37=1;
				}
				else if ( (LA37_11==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA37_12 = input.LA(2);
				if ( (LA37_12==K_FROM||LA37_12==145) ) {
					alt37=1;
				}
				else if ( (LA37_12==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA37_13 = input.LA(2);
				if ( (LA37_13==K_FROM||LA37_13==145) ) {
					alt37=1;
				}
				else if ( (LA37_13==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA37_14 = input.LA(2);
				if ( (LA37_14==K_FROM||LA37_14==145) ) {
					alt37=1;
				}
				else if ( (LA37_14==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA37_15 = input.LA(2);
				if ( (LA37_15==K_FROM||LA37_15==145) ) {
					alt37=1;
				}
				else if ( (LA37_15==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA37_16 = input.LA(2);
				if ( (LA37_16==K_FROM||LA37_16==145) ) {
					alt37=1;
				}
				else if ( (LA37_16==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA37_17 = input.LA(2);
				if ( (LA37_17==K_FROM||LA37_17==145) ) {
					alt37=1;
				}
				else if ( (LA37_17==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA37_18 = input.LA(2);
				if ( (LA37_18==K_FROM||LA37_18==145) ) {
					alt37=1;
				}
				else if ( (LA37_18==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA37_19 = input.LA(2);
				if ( (LA37_19==K_FROM||LA37_19==145) ) {
					alt37=1;
				}
				else if ( (LA37_19==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				int LA37_20 = input.LA(2);
				if ( (LA37_20==K_FROM||LA37_20==145) ) {
					alt37=1;
				}
				else if ( (LA37_20==155) ) {
					alt37=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 37, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 37, 0, input);
				throw nvae;
			}
			switch (alt37) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:437:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_deleteOp1964);
					c=cident();
					state._fsp--;

					 op = new Operation.ColumnDeletion(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:438:7: c= cident '[' t= term ']'
					{
					pushFollow(FOLLOW_cident_in_deleteOp1991);
					c=cident();
					state._fsp--;

					match(input,155,FOLLOW_155_in_deleteOp1993); 
					pushFollow(FOLLOW_term_in_deleteOp1997);
					t=term();
					state._fsp--;

					match(input,157,FOLLOW_157_in_deleteOp1999); 
					 op = new Operation.ElementDeletion(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "deleteOp"



	// $ANTLR start "usingClauseDelete"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:441:1: usingClauseDelete[Attributes.Raw attrs] : K_USING K_TIMESTAMP ts= intValue ;
	public final void usingClauseDelete(Attributes.Raw attrs) throws RecognitionException {
		Term.Raw ts =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:442:5: ( K_USING K_TIMESTAMP ts= intValue )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:442:7: K_USING K_TIMESTAMP ts= intValue
			{
			match(input,K_USING,FOLLOW_K_USING_in_usingClauseDelete2019); 
			match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_usingClauseDelete2021); 
			pushFollow(FOLLOW_intValue_in_usingClauseDelete2025);
			ts=intValue();
			state._fsp--;

			 attrs.timestamp = ts; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "usingClauseDelete"



	// $ANTLR start "batchStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:469:1: batchStatement returns [BatchStatement.Parsed expr] : K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH ;
	public final BatchStatement.Parsed batchStatement() throws RecognitionException {
		BatchStatement.Parsed expr = null;


		ModificationStatement.Parsed s =null;


		        BatchStatement.Type type = BatchStatement.Type.LOGGED;
		        List<ModificationStatement.Parsed> statements = new ArrayList<ModificationStatement.Parsed>();
		        Attributes.Raw attrs = new Attributes.Raw();
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:5: ( K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:475:7: K_BEGIN ( K_UNLOGGED | K_COUNTER )? K_BATCH ( usingClause[attrs] )? (s= batchStatementObjective ( ';' )? )* K_APPLY K_BATCH
			{
			match(input,K_BEGIN,FOLLOW_K_BEGIN_in_batchStatement2059); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:7: ( K_UNLOGGED | K_COUNTER )?
			int alt38=3;
			int LA38_0 = input.LA(1);
			if ( (LA38_0==K_UNLOGGED) ) {
				alt38=1;
			}
			else if ( (LA38_0==K_COUNTER) ) {
				alt38=2;
			}
			switch (alt38) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:9: K_UNLOGGED
					{
					match(input,K_UNLOGGED,FOLLOW_K_UNLOGGED_in_batchStatement2069); 
					 type = BatchStatement.Type.UNLOGGED; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:476:63: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_batchStatement2075); 
					 type = BatchStatement.Type.COUNTER; 
					}
					break;

			}

			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2088); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:477:15: ( usingClause[attrs] )?
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==K_USING) ) {
				alt39=1;
			}
			switch (alt39) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:477:17: usingClause[attrs]
					{
					pushFollow(FOLLOW_usingClause_in_batchStatement2092);
					usingClause(attrs);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:11: (s= batchStatementObjective ( ';' )? )*
			loop41:
			while (true) {
				int alt41=2;
				int LA41_0 = input.LA(1);
				if ( (LA41_0==K_DELETE||LA41_0==K_INSERT||LA41_0==K_UPDATE) ) {
					alt41=1;
				}

				switch (alt41) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:13: s= batchStatementObjective ( ';' )?
					{
					pushFollow(FOLLOW_batchStatementObjective_in_batchStatement2112);
					s=batchStatementObjective();
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:39: ( ';' )?
					int alt40=2;
					int LA40_0 = input.LA(1);
					if ( (LA40_0==149) ) {
						alt40=1;
					}
					switch (alt40) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:478:39: ';'
							{
							match(input,149,FOLLOW_149_in_batchStatement2114); 
							}
							break;

					}

					 statements.add(s); 
					}
					break;

				default :
					break loop41;
				}
			}

			match(input,K_APPLY,FOLLOW_K_APPLY_in_batchStatement2128); 
			match(input,K_BATCH,FOLLOW_K_BATCH_in_batchStatement2130); 

			          return new BatchStatement.Parsed(type, attrs, statements);
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "batchStatement"



	// $ANTLR start "batchStatementObjective"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:485:1: batchStatementObjective returns [ModificationStatement.Parsed statement] : (i= insertStatement |u= updateStatement |d= deleteStatement );
	public final ModificationStatement.Parsed batchStatementObjective() throws RecognitionException {
		ModificationStatement.Parsed statement = null;


		UpdateStatement.ParsedInsert i =null;
		UpdateStatement.ParsedUpdate u =null;
		DeleteStatement.Parsed d =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:5: (i= insertStatement |u= updateStatement |d= deleteStatement )
			int alt42=3;
			switch ( input.LA(1) ) {
			case K_INSERT:
				{
				alt42=1;
				}
				break;
			case K_UPDATE:
				{
				alt42=2;
				}
				break;
			case K_DELETE:
				{
				alt42=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}
			switch (alt42) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:486:7: i= insertStatement
					{
					pushFollow(FOLLOW_insertStatement_in_batchStatementObjective2161);
					i=insertStatement();
					state._fsp--;

					 statement = i; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:487:7: u= updateStatement
					{
					pushFollow(FOLLOW_updateStatement_in_batchStatementObjective2174);
					u=updateStatement();
					state._fsp--;

					 statement = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:488:7: d= deleteStatement
					{
					pushFollow(FOLLOW_deleteStatement_in_batchStatementObjective2187);
					d=deleteStatement();
					state._fsp--;

					 statement = d; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return statement;
	}
	// $ANTLR end "batchStatementObjective"



	// $ANTLR start "createKeyspaceStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:494:1: createKeyspaceStatement returns [CreateKeyspaceStatement expr] : K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] ;
	public final CreateKeyspaceStatement createKeyspaceStatement() throws RecognitionException {
		CreateKeyspaceStatement expr = null;


		String ks =null;


		        KSPropDefs attrs = new KSPropDefs();
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:5: ( K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:7: K_CREATE K_KEYSPACE ( K_IF K_NOT K_EXISTS )? ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createKeyspaceStatement2222); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2224); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:27: ( K_IF K_NOT K_EXISTS )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==K_IF) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:499:28: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createKeyspaceStatement2227); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createKeyspaceStatement2229); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createKeyspaceStatement2231); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_createKeyspaceStatement2240);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_createKeyspaceStatement2248); 
			pushFollow(FOLLOW_properties_in_createKeyspaceStatement2250);
			properties(attrs);
			state._fsp--;

			 expr = new CreateKeyspaceStatement(ks, attrs, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createKeyspaceStatement"



	// $ANTLR start "createTableStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:510:1: createTableStatement returns [CreateTableStatement.RawStatement expr] : K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] ;
	public final CreateTableStatement.RawStatement createTableStatement() throws RecognitionException {
		CreateTableStatement.RawStatement expr = null;


		CFName cf =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:5: ( K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:7: K_CREATE K_COLUMNFAMILY ( K_IF K_NOT K_EXISTS )? cf= columnFamilyName cfamDefinition[expr]
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTableStatement2285); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_createTableStatement2287); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:31: ( K_IF K_NOT K_EXISTS )?
			int alt44=2;
			int LA44_0 = input.LA(1);
			if ( (LA44_0==K_IF) ) {
				alt44=1;
			}
			switch (alt44) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:512:32: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTableStatement2290); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTableStatement2292); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTableStatement2294); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_createTableStatement2309);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new CreateTableStatement.RawStatement(cf, ifNotExists); 
			pushFollow(FOLLOW_cfamDefinition_in_createTableStatement2319);
			cfamDefinition(expr);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTableStatement"



	// $ANTLR start "cfamDefinition"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:517:1: cfamDefinition[CreateTableStatement.RawStatement expr] : '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? ;
	public final void cfamDefinition(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:5: ( '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:7: '(' cfamColumns[expr] ( ',' ( cfamColumns[expr] )? )* ')' ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
			{
			match(input,142,FOLLOW_142_in_cfamDefinition2338); 
			pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2340);
			cfamColumns(expr);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:29: ( ',' ( cfamColumns[expr] )? )*
			loop46:
			while (true) {
				int alt46=2;
				int LA46_0 = input.LA(1);
				if ( (LA46_0==145) ) {
					alt46=1;
				}

				switch (alt46) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:31: ',' ( cfamColumns[expr] )?
					{
					match(input,145,FOLLOW_145_in_cfamDefinition2345); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:35: ( cfamColumns[expr] )?
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==IDENT||LA45_0==K_ALL||LA45_0==K_AS||LA45_0==K_ASCII||(LA45_0 >= K_BIGINT && LA45_0 <= K_BOOLEAN)||LA45_0==K_CLUSTERING||(LA45_0 >= K_COMPACT && LA45_0 <= K_COUNTER)||(LA45_0 >= K_CUSTOM && LA45_0 <= K_DECIMAL)||(LA45_0 >= K_DISTINCT && LA45_0 <= K_DOUBLE)||(LA45_0 >= K_EXISTS && LA45_0 <= K_FLOAT)||LA45_0==K_FROZEN||LA45_0==K_INET||LA45_0==K_INT||(LA45_0 >= K_KEY && LA45_0 <= K_KEYS)||LA45_0==K_KEYSPACES||(LA45_0 >= K_LIST && LA45_0 <= K_MAP)||LA45_0==K_NOSUPERUSER||(LA45_0 >= K_PASSWORD && LA45_0 <= K_PRIMARY)||(LA45_0 >= K_STATIC && LA45_0 <= K_TIMEUUID)||LA45_0==K_TRIGGER||(LA45_0 >= K_TTL && LA45_0 <= K_TYPE)||(LA45_0 >= K_USER && LA45_0 <= K_USERS)||(LA45_0 >= K_UUID && LA45_0 <= K_VARINT)||LA45_0==K_WRITETIME||LA45_0==QUOTED_NAME) ) {
						alt45=1;
					}
					switch (alt45) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:518:35: cfamColumns[expr]
							{
							pushFollow(FOLLOW_cfamColumns_in_cfamDefinition2347);
							cfamColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop46;
				}
			}

			match(input,143,FOLLOW_143_in_cfamDefinition2354); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:7: ( K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )* )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==K_WITH) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:9: K_WITH cfamProperty[expr] ( K_AND cfamProperty[expr] )*
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_cfamDefinition2364); 
					pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2366);
					cfamProperty(expr);
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:35: ( K_AND cfamProperty[expr] )*
					loop47:
					while (true) {
						int alt47=2;
						int LA47_0 = input.LA(1);
						if ( (LA47_0==K_AND) ) {
							alt47=1;
						}

						switch (alt47) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:519:37: K_AND cfamProperty[expr]
							{
							match(input,K_AND,FOLLOW_K_AND_in_cfamDefinition2371); 
							pushFollow(FOLLOW_cfamProperty_in_cfamDefinition2373);
							cfamProperty(expr);
							state._fsp--;

							}
							break;

						default :
							break loop47;
						}
					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamDefinition"



	// $ANTLR start "cfamColumns"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:522:1: cfamColumns[CreateTableStatement.RawStatement expr] : (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' );
	public final void cfamColumns(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier c =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:5: (k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )? | K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')' )
			int alt52=2;
			int LA52_0 = input.LA(1);
			if ( (LA52_0==IDENT||LA52_0==K_ALL||LA52_0==K_AS||LA52_0==K_ASCII||(LA52_0 >= K_BIGINT && LA52_0 <= K_BOOLEAN)||LA52_0==K_CLUSTERING||(LA52_0 >= K_COMPACT && LA52_0 <= K_COUNTER)||(LA52_0 >= K_CUSTOM && LA52_0 <= K_DECIMAL)||(LA52_0 >= K_DISTINCT && LA52_0 <= K_DOUBLE)||(LA52_0 >= K_EXISTS && LA52_0 <= K_FLOAT)||LA52_0==K_FROZEN||LA52_0==K_INET||LA52_0==K_INT||(LA52_0 >= K_KEY && LA52_0 <= K_KEYS)||LA52_0==K_KEYSPACES||(LA52_0 >= K_LIST && LA52_0 <= K_MAP)||LA52_0==K_NOSUPERUSER||(LA52_0 >= K_PASSWORD && LA52_0 <= K_PERMISSIONS)||(LA52_0 >= K_STATIC && LA52_0 <= K_TIMEUUID)||LA52_0==K_TRIGGER||(LA52_0 >= K_TTL && LA52_0 <= K_TYPE)||(LA52_0 >= K_USER && LA52_0 <= K_USERS)||(LA52_0 >= K_UUID && LA52_0 <= K_VARINT)||LA52_0==K_WRITETIME||LA52_0==QUOTED_NAME) ) {
				alt52=1;
			}
			else if ( (LA52_0==K_PRIMARY) ) {
				alt52=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 52, 0, input);
				throw nvae;
			}

			switch (alt52) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:7: k= ident v= comparatorType ( K_STATIC )? ( K_PRIMARY K_KEY )?
					{
					pushFollow(FOLLOW_ident_in_cfamColumns2399);
					k=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_cfamColumns2403);
					v=comparatorType();
					state._fsp--;

					 boolean isStatic=false; 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:60: ( K_STATIC )?
					int alt49=2;
					int LA49_0 = input.LA(1);
					if ( (LA49_0==K_STATIC) ) {
						alt49=1;
					}
					switch (alt49) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:523:61: K_STATIC
							{
							match(input,K_STATIC,FOLLOW_K_STATIC_in_cfamColumns2408); 
							isStatic = true;
							}
							break;

					}

					 expr.addDefinition(k, v, isStatic); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:524:9: ( K_PRIMARY K_KEY )?
					int alt50=2;
					int LA50_0 = input.LA(1);
					if ( (LA50_0==K_PRIMARY) ) {
						alt50=1;
					}
					switch (alt50) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:524:10: K_PRIMARY K_KEY
							{
							match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2425); 
							match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2427); 
							 expr.addKeyAliases(Collections.singletonList(k)); 
							}
							break;

					}

					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:7: K_PRIMARY K_KEY '(' pkDef[expr] ( ',' c= ident )* ')'
					{
					match(input,K_PRIMARY,FOLLOW_K_PRIMARY_in_cfamColumns2439); 
					match(input,K_KEY,FOLLOW_K_KEY_in_cfamColumns2441); 
					match(input,142,FOLLOW_142_in_cfamColumns2443); 
					pushFollow(FOLLOW_pkDef_in_cfamColumns2445);
					pkDef(expr);
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:39: ( ',' c= ident )*
					loop51:
					while (true) {
						int alt51=2;
						int LA51_0 = input.LA(1);
						if ( (LA51_0==145) ) {
							alt51=1;
						}

						switch (alt51) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:525:40: ',' c= ident
							{
							match(input,145,FOLLOW_145_in_cfamColumns2449); 
							pushFollow(FOLLOW_ident_in_cfamColumns2453);
							c=ident();
							state._fsp--;

							 expr.addColumnAlias(c); 
							}
							break;

						default :
							break loop51;
						}
					}

					match(input,143,FOLLOW_143_in_cfamColumns2460); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamColumns"



	// $ANTLR start "pkDef"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:528:1: pkDef[CreateTableStatement.RawStatement expr] : (k= ident | '(' k1= ident ( ',' kn= ident )* ')' );
	public final void pkDef(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		ColumnIdentifier k1 =null;
		ColumnIdentifier kn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:529:5: (k= ident | '(' k1= ident ( ',' kn= ident )* ')' )
			int alt54=2;
			int LA54_0 = input.LA(1);
			if ( (LA54_0==IDENT||LA54_0==K_ALL||LA54_0==K_AS||LA54_0==K_ASCII||(LA54_0 >= K_BIGINT && LA54_0 <= K_BOOLEAN)||LA54_0==K_CLUSTERING||(LA54_0 >= K_COMPACT && LA54_0 <= K_COUNTER)||(LA54_0 >= K_CUSTOM && LA54_0 <= K_DECIMAL)||(LA54_0 >= K_DISTINCT && LA54_0 <= K_DOUBLE)||(LA54_0 >= K_EXISTS && LA54_0 <= K_FLOAT)||LA54_0==K_FROZEN||LA54_0==K_INET||LA54_0==K_INT||(LA54_0 >= K_KEY && LA54_0 <= K_KEYS)||LA54_0==K_KEYSPACES||(LA54_0 >= K_LIST && LA54_0 <= K_MAP)||LA54_0==K_NOSUPERUSER||(LA54_0 >= K_PASSWORD && LA54_0 <= K_PERMISSIONS)||(LA54_0 >= K_STATIC && LA54_0 <= K_TIMEUUID)||LA54_0==K_TRIGGER||(LA54_0 >= K_TTL && LA54_0 <= K_TYPE)||(LA54_0 >= K_USER && LA54_0 <= K_USERS)||(LA54_0 >= K_UUID && LA54_0 <= K_VARINT)||LA54_0==K_WRITETIME||LA54_0==QUOTED_NAME) ) {
				alt54=1;
			}
			else if ( (LA54_0==142) ) {
				alt54=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}

			switch (alt54) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:529:7: k= ident
					{
					pushFollow(FOLLOW_ident_in_pkDef2480);
					k=ident();
					state._fsp--;

					 expr.addKeyAliases(Collections.singletonList(k)); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:7: '(' k1= ident ( ',' kn= ident )* ')'
					{
					match(input,142,FOLLOW_142_in_pkDef2490); 
					 List<ColumnIdentifier> l = new ArrayList<ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_pkDef2496);
					k1=ident();
					state._fsp--;

					 l.add(k1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:101: ( ',' kn= ident )*
					loop53:
					while (true) {
						int alt53=2;
						int LA53_0 = input.LA(1);
						if ( (LA53_0==145) ) {
							alt53=1;
						}

						switch (alt53) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:530:103: ',' kn= ident
							{
							match(input,145,FOLLOW_145_in_pkDef2502); 
							pushFollow(FOLLOW_ident_in_pkDef2506);
							kn=ident();
							state._fsp--;

							 l.add(kn); 
							}
							break;

						default :
							break loop53;
						}
					}

					match(input,143,FOLLOW_143_in_pkDef2513); 
					 expr.addKeyAliases(l); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "pkDef"



	// $ANTLR start "cfamProperty"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:533:1: cfamProperty[CreateTableStatement.RawStatement expr] : ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' );
	public final void cfamProperty(CreateTableStatement.RawStatement expr) throws RecognitionException {
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:534:5: ( property[expr.properties] | K_COMPACT K_STORAGE | K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')' )
			int alt56=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt56=1;
				}
				break;
			case K_COMPACT:
				{
				int LA56_2 = input.LA(2);
				if ( (LA56_2==K_STORAGE) ) {
					alt56=2;
				}
				else if ( (LA56_2==152) ) {
					alt56=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 56, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_CLUSTERING:
				{
				int LA56_3 = input.LA(2);
				if ( (LA56_3==K_ORDER) ) {
					alt56=3;
				}
				else if ( (LA56_3==152) ) {
					alt56=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 56, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 56, 0, input);
				throw nvae;
			}
			switch (alt56) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:534:7: property[expr.properties]
					{
					pushFollow(FOLLOW_property_in_cfamProperty2533);
					property(expr.properties);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:535:7: K_COMPACT K_STORAGE
					{
					match(input,K_COMPACT,FOLLOW_K_COMPACT_in_cfamProperty2542); 
					match(input,K_STORAGE,FOLLOW_K_STORAGE_in_cfamProperty2544); 
					 expr.setCompactStorage(); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:7: K_CLUSTERING K_ORDER K_BY '(' cfamOrdering[expr] ( ',' cfamOrdering[expr] )* ')'
					{
					match(input,K_CLUSTERING,FOLLOW_K_CLUSTERING_in_cfamProperty2554); 
					match(input,K_ORDER,FOLLOW_K_ORDER_in_cfamProperty2556); 
					match(input,K_BY,FOLLOW_K_BY_in_cfamProperty2558); 
					match(input,142,FOLLOW_142_in_cfamProperty2560); 
					pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2562);
					cfamOrdering(expr);
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:56: ( ',' cfamOrdering[expr] )*
					loop55:
					while (true) {
						int alt55=2;
						int LA55_0 = input.LA(1);
						if ( (LA55_0==145) ) {
							alt55=1;
						}

						switch (alt55) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:536:57: ',' cfamOrdering[expr]
							{
							match(input,145,FOLLOW_145_in_cfamProperty2566); 
							pushFollow(FOLLOW_cfamOrdering_in_cfamProperty2568);
							cfamOrdering(expr);
							state._fsp--;

							}
							break;

						default :
							break loop55;
						}
					}

					match(input,143,FOLLOW_143_in_cfamProperty2573); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamProperty"



	// $ANTLR start "cfamOrdering"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:539:1: cfamOrdering[CreateTableStatement.RawStatement expr] : k= ident ( K_ASC | K_DESC ) ;
	public final void cfamOrdering(CreateTableStatement.RawStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;

		 boolean reversed=false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:5: (k= ident ( K_ASC | K_DESC ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:7: k= ident ( K_ASC | K_DESC )
			{
			pushFollow(FOLLOW_ident_in_cfamOrdering2601);
			k=ident();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:15: ( K_ASC | K_DESC )
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==K_ASC) ) {
				alt57=1;
			}
			else if ( (LA57_0==K_DESC) ) {
				alt57=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 57, 0, input);
				throw nvae;
			}

			switch (alt57) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:16: K_ASC
					{
					match(input,K_ASC,FOLLOW_K_ASC_in_cfamOrdering2604); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:541:24: K_DESC
					{
					match(input,K_DESC,FOLLOW_K_DESC_in_cfamOrdering2608); 
					 reversed=true;
					}
					break;

			}

			 expr.setOrdering(k, reversed); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfamOrdering"



	// $ANTLR start "createTypeStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:552:1: createTypeStatement returns [CreateTypeStatement expr] : K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' ;
	public final CreateTypeStatement createTypeStatement() throws RecognitionException {
		CreateTypeStatement expr = null;


		UTName tn =null;

		 boolean ifNotExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:5: ( K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:7: K_CREATE K_TYPE ( K_IF K_NOT K_EXISTS )? tn= userTypeName '(' typeColumns[expr] ( ',' ( typeColumns[expr] )? )* ')'
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTypeStatement2647); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_createTypeStatement2649); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:23: ( K_IF K_NOT K_EXISTS )?
			int alt58=2;
			int LA58_0 = input.LA(1);
			if ( (LA58_0==K_IF) ) {
				alt58=1;
			}
			switch (alt58) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:554:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTypeStatement2652); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTypeStatement2654); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTypeStatement2656); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_createTypeStatement2674);
			tn=userTypeName();
			state._fsp--;

			 expr = new CreateTypeStatement(tn, ifNotExists); 
			match(input,142,FOLLOW_142_in_createTypeStatement2687); 
			pushFollow(FOLLOW_typeColumns_in_createTypeStatement2689);
			typeColumns(expr);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:32: ( ',' ( typeColumns[expr] )? )*
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==145) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:34: ',' ( typeColumns[expr] )?
					{
					match(input,145,FOLLOW_145_in_createTypeStatement2694); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:38: ( typeColumns[expr] )?
					int alt59=2;
					int LA59_0 = input.LA(1);
					if ( (LA59_0==IDENT||LA59_0==K_ALL||LA59_0==K_AS||LA59_0==K_ASCII||(LA59_0 >= K_BIGINT && LA59_0 <= K_BOOLEAN)||LA59_0==K_CLUSTERING||(LA59_0 >= K_COMPACT && LA59_0 <= K_COUNTER)||(LA59_0 >= K_CUSTOM && LA59_0 <= K_DECIMAL)||(LA59_0 >= K_DISTINCT && LA59_0 <= K_DOUBLE)||(LA59_0 >= K_EXISTS && LA59_0 <= K_FLOAT)||LA59_0==K_FROZEN||LA59_0==K_INET||LA59_0==K_INT||(LA59_0 >= K_KEY && LA59_0 <= K_KEYS)||LA59_0==K_KEYSPACES||(LA59_0 >= K_LIST && LA59_0 <= K_MAP)||LA59_0==K_NOSUPERUSER||(LA59_0 >= K_PASSWORD && LA59_0 <= K_PERMISSIONS)||(LA59_0 >= K_STATIC && LA59_0 <= K_TIMEUUID)||LA59_0==K_TRIGGER||(LA59_0 >= K_TTL && LA59_0 <= K_TYPE)||(LA59_0 >= K_USER && LA59_0 <= K_USERS)||(LA59_0 >= K_UUID && LA59_0 <= K_VARINT)||LA59_0==K_WRITETIME||LA59_0==QUOTED_NAME) ) {
						alt59=1;
					}
					switch (alt59) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:556:38: typeColumns[expr]
							{
							pushFollow(FOLLOW_typeColumns_in_createTypeStatement2696);
							typeColumns(expr);
							state._fsp--;

							}
							break;

					}

					}
					break;

				default :
					break loop60;
				}
			}

			match(input,143,FOLLOW_143_in_createTypeStatement2703); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTypeStatement"



	// $ANTLR start "typeColumns"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:559:1: typeColumns[CreateTypeStatement expr] : k= ident v= comparatorType ;
	public final void typeColumns(CreateTypeStatement expr) throws RecognitionException {
		ColumnIdentifier k =null;
		CQL3Type.Raw v =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:5: (k= ident v= comparatorType )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:560:7: k= ident v= comparatorType
			{
			pushFollow(FOLLOW_ident_in_typeColumns2723);
			k=ident();
			state._fsp--;

			pushFollow(FOLLOW_comparatorType_in_typeColumns2727);
			v=comparatorType();
			state._fsp--;

			 expr.addDefinition(k, v); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "typeColumns"



	// $ANTLR start "createIndexStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:568:1: createIndexStatement returns [CreateIndexStatement expr] : K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? ;
	public final CreateIndexStatement createIndexStatement() throws RecognitionException {
		CreateIndexStatement expr = null;


		Token cls=null;
		CFName cf =null;
		IndexTarget.Raw id =null;


		        IndexPropDefs props = new IndexPropDefs();
		        boolean ifNotExists = false;
		        IndexName name = new IndexName();
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:5: ( K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:7: K_CREATE ( K_CUSTOM )? K_INDEX ( K_IF K_NOT K_EXISTS )? ( idxName[name] )? K_ON cf= columnFamilyName '(' id= indexIdent ')' ( K_USING cls= STRING_LITERAL )? ( K_WITH properties[props] )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createIndexStatement2762); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:16: ( K_CUSTOM )?
			int alt61=2;
			int LA61_0 = input.LA(1);
			if ( (LA61_0==K_CUSTOM) ) {
				alt61=1;
			}
			switch (alt61) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:17: K_CUSTOM
					{
					match(input,K_CUSTOM,FOLLOW_K_CUSTOM_in_createIndexStatement2765); 
					 props.isCustom = true; 
					}
					break;

			}

			match(input,K_INDEX,FOLLOW_K_INDEX_in_createIndexStatement2771); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:63: ( K_IF K_NOT K_EXISTS )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==K_IF) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:574:64: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createIndexStatement2774); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createIndexStatement2776); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createIndexStatement2778); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:9: ( idxName[name] )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==IDENT||LA63_0==K_ALL||LA63_0==K_AS||LA63_0==K_ASCII||(LA63_0 >= K_BIGINT && LA63_0 <= K_BOOLEAN)||LA63_0==K_CLUSTERING||(LA63_0 >= K_COMPACT && LA63_0 <= K_COUNTER)||(LA63_0 >= K_CUSTOM && LA63_0 <= K_DECIMAL)||(LA63_0 >= K_DISTINCT && LA63_0 <= K_DOUBLE)||(LA63_0 >= K_EXISTS && LA63_0 <= K_FLOAT)||LA63_0==K_FROZEN||LA63_0==K_INET||LA63_0==K_INT||(LA63_0 >= K_KEY && LA63_0 <= K_KEYS)||LA63_0==K_KEYSPACES||(LA63_0 >= K_LIST && LA63_0 <= K_MAP)||LA63_0==K_NOSUPERUSER||(LA63_0 >= K_PASSWORD && LA63_0 <= K_PERMISSIONS)||(LA63_0 >= K_STATIC && LA63_0 <= K_TIMEUUID)||LA63_0==K_TRIGGER||(LA63_0 >= K_TTL && LA63_0 <= K_TYPE)||(LA63_0 >= K_USER && LA63_0 <= K_USERS)||(LA63_0 >= K_UUID && LA63_0 <= K_VARINT)||LA63_0==K_WRITETIME||(LA63_0 >= QMARK && LA63_0 <= QUOTED_NAME)) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:575:10: idxName[name]
					{
					pushFollow(FOLLOW_idxName_in_createIndexStatement2794);
					idxName(name);
					state._fsp--;

					}
					break;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createIndexStatement2799); 
			pushFollow(FOLLOW_columnFamilyName_in_createIndexStatement2803);
			cf=columnFamilyName();
			state._fsp--;

			match(input,142,FOLLOW_142_in_createIndexStatement2805); 
			pushFollow(FOLLOW_indexIdent_in_createIndexStatement2809);
			id=indexIdent();
			state._fsp--;

			match(input,143,FOLLOW_143_in_createIndexStatement2811); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:9: ( K_USING cls= STRING_LITERAL )?
			int alt64=2;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==K_USING) ) {
				alt64=1;
			}
			switch (alt64) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:576:10: K_USING cls= STRING_LITERAL
					{
					match(input,K_USING,FOLLOW_K_USING_in_createIndexStatement2822); 
					cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createIndexStatement2826); 
					 props.customClass = (cls!=null?cls.getText():null); 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:577:9: ( K_WITH properties[props] )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==K_WITH) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:577:10: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createIndexStatement2841); 
					pushFollow(FOLLOW_properties_in_createIndexStatement2843);
					properties(props);
					state._fsp--;

					}
					break;

			}

			 expr = new CreateIndexStatement(cf, name, id, props, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createIndexStatement"



	// $ANTLR start "indexIdent"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:581:1: indexIdent returns [IndexTarget.Raw id] : (c= cident | K_KEYS '(' c= cident ')' | K_FULL '(' c= cident ')' );
	public final IndexTarget.Raw indexIdent() throws RecognitionException {
		IndexTarget.Raw id = null;


		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:5: (c= cident | K_KEYS '(' c= cident ')' | K_FULL '(' c= cident ')' )
			int alt66=3;
			switch ( input.LA(1) ) {
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt66=1;
				}
				break;
			case K_KEYS:
				{
				int LA66_2 = input.LA(2);
				if ( (LA66_2==142) ) {
					alt66=2;
				}
				else if ( (LA66_2==143) ) {
					alt66=1;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 66, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FULL:
				{
				alt66=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 66, 0, input);
				throw nvae;
			}
			switch (alt66) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:582:7: c= cident
					{
					pushFollow(FOLLOW_cident_in_indexIdent2877);
					c=cident();
					state._fsp--;

					 id = IndexTarget.Raw.valuesOf(c); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:583:7: K_KEYS '(' c= cident ')'
					{
					match(input,K_KEYS,FOLLOW_K_KEYS_in_indexIdent2902); 
					match(input,142,FOLLOW_142_in_indexIdent2904); 
					pushFollow(FOLLOW_cident_in_indexIdent2908);
					c=cident();
					state._fsp--;

					match(input,143,FOLLOW_143_in_indexIdent2910); 
					 id = IndexTarget.Raw.keysOf(c); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:584:7: K_FULL '(' c= cident ')'
					{
					match(input,K_FULL,FOLLOW_K_FULL_in_indexIdent2920); 
					match(input,142,FOLLOW_142_in_indexIdent2922); 
					pushFollow(FOLLOW_cident_in_indexIdent2926);
					c=cident();
					state._fsp--;

					match(input,143,FOLLOW_143_in_indexIdent2928); 
					 id = IndexTarget.Raw.fullCollection(c); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "indexIdent"



	// $ANTLR start "createTriggerStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:591:1: createTriggerStatement returns [CreateTriggerStatement expr] : K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL ;
	public final CreateTriggerStatement createTriggerStatement() throws RecognitionException {
		CreateTriggerStatement expr = null;


		Token cls=null;
		ColumnIdentifier.Raw name =null;
		CFName cf =null;


		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:5: ( K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:7: K_CREATE K_TRIGGER ( K_IF K_NOT K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName K_USING cls= STRING_LITERAL
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createTriggerStatement2963); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_createTriggerStatement2965); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:26: ( K_IF K_NOT K_EXISTS )?
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==K_IF) ) {
				alt67=1;
			}
			switch (alt67) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:27: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createTriggerStatement2968); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createTriggerStatement2970); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createTriggerStatement2972); 
					 ifNotExists = true; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:74: (name= cident )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:595:75: name= cident
			{
			pushFollow(FOLLOW_cident_in_createTriggerStatement2982);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_createTriggerStatement2993); 
			pushFollow(FOLLOW_columnFamilyName_in_createTriggerStatement2997);
			cf=columnFamilyName();
			state._fsp--;

			match(input,K_USING,FOLLOW_K_USING_in_createTriggerStatement2999); 
			cls=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_createTriggerStatement3003); 
			 expr = new CreateTriggerStatement(cf, name.toString(), (cls!=null?cls.getText():null), ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "createTriggerStatement"



	// $ANTLR start "dropTriggerStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:603:1: dropTriggerStatement returns [DropTriggerStatement expr] : K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName ;
	public final DropTriggerStatement dropTriggerStatement() throws RecognitionException {
		DropTriggerStatement expr = null;


		ColumnIdentifier.Raw name =null;
		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:5: ( K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:7: K_DROP K_TRIGGER ( K_IF K_EXISTS )? (name= cident ) K_ON cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTriggerStatement3044); 
			match(input,K_TRIGGER,FOLLOW_K_TRIGGER_in_dropTriggerStatement3046); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:24: ( K_IF K_EXISTS )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==K_IF) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:25: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTriggerStatement3049); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTriggerStatement3051); 
					 ifExists = true; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:63: (name= cident )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:605:64: name= cident
			{
			pushFollow(FOLLOW_cident_in_dropTriggerStatement3061);
			name=cident();
			state._fsp--;

			}

			match(input,K_ON,FOLLOW_K_ON_in_dropTriggerStatement3064); 
			pushFollow(FOLLOW_columnFamilyName_in_dropTriggerStatement3068);
			cf=columnFamilyName();
			state._fsp--;

			 expr = new DropTriggerStatement(cf, name.toString(), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropTriggerStatement"



	// $ANTLR start "alterKeyspaceStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:612:1: alterKeyspaceStatement returns [AlterKeyspaceStatement expr] : K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] ;
	public final AlterKeyspaceStatement alterKeyspaceStatement() throws RecognitionException {
		AlterKeyspaceStatement expr = null;


		String ks =null;

		 KSPropDefs attrs = new KSPropDefs(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:5: ( K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:614:7: K_ALTER K_KEYSPACE ks= keyspaceName K_WITH properties[attrs]
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterKeyspaceStatement3108); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3110); 
			pushFollow(FOLLOW_keyspaceName_in_alterKeyspaceStatement3114);
			ks=keyspaceName();
			state._fsp--;

			match(input,K_WITH,FOLLOW_K_WITH_in_alterKeyspaceStatement3124); 
			pushFollow(FOLLOW_properties_in_alterKeyspaceStatement3126);
			properties(attrs);
			state._fsp--;

			 expr = new AlterKeyspaceStatement(ks, attrs); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterKeyspaceStatement"



	// $ANTLR start "alterTableStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:626:1: alterTableStatement returns [AlterTableStatement expr] : K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) ;
	public final AlterTableStatement alterTableStatement() throws RecognitionException {
		AlterTableStatement expr = null;


		CFName cf =null;
		ColumnIdentifier.Raw id =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier.Raw id1 =null;
		ColumnIdentifier.Raw toId1 =null;
		ColumnIdentifier.Raw idn =null;
		ColumnIdentifier.Raw toIdn =null;


		        AlterTableStatement.Type type = null;
		        CFPropDefs props = new CFPropDefs();
		        Map<ColumnIdentifier.Raw, ColumnIdentifier.Raw> renames = new HashMap<ColumnIdentifier.Raw, ColumnIdentifier.Raw>();
		        boolean isStatic = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:5: ( K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:633:7: K_ALTER K_COLUMNFAMILY cf= columnFamilyName ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3162); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3164); 
			pushFollow(FOLLOW_columnFamilyName_in_alterTableStatement3168);
			cf=columnFamilyName();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:634:11: ( K_ALTER id= cident K_TYPE v= comparatorType | K_ADD id= cident v= comparatorType ( K_STATIC )? | K_DROP id= cident | K_WITH properties[props] | K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )* )
			int alt71=5;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt71=1;
				}
				break;
			case K_ADD:
				{
				alt71=2;
				}
				break;
			case K_DROP:
				{
				alt71=3;
				}
				break;
			case K_WITH:
				{
				alt71=4;
				}
				break;
			case K_RENAME:
				{
				alt71=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 71, 0, input);
				throw nvae;
			}
			switch (alt71) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:634:13: K_ALTER id= cident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTableStatement3182); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3186);
					id=cident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTableStatement3188); 
					pushFollow(FOLLOW_comparatorType_in_alterTableStatement3192);
					v=comparatorType();
					state._fsp--;

					 type = AlterTableStatement.Type.ALTER; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:13: K_ADD id= cident v= comparatorType ( K_STATIC )?
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTableStatement3208); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3214);
					id=cident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTableStatement3218);
					v=comparatorType();
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:48: ( K_STATIC )?
					int alt69=2;
					int LA69_0 = input.LA(1);
					if ( (LA69_0==K_STATIC) ) {
						alt69=1;
					}
					switch (alt69) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:635:49: K_STATIC
							{
							 isStatic=true; 
							match(input,K_STATIC,FOLLOW_K_STATIC_in_alterTableStatement3223); 
							}
							break;

					}

					 type = AlterTableStatement.Type.ADD; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:636:13: K_DROP id= cident
					{
					match(input,K_DROP,FOLLOW_K_DROP_in_alterTableStatement3241); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3246);
					id=cident();
					state._fsp--;

					 type = AlterTableStatement.Type.DROP; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:637:13: K_WITH properties[props]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterTableStatement3286); 
					pushFollow(FOLLOW_properties_in_alterTableStatement3289);
					properties(props);
					state._fsp--;

					 type = AlterTableStatement.Type.OPTS; 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:638:13: K_RENAME id1= cident K_TO toId1= cident ( K_AND idn= cident K_TO toIdn= cident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTableStatement3322); 
					 type = AlterTableStatement.Type.RENAME; 
					pushFollow(FOLLOW_cident_in_alterTableStatement3376);
					id1=cident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3378); 
					pushFollow(FOLLOW_cident_in_alterTableStatement3382);
					toId1=cident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:16: ( K_AND idn= cident K_TO toIdn= cident )*
					loop70:
					while (true) {
						int alt70=2;
						int LA70_0 = input.LA(1);
						if ( (LA70_0==K_AND) ) {
							alt70=1;
						}

						switch (alt70) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:640:18: K_AND idn= cident K_TO toIdn= cident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTableStatement3403); 
							pushFollow(FOLLOW_cident_in_alterTableStatement3407);
							idn=cident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTableStatement3409); 
							pushFollow(FOLLOW_cident_in_alterTableStatement3413);
							toIdn=cident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop70;
						}
					}

					}
					break;

			}


			        expr = new AlterTableStatement(cf, type, id, v, props, renames, isStatic);
			    
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTableStatement"



	// $ANTLR start "alterTypeStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:652:1: alterTypeStatement returns [AlterTypeStatement expr] : K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) ;
	public final AlterTypeStatement alterTypeStatement() throws RecognitionException {
		AlterTypeStatement expr = null;


		UTName name =null;
		ColumnIdentifier f =null;
		CQL3Type.Raw v =null;
		ColumnIdentifier id1 =null;
		ColumnIdentifier toId1 =null;
		ColumnIdentifier idn =null;
		ColumnIdentifier toIdn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:653:5: ( K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:653:7: K_ALTER K_TYPE name= userTypeName ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3459); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3461); 
			pushFollow(FOLLOW_userTypeName_in_alterTypeStatement3465);
			name=userTypeName();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:654:11: ( K_ALTER f= ident K_TYPE v= comparatorType | K_ADD f= ident v= comparatorType | K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )* )
			int alt73=3;
			switch ( input.LA(1) ) {
			case K_ALTER:
				{
				alt73=1;
				}
				break;
			case K_ADD:
				{
				alt73=2;
				}
				break;
			case K_RENAME:
				{
				alt73=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 73, 0, input);
				throw nvae;
			}
			switch (alt73) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:654:13: K_ALTER f= ident K_TYPE v= comparatorType
					{
					match(input,K_ALTER,FOLLOW_K_ALTER_in_alterTypeStatement3479); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3483);
					f=ident();
					state._fsp--;

					match(input,K_TYPE,FOLLOW_K_TYPE_in_alterTypeStatement3485); 
					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3489);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.alter(name, f, v); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:655:13: K_ADD f= ident v= comparatorType
					{
					match(input,K_ADD,FOLLOW_K_ADD_in_alterTypeStatement3505); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3511);
					f=ident();
					state._fsp--;

					pushFollow(FOLLOW_comparatorType_in_alterTypeStatement3515);
					v=comparatorType();
					state._fsp--;

					 expr = AlterTypeStatement.addition(name, f, v); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:656:13: K_RENAME id1= ident K_TO toId1= ident ( K_AND idn= ident K_TO toIdn= ident )*
					{
					match(input,K_RENAME,FOLLOW_K_RENAME_in_alterTypeStatement3538); 
					 Map<ColumnIdentifier, ColumnIdentifier> renames = new HashMap<ColumnIdentifier, ColumnIdentifier>(); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3576);
					id1=ident();
					state._fsp--;

					match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3578); 
					pushFollow(FOLLOW_ident_in_alterTypeStatement3582);
					toId1=ident();
					state._fsp--;

					 renames.put(id1, toId1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:18: ( K_AND idn= ident K_TO toIdn= ident )*
					loop72:
					while (true) {
						int alt72=2;
						int LA72_0 = input.LA(1);
						if ( (LA72_0==K_AND) ) {
							alt72=1;
						}

						switch (alt72) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:659:20: K_AND idn= ident K_TO toIdn= ident
							{
							match(input,K_AND,FOLLOW_K_AND_in_alterTypeStatement3605); 
							pushFollow(FOLLOW_ident_in_alterTypeStatement3609);
							idn=ident();
							state._fsp--;

							match(input,K_TO,FOLLOW_K_TO_in_alterTypeStatement3611); 
							pushFollow(FOLLOW_ident_in_alterTypeStatement3615);
							toIdn=ident();
							state._fsp--;

							 renames.put(idn, toIdn); 
							}
							break;

						default :
							break loop72;
						}
					}

					 expr = AlterTypeStatement.renames(name, renames); 
					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "alterTypeStatement"



	// $ANTLR start "dropKeyspaceStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:668:1: dropKeyspaceStatement returns [DropKeyspaceStatement ksp] : K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName ;
	public final DropKeyspaceStatement dropKeyspaceStatement() throws RecognitionException {
		DropKeyspaceStatement ksp = null;


		String ks =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:5: ( K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:7: K_DROP K_KEYSPACE ( K_IF K_EXISTS )? ks= keyspaceName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropKeyspaceStatement3682); 
			match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3684); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:25: ( K_IF K_EXISTS )?
			int alt74=2;
			int LA74_0 = input.LA(1);
			if ( (LA74_0==K_IF) ) {
				alt74=1;
			}
			switch (alt74) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:670:26: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropKeyspaceStatement3687); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropKeyspaceStatement3689); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_keyspaceName_in_dropKeyspaceStatement3698);
			ks=keyspaceName();
			state._fsp--;

			 ksp = new DropKeyspaceStatement(ks, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ksp;
	}
	// $ANTLR end "dropKeyspaceStatement"



	// $ANTLR start "dropTableStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:676:1: dropTableStatement returns [DropTableStatement stmt] : K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName ;
	public final DropTableStatement dropTableStatement() throws RecognitionException {
		DropTableStatement stmt = null;


		CFName cf =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:678:5: ( K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:678:7: K_DROP K_COLUMNFAMILY ( K_IF K_EXISTS )? cf= columnFamilyName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTableStatement3732); 
			match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3734); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:678:29: ( K_IF K_EXISTS )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==K_IF) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:678:30: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTableStatement3737); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTableStatement3739); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_dropTableStatement3748);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new DropTableStatement(cf, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTableStatement"



	// $ANTLR start "dropTypeStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:684:1: dropTypeStatement returns [DropTypeStatement stmt] : K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName ;
	public final DropTypeStatement dropTypeStatement() throws RecognitionException {
		DropTypeStatement stmt = null;


		UTName name =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:5: ( K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:7: K_DROP K_TYPE ( K_IF K_EXISTS )? name= userTypeName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropTypeStatement3782); 
			match(input,K_TYPE,FOLLOW_K_TYPE_in_dropTypeStatement3784); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:21: ( K_IF K_EXISTS )?
			int alt76=2;
			int LA76_0 = input.LA(1);
			if ( (LA76_0==K_IF) ) {
				alt76=1;
			}
			switch (alt76) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:686:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropTypeStatement3787); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropTypeStatement3789); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_userTypeName_in_dropTypeStatement3798);
			name=userTypeName();
			state._fsp--;

			 stmt = new DropTypeStatement(name, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropTypeStatement"



	// $ANTLR start "dropIndexStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:692:1: dropIndexStatement returns [DropIndexStatement expr] : K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName ;
	public final DropIndexStatement dropIndexStatement() throws RecognitionException {
		DropIndexStatement expr = null;


		IndexName index =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:694:5: ( K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:694:7: K_DROP K_INDEX ( K_IF K_EXISTS )? index= indexName
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropIndexStatement3832); 
			match(input,K_INDEX,FOLLOW_K_INDEX_in_dropIndexStatement3834); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:694:22: ( K_IF K_EXISTS )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==K_IF) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:694:23: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropIndexStatement3837); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropIndexStatement3839); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_indexName_in_dropIndexStatement3848);
			index=indexName();
			state._fsp--;

			 expr = new DropIndexStatement(index, ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "dropIndexStatement"



	// $ANTLR start "truncateStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:701:1: truncateStatement returns [TruncateStatement stmt] : K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName ;
	public final TruncateStatement truncateStatement() throws RecognitionException {
		TruncateStatement stmt = null;


		CFName cf =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:5: ( K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:7: K_TRUNCATE ( K_COLUMNFAMILY )? cf= columnFamilyName
			{
			match(input,K_TRUNCATE,FOLLOW_K_TRUNCATE_in_truncateStatement3879); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:18: ( K_COLUMNFAMILY )?
			int alt78=2;
			int LA78_0 = input.LA(1);
			if ( (LA78_0==K_COLUMNFAMILY) ) {
				alt78=1;
			}
			switch (alt78) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:702:19: K_COLUMNFAMILY
					{
					match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_truncateStatement3882); 
					}
					break;

			}

			pushFollow(FOLLOW_columnFamilyName_in_truncateStatement3888);
			cf=columnFamilyName();
			state._fsp--;

			 stmt = new TruncateStatement(cf); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "truncateStatement"



	// $ANTLR start "grantStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:708:1: grantStatement returns [GrantStatement stmt] : K_GRANT permissionOrAll K_ON resource K_TO username ;
	public final GrantStatement grantStatement() throws RecognitionException {
		GrantStatement stmt = null;


		Set<Permission> permissionOrAll1 =null;
		IResource resource2 =null;
		ParserRuleReturnScope username3 =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:709:5: ( K_GRANT permissionOrAll K_ON resource K_TO username )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:709:7: K_GRANT permissionOrAll K_ON resource K_TO username
			{
			match(input,K_GRANT,FOLLOW_K_GRANT_in_grantStatement3913); 
			pushFollow(FOLLOW_permissionOrAll_in_grantStatement3925);
			permissionOrAll1=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_grantStatement3933); 
			pushFollow(FOLLOW_resource_in_grantStatement3945);
			resource2=resource();
			state._fsp--;

			match(input,K_TO,FOLLOW_K_TO_in_grantStatement3953); 
			pushFollow(FOLLOW_username_in_grantStatement3965);
			username3=username();
			state._fsp--;

			 stmt = new GrantStatement(permissionOrAll1, resource2, (username3!=null?input.toString(username3.start,username3.stop):null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "grantStatement"



	// $ANTLR start "revokeStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:721:1: revokeStatement returns [RevokeStatement stmt] : K_REVOKE permissionOrAll K_ON resource K_FROM username ;
	public final RevokeStatement revokeStatement() throws RecognitionException {
		RevokeStatement stmt = null;


		Set<Permission> permissionOrAll4 =null;
		IResource resource5 =null;
		ParserRuleReturnScope username6 =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:5: ( K_REVOKE permissionOrAll K_ON resource K_FROM username )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:722:7: K_REVOKE permissionOrAll K_ON resource K_FROM username
			{
			match(input,K_REVOKE,FOLLOW_K_REVOKE_in_revokeStatement3996); 
			pushFollow(FOLLOW_permissionOrAll_in_revokeStatement4008);
			permissionOrAll4=permissionOrAll();
			state._fsp--;

			match(input,K_ON,FOLLOW_K_ON_in_revokeStatement4016); 
			pushFollow(FOLLOW_resource_in_revokeStatement4028);
			resource5=resource();
			state._fsp--;

			match(input,K_FROM,FOLLOW_K_FROM_in_revokeStatement4036); 
			pushFollow(FOLLOW_username_in_revokeStatement4048);
			username6=username();
			state._fsp--;

			 stmt = new RevokeStatement(permissionOrAll4, resource5, (username6!=null?input.toString(username6.start,username6.stop):null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "revokeStatement"



	// $ANTLR start "listPermissionsStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:731:1: listPermissionsStatement returns [ListPermissionsStatement stmt] : K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? ;
	public final ListPermissionsStatement listPermissionsStatement() throws RecognitionException {
		ListPermissionsStatement stmt = null;


		IResource resource7 =null;
		ParserRuleReturnScope username8 =null;
		Set<Permission> permissionOrAll9 =null;


		        IResource resource = null;
		        String username = null;
		        boolean recursive = true;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:737:5: ( K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:737:7: K_LIST permissionOrAll ( K_ON resource )? ( K_OF username )? ( K_NORECURSIVE )?
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listPermissionsStatement4086); 
			pushFollow(FOLLOW_permissionOrAll_in_listPermissionsStatement4098);
			permissionOrAll9=permissionOrAll();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:739:7: ( K_ON resource )?
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==K_ON) ) {
				alt79=1;
			}
			switch (alt79) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:739:9: K_ON resource
					{
					match(input,K_ON,FOLLOW_K_ON_in_listPermissionsStatement4108); 
					pushFollow(FOLLOW_resource_in_listPermissionsStatement4110);
					resource7=resource();
					state._fsp--;

					 resource = resource7; 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:740:7: ( K_OF username )?
			int alt80=2;
			int LA80_0 = input.LA(1);
			if ( (LA80_0==K_OF) ) {
				alt80=1;
			}
			switch (alt80) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:740:9: K_OF username
					{
					match(input,K_OF,FOLLOW_K_OF_in_listPermissionsStatement4125); 
					pushFollow(FOLLOW_username_in_listPermissionsStatement4127);
					username8=username();
					state._fsp--;

					 username = (username8!=null?input.toString(username8.start,username8.stop):null); 
					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:7: ( K_NORECURSIVE )?
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==K_NORECURSIVE) ) {
				alt81=1;
			}
			switch (alt81) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:741:9: K_NORECURSIVE
					{
					match(input,K_NORECURSIVE,FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4142); 
					 recursive = false; 
					}
					break;

			}

			 stmt = new ListPermissionsStatement(permissionOrAll9, resource, username, recursive); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listPermissionsStatement"



	// $ANTLR start "permission"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:745:1: permission returns [Permission perm] : p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) ;
	public final Permission permission() throws RecognitionException {
		Permission perm = null;


		Token p=null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:5: (p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:746:7: p= ( K_CREATE | K_ALTER | K_DROP | K_SELECT | K_MODIFY | K_AUTHORIZE )
			{
			p=input.LT(1);
			if ( input.LA(1)==K_ALTER||input.LA(1)==K_AUTHORIZE||input.LA(1)==K_CREATE||input.LA(1)==K_DROP||input.LA(1)==K_MODIFY||input.LA(1)==K_SELECT ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 perm = Permission.valueOf((p!=null?p.getText():null).toUpperCase()); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perm;
	}
	// $ANTLR end "permission"



	// $ANTLR start "permissionOrAll"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:750:1: permissionOrAll returns [Set<Permission> perms] : ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? );
	public final Set<Permission> permissionOrAll() throws RecognitionException {
		Set<Permission> perms = null;


		Permission p =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:5: ( K_ALL ( K_PERMISSIONS )? |p= permission ( K_PERMISSION )? )
			int alt84=2;
			int LA84_0 = input.LA(1);
			if ( (LA84_0==K_ALL) ) {
				alt84=1;
			}
			else if ( (LA84_0==K_ALTER||LA84_0==K_AUTHORIZE||LA84_0==K_CREATE||LA84_0==K_DROP||LA84_0==K_MODIFY||LA84_0==K_SELECT) ) {
				alt84=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 84, 0, input);
				throw nvae;
			}

			switch (alt84) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:7: K_ALL ( K_PERMISSIONS )?
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_permissionOrAll4227); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:13: ( K_PERMISSIONS )?
					int alt82=2;
					int LA82_0 = input.LA(1);
					if ( (LA82_0==K_PERMISSIONS) ) {
						alt82=1;
					}
					switch (alt82) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:751:15: K_PERMISSIONS
							{
							match(input,K_PERMISSIONS,FOLLOW_K_PERMISSIONS_in_permissionOrAll4231); 
							}
							break;

					}

					 perms = Permission.ALL_DATA; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:7: p= permission ( K_PERMISSION )?
					{
					pushFollow(FOLLOW_permission_in_permissionOrAll4252);
					p=permission();
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:20: ( K_PERMISSION )?
					int alt83=2;
					int LA83_0 = input.LA(1);
					if ( (LA83_0==K_PERMISSION) ) {
						alt83=1;
					}
					switch (alt83) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:752:22: K_PERMISSION
							{
							match(input,K_PERMISSION,FOLLOW_K_PERMISSION_in_permissionOrAll4256); 
							}
							break;

					}

					 perms = EnumSet.of(p); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return perms;
	}
	// $ANTLR end "permissionOrAll"



	// $ANTLR start "resource"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:755:1: resource returns [IResource res] : r= dataResource ;
	public final IResource resource() throws RecognitionException {
		IResource res = null;


		DataResource r =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:756:5: (r= dataResource )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:756:7: r= dataResource
			{
			pushFollow(FOLLOW_dataResource_in_resource4284);
			r=dataResource();
			state._fsp--;

			 res = r; 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "resource"



	// $ANTLR start "dataResource"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:759:1: dataResource returns [DataResource res] : ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName );
	public final DataResource dataResource() throws RecognitionException {
		DataResource res = null;


		String ks =null;
		CFName cf =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:760:5: ( K_ALL K_KEYSPACES | K_KEYSPACE ks= keyspaceName | ( K_COLUMNFAMILY )? cf= columnFamilyName )
			int alt86=3;
			switch ( input.LA(1) ) {
			case K_ALL:
				{
				int LA86_1 = input.LA(2);
				if ( (LA86_1==K_KEYSPACES) ) {
					alt86=1;
				}
				else if ( (LA86_1==EOF||LA86_1==K_FROM||LA86_1==K_NORECURSIVE||LA86_1==K_OF||LA86_1==K_TO||LA86_1==147||LA86_1==149) ) {
					alt86=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 86, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_KEYSPACE:
				{
				alt86=2;
				}
				break;
			case IDENT:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COLUMNFAMILY:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
			case QMARK:
			case QUOTED_NAME:
				{
				alt86=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}
			switch (alt86) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:760:7: K_ALL K_KEYSPACES
					{
					match(input,K_ALL,FOLLOW_K_ALL_in_dataResource4307); 
					match(input,K_KEYSPACES,FOLLOW_K_KEYSPACES_in_dataResource4309); 
					 res = DataResource.root(); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:761:7: K_KEYSPACE ks= keyspaceName
					{
					match(input,K_KEYSPACE,FOLLOW_K_KEYSPACE_in_dataResource4319); 
					pushFollow(FOLLOW_keyspaceName_in_dataResource4325);
					ks=keyspaceName();
					state._fsp--;

					 res = DataResource.keyspace(ks); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:7: ( K_COLUMNFAMILY )? cf= columnFamilyName
					{
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:7: ( K_COLUMNFAMILY )?
					int alt85=2;
					int LA85_0 = input.LA(1);
					if ( (LA85_0==K_COLUMNFAMILY) ) {
						alt85=1;
					}
					switch (alt85) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:762:9: K_COLUMNFAMILY
							{
							match(input,K_COLUMNFAMILY,FOLLOW_K_COLUMNFAMILY_in_dataResource4337); 
							}
							break;

					}

					pushFollow(FOLLOW_columnFamilyName_in_dataResource4346);
					cf=columnFamilyName();
					state._fsp--;

					 res = DataResource.columnFamily(cf.getKeyspace(), cf.getColumnFamily()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return res;
	}
	// $ANTLR end "dataResource"



	// $ANTLR start "createUserStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:769:1: createUserStatement returns [CreateUserStatement stmt] : K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final CreateUserStatement createUserStatement() throws RecognitionException {
		CreateUserStatement stmt = null;


		ParserRuleReturnScope username10 =null;


		        UserOptions opts = new UserOptions();
		        boolean superuser = false;
		        boolean ifNotExists = false;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:5: ( K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:7: K_CREATE K_USER ( K_IF K_NOT K_EXISTS )? username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_CREATE,FOLLOW_K_CREATE_in_createUserStatement4386); 
			match(input,K_USER,FOLLOW_K_USER_in_createUserStatement4388); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:23: ( K_IF K_NOT K_EXISTS )?
			int alt87=2;
			int LA87_0 = input.LA(1);
			if ( (LA87_0==K_IF) ) {
				alt87=1;
			}
			switch (alt87) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:775:24: K_IF K_NOT K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_createUserStatement4391); 
					match(input,K_NOT,FOLLOW_K_NOT_in_createUserStatement4393); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_createUserStatement4395); 
					 ifNotExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_createUserStatement4401);
			username10=username();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:7: ( K_WITH userOptions[opts] )?
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==K_WITH) ) {
				alt88=1;
			}
			switch (alt88) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:776:9: K_WITH userOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_createUserStatement4411); 
					pushFollow(FOLLOW_userOptions_in_createUserStatement4413);
					userOptions(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:777:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt89=3;
			int LA89_0 = input.LA(1);
			if ( (LA89_0==K_SUPERUSER) ) {
				alt89=1;
			}
			else if ( (LA89_0==K_NOSUPERUSER) ) {
				alt89=2;
			}
			switch (alt89) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:777:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_createUserStatement4427); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:777:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_createUserStatement4433); 
					 superuser = false; 
					}
					break;

			}

			 stmt = new CreateUserStatement((username10!=null?input.toString(username10.start,username10.stop):null), opts, superuser, ifNotExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "createUserStatement"



	// $ANTLR start "alterUserStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:784:1: alterUserStatement returns [AlterUserStatement stmt] : K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? ;
	public final AlterUserStatement alterUserStatement() throws RecognitionException {
		AlterUserStatement stmt = null;


		ParserRuleReturnScope username11 =null;


		        UserOptions opts = new UserOptions();
		        Boolean superuser = null;
		    
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:789:5: ( K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )? )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:789:7: K_ALTER K_USER username ( K_WITH userOptions[opts] )? ( K_SUPERUSER | K_NOSUPERUSER )?
			{
			match(input,K_ALTER,FOLLOW_K_ALTER_in_alterUserStatement4478); 
			match(input,K_USER,FOLLOW_K_USER_in_alterUserStatement4480); 
			pushFollow(FOLLOW_username_in_alterUserStatement4482);
			username11=username();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:790:7: ( K_WITH userOptions[opts] )?
			int alt90=2;
			int LA90_0 = input.LA(1);
			if ( (LA90_0==K_WITH) ) {
				alt90=1;
			}
			switch (alt90) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:790:9: K_WITH userOptions[opts]
					{
					match(input,K_WITH,FOLLOW_K_WITH_in_alterUserStatement4492); 
					pushFollow(FOLLOW_userOptions_in_alterUserStatement4494);
					userOptions(opts);
					state._fsp--;

					}
					break;

			}

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:791:7: ( K_SUPERUSER | K_NOSUPERUSER )?
			int alt91=3;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==K_SUPERUSER) ) {
				alt91=1;
			}
			else if ( (LA91_0==K_NOSUPERUSER) ) {
				alt91=2;
			}
			switch (alt91) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:791:9: K_SUPERUSER
					{
					match(input,K_SUPERUSER,FOLLOW_K_SUPERUSER_in_alterUserStatement4508); 
					 superuser = true; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:791:45: K_NOSUPERUSER
					{
					match(input,K_NOSUPERUSER,FOLLOW_K_NOSUPERUSER_in_alterUserStatement4514); 
					 superuser = false; 
					}
					break;

			}

			 stmt = new AlterUserStatement((username11!=null?input.toString(username11.start,username11.stop):null), opts, superuser); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "alterUserStatement"



	// $ANTLR start "dropUserStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:798:1: dropUserStatement returns [DropUserStatement stmt] : K_DROP K_USER ( K_IF K_EXISTS )? username ;
	public final DropUserStatement dropUserStatement() throws RecognitionException {
		DropUserStatement stmt = null;


		ParserRuleReturnScope username12 =null;

		 boolean ifExists = false; 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:5: ( K_DROP K_USER ( K_IF K_EXISTS )? username )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:7: K_DROP K_USER ( K_IF K_EXISTS )? username
			{
			match(input,K_DROP,FOLLOW_K_DROP_in_dropUserStatement4559); 
			match(input,K_USER,FOLLOW_K_USER_in_dropUserStatement4561); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:21: ( K_IF K_EXISTS )?
			int alt92=2;
			int LA92_0 = input.LA(1);
			if ( (LA92_0==K_IF) ) {
				alt92=1;
			}
			switch (alt92) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:800:22: K_IF K_EXISTS
					{
					match(input,K_IF,FOLLOW_K_IF_in_dropUserStatement4564); 
					match(input,K_EXISTS,FOLLOW_K_EXISTS_in_dropUserStatement4566); 
					 ifExists = true; 
					}
					break;

			}

			pushFollow(FOLLOW_username_in_dropUserStatement4572);
			username12=username();
			state._fsp--;

			 stmt = new DropUserStatement((username12!=null?input.toString(username12.start,username12.stop):null), ifExists); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "dropUserStatement"



	// $ANTLR start "listUsersStatement"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:806:1: listUsersStatement returns [ListUsersStatement stmt] : K_LIST K_USERS ;
	public final ListUsersStatement listUsersStatement() throws RecognitionException {
		ListUsersStatement stmt = null;


		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:807:5: ( K_LIST K_USERS )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:807:7: K_LIST K_USERS
			{
			match(input,K_LIST,FOLLOW_K_LIST_in_listUsersStatement4597); 
			match(input,K_USERS,FOLLOW_K_USERS_in_listUsersStatement4599); 
			 stmt = new ListUsersStatement(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmt;
	}
	// $ANTLR end "listUsersStatement"



	// $ANTLR start "userOptions"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:810:1: userOptions[UserOptions opts] : userOption[opts] ;
	public final void userOptions(UserOptions opts) throws RecognitionException {
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:5: ( userOption[opts] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:811:7: userOption[opts]
			{
			pushFollow(FOLLOW_userOption_in_userOptions4619);
			userOption(opts);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userOptions"



	// $ANTLR start "userOption"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:814:1: userOption[UserOptions opts] : k= K_PASSWORD v= STRING_LITERAL ;
	public final void userOption(UserOptions opts) throws RecognitionException {
		Token k=null;
		Token v=null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:5: (k= K_PASSWORD v= STRING_LITERAL )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:815:7: k= K_PASSWORD v= STRING_LITERAL
			{
			k=(Token)match(input,K_PASSWORD,FOLLOW_K_PASSWORD_in_userOption4640); 
			v=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_userOption4644); 
			 opts.put((k!=null?k.getText():null), (v!=null?v.getText():null)); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "userOption"



	// $ANTLR start "cident"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:823:1: cident returns [ColumnIdentifier.Raw id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier.Raw cident() throws RecognitionException {
		ColumnIdentifier.Raw id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:824:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt93=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt93=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt93=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt93=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 93, 0, input);
				throw nvae;
			}
			switch (alt93) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:824:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cident4675); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:825:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cident4700); 
					 id = new ColumnIdentifier.Raw((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:826:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cident4719);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier.Raw(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "cident"



	// $ANTLR start "ident"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:830:1: ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword );
	public final ColumnIdentifier ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:831:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword )
			int alt94=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt94=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt94=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt94=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 94, 0, input);
				throw nvae;
			}
			switch (alt94) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:831:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ident4745); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:832:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ident4770); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:833:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ident4789);
					k=unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "ident"



	// $ANTLR start "keyspaceName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:837:1: keyspaceName returns [String id] : ksName[name] ;
	public final String keyspaceName() throws RecognitionException {
		String id = null;


		 CFName name = new CFName(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:5: ( ksName[name] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:839:7: ksName[name]
			{
			pushFollow(FOLLOW_ksName_in_keyspaceName4822);
			ksName(name);
			state._fsp--;

			 id = name.getKeyspace(); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "keyspaceName"



	// $ANTLR start "indexName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:842:1: indexName returns [IndexName name] : ( ksName[name] '.' )? idxName[name] ;
	public final IndexName indexName() throws RecognitionException {
		IndexName name = null;


		 name = new IndexName(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:5: ( ( ksName[name] '.' )? idxName[name] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:7: ( ksName[name] '.' )? idxName[name]
			{
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:7: ( ksName[name] '.' )?
			int alt95=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA95_1 = input.LA(2);
					if ( (LA95_1==147) ) {
						alt95=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA95_2 = input.LA(2);
					if ( (LA95_2==147) ) {
						alt95=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FROZEN:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA95_3 = input.LA(2);
					if ( (LA95_3==147) ) {
						alt95=1;
					}
					}
					break;
				case K_ASCII:
					{
					int LA95_4 = input.LA(2);
					if ( (LA95_4==147) ) {
						alt95=1;
					}
					}
					break;
				case K_BIGINT:
					{
					int LA95_5 = input.LA(2);
					if ( (LA95_5==147) ) {
						alt95=1;
					}
					}
					break;
				case K_BLOB:
					{
					int LA95_6 = input.LA(2);
					if ( (LA95_6==147) ) {
						alt95=1;
					}
					}
					break;
				case K_BOOLEAN:
					{
					int LA95_7 = input.LA(2);
					if ( (LA95_7==147) ) {
						alt95=1;
					}
					}
					break;
				case K_COUNTER:
					{
					int LA95_8 = input.LA(2);
					if ( (LA95_8==147) ) {
						alt95=1;
					}
					}
					break;
				case K_DECIMAL:
					{
					int LA95_9 = input.LA(2);
					if ( (LA95_9==147) ) {
						alt95=1;
					}
					}
					break;
				case K_DOUBLE:
					{
					int LA95_10 = input.LA(2);
					if ( (LA95_10==147) ) {
						alt95=1;
					}
					}
					break;
				case K_FLOAT:
					{
					int LA95_11 = input.LA(2);
					if ( (LA95_11==147) ) {
						alt95=1;
					}
					}
					break;
				case K_INET:
					{
					int LA95_12 = input.LA(2);
					if ( (LA95_12==147) ) {
						alt95=1;
					}
					}
					break;
				case K_INT:
					{
					int LA95_13 = input.LA(2);
					if ( (LA95_13==147) ) {
						alt95=1;
					}
					}
					break;
				case K_TEXT:
					{
					int LA95_14 = input.LA(2);
					if ( (LA95_14==147) ) {
						alt95=1;
					}
					}
					break;
				case K_TIMESTAMP:
					{
					int LA95_15 = input.LA(2);
					if ( (LA95_15==147) ) {
						alt95=1;
					}
					}
					break;
				case K_UUID:
					{
					int LA95_16 = input.LA(2);
					if ( (LA95_16==147) ) {
						alt95=1;
					}
					}
					break;
				case K_VARCHAR:
					{
					int LA95_17 = input.LA(2);
					if ( (LA95_17==147) ) {
						alt95=1;
					}
					}
					break;
				case K_VARINT:
					{
					int LA95_18 = input.LA(2);
					if ( (LA95_18==147) ) {
						alt95=1;
					}
					}
					break;
				case K_TIMEUUID:
					{
					int LA95_19 = input.LA(2);
					if ( (LA95_19==147) ) {
						alt95=1;
					}
					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA95_20 = input.LA(2);
					if ( (LA95_20==147) ) {
						alt95=1;
					}
					}
					break;
				case QMARK:
					{
					int LA95_21 = input.LA(2);
					if ( (LA95_21==147) ) {
						alt95=1;
					}
					}
					break;
			}
			switch (alt95) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:844:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_indexName4856);
					ksName(name);
					state._fsp--;

					match(input,147,FOLLOW_147_in_indexName4859); 
					}
					break;

			}

			pushFollow(FOLLOW_idxName_in_indexName4863);
			idxName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "indexName"



	// $ANTLR start "columnFamilyName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:847:1: columnFamilyName returns [CFName name] : ( ksName[name] '.' )? cfName[name] ;
	public final CFName columnFamilyName() throws RecognitionException {
		CFName name = null;


		 name = new CFName(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:5: ( ( ksName[name] '.' )? cfName[name] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:7: ( ksName[name] '.' )? cfName[name]
			{
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:7: ( ksName[name] '.' )?
			int alt96=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA96_1 = input.LA(2);
					if ( (LA96_1==147) ) {
						alt96=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA96_2 = input.LA(2);
					if ( (LA96_2==147) ) {
						alt96=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FROZEN:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA96_3 = input.LA(2);
					if ( (LA96_3==147) ) {
						alt96=1;
					}
					}
					break;
				case K_ASCII:
					{
					int LA96_4 = input.LA(2);
					if ( (LA96_4==147) ) {
						alt96=1;
					}
					}
					break;
				case K_BIGINT:
					{
					int LA96_5 = input.LA(2);
					if ( (LA96_5==147) ) {
						alt96=1;
					}
					}
					break;
				case K_BLOB:
					{
					int LA96_6 = input.LA(2);
					if ( (LA96_6==147) ) {
						alt96=1;
					}
					}
					break;
				case K_BOOLEAN:
					{
					int LA96_7 = input.LA(2);
					if ( (LA96_7==147) ) {
						alt96=1;
					}
					}
					break;
				case K_COUNTER:
					{
					int LA96_8 = input.LA(2);
					if ( (LA96_8==147) ) {
						alt96=1;
					}
					}
					break;
				case K_DECIMAL:
					{
					int LA96_9 = input.LA(2);
					if ( (LA96_9==147) ) {
						alt96=1;
					}
					}
					break;
				case K_DOUBLE:
					{
					int LA96_10 = input.LA(2);
					if ( (LA96_10==147) ) {
						alt96=1;
					}
					}
					break;
				case K_FLOAT:
					{
					int LA96_11 = input.LA(2);
					if ( (LA96_11==147) ) {
						alt96=1;
					}
					}
					break;
				case K_INET:
					{
					int LA96_12 = input.LA(2);
					if ( (LA96_12==147) ) {
						alt96=1;
					}
					}
					break;
				case K_INT:
					{
					int LA96_13 = input.LA(2);
					if ( (LA96_13==147) ) {
						alt96=1;
					}
					}
					break;
				case K_TEXT:
					{
					int LA96_14 = input.LA(2);
					if ( (LA96_14==147) ) {
						alt96=1;
					}
					}
					break;
				case K_TIMESTAMP:
					{
					int LA96_15 = input.LA(2);
					if ( (LA96_15==147) ) {
						alt96=1;
					}
					}
					break;
				case K_UUID:
					{
					int LA96_16 = input.LA(2);
					if ( (LA96_16==147) ) {
						alt96=1;
					}
					}
					break;
				case K_VARCHAR:
					{
					int LA96_17 = input.LA(2);
					if ( (LA96_17==147) ) {
						alt96=1;
					}
					}
					break;
				case K_VARINT:
					{
					int LA96_18 = input.LA(2);
					if ( (LA96_18==147) ) {
						alt96=1;
					}
					}
					break;
				case K_TIMEUUID:
					{
					int LA96_19 = input.LA(2);
					if ( (LA96_19==147) ) {
						alt96=1;
					}
					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA96_20 = input.LA(2);
					if ( (LA96_20==147) ) {
						alt96=1;
					}
					}
					break;
				case QMARK:
					{
					int LA96_21 = input.LA(2);
					if ( (LA96_21==147) ) {
						alt96=1;
					}
					}
					break;
			}
			switch (alt96) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:849:8: ksName[name] '.'
					{
					pushFollow(FOLLOW_ksName_in_columnFamilyName4895);
					ksName(name);
					state._fsp--;

					match(input,147,FOLLOW_147_in_columnFamilyName4898); 
					}
					break;

			}

			pushFollow(FOLLOW_cfName_in_columnFamilyName4902);
			cfName(name);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "columnFamilyName"



	// $ANTLR start "userTypeName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:852:1: userTypeName returns [UTName name] : (ks= ident '.' )? ut= non_type_ident ;
	public final UTName userTypeName() throws RecognitionException {
		UTName name = null;


		ColumnIdentifier ks =null;
		ColumnIdentifier ut =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:5: ( (ks= ident '.' )? ut= non_type_ident )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:7: (ks= ident '.' )? ut= non_type_ident
			{
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:7: (ks= ident '.' )?
			int alt97=2;
			switch ( input.LA(1) ) {
				case IDENT:
					{
					int LA97_1 = input.LA(2);
					if ( (LA97_1==147) ) {
						alt97=1;
					}
					}
					break;
				case QUOTED_NAME:
					{
					int LA97_2 = input.LA(2);
					if ( (LA97_2==147) ) {
						alt97=1;
					}
					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FROZEN:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA97_3 = input.LA(2);
					if ( (LA97_3==147) ) {
						alt97=1;
					}
					}
					break;
				case K_ASCII:
				case K_BIGINT:
				case K_BLOB:
				case K_BOOLEAN:
				case K_COUNT:
				case K_COUNTER:
				case K_DECIMAL:
				case K_DOUBLE:
				case K_FLOAT:
				case K_INET:
				case K_INT:
				case K_TEXT:
				case K_TIMESTAMP:
				case K_TIMEUUID:
				case K_TTL:
				case K_UUID:
				case K_VARCHAR:
				case K_VARINT:
				case K_WRITETIME:
					{
					alt97=1;
					}
					break;
				case K_KEY:
					{
					int LA97_5 = input.LA(2);
					if ( (LA97_5==147) ) {
						alt97=1;
					}
					}
					break;
			}
			switch (alt97) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:853:8: ks= ident '.'
					{
					pushFollow(FOLLOW_ident_in_userTypeName4927);
					ks=ident();
					state._fsp--;

					match(input,147,FOLLOW_147_in_userTypeName4929); 
					}
					break;

			}

			pushFollow(FOLLOW_non_type_ident_in_userTypeName4935);
			ut=non_type_ident();
			state._fsp--;

			 return new UTName(ks, ut); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return name;
	}
	// $ANTLR end "userTypeName"



	// $ANTLR start "ksName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:856:1: ksName[KeyspaceElementName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void ksName(KeyspaceElementName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt98=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt98=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt98=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt98=3;
				}
				break;
			case QMARK:
				{
				alt98=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}
			switch (alt98) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:857:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_ksName4957); 
					 name.setKeyspace((t!=null?t.getText():null), false);
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:858:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_ksName4982); 
					 name.setKeyspace((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:859:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_ksName5001);
					k=unreserved_keyword();
					state._fsp--;

					 name.setKeyspace(k, false);
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:860:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_ksName5011); 
					addRecognitionError("Bind variables cannot be used for keyspace names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ksName"



	// $ANTLR start "cfName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:863:1: cfName[CFName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void cfName(CFName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt99=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt99=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt99=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt99=3;
				}
				break;
			case QMARK:
				{
				alt99=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 99, 0, input);
				throw nvae;
			}
			switch (alt99) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:864:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_cfName5033); 
					 name.setColumnFamily((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:865:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_cfName5058); 
					 name.setColumnFamily((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:866:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_cfName5077);
					k=unreserved_keyword();
					state._fsp--;

					 name.setColumnFamily(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:867:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_cfName5087); 
					addRecognitionError("Bind variables cannot be used for table names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "cfName"



	// $ANTLR start "idxName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:870:1: idxName[IndexName name] : (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK );
	public final void idxName(IndexName name) throws RecognitionException {
		Token t=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:5: (t= IDENT |t= QUOTED_NAME |k= unreserved_keyword | QMARK )
			int alt100=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt100=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt100=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TTL:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
			case K_WRITETIME:
				{
				alt100=3;
				}
				break;
			case QMARK:
				{
				alt100=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 100, 0, input);
				throw nvae;
			}
			switch (alt100) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:871:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_idxName5109); 
					 name.setIndex((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:872:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_idxName5134); 
					 name.setIndex((t!=null?t.getText():null), true);
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:873:7: k= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_idxName5153);
					k=unreserved_keyword();
					state._fsp--;

					 name.setIndex(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:874:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_idxName5163); 
					addRecognitionError("Bind variables cannot be used for index names");
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "idxName"



	// $ANTLR start "constant"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:877:1: constant returns [Constants.Literal constant] : (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) );
	public final Constants.Literal constant() throws RecognitionException {
		Constants.Literal constant = null;


		Token t=null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:878:5: (t= STRING_LITERAL |t= INTEGER |t= FLOAT |t= BOOLEAN |t= UUID |t= HEXNUMBER | ( '-' )? t= ( K_NAN | K_INFINITY ) )
			int alt102=7;
			switch ( input.LA(1) ) {
			case STRING_LITERAL:
				{
				alt102=1;
				}
				break;
			case INTEGER:
				{
				alt102=2;
				}
				break;
			case FLOAT:
				{
				alt102=3;
				}
				break;
			case BOOLEAN:
				{
				alt102=4;
				}
				break;
			case UUID:
				{
				alt102=5;
				}
				break;
			case HEXNUMBER:
				{
				alt102=6;
				}
				break;
			case K_INFINITY:
			case K_NAN:
			case 146:
				{
				alt102=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 102, 0, input);
				throw nvae;
			}
			switch (alt102) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:878:7: t= STRING_LITERAL
					{
					t=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_constant5188); 
					 constant = Constants.Literal.string((t!=null?t.getText():null)); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:879:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_constant5200); 
					 constant = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:880:7: t= FLOAT
					{
					t=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_constant5219); 
					 constant = Constants.Literal.floatingPoint((t!=null?t.getText():null)); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:881:7: t= BOOLEAN
					{
					t=(Token)match(input,BOOLEAN,FOLLOW_BOOLEAN_in_constant5240); 
					 constant = Constants.Literal.bool((t!=null?t.getText():null)); 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:882:7: t= UUID
					{
					t=(Token)match(input,UUID,FOLLOW_UUID_in_constant5259); 
					 constant = Constants.Literal.uuid((t!=null?t.getText():null)); 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:883:7: t= HEXNUMBER
					{
					t=(Token)match(input,HEXNUMBER,FOLLOW_HEXNUMBER_in_constant5281); 
					 constant = Constants.Literal.hex((t!=null?t.getText():null)); 
					}
					break;
				case 7 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:7: ( '-' )? t= ( K_NAN | K_INFINITY )
					{
					 String sign=""; 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:27: ( '-' )?
					int alt101=2;
					int LA101_0 = input.LA(1);
					if ( (LA101_0==146) ) {
						alt101=1;
					}
					switch (alt101) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:884:28: '-'
							{
							match(input,146,FOLLOW_146_in_constant5299); 
							sign = "-"; 
							}
							break;

					}

					t=input.LT(1);
					if ( input.LA(1)==K_INFINITY||input.LA(1)==K_NAN ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 constant = Constants.Literal.floatingPoint(sign + (t!=null?t.getText():null)); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return constant;
	}
	// $ANTLR end "constant"



	// $ANTLR start "mapLiteral"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:887:1: mapLiteral returns [Maps.Literal map] : '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' ;
	public final Maps.Literal mapLiteral() throws RecognitionException {
		Maps.Literal map = null;


		Term.Raw k1 =null;
		Term.Raw v1 =null;
		Term.Raw kn =null;
		Term.Raw vn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:888:5: ( '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:888:7: '{' (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )? '}'
			{
			match(input,158,FOLLOW_158_in_mapLiteral5337); 
			 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:11: (k1= term ':' v1= term ( ',' kn= term ':' vn= term )* )?
			int alt104=2;
			int LA104_0 = input.LA(1);
			if ( (LA104_0==BOOLEAN||LA104_0==FLOAT||LA104_0==HEXNUMBER||(LA104_0 >= IDENT && LA104_0 <= INTEGER)||LA104_0==K_ALL||LA104_0==K_AS||LA104_0==K_ASCII||(LA104_0 >= K_BIGINT && LA104_0 <= K_BOOLEAN)||LA104_0==K_CLUSTERING||(LA104_0 >= K_COMPACT && LA104_0 <= K_CONTAINS)||LA104_0==K_COUNTER||(LA104_0 >= K_CUSTOM && LA104_0 <= K_DECIMAL)||(LA104_0 >= K_DISTINCT && LA104_0 <= K_DOUBLE)||(LA104_0 >= K_EXISTS && LA104_0 <= K_FLOAT)||LA104_0==K_FROZEN||(LA104_0 >= K_INET && LA104_0 <= K_INFINITY)||LA104_0==K_INT||LA104_0==K_KEYS||LA104_0==K_KEYSPACES||(LA104_0 >= K_LIST && LA104_0 <= K_MAP)||LA104_0==K_NAN||LA104_0==K_NOSUPERUSER||LA104_0==K_NULL||(LA104_0 >= K_PASSWORD && LA104_0 <= K_PERMISSIONS)||(LA104_0 >= K_STATIC && LA104_0 <= K_TIMEUUID)||(LA104_0 >= K_TOKEN && LA104_0 <= K_TRIGGER)||(LA104_0 >= K_TUPLE && LA104_0 <= K_TYPE)||(LA104_0 >= K_USER && LA104_0 <= K_USERS)||(LA104_0 >= K_UUID && LA104_0 <= K_VARINT)||LA104_0==QMARK||LA104_0==STRING_LITERAL||LA104_0==UUID||LA104_0==142||LA104_0==146||LA104_0==148||LA104_0==155||LA104_0==158) ) {
				alt104=1;
			}
			switch (alt104) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:13: k1= term ':' v1= term ( ',' kn= term ':' vn= term )*
					{
					pushFollow(FOLLOW_term_in_mapLiteral5355);
					k1=term();
					state._fsp--;

					match(input,148,FOLLOW_148_in_mapLiteral5357); 
					pushFollow(FOLLOW_term_in_mapLiteral5361);
					v1=term();
					state._fsp--;

					 m.add(Pair.create(k1, v1)); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:65: ( ',' kn= term ':' vn= term )*
					loop103:
					while (true) {
						int alt103=2;
						int LA103_0 = input.LA(1);
						if ( (LA103_0==145) ) {
							alt103=1;
						}

						switch (alt103) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:889:67: ',' kn= term ':' vn= term
							{
							match(input,145,FOLLOW_145_in_mapLiteral5367); 
							pushFollow(FOLLOW_term_in_mapLiteral5371);
							kn=term();
							state._fsp--;

							match(input,148,FOLLOW_148_in_mapLiteral5373); 
							pushFollow(FOLLOW_term_in_mapLiteral5377);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop103;
						}
					}

					}
					break;

			}

			match(input,159,FOLLOW_159_in_mapLiteral5393); 
			 map = new Maps.Literal(m); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return map;
	}
	// $ANTLR end "mapLiteral"



	// $ANTLR start "setOrMapLiteral"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:893:1: setOrMapLiteral[Term.Raw t] returns [Term.Raw value] : ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* );
	public final Term.Raw setOrMapLiteral(Term.Raw t) throws RecognitionException {
		Term.Raw value = null;


		Term.Raw v =null;
		Term.Raw kn =null;
		Term.Raw vn =null;
		Term.Raw tn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:894:5: ( ':' v= term ( ',' kn= term ':' vn= term )* | ( ',' tn= term )* )
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==148) ) {
				alt107=1;
			}
			else if ( (LA107_0==145||LA107_0==159) ) {
				alt107=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 107, 0, input);
				throw nvae;
			}

			switch (alt107) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:894:7: ':' v= term ( ',' kn= term ':' vn= term )*
					{
					match(input,148,FOLLOW_148_in_setOrMapLiteral5417); 
					pushFollow(FOLLOW_term_in_setOrMapLiteral5421);
					v=term();
					state._fsp--;

					 List<Pair<Term.Raw, Term.Raw>> m = new ArrayList<Pair<Term.Raw, Term.Raw>>(); m.add(Pair.create(t, v)); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:895:11: ( ',' kn= term ':' vn= term )*
					loop105:
					while (true) {
						int alt105=2;
						int LA105_0 = input.LA(1);
						if ( (LA105_0==145) ) {
							alt105=1;
						}

						switch (alt105) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:895:13: ',' kn= term ':' vn= term
							{
							match(input,145,FOLLOW_145_in_setOrMapLiteral5437); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5441);
							kn=term();
							state._fsp--;

							match(input,148,FOLLOW_148_in_setOrMapLiteral5443); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5447);
							vn=term();
							state._fsp--;

							 m.add(Pair.create(kn, vn)); 
							}
							break;

						default :
							break loop105;
						}
					}

					 value = new Maps.Literal(m); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:897:7: ( ',' tn= term )*
					{
					 List<Term.Raw> s = new ArrayList<Term.Raw>(); s.add(t); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:898:11: ( ',' tn= term )*
					loop106:
					while (true) {
						int alt106=2;
						int LA106_0 = input.LA(1);
						if ( (LA106_0==145) ) {
							alt106=1;
						}

						switch (alt106) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:898:13: ',' tn= term
							{
							match(input,145,FOLLOW_145_in_setOrMapLiteral5482); 
							pushFollow(FOLLOW_term_in_setOrMapLiteral5486);
							tn=term();
							state._fsp--;

							 s.add(tn); 
							}
							break;

						default :
							break loop106;
						}
					}

					 value = new Sets.Literal(s); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "setOrMapLiteral"



	// $ANTLR start "collectionLiteral"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:902:1: collectionLiteral returns [Term.Raw value] : ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' );
	public final Term.Raw collectionLiteral() throws RecognitionException {
		Term.Raw value = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;
		Term.Raw t =null;
		Term.Raw v =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:903:5: ( '[' (t1= term ( ',' tn= term )* )? ']' | '{' t= term v= setOrMapLiteral[t] '}' | '{' '}' )
			int alt110=3;
			int LA110_0 = input.LA(1);
			if ( (LA110_0==155) ) {
				alt110=1;
			}
			else if ( (LA110_0==158) ) {
				int LA110_2 = input.LA(2);
				if ( (LA110_2==159) ) {
					alt110=3;
				}
				else if ( (LA110_2==BOOLEAN||LA110_2==FLOAT||LA110_2==HEXNUMBER||(LA110_2 >= IDENT && LA110_2 <= INTEGER)||LA110_2==K_ALL||LA110_2==K_AS||LA110_2==K_ASCII||(LA110_2 >= K_BIGINT && LA110_2 <= K_BOOLEAN)||LA110_2==K_CLUSTERING||(LA110_2 >= K_COMPACT && LA110_2 <= K_CONTAINS)||LA110_2==K_COUNTER||(LA110_2 >= K_CUSTOM && LA110_2 <= K_DECIMAL)||(LA110_2 >= K_DISTINCT && LA110_2 <= K_DOUBLE)||(LA110_2 >= K_EXISTS && LA110_2 <= K_FLOAT)||LA110_2==K_FROZEN||(LA110_2 >= K_INET && LA110_2 <= K_INFINITY)||LA110_2==K_INT||LA110_2==K_KEYS||LA110_2==K_KEYSPACES||(LA110_2 >= K_LIST && LA110_2 <= K_MAP)||LA110_2==K_NAN||LA110_2==K_NOSUPERUSER||LA110_2==K_NULL||(LA110_2 >= K_PASSWORD && LA110_2 <= K_PERMISSIONS)||(LA110_2 >= K_STATIC && LA110_2 <= K_TIMEUUID)||(LA110_2 >= K_TOKEN && LA110_2 <= K_TRIGGER)||(LA110_2 >= K_TUPLE && LA110_2 <= K_TYPE)||(LA110_2 >= K_USER && LA110_2 <= K_USERS)||(LA110_2 >= K_UUID && LA110_2 <= K_VARINT)||LA110_2==QMARK||LA110_2==STRING_LITERAL||LA110_2==UUID||LA110_2==142||LA110_2==146||LA110_2==148||LA110_2==155||LA110_2==158) ) {
					alt110=2;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 110, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 110, 0, input);
				throw nvae;
			}

			switch (alt110) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:903:7: '[' (t1= term ( ',' tn= term )* )? ']'
					{
					match(input,155,FOLLOW_155_in_collectionLiteral5520); 
					 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:11: (t1= term ( ',' tn= term )* )?
					int alt109=2;
					int LA109_0 = input.LA(1);
					if ( (LA109_0==BOOLEAN||LA109_0==FLOAT||LA109_0==HEXNUMBER||(LA109_0 >= IDENT && LA109_0 <= INTEGER)||LA109_0==K_ALL||LA109_0==K_AS||LA109_0==K_ASCII||(LA109_0 >= K_BIGINT && LA109_0 <= K_BOOLEAN)||LA109_0==K_CLUSTERING||(LA109_0 >= K_COMPACT && LA109_0 <= K_CONTAINS)||LA109_0==K_COUNTER||(LA109_0 >= K_CUSTOM && LA109_0 <= K_DECIMAL)||(LA109_0 >= K_DISTINCT && LA109_0 <= K_DOUBLE)||(LA109_0 >= K_EXISTS && LA109_0 <= K_FLOAT)||LA109_0==K_FROZEN||(LA109_0 >= K_INET && LA109_0 <= K_INFINITY)||LA109_0==K_INT||LA109_0==K_KEYS||LA109_0==K_KEYSPACES||(LA109_0 >= K_LIST && LA109_0 <= K_MAP)||LA109_0==K_NAN||LA109_0==K_NOSUPERUSER||LA109_0==K_NULL||(LA109_0 >= K_PASSWORD && LA109_0 <= K_PERMISSIONS)||(LA109_0 >= K_STATIC && LA109_0 <= K_TIMEUUID)||(LA109_0 >= K_TOKEN && LA109_0 <= K_TRIGGER)||(LA109_0 >= K_TUPLE && LA109_0 <= K_TYPE)||(LA109_0 >= K_USER && LA109_0 <= K_USERS)||(LA109_0 >= K_UUID && LA109_0 <= K_VARINT)||LA109_0==QMARK||LA109_0==STRING_LITERAL||LA109_0==UUID||LA109_0==142||LA109_0==146||LA109_0==148||LA109_0==155||LA109_0==158) ) {
						alt109=1;
					}
					switch (alt109) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:13: t1= term ( ',' tn= term )*
							{
							pushFollow(FOLLOW_term_in_collectionLiteral5538);
							t1=term();
							state._fsp--;

							 l.add(t1); 
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:36: ( ',' tn= term )*
							loop108:
							while (true) {
								int alt108=2;
								int LA108_0 = input.LA(1);
								if ( (LA108_0==145) ) {
									alt108=1;
								}

								switch (alt108) {
								case 1 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:904:38: ',' tn= term
									{
									match(input,145,FOLLOW_145_in_collectionLiteral5544); 
									pushFollow(FOLLOW_term_in_collectionLiteral5548);
									tn=term();
									state._fsp--;

									 l.add(tn); 
									}
									break;

								default :
									break loop108;
								}
							}

							}
							break;

					}

					match(input,157,FOLLOW_157_in_collectionLiteral5564); 
					 value = new Lists.Literal(l); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:906:7: '{' t= term v= setOrMapLiteral[t] '}'
					{
					match(input,158,FOLLOW_158_in_collectionLiteral5574); 
					pushFollow(FOLLOW_term_in_collectionLiteral5578);
					t=term();
					state._fsp--;

					pushFollow(FOLLOW_setOrMapLiteral_in_collectionLiteral5582);
					v=setOrMapLiteral(t);
					state._fsp--;

					 value = v; 
					match(input,159,FOLLOW_159_in_collectionLiteral5587); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:909:7: '{' '}'
					{
					match(input,158,FOLLOW_158_in_collectionLiteral5605); 
					match(input,159,FOLLOW_159_in_collectionLiteral5607); 
					 value = new Sets.Literal(Collections.<Term.Raw>emptyList()); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "collectionLiteral"



	// $ANTLR start "usertypeLiteral"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:912:1: usertypeLiteral returns [UserTypes.Literal ut] : '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}' ;
	public final UserTypes.Literal usertypeLiteral() throws RecognitionException {
		UserTypes.Literal ut = null;


		ColumnIdentifier k1 =null;
		Term.Raw v1 =null;
		ColumnIdentifier kn =null;
		Term.Raw vn =null;

		 Map<ColumnIdentifier, Term.Raw> m = new HashMap<ColumnIdentifier, Term.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:916:5: ( '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:916:7: '{' k1= ident ':' v1= term ( ',' kn= ident ':' vn= term )* '}'
			{
			match(input,158,FOLLOW_158_in_usertypeLiteral5651); 
			pushFollow(FOLLOW_ident_in_usertypeLiteral5655);
			k1=ident();
			state._fsp--;

			match(input,148,FOLLOW_148_in_usertypeLiteral5657); 
			pushFollow(FOLLOW_term_in_usertypeLiteral5661);
			v1=term();
			state._fsp--;

			 m.put(k1, v1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:916:51: ( ',' kn= ident ':' vn= term )*
			loop111:
			while (true) {
				int alt111=2;
				int LA111_0 = input.LA(1);
				if ( (LA111_0==145) ) {
					alt111=1;
				}

				switch (alt111) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:916:53: ',' kn= ident ':' vn= term
					{
					match(input,145,FOLLOW_145_in_usertypeLiteral5667); 
					pushFollow(FOLLOW_ident_in_usertypeLiteral5671);
					kn=ident();
					state._fsp--;

					match(input,148,FOLLOW_148_in_usertypeLiteral5673); 
					pushFollow(FOLLOW_term_in_usertypeLiteral5677);
					vn=term();
					state._fsp--;

					 m.put(kn, vn); 
					}
					break;

				default :
					break loop111;
				}
			}

			match(input,159,FOLLOW_159_in_usertypeLiteral5684); 
			}

			 ut = new UserTypes.Literal(m); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ut;
	}
	// $ANTLR end "usertypeLiteral"



	// $ANTLR start "tupleLiteral"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:919:1: tupleLiteral returns [Tuples.Literal tt] : '(' t1= term ( ',' tn= term )* ')' ;
	public final Tuples.Literal tupleLiteral() throws RecognitionException {
		Tuples.Literal tt = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 List<Term.Raw> l = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:922:5: ( '(' t1= term ( ',' tn= term )* ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:922:7: '(' t1= term ( ',' tn= term )* ')'
			{
			match(input,142,FOLLOW_142_in_tupleLiteral5721); 
			pushFollow(FOLLOW_term_in_tupleLiteral5725);
			t1=term();
			state._fsp--;

			 l.add(t1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:922:34: ( ',' tn= term )*
			loop112:
			while (true) {
				int alt112=2;
				int LA112_0 = input.LA(1);
				if ( (LA112_0==145) ) {
					alt112=1;
				}

				switch (alt112) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:922:36: ',' tn= term
					{
					match(input,145,FOLLOW_145_in_tupleLiteral5731); 
					pushFollow(FOLLOW_term_in_tupleLiteral5735);
					tn=term();
					state._fsp--;

					 l.add(tn); 
					}
					break;

				default :
					break loop112;
				}
			}

			match(input,143,FOLLOW_143_in_tupleLiteral5742); 
			}

			 tt = new Tuples.Literal(l); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return tt;
	}
	// $ANTLR end "tupleLiteral"



	// $ANTLR start "value"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:925:1: value returns [Term.Raw value] : (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= ident | QMARK );
	public final Term.Raw value() throws RecognitionException {
		Term.Raw value = null;


		Constants.Literal c =null;
		Term.Raw l =null;
		UserTypes.Literal u =null;
		Tuples.Literal t =null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:926:5: (c= constant |l= collectionLiteral |u= usertypeLiteral |t= tupleLiteral | K_NULL | ':' id= ident | QMARK )
			int alt113=7;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case STRING_LITERAL:
			case UUID:
			case 146:
				{
				alt113=1;
				}
				break;
			case 155:
				{
				alt113=2;
				}
				break;
			case 158:
				{
				switch ( input.LA(2) ) {
				case BOOLEAN:
				case FLOAT:
				case HEXNUMBER:
				case INTEGER:
				case K_INFINITY:
				case K_NAN:
				case K_NULL:
				case K_TOKEN:
				case QMARK:
				case STRING_LITERAL:
				case UUID:
				case 142:
				case 146:
				case 148:
				case 155:
				case 158:
				case 159:
					{
					alt113=2;
					}
					break;
				case IDENT:
					{
					int LA113_8 = input.LA(3);
					if ( (LA113_8==142) ) {
						alt113=2;
					}
					else if ( (LA113_8==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 8, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FROZEN:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA113_9 = input.LA(3);
					if ( (LA113_9==142) ) {
						alt113=2;
					}
					else if ( (LA113_9==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 9, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA113_10 = input.LA(3);
					if ( (LA113_10==142) ) {
						alt113=2;
					}
					else if ( (LA113_10==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 10, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA113_11 = input.LA(3);
					if ( (LA113_11==142) ) {
						alt113=2;
					}
					else if ( (LA113_11==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA113_12 = input.LA(3);
					if ( (LA113_12==142) ) {
						alt113=2;
					}
					else if ( (LA113_12==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 12, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA113_13 = input.LA(3);
					if ( (LA113_13==142) ) {
						alt113=2;
					}
					else if ( (LA113_13==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 13, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA113_14 = input.LA(3);
					if ( (LA113_14==142) ) {
						alt113=2;
					}
					else if ( (LA113_14==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 14, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA113_15 = input.LA(3);
					if ( (LA113_15==142) ) {
						alt113=2;
					}
					else if ( (LA113_15==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 15, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA113_16 = input.LA(3);
					if ( (LA113_16==142) ) {
						alt113=2;
					}
					else if ( (LA113_16==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 16, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA113_17 = input.LA(3);
					if ( (LA113_17==142) ) {
						alt113=2;
					}
					else if ( (LA113_17==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 17, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA113_18 = input.LA(3);
					if ( (LA113_18==142) ) {
						alt113=2;
					}
					else if ( (LA113_18==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 18, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA113_19 = input.LA(3);
					if ( (LA113_19==142) ) {
						alt113=2;
					}
					else if ( (LA113_19==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 19, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA113_20 = input.LA(3);
					if ( (LA113_20==142) ) {
						alt113=2;
					}
					else if ( (LA113_20==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA113_21 = input.LA(3);
					if ( (LA113_21==142) ) {
						alt113=2;
					}
					else if ( (LA113_21==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA113_22 = input.LA(3);
					if ( (LA113_22==142) ) {
						alt113=2;
					}
					else if ( (LA113_22==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 22, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA113_23 = input.LA(3);
					if ( (LA113_23==142) ) {
						alt113=2;
					}
					else if ( (LA113_23==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 23, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA113_24 = input.LA(3);
					if ( (LA113_24==142) ) {
						alt113=2;
					}
					else if ( (LA113_24==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA113_25 = input.LA(3);
					if ( (LA113_25==142) ) {
						alt113=2;
					}
					else if ( (LA113_25==148) ) {
						alt113=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 113, 25, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
				case QUOTED_NAME:
					{
					alt113=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 113, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case 142:
				{
				alt113=4;
				}
				break;
			case K_NULL:
				{
				alt113=5;
				}
				break;
			case 148:
				{
				alt113=6;
				}
				break;
			case QMARK:
				{
				alt113=7;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 113, 0, input);
				throw nvae;
			}
			switch (alt113) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:926:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_value5765);
					c=constant();
					state._fsp--;

					 value = c; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:927:7: l= collectionLiteral
					{
					pushFollow(FOLLOW_collectionLiteral_in_value5787);
					l=collectionLiteral();
					state._fsp--;

					 value = l; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:928:7: u= usertypeLiteral
					{
					pushFollow(FOLLOW_usertypeLiteral_in_value5800);
					u=usertypeLiteral();
					state._fsp--;

					 value = u; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:929:7: t= tupleLiteral
					{
					pushFollow(FOLLOW_tupleLiteral_in_value5815);
					t=tupleLiteral();
					state._fsp--;

					 value = t; 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:930:7: K_NULL
					{
					match(input,K_NULL,FOLLOW_K_NULL_in_value5831); 
					 value = Constants.NULL_LITERAL; 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:931:7: ':' id= ident
					{
					match(input,148,FOLLOW_148_in_value5855); 
					pushFollow(FOLLOW_ident_in_value5859);
					id=ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 7 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:932:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_value5877); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "value"



	// $ANTLR start "intValue"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:935:1: intValue returns [Term.Raw value] : (|t= INTEGER | ':' id= ident | QMARK );
	public final Term.Raw intValue() throws RecognitionException {
		Term.Raw value = null;


		Token t=null;
		ColumnIdentifier id =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:936:5: (|t= INTEGER | ':' id= ident | QMARK )
			int alt114=4;
			switch ( input.LA(1) ) {
			case EOF:
			case K_ALLOW:
			case K_AND:
			case K_APPLY:
			case K_DELETE:
			case K_INSERT:
			case K_SET:
			case K_UPDATE:
			case K_WHERE:
			case 149:
				{
				alt114=1;
				}
				break;
			case INTEGER:
				{
				alt114=2;
				}
				break;
			case 148:
				{
				alt114=3;
				}
				break;
			case QMARK:
				{
				alt114=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}
			switch (alt114) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:5: 
					{
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:937:7: t= INTEGER
					{
					t=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_intValue5923); 
					 value = Constants.Literal.integer((t!=null?t.getText():null)); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:938:7: ':' id= ident
					{
					match(input,148,FOLLOW_148_in_intValue5937); 
					pushFollow(FOLLOW_ident_in_intValue5941);
					id=ident();
					state._fsp--;

					 value = newBindVariables(id); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:939:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_intValue5952); 
					 value = newBindVariables(null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return value;
	}
	// $ANTLR end "intValue"



	// $ANTLR start "functionName"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:942:1: functionName returns [String s] : (f= IDENT |u= unreserved_function_keyword | K_TOKEN );
	public final String functionName() throws RecognitionException {
		String s = null;


		Token f=null;
		String u =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:943:5: (f= IDENT |u= unreserved_function_keyword | K_TOKEN )
			int alt115=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt115=1;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt115=2;
				}
				break;
			case K_TOKEN:
				{
				alt115=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 115, 0, input);
				throw nvae;
			}
			switch (alt115) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:943:7: f= IDENT
					{
					f=(Token)match(input,IDENT,FOLLOW_IDENT_in_functionName5985); 
					 s = (f!=null?f.getText():null); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:944:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_functionName6019);
					u=unreserved_function_keyword();
					state._fsp--;

					 s = u; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:945:7: K_TOKEN
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_functionName6029); 
					 s = "token"; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "functionName"



	// $ANTLR start "function"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:948:1: function returns [Term.Raw t] : (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' );
	public final Term.Raw function() throws RecognitionException {
		Term.Raw t = null;


		String f =null;
		List<Term.Raw> args =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:949:5: (f= functionName '(' ')' |f= functionName '(' args= functionArgs ')' )
			int alt116=2;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA116_1 = input.LA(2);
				if ( (LA116_1==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA116_2 = input.LA(2);
				if ( (LA116_2==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA116_3 = input.LA(2);
				if ( (LA116_3==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA116_4 = input.LA(2);
				if ( (LA116_4==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA116_5 = input.LA(2);
				if ( (LA116_5==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA116_6 = input.LA(2);
				if ( (LA116_6==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA116_7 = input.LA(2);
				if ( (LA116_7==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA116_8 = input.LA(2);
				if ( (LA116_8==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA116_9 = input.LA(2);
				if ( (LA116_9==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA116_10 = input.LA(2);
				if ( (LA116_10==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA116_11 = input.LA(2);
				if ( (LA116_11==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA116_12 = input.LA(2);
				if ( (LA116_12==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA116_13 = input.LA(2);
				if ( (LA116_13==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA116_14 = input.LA(2);
				if ( (LA116_14==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA116_15 = input.LA(2);
				if ( (LA116_15==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA116_16 = input.LA(2);
				if ( (LA116_16==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA116_17 = input.LA(2);
				if ( (LA116_17==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA116_18 = input.LA(2);
				if ( (LA116_18==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TOKEN:
				{
				int LA116_19 = input.LA(2);
				if ( (LA116_19==142) ) {
					int LA116_20 = input.LA(3);
					if ( (LA116_20==143) ) {
						alt116=1;
					}
					else if ( (LA116_20==BOOLEAN||LA116_20==FLOAT||LA116_20==HEXNUMBER||(LA116_20 >= IDENT && LA116_20 <= INTEGER)||LA116_20==K_ALL||LA116_20==K_AS||LA116_20==K_ASCII||(LA116_20 >= K_BIGINT && LA116_20 <= K_BOOLEAN)||LA116_20==K_CLUSTERING||(LA116_20 >= K_COMPACT && LA116_20 <= K_CONTAINS)||LA116_20==K_COUNTER||(LA116_20 >= K_CUSTOM && LA116_20 <= K_DECIMAL)||(LA116_20 >= K_DISTINCT && LA116_20 <= K_DOUBLE)||(LA116_20 >= K_EXISTS && LA116_20 <= K_FLOAT)||LA116_20==K_FROZEN||(LA116_20 >= K_INET && LA116_20 <= K_INFINITY)||LA116_20==K_INT||LA116_20==K_KEYS||LA116_20==K_KEYSPACES||(LA116_20 >= K_LIST && LA116_20 <= K_MAP)||LA116_20==K_NAN||LA116_20==K_NOSUPERUSER||LA116_20==K_NULL||(LA116_20 >= K_PASSWORD && LA116_20 <= K_PERMISSIONS)||(LA116_20 >= K_STATIC && LA116_20 <= K_TIMEUUID)||(LA116_20 >= K_TOKEN && LA116_20 <= K_TRIGGER)||(LA116_20 >= K_TUPLE && LA116_20 <= K_TYPE)||(LA116_20 >= K_USER && LA116_20 <= K_USERS)||(LA116_20 >= K_UUID && LA116_20 <= K_VARINT)||LA116_20==QMARK||LA116_20==STRING_LITERAL||LA116_20==UUID||LA116_20==142||LA116_20==146||LA116_20==148||LA116_20==155||LA116_20==158) ) {
						alt116=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 116, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 116, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 116, 0, input);
				throw nvae;
			}
			switch (alt116) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:949:7: f= functionName '(' ')'
					{
					pushFollow(FOLLOW_functionName_in_function6076);
					f=functionName();
					state._fsp--;

					match(input,142,FOLLOW_142_in_function6078); 
					match(input,143,FOLLOW_143_in_function6080); 
					 t = new FunctionCall.Raw(f, Collections.<Term.Raw>emptyList()); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:950:7: f= functionName '(' args= functionArgs ')'
					{
					pushFollow(FOLLOW_functionName_in_function6110);
					f=functionName();
					state._fsp--;

					match(input,142,FOLLOW_142_in_function6112); 
					pushFollow(FOLLOW_functionArgs_in_function6116);
					args=functionArgs();
					state._fsp--;

					match(input,143,FOLLOW_143_in_function6118); 
					 t = new FunctionCall.Raw(f, args); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "function"



	// $ANTLR start "functionArgs"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:953:1: functionArgs returns [List<Term.Raw> args] : t1= term ( ',' tn= term )* ;
	public final List<Term.Raw> functionArgs() throws RecognitionException {
		List<Term.Raw> args = null;


		Term.Raw t1 =null;
		Term.Raw tn =null;

		 args = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:955:5: (t1= term ( ',' tn= term )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:955:7: t1= term ( ',' tn= term )*
			{
			pushFollow(FOLLOW_term_in_functionArgs6151);
			t1=term();
			state._fsp--;

			args.add(t1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:955:32: ( ',' tn= term )*
			loop117:
			while (true) {
				int alt117=2;
				int LA117_0 = input.LA(1);
				if ( (LA117_0==145) ) {
					alt117=1;
				}

				switch (alt117) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:955:34: ',' tn= term
					{
					match(input,145,FOLLOW_145_in_functionArgs6157); 
					pushFollow(FOLLOW_term_in_functionArgs6161);
					tn=term();
					state._fsp--;

					 args.add(tn); 
					}
					break;

				default :
					break loop117;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return args;
	}
	// $ANTLR end "functionArgs"



	// $ANTLR start "term"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:958:1: term returns [Term.Raw term] : (v= value |f= function | '(' c= comparatorType ')' t= term );
	public final Term.Raw term() throws RecognitionException {
		Term.Raw term = null;


		Term.Raw v =null;
		Term.Raw f =null;
		CQL3Type.Raw c =null;
		Term.Raw t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:959:5: (v= value |f= function | '(' c= comparatorType ')' t= term )
			int alt118=3;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case K_NULL:
			case QMARK:
			case STRING_LITERAL:
			case UUID:
			case 146:
			case 148:
			case 155:
			case 158:
				{
				alt118=1;
				}
				break;
			case 142:
				{
				switch ( input.LA(2) ) {
				case STRING_LITERAL:
					{
					int LA118_4 = input.LA(3);
					if ( (LA118_4==145) ) {
						alt118=1;
					}
					else if ( (LA118_4==143) ) {
						switch ( input.LA(4) ) {
						case EOF:
						case K_ALLOW:
						case K_AND:
						case K_APPLY:
						case K_DELETE:
						case K_IF:
						case K_INSERT:
						case K_LIMIT:
						case K_ORDER:
						case K_UPDATE:
						case K_WHERE:
						case 143:
						case 144:
						case 145:
						case 149:
						case 157:
						case 159:
							{
							alt118=1;
							}
							break;
						case 148:
							{
							switch ( input.LA(5) ) {
							case BOOLEAN:
							case FLOAT:
							case HEXNUMBER:
							case INTEGER:
							case K_INFINITY:
							case K_NAN:
							case K_NULL:
							case K_TOKEN:
							case QMARK:
							case STRING_LITERAL:
							case UUID:
							case 142:
							case 146:
							case 148:
							case 155:
							case 158:
								{
								alt118=1;
								}
								break;
							case IDENT:
								{
								int LA118_30 = input.LA(6);
								if ( (LA118_30==142) ) {
									alt118=1;
								}
								else if ( (LA118_30==EOF||LA118_30==K_ALLOW||(LA118_30 >= K_AND && LA118_30 <= K_APPLY)||LA118_30==K_DELETE||LA118_30==K_IF||LA118_30==K_INSERT||LA118_30==K_LIMIT||LA118_30==K_ORDER||LA118_30==K_UPDATE||LA118_30==K_WHERE||(LA118_30 >= 143 && LA118_30 <= 145)||(LA118_30 >= 148 && LA118_30 <= 149)||LA118_30==157||LA118_30==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 30, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_ALL:
							case K_AS:
							case K_CLUSTERING:
							case K_COMPACT:
							case K_CONTAINS:
							case K_CUSTOM:
							case K_DISTINCT:
							case K_EXISTS:
							case K_FILTERING:
							case K_FROZEN:
							case K_KEYS:
							case K_KEYSPACES:
							case K_LIST:
							case K_MAP:
							case K_NOSUPERUSER:
							case K_PASSWORD:
							case K_PERMISSION:
							case K_PERMISSIONS:
							case K_STATIC:
							case K_STORAGE:
							case K_SUPERUSER:
							case K_TRIGGER:
							case K_TUPLE:
							case K_TYPE:
							case K_USER:
							case K_USERS:
							case K_VALUES:
								{
								int LA118_31 = input.LA(6);
								if ( (LA118_31==142) ) {
									alt118=1;
								}
								else if ( (LA118_31==EOF||LA118_31==K_ALLOW||(LA118_31 >= K_AND && LA118_31 <= K_APPLY)||LA118_31==K_DELETE||LA118_31==K_IF||LA118_31==K_INSERT||LA118_31==K_LIMIT||LA118_31==K_ORDER||LA118_31==K_UPDATE||LA118_31==K_WHERE||(LA118_31 >= 143 && LA118_31 <= 145)||(LA118_31 >= 148 && LA118_31 <= 149)||LA118_31==157||LA118_31==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 31, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_ASCII:
								{
								int LA118_32 = input.LA(6);
								if ( (LA118_32==142) ) {
									alt118=1;
								}
								else if ( (LA118_32==EOF||LA118_32==K_ALLOW||(LA118_32 >= K_AND && LA118_32 <= K_APPLY)||LA118_32==K_DELETE||LA118_32==K_IF||LA118_32==K_INSERT||LA118_32==K_LIMIT||LA118_32==K_ORDER||LA118_32==K_UPDATE||LA118_32==K_WHERE||(LA118_32 >= 143 && LA118_32 <= 145)||(LA118_32 >= 148 && LA118_32 <= 149)||LA118_32==157||LA118_32==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 32, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BIGINT:
								{
								int LA118_33 = input.LA(6);
								if ( (LA118_33==142) ) {
									alt118=1;
								}
								else if ( (LA118_33==EOF||LA118_33==K_ALLOW||(LA118_33 >= K_AND && LA118_33 <= K_APPLY)||LA118_33==K_DELETE||LA118_33==K_IF||LA118_33==K_INSERT||LA118_33==K_LIMIT||LA118_33==K_ORDER||LA118_33==K_UPDATE||LA118_33==K_WHERE||(LA118_33 >= 143 && LA118_33 <= 145)||(LA118_33 >= 148 && LA118_33 <= 149)||LA118_33==157||LA118_33==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 33, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BLOB:
								{
								int LA118_34 = input.LA(6);
								if ( (LA118_34==142) ) {
									alt118=1;
								}
								else if ( (LA118_34==EOF||LA118_34==K_ALLOW||(LA118_34 >= K_AND && LA118_34 <= K_APPLY)||LA118_34==K_DELETE||LA118_34==K_IF||LA118_34==K_INSERT||LA118_34==K_LIMIT||LA118_34==K_ORDER||LA118_34==K_UPDATE||LA118_34==K_WHERE||(LA118_34 >= 143 && LA118_34 <= 145)||(LA118_34 >= 148 && LA118_34 <= 149)||LA118_34==157||LA118_34==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 34, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_BOOLEAN:
								{
								int LA118_35 = input.LA(6);
								if ( (LA118_35==142) ) {
									alt118=1;
								}
								else if ( (LA118_35==EOF||LA118_35==K_ALLOW||(LA118_35 >= K_AND && LA118_35 <= K_APPLY)||LA118_35==K_DELETE||LA118_35==K_IF||LA118_35==K_INSERT||LA118_35==K_LIMIT||LA118_35==K_ORDER||LA118_35==K_UPDATE||LA118_35==K_WHERE||(LA118_35 >= 143 && LA118_35 <= 145)||(LA118_35 >= 148 && LA118_35 <= 149)||LA118_35==157||LA118_35==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 35, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_COUNTER:
								{
								int LA118_36 = input.LA(6);
								if ( (LA118_36==142) ) {
									alt118=1;
								}
								else if ( (LA118_36==EOF||LA118_36==K_ALLOW||(LA118_36 >= K_AND && LA118_36 <= K_APPLY)||LA118_36==K_DELETE||LA118_36==K_IF||LA118_36==K_INSERT||LA118_36==K_LIMIT||LA118_36==K_ORDER||LA118_36==K_UPDATE||LA118_36==K_WHERE||(LA118_36 >= 143 && LA118_36 <= 145)||(LA118_36 >= 148 && LA118_36 <= 149)||LA118_36==157||LA118_36==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 36, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_DECIMAL:
								{
								int LA118_37 = input.LA(6);
								if ( (LA118_37==142) ) {
									alt118=1;
								}
								else if ( (LA118_37==EOF||LA118_37==K_ALLOW||(LA118_37 >= K_AND && LA118_37 <= K_APPLY)||LA118_37==K_DELETE||LA118_37==K_IF||LA118_37==K_INSERT||LA118_37==K_LIMIT||LA118_37==K_ORDER||LA118_37==K_UPDATE||LA118_37==K_WHERE||(LA118_37 >= 143 && LA118_37 <= 145)||(LA118_37 >= 148 && LA118_37 <= 149)||LA118_37==157||LA118_37==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 37, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_DOUBLE:
								{
								int LA118_38 = input.LA(6);
								if ( (LA118_38==142) ) {
									alt118=1;
								}
								else if ( (LA118_38==EOF||LA118_38==K_ALLOW||(LA118_38 >= K_AND && LA118_38 <= K_APPLY)||LA118_38==K_DELETE||LA118_38==K_IF||LA118_38==K_INSERT||LA118_38==K_LIMIT||LA118_38==K_ORDER||LA118_38==K_UPDATE||LA118_38==K_WHERE||(LA118_38 >= 143 && LA118_38 <= 145)||(LA118_38 >= 148 && LA118_38 <= 149)||LA118_38==157||LA118_38==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 38, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_FLOAT:
								{
								int LA118_39 = input.LA(6);
								if ( (LA118_39==142) ) {
									alt118=1;
								}
								else if ( (LA118_39==EOF||LA118_39==K_ALLOW||(LA118_39 >= K_AND && LA118_39 <= K_APPLY)||LA118_39==K_DELETE||LA118_39==K_IF||LA118_39==K_INSERT||LA118_39==K_LIMIT||LA118_39==K_ORDER||LA118_39==K_UPDATE||LA118_39==K_WHERE||(LA118_39 >= 143 && LA118_39 <= 145)||(LA118_39 >= 148 && LA118_39 <= 149)||LA118_39==157||LA118_39==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 39, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_INET:
								{
								int LA118_40 = input.LA(6);
								if ( (LA118_40==142) ) {
									alt118=1;
								}
								else if ( (LA118_40==EOF||LA118_40==K_ALLOW||(LA118_40 >= K_AND && LA118_40 <= K_APPLY)||LA118_40==K_DELETE||LA118_40==K_IF||LA118_40==K_INSERT||LA118_40==K_LIMIT||LA118_40==K_ORDER||LA118_40==K_UPDATE||LA118_40==K_WHERE||(LA118_40 >= 143 && LA118_40 <= 145)||(LA118_40 >= 148 && LA118_40 <= 149)||LA118_40==157||LA118_40==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 40, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_INT:
								{
								int LA118_41 = input.LA(6);
								if ( (LA118_41==142) ) {
									alt118=1;
								}
								else if ( (LA118_41==EOF||LA118_41==K_ALLOW||(LA118_41 >= K_AND && LA118_41 <= K_APPLY)||LA118_41==K_DELETE||LA118_41==K_IF||LA118_41==K_INSERT||LA118_41==K_LIMIT||LA118_41==K_ORDER||LA118_41==K_UPDATE||LA118_41==K_WHERE||(LA118_41 >= 143 && LA118_41 <= 145)||(LA118_41 >= 148 && LA118_41 <= 149)||LA118_41==157||LA118_41==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 41, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TEXT:
								{
								int LA118_42 = input.LA(6);
								if ( (LA118_42==142) ) {
									alt118=1;
								}
								else if ( (LA118_42==EOF||LA118_42==K_ALLOW||(LA118_42 >= K_AND && LA118_42 <= K_APPLY)||LA118_42==K_DELETE||LA118_42==K_IF||LA118_42==K_INSERT||LA118_42==K_LIMIT||LA118_42==K_ORDER||LA118_42==K_UPDATE||LA118_42==K_WHERE||(LA118_42 >= 143 && LA118_42 <= 145)||(LA118_42 >= 148 && LA118_42 <= 149)||LA118_42==157||LA118_42==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 42, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TIMESTAMP:
								{
								int LA118_43 = input.LA(6);
								if ( (LA118_43==142) ) {
									alt118=1;
								}
								else if ( (LA118_43==EOF||LA118_43==K_ALLOW||(LA118_43 >= K_AND && LA118_43 <= K_APPLY)||LA118_43==K_DELETE||LA118_43==K_IF||LA118_43==K_INSERT||LA118_43==K_LIMIT||LA118_43==K_ORDER||LA118_43==K_UPDATE||LA118_43==K_WHERE||(LA118_43 >= 143 && LA118_43 <= 145)||(LA118_43 >= 148 && LA118_43 <= 149)||LA118_43==157||LA118_43==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 43, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_UUID:
								{
								int LA118_44 = input.LA(6);
								if ( (LA118_44==142) ) {
									alt118=1;
								}
								else if ( (LA118_44==EOF||LA118_44==K_ALLOW||(LA118_44 >= K_AND && LA118_44 <= K_APPLY)||LA118_44==K_DELETE||LA118_44==K_IF||LA118_44==K_INSERT||LA118_44==K_LIMIT||LA118_44==K_ORDER||LA118_44==K_UPDATE||LA118_44==K_WHERE||(LA118_44 >= 143 && LA118_44 <= 145)||(LA118_44 >= 148 && LA118_44 <= 149)||LA118_44==157||LA118_44==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 44, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_VARCHAR:
								{
								int LA118_45 = input.LA(6);
								if ( (LA118_45==142) ) {
									alt118=1;
								}
								else if ( (LA118_45==EOF||LA118_45==K_ALLOW||(LA118_45 >= K_AND && LA118_45 <= K_APPLY)||LA118_45==K_DELETE||LA118_45==K_IF||LA118_45==K_INSERT||LA118_45==K_LIMIT||LA118_45==K_ORDER||LA118_45==K_UPDATE||LA118_45==K_WHERE||(LA118_45 >= 143 && LA118_45 <= 145)||(LA118_45 >= 148 && LA118_45 <= 149)||LA118_45==157||LA118_45==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 45, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_VARINT:
								{
								int LA118_46 = input.LA(6);
								if ( (LA118_46==142) ) {
									alt118=1;
								}
								else if ( (LA118_46==EOF||LA118_46==K_ALLOW||(LA118_46 >= K_AND && LA118_46 <= K_APPLY)||LA118_46==K_DELETE||LA118_46==K_IF||LA118_46==K_INSERT||LA118_46==K_LIMIT||LA118_46==K_ORDER||LA118_46==K_UPDATE||LA118_46==K_WHERE||(LA118_46 >= 143 && LA118_46 <= 145)||(LA118_46 >= 148 && LA118_46 <= 149)||LA118_46==157||LA118_46==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 46, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_TIMEUUID:
								{
								int LA118_47 = input.LA(6);
								if ( (LA118_47==142) ) {
									alt118=1;
								}
								else if ( (LA118_47==EOF||LA118_47==K_ALLOW||(LA118_47 >= K_AND && LA118_47 <= K_APPLY)||LA118_47==K_DELETE||LA118_47==K_IF||LA118_47==K_INSERT||LA118_47==K_LIMIT||LA118_47==K_ORDER||LA118_47==K_UPDATE||LA118_47==K_WHERE||(LA118_47 >= 143 && LA118_47 <= 145)||(LA118_47 >= 148 && LA118_47 <= 149)||LA118_47==157||LA118_47==159) ) {
									alt118=3;
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 118, 47, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

								}
								break;
							case K_COUNT:
							case K_KEY:
							case K_TTL:
							case K_WRITETIME:
							case QUOTED_NAME:
								{
								alt118=3;
								}
								break;
							default:
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 118, 29, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}
							}
							break;
						case BOOLEAN:
						case FLOAT:
						case HEXNUMBER:
						case IDENT:
						case INTEGER:
						case K_ALL:
						case K_AS:
						case K_ASCII:
						case K_BIGINT:
						case K_BLOB:
						case K_BOOLEAN:
						case K_CLUSTERING:
						case K_COMPACT:
						case K_CONTAINS:
						case K_COUNTER:
						case K_CUSTOM:
						case K_DECIMAL:
						case K_DISTINCT:
						case K_DOUBLE:
						case K_EXISTS:
						case K_FILTERING:
						case K_FLOAT:
						case K_FROZEN:
						case K_INET:
						case K_INFINITY:
						case K_INT:
						case K_KEYS:
						case K_KEYSPACES:
						case K_LIST:
						case K_MAP:
						case K_NAN:
						case K_NOSUPERUSER:
						case K_NULL:
						case K_PASSWORD:
						case K_PERMISSION:
						case K_PERMISSIONS:
						case K_STATIC:
						case K_STORAGE:
						case K_SUPERUSER:
						case K_TEXT:
						case K_TIMESTAMP:
						case K_TIMEUUID:
						case K_TOKEN:
						case K_TRIGGER:
						case K_TUPLE:
						case K_TYPE:
						case K_USER:
						case K_USERS:
						case K_UUID:
						case K_VALUES:
						case K_VARCHAR:
						case K_VARINT:
						case QMARK:
						case STRING_LITERAL:
						case UUID:
						case 142:
						case 146:
						case 155:
						case 158:
							{
							alt118=3;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 118, 28, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case BOOLEAN:
				case FLOAT:
				case HEXNUMBER:
				case INTEGER:
				case K_INFINITY:
				case K_NAN:
				case K_NULL:
				case K_TOKEN:
				case QMARK:
				case UUID:
				case 142:
				case 146:
				case 148:
				case 155:
				case 158:
					{
					alt118=1;
					}
					break;
				case IDENT:
					{
					int LA118_5 = input.LA(3);
					if ( (LA118_5==142) ) {
						alt118=1;
					}
					else if ( (LA118_5==143||LA118_5==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_MAP:
					{
					int LA118_6 = input.LA(3);
					if ( (LA118_6==143||LA118_6==147||LA118_6==150) ) {
						alt118=3;
					}
					else if ( (LA118_6==142) ) {
						alt118=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 6, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA118_7 = input.LA(3);
					if ( (LA118_7==142) ) {
						alt118=1;
					}
					else if ( (LA118_7==143||LA118_7==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 7, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA118_8 = input.LA(3);
					if ( (LA118_8==142) ) {
						alt118=1;
					}
					else if ( (LA118_8==143||LA118_8==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 8, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA118_9 = input.LA(3);
					if ( (LA118_9==142) ) {
						alt118=1;
					}
					else if ( (LA118_9==143||LA118_9==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 9, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA118_10 = input.LA(3);
					if ( (LA118_10==142) ) {
						alt118=1;
					}
					else if ( (LA118_10==143||LA118_10==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 10, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA118_11 = input.LA(3);
					if ( (LA118_11==142) ) {
						alt118=1;
					}
					else if ( (LA118_11==143||LA118_11==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 11, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA118_12 = input.LA(3);
					if ( (LA118_12==142) ) {
						alt118=1;
					}
					else if ( (LA118_12==143||LA118_12==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 12, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA118_13 = input.LA(3);
					if ( (LA118_13==142) ) {
						alt118=1;
					}
					else if ( (LA118_13==143||LA118_13==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 13, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA118_14 = input.LA(3);
					if ( (LA118_14==142) ) {
						alt118=1;
					}
					else if ( (LA118_14==143||LA118_14==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 14, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA118_15 = input.LA(3);
					if ( (LA118_15==142) ) {
						alt118=1;
					}
					else if ( (LA118_15==143||LA118_15==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 15, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA118_16 = input.LA(3);
					if ( (LA118_16==142) ) {
						alt118=1;
					}
					else if ( (LA118_16==143||LA118_16==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 16, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA118_17 = input.LA(3);
					if ( (LA118_17==142) ) {
						alt118=1;
					}
					else if ( (LA118_17==143||LA118_17==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 17, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA118_18 = input.LA(3);
					if ( (LA118_18==142) ) {
						alt118=1;
					}
					else if ( (LA118_18==143||LA118_18==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 18, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA118_19 = input.LA(3);
					if ( (LA118_19==142) ) {
						alt118=1;
					}
					else if ( (LA118_19==143||LA118_19==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 19, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA118_20 = input.LA(3);
					if ( (LA118_20==142) ) {
						alt118=1;
					}
					else if ( (LA118_20==143||LA118_20==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 20, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA118_21 = input.LA(3);
					if ( (LA118_21==142) ) {
						alt118=1;
					}
					else if ( (LA118_21==143||LA118_21==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA118_22 = input.LA(3);
					if ( (LA118_22==142) ) {
						alt118=1;
					}
					else if ( (LA118_22==143||LA118_22==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 22, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_LIST:
					{
					int LA118_23 = input.LA(3);
					if ( (LA118_23==143||LA118_23==147||LA118_23==150) ) {
						alt118=3;
					}
					else if ( (LA118_23==142) ) {
						alt118=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 23, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TUPLE:
					{
					int LA118_24 = input.LA(3);
					if ( (LA118_24==143||LA118_24==147||LA118_24==150) ) {
						alt118=3;
					}
					else if ( (LA118_24==142) ) {
						alt118=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_SET:
				case K_TTL:
				case K_WRITETIME:
				case QUOTED_NAME:
					{
					alt118=3;
					}
					break;
				case K_FROZEN:
					{
					int LA118_26 = input.LA(3);
					if ( (LA118_26==143||LA118_26==147||LA118_26==150) ) {
						alt118=3;
					}
					else if ( (LA118_26==142) ) {
						alt118=1;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 26, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_KEYS:
				case K_KEYSPACES:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA118_27 = input.LA(3);
					if ( (LA118_27==142) ) {
						alt118=1;
					}
					else if ( (LA118_27==143||LA118_27==147) ) {
						alt118=3;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 118, 27, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 118, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_ASCII:
			case K_BIGINT:
			case K_BLOB:
			case K_BOOLEAN:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNTER:
			case K_CUSTOM:
			case K_DECIMAL:
			case K_DISTINCT:
			case K_DOUBLE:
			case K_EXISTS:
			case K_FILTERING:
			case K_FLOAT:
			case K_FROZEN:
			case K_INET:
			case K_INT:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TEXT:
			case K_TIMESTAMP:
			case K_TIMEUUID:
			case K_TOKEN:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_UUID:
			case K_VALUES:
			case K_VARCHAR:
			case K_VARINT:
				{
				alt118=2;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:959:7: v= value
					{
					pushFollow(FOLLOW_value_in_term6189);
					v=value();
					state._fsp--;

					 term = v; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:960:7: f= function
					{
					pushFollow(FOLLOW_function_in_term6226);
					f=function();
					state._fsp--;

					 term = f; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:961:7: '(' c= comparatorType ')' t= term
					{
					match(input,142,FOLLOW_142_in_term6258); 
					pushFollow(FOLLOW_comparatorType_in_term6262);
					c=comparatorType();
					state._fsp--;

					match(input,143,FOLLOW_143_in_term6264); 
					pushFollow(FOLLOW_term_in_term6268);
					t=term();
					state._fsp--;

					 term = new TypeCast(c, t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return term;
	}
	// $ANTLR end "term"



	// $ANTLR start "columnOperation"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:964:1: columnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations] : key= cident columnOperationDifferentiator[operations, key] ;
	public final void columnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations) throws RecognitionException {
		ColumnIdentifier.Raw key =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:5: (key= cident columnOperationDifferentiator[operations, key] )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:965:7: key= cident columnOperationDifferentiator[operations, key]
			{
			pushFollow(FOLLOW_cident_in_columnOperation6291);
			key=cident();
			state._fsp--;

			pushFollow(FOLLOW_columnOperationDifferentiator_in_columnOperation6293);
			columnOperationDifferentiator(operations, key);
			state._fsp--;

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperation"



	// $ANTLR start "columnOperationDifferentiator"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:968:1: columnOperationDifferentiator[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] );
	public final void columnOperationDifferentiator(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Term.Raw k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:969:5: ( '=' normalColumnOperation[operations, key] | '[' k= term ']' specializedColumnOperation[operations, key, k] )
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==152) ) {
				alt119=1;
			}
			else if ( (LA119_0==155) ) {
				alt119=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 119, 0, input);
				throw nvae;
			}

			switch (alt119) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:969:7: '=' normalColumnOperation[operations, key]
					{
					match(input,152,FOLLOW_152_in_columnOperationDifferentiator6312); 
					pushFollow(FOLLOW_normalColumnOperation_in_columnOperationDifferentiator6314);
					normalColumnOperation(operations, key);
					state._fsp--;

					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:970:7: '[' k= term ']' specializedColumnOperation[operations, key, k]
					{
					match(input,155,FOLLOW_155_in_columnOperationDifferentiator6323); 
					pushFollow(FOLLOW_term_in_columnOperationDifferentiator6327);
					k=term();
					state._fsp--;

					match(input,157,FOLLOW_157_in_columnOperationDifferentiator6329); 
					pushFollow(FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator6331);
					specializedColumnOperation(operations, key, k);
					state._fsp--;

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnOperationDifferentiator"



	// $ANTLR start "normalColumnOperation"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:973:1: normalColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key] : (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER );
	public final void normalColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key) throws RecognitionException {
		Token sig=null;
		Token i=null;
		Term.Raw t =null;
		ColumnIdentifier.Raw c =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:5: (t= term ( '+' c= cident )? |c= cident sig= ( '+' | '-' ) t= term |c= cident i= INTEGER )
			int alt121=3;
			switch ( input.LA(1) ) {
			case BOOLEAN:
			case FLOAT:
			case HEXNUMBER:
			case INTEGER:
			case K_INFINITY:
			case K_NAN:
			case K_NULL:
			case K_TOKEN:
			case QMARK:
			case STRING_LITERAL:
			case UUID:
			case 142:
			case 146:
			case 148:
			case 155:
			case 158:
				{
				alt121=1;
				}
				break;
			case IDENT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ASCII:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BIGINT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BLOB:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BOOLEAN:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNTER:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DECIMAL:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DOUBLE:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_FLOAT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INET:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TEXT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMESTAMP:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_UUID:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARCHAR:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARINT:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMEUUID:
				{
				switch ( input.LA(2) ) {
				case 142:
					{
					alt121=1;
					}
					break;
				case 144:
				case 146:
					{
					alt121=2;
					}
					break;
				case INTEGER:
					{
					alt121=3;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case QUOTED_NAME:
				{
				int LA121_20 = input.LA(2);
				if ( (LA121_20==144||LA121_20==146) ) {
					alt121=2;
				}
				else if ( (LA121_20==INTEGER) ) {
					alt121=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				int LA121_21 = input.LA(2);
				if ( (LA121_21==144||LA121_21==146) ) {
					alt121=2;
				}
				else if ( (LA121_21==INTEGER) ) {
					alt121=3;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 121, 21, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}
			switch (alt121) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:7: t= term ( '+' c= cident )?
					{
					pushFollow(FOLLOW_term_in_normalColumnOperation6352);
					t=term();
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:14: ( '+' c= cident )?
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==144) ) {
						alt120=1;
					}
					switch (alt120) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:974:15: '+' c= cident
							{
							match(input,144,FOLLOW_144_in_normalColumnOperation6355); 
							pushFollow(FOLLOW_cident_in_normalColumnOperation6359);
							c=cident();
							state._fsp--;

							}
							break;

					}


					          if (c == null)
					          {
					              addRawUpdate(operations, key, new Operation.SetValue(t));
					          }
					          else
					          {
					              if (!key.equals(c))
					                  addRecognitionError("Only expressions of the form X = <value> + X are supported.");
					              addRawUpdate(operations, key, new Operation.Prepend(t));
					          }
					      
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:987:7: c= cident sig= ( '+' | '-' ) t= term
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation6380);
					c=cident();
					state._fsp--;

					sig=input.LT(1);
					if ( input.LA(1)==144||input.LA(1)==146 ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					pushFollow(FOLLOW_term_in_normalColumnOperation6394);
					t=term();
					state._fsp--;


					          if (!key.equals(c))
					              addRecognitionError("Only expressions of the form X = X " + (sig!=null?sig.getText():null) + "<value> are supported.");
					          addRawUpdate(operations, key, (sig!=null?sig.getText():null).equals("+") ? new Operation.Addition(t) : new Operation.Substraction(t));
					      
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:993:7: c= cident i= INTEGER
					{
					pushFollow(FOLLOW_cident_in_normalColumnOperation6412);
					c=cident();
					state._fsp--;

					i=(Token)match(input,INTEGER,FOLLOW_INTEGER_in_normalColumnOperation6416); 

					          // Note that this production *is* necessary because X = X - 3 will in fact be lexed as [ X, '=', X, INTEGER].
					          if (!key.equals(c))
					              // We don't yet allow a '+' in front of an integer, but we could in the future really, so let's be future-proof in our error message
					              addRecognitionError("Only expressions of the form X = X " + ((i!=null?i.getText():null).charAt(0) == '-' ? '-' : '+') + " <value> are supported.");
					          addRawUpdate(operations, key, new Operation.Addition(Constants.Literal.integer((i!=null?i.getText():null))));
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "normalColumnOperation"



	// $ANTLR start "specializedColumnOperation"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1003:1: specializedColumnOperation[List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k] : '=' t= term ;
	public final void specializedColumnOperation(List<Pair<ColumnIdentifier.Raw, Operation.RawUpdate>> operations, ColumnIdentifier.Raw key, Term.Raw k) throws RecognitionException {
		Term.Raw t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:5: ( '=' t= term )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1004:7: '=' t= term
			{
			match(input,152,FOLLOW_152_in_specializedColumnOperation6442); 
			pushFollow(FOLLOW_term_in_specializedColumnOperation6446);
			t=term();
			state._fsp--;


			          addRawUpdate(operations, key, new Operation.SetElement(k, t));
			      
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "specializedColumnOperation"



	// $ANTLR start "columnCondition"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1010:1: columnCondition[List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions] : key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) ;
	public final void columnCondition(List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions) throws RecognitionException {
		ColumnIdentifier.Raw key =null;
		Operator op =null;
		Term.Raw t =null;
		List<Term.Raw> values =null;
		AbstractMarker.INRaw marker =null;
		Term.Raw element =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:5: (key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1012:7: key= cident (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			{
			pushFollow(FOLLOW_cident_in_columnCondition6479);
			key=cident();
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1013:9: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) | '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) ) )
			int alt125=3;
			switch ( input.LA(1) ) {
			case 141:
			case 150:
			case 151:
			case 152:
			case 153:
			case 154:
				{
				alt125=1;
				}
				break;
			case K_IN:
				{
				alt125=2;
				}
				break;
			case 155:
				{
				alt125=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 125, 0, input);
				throw nvae;
			}
			switch (alt125) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1013:11: op= relationType t= term
					{
					pushFollow(FOLLOW_relationType_in_columnCondition6493);
					op=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_columnCondition6497);
					t=term();
					state._fsp--;

					 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleCondition(t, op))); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1014:11: K_IN (values= singleColumnInValues |marker= inMarker )
					{
					match(input,K_IN,FOLLOW_K_IN_in_columnCondition6511); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1015:13: (values= singleColumnInValues |marker= inMarker )
					int alt122=2;
					int LA122_0 = input.LA(1);
					if ( (LA122_0==142) ) {
						alt122=1;
					}
					else if ( (LA122_0==QMARK||LA122_0==148) ) {
						alt122=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 122, 0, input);
						throw nvae;
					}

					switch (alt122) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1015:15: values= singleColumnInValues
							{
							pushFollow(FOLLOW_singleColumnInValues_in_columnCondition6529);
							values=singleColumnInValues();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(values))); 
							}
							break;
						case 2 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1016:15: marker= inMarker
							{
							pushFollow(FOLLOW_inMarker_in_columnCondition6549);
							marker=inMarker();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.simpleInCondition(marker))); 
							}
							break;

					}

					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1018:11: '[' element= term ']' (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					{
					match(input,155,FOLLOW_155_in_columnCondition6577); 
					pushFollow(FOLLOW_term_in_columnCondition6581);
					element=term();
					state._fsp--;

					match(input,157,FOLLOW_157_in_columnCondition6583); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1019:13: (op= relationType t= term | K_IN (values= singleColumnInValues |marker= inMarker ) )
					int alt124=2;
					int LA124_0 = input.LA(1);
					if ( (LA124_0==141||(LA124_0 >= 150 && LA124_0 <= 154)) ) {
						alt124=1;
					}
					else if ( (LA124_0==K_IN) ) {
						alt124=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 124, 0, input);
						throw nvae;
					}

					switch (alt124) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1019:15: op= relationType t= term
							{
							pushFollow(FOLLOW_relationType_in_columnCondition6601);
							op=relationType();
							state._fsp--;

							pushFollow(FOLLOW_term_in_columnCondition6605);
							t=term();
							state._fsp--;

							 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionCondition(t, element, op))); 
							}
							break;
						case 2 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1020:15: K_IN (values= singleColumnInValues |marker= inMarker )
							{
							match(input,K_IN,FOLLOW_K_IN_in_columnCondition6623); 
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1021:17: (values= singleColumnInValues |marker= inMarker )
							int alt123=2;
							int LA123_0 = input.LA(1);
							if ( (LA123_0==142) ) {
								alt123=1;
							}
							else if ( (LA123_0==QMARK||LA123_0==148) ) {
								alt123=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 123, 0, input);
								throw nvae;
							}

							switch (alt123) {
								case 1 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1021:19: values= singleColumnInValues
									{
									pushFollow(FOLLOW_singleColumnInValues_in_columnCondition6645);
									values=singleColumnInValues();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, values))); 
									}
									break;
								case 2 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1022:19: marker= inMarker
									{
									pushFollow(FOLLOW_inMarker_in_columnCondition6669);
									marker=inMarker();
									state._fsp--;

									 conditions.add(Pair.create(key, ColumnCondition.Raw.collectionInCondition(element, marker))); 
									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "columnCondition"



	// $ANTLR start "properties"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1028:1: properties[PropertyDefinitions props] : property[props] ( K_AND property[props] )* ;
	public final void properties(PropertyDefinitions props) throws RecognitionException {
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:5: ( property[props] ( K_AND property[props] )* )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:7: property[props] ( K_AND property[props] )*
			{
			pushFollow(FOLLOW_property_in_properties6731);
			property(props);
			state._fsp--;

			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:23: ( K_AND property[props] )*
			loop126:
			while (true) {
				int alt126=2;
				int LA126_0 = input.LA(1);
				if ( (LA126_0==K_AND) ) {
					alt126=1;
				}

				switch (alt126) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1029:24: K_AND property[props]
					{
					match(input,K_AND,FOLLOW_K_AND_in_properties6735); 
					pushFollow(FOLLOW_property_in_properties6737);
					property(props);
					state._fsp--;

					}
					break;

				default :
					break loop126;
				}
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "properties"



	// $ANTLR start "property"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1032:1: property[PropertyDefinitions props] : (k= ident '=' simple= propertyValue |k= ident '=' map= mapLiteral );
	public final void property(PropertyDefinitions props) throws RecognitionException {
		ColumnIdentifier k =null;
		String simple =null;
		Maps.Literal map =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1033:5: (k= ident '=' simple= propertyValue |k= ident '=' map= mapLiteral )
			int alt127=2;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				int LA127_1 = input.LA(2);
				if ( (LA127_1==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case QUOTED_NAME:
				{
				int LA127_2 = input.LA(2);
				if ( (LA127_2==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				int LA127_3 = input.LA(2);
				if ( (LA127_3==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_ASCII:
				{
				int LA127_4 = input.LA(2);
				if ( (LA127_4==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA127_5 = input.LA(2);
				if ( (LA127_5==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA127_6 = input.LA(2);
				if ( (LA127_6==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA127_7 = input.LA(2);
				if ( (LA127_7==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA127_8 = input.LA(2);
				if ( (LA127_8==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA127_9 = input.LA(2);
				if ( (LA127_9==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA127_10 = input.LA(2);
				if ( (LA127_10==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA127_11 = input.LA(2);
				if ( (LA127_11==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA127_12 = input.LA(2);
				if ( (LA127_12==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA127_13 = input.LA(2);
				if ( (LA127_13==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA127_14 = input.LA(2);
				if ( (LA127_14==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA127_15 = input.LA(2);
				if ( (LA127_15==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA127_16 = input.LA(2);
				if ( (LA127_16==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA127_17 = input.LA(2);
				if ( (LA127_17==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA127_18 = input.LA(2);
				if ( (LA127_18==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA127_19 = input.LA(2);
				if ( (LA127_19==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				int LA127_20 = input.LA(2);
				if ( (LA127_20==152) ) {
					int LA127_21 = input.LA(3);
					if ( (LA127_21==BOOLEAN||LA127_21==FLOAT||LA127_21==HEXNUMBER||LA127_21==INTEGER||LA127_21==K_ALL||LA127_21==K_AS||LA127_21==K_ASCII||(LA127_21 >= K_BIGINT && LA127_21 <= K_BOOLEAN)||LA127_21==K_CLUSTERING||(LA127_21 >= K_COMPACT && LA127_21 <= K_COUNTER)||(LA127_21 >= K_CUSTOM && LA127_21 <= K_DECIMAL)||(LA127_21 >= K_DISTINCT && LA127_21 <= K_DOUBLE)||(LA127_21 >= K_EXISTS && LA127_21 <= K_FLOAT)||LA127_21==K_FROZEN||(LA127_21 >= K_INET && LA127_21 <= K_INFINITY)||LA127_21==K_INT||(LA127_21 >= K_KEY && LA127_21 <= K_KEYS)||LA127_21==K_KEYSPACES||(LA127_21 >= K_LIST && LA127_21 <= K_MAP)||LA127_21==K_NAN||LA127_21==K_NOSUPERUSER||(LA127_21 >= K_PASSWORD && LA127_21 <= K_PERMISSIONS)||(LA127_21 >= K_STATIC && LA127_21 <= K_TIMEUUID)||LA127_21==K_TRIGGER||(LA127_21 >= K_TTL && LA127_21 <= K_TYPE)||(LA127_21 >= K_USER && LA127_21 <= K_USERS)||(LA127_21 >= K_UUID && LA127_21 <= K_VARINT)||LA127_21==K_WRITETIME||LA127_21==STRING_LITERAL||LA127_21==UUID||LA127_21==146) ) {
						alt127=1;
					}
					else if ( (LA127_21==158) ) {
						alt127=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 127, 21, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 127, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 127, 0, input);
				throw nvae;
			}
			switch (alt127) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1033:7: k= ident '=' simple= propertyValue
					{
					pushFollow(FOLLOW_ident_in_property6760);
					k=ident();
					state._fsp--;

					match(input,152,FOLLOW_152_in_property6762); 
					pushFollow(FOLLOW_propertyValue_in_property6766);
					simple=propertyValue();
					state._fsp--;

					 try { props.addProperty(k.toString(), simple); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1034:7: k= ident '=' map= mapLiteral
					{
					pushFollow(FOLLOW_ident_in_property6778);
					k=ident();
					state._fsp--;

					match(input,152,FOLLOW_152_in_property6780); 
					pushFollow(FOLLOW_mapLiteral_in_property6784);
					map=mapLiteral();
					state._fsp--;

					 try { props.addProperty(k.toString(), convertPropertyMap(map)); } catch (SyntaxException e) { addRecognitionError(e.getMessage()); } 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"



	// $ANTLR start "propertyValue"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1037:1: propertyValue returns [String str] : (c= constant |u= unreserved_keyword );
	public final String propertyValue() throws RecognitionException {
		String str = null;


		Constants.Literal c =null;
		String u =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1038:5: (c= constant |u= unreserved_keyword )
			int alt128=2;
			int LA128_0 = input.LA(1);
			if ( (LA128_0==BOOLEAN||LA128_0==FLOAT||LA128_0==HEXNUMBER||LA128_0==INTEGER||LA128_0==K_INFINITY||LA128_0==K_NAN||LA128_0==STRING_LITERAL||LA128_0==UUID||LA128_0==146) ) {
				alt128=1;
			}
			else if ( (LA128_0==K_ALL||LA128_0==K_AS||LA128_0==K_ASCII||(LA128_0 >= K_BIGINT && LA128_0 <= K_BOOLEAN)||LA128_0==K_CLUSTERING||(LA128_0 >= K_COMPACT && LA128_0 <= K_COUNTER)||(LA128_0 >= K_CUSTOM && LA128_0 <= K_DECIMAL)||(LA128_0 >= K_DISTINCT && LA128_0 <= K_DOUBLE)||(LA128_0 >= K_EXISTS && LA128_0 <= K_FLOAT)||LA128_0==K_FROZEN||LA128_0==K_INET||LA128_0==K_INT||(LA128_0 >= K_KEY && LA128_0 <= K_KEYS)||LA128_0==K_KEYSPACES||(LA128_0 >= K_LIST && LA128_0 <= K_MAP)||LA128_0==K_NOSUPERUSER||(LA128_0 >= K_PASSWORD && LA128_0 <= K_PERMISSIONS)||(LA128_0 >= K_STATIC && LA128_0 <= K_TIMEUUID)||LA128_0==K_TRIGGER||(LA128_0 >= K_TTL && LA128_0 <= K_TYPE)||(LA128_0 >= K_USER && LA128_0 <= K_USERS)||(LA128_0 >= K_UUID && LA128_0 <= K_VARINT)||LA128_0==K_WRITETIME) ) {
				alt128=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 128, 0, input);
				throw nvae;
			}

			switch (alt128) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1038:7: c= constant
					{
					pushFollow(FOLLOW_constant_in_propertyValue6809);
					c=constant();
					state._fsp--;

					 str = c.getRawText(); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1039:7: u= unreserved_keyword
					{
					pushFollow(FOLLOW_unreserved_keyword_in_propertyValue6831);
					u=unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "propertyValue"



	// $ANTLR start "relationType"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1042:1: relationType returns [Operator op] : ( '=' | '<' | '<=' | '>' | '>=' | '!=' );
	public final Operator relationType() throws RecognitionException {
		Operator op = null;


		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1043:5: ( '=' | '<' | '<=' | '>' | '>=' | '!=' )
			int alt129=6;
			switch ( input.LA(1) ) {
			case 152:
				{
				alt129=1;
				}
				break;
			case 150:
				{
				alt129=2;
				}
				break;
			case 151:
				{
				alt129=3;
				}
				break;
			case 153:
				{
				alt129=4;
				}
				break;
			case 154:
				{
				alt129=5;
				}
				break;
			case 141:
				{
				alt129=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 129, 0, input);
				throw nvae;
			}
			switch (alt129) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1043:7: '='
					{
					match(input,152,FOLLOW_152_in_relationType6854); 
					 op = Operator.EQ; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1044:7: '<'
					{
					match(input,150,FOLLOW_150_in_relationType6865); 
					 op = Operator.LT; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1045:7: '<='
					{
					match(input,151,FOLLOW_151_in_relationType6876); 
					 op = Operator.LTE; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1046:7: '>'
					{
					match(input,153,FOLLOW_153_in_relationType6886); 
					 op = Operator.GT; 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1047:7: '>='
					{
					match(input,154,FOLLOW_154_in_relationType6897); 
					 op = Operator.GTE; 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1048:7: '!='
					{
					match(input,141,FOLLOW_141_in_relationType6907); 
					 op = Operator.NEQ; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return op;
	}
	// $ANTLR end "relationType"



	// $ANTLR start "relation"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1051:1: relation[List<Relation> clauses] : (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' );
	public final void relation(List<Relation> clauses) throws RecognitionException {
		ColumnIdentifier.Raw name =null;
		Operator type =null;
		Term.Raw t =null;
		List<ColumnIdentifier.Raw> l =null;
		AbstractMarker.INRaw marker =null;
		List<Term.Raw> inValues =null;
		List<ColumnIdentifier.Raw> ids =null;
		Tuples.INRaw tupleInMarker =null;
		List<Tuples.Literal> literals =null;
		List<Tuples.Raw> markers =null;
		Tuples.Literal literal =null;
		Tuples.Raw tupleMarker =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:5: (name= cident type= relationType t= term | K_TOKEN l= tupleOfIdentifiers type= relationType t= term |name= cident K_IN marker= inMarker |name= cident K_IN inValues= singleColumnInValues |name= cident K_CONTAINS ( K_KEY )? t= term |ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple ) | '(' relation[$clauses] ')' )
			int alt133=7;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case QUOTED_NAME:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_ASCII:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BIGINT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BLOB:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_BOOLEAN:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNTER:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DECIMAL:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_DOUBLE:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_FLOAT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INET:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_INT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TEXT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMESTAMP:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_UUID:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARCHAR:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_VARINT:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TIMEUUID:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 19, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_COUNT:
			case K_KEY:
			case K_TTL:
			case K_WRITETIME:
				{
				switch ( input.LA(2) ) {
				case 141:
				case 150:
				case 151:
				case 152:
				case 153:
				case 154:
					{
					alt133=1;
					}
					break;
				case K_IN:
					{
					int LA133_24 = input.LA(3);
					if ( (LA133_24==QMARK||LA133_24==148) ) {
						alt133=3;
					}
					else if ( (LA133_24==142) ) {
						alt133=4;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 24, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_CONTAINS:
					{
					alt133=5;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case K_TOKEN:
				{
				alt133=2;
				}
				break;
			case 142:
				{
				switch ( input.LA(2) ) {
				case IDENT:
					{
					int LA133_26 = input.LA(3);
					if ( (LA133_26==143||LA133_26==145) ) {
						alt133=6;
					}
					else if ( (LA133_26==K_CONTAINS||LA133_26==K_IN||LA133_26==141||(LA133_26 >= 150 && LA133_26 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 26, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case QUOTED_NAME:
					{
					int LA133_27 = input.LA(3);
					if ( (LA133_27==143||LA133_27==145) ) {
						alt133=6;
					}
					else if ( (LA133_27==K_CONTAINS||LA133_27==K_IN||LA133_27==141||(LA133_27 >= 150 && LA133_27 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 27, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ALL:
				case K_AS:
				case K_CLUSTERING:
				case K_COMPACT:
				case K_CONTAINS:
				case K_CUSTOM:
				case K_DISTINCT:
				case K_EXISTS:
				case K_FILTERING:
				case K_FROZEN:
				case K_KEYS:
				case K_KEYSPACES:
				case K_LIST:
				case K_MAP:
				case K_NOSUPERUSER:
				case K_PASSWORD:
				case K_PERMISSION:
				case K_PERMISSIONS:
				case K_STATIC:
				case K_STORAGE:
				case K_SUPERUSER:
				case K_TRIGGER:
				case K_TUPLE:
				case K_TYPE:
				case K_USER:
				case K_USERS:
				case K_VALUES:
					{
					int LA133_28 = input.LA(3);
					if ( (LA133_28==143||LA133_28==145) ) {
						alt133=6;
					}
					else if ( (LA133_28==K_CONTAINS||LA133_28==K_IN||LA133_28==141||(LA133_28 >= 150 && LA133_28 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 28, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_ASCII:
					{
					int LA133_29 = input.LA(3);
					if ( (LA133_29==143||LA133_29==145) ) {
						alt133=6;
					}
					else if ( (LA133_29==K_CONTAINS||LA133_29==K_IN||LA133_29==141||(LA133_29 >= 150 && LA133_29 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 29, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BIGINT:
					{
					int LA133_30 = input.LA(3);
					if ( (LA133_30==143||LA133_30==145) ) {
						alt133=6;
					}
					else if ( (LA133_30==K_CONTAINS||LA133_30==K_IN||LA133_30==141||(LA133_30 >= 150 && LA133_30 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 30, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BLOB:
					{
					int LA133_31 = input.LA(3);
					if ( (LA133_31==143||LA133_31==145) ) {
						alt133=6;
					}
					else if ( (LA133_31==K_CONTAINS||LA133_31==K_IN||LA133_31==141||(LA133_31 >= 150 && LA133_31 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 31, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_BOOLEAN:
					{
					int LA133_32 = input.LA(3);
					if ( (LA133_32==143||LA133_32==145) ) {
						alt133=6;
					}
					else if ( (LA133_32==K_CONTAINS||LA133_32==K_IN||LA133_32==141||(LA133_32 >= 150 && LA133_32 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 32, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNTER:
					{
					int LA133_33 = input.LA(3);
					if ( (LA133_33==143||LA133_33==145) ) {
						alt133=6;
					}
					else if ( (LA133_33==K_CONTAINS||LA133_33==K_IN||LA133_33==141||(LA133_33 >= 150 && LA133_33 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 33, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DECIMAL:
					{
					int LA133_34 = input.LA(3);
					if ( (LA133_34==143||LA133_34==145) ) {
						alt133=6;
					}
					else if ( (LA133_34==K_CONTAINS||LA133_34==K_IN||LA133_34==141||(LA133_34 >= 150 && LA133_34 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 34, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_DOUBLE:
					{
					int LA133_35 = input.LA(3);
					if ( (LA133_35==143||LA133_35==145) ) {
						alt133=6;
					}
					else if ( (LA133_35==K_CONTAINS||LA133_35==K_IN||LA133_35==141||(LA133_35 >= 150 && LA133_35 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 35, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_FLOAT:
					{
					int LA133_36 = input.LA(3);
					if ( (LA133_36==143||LA133_36==145) ) {
						alt133=6;
					}
					else if ( (LA133_36==K_CONTAINS||LA133_36==K_IN||LA133_36==141||(LA133_36 >= 150 && LA133_36 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 36, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INET:
					{
					int LA133_37 = input.LA(3);
					if ( (LA133_37==143||LA133_37==145) ) {
						alt133=6;
					}
					else if ( (LA133_37==K_CONTAINS||LA133_37==K_IN||LA133_37==141||(LA133_37 >= 150 && LA133_37 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 37, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_INT:
					{
					int LA133_38 = input.LA(3);
					if ( (LA133_38==143||LA133_38==145) ) {
						alt133=6;
					}
					else if ( (LA133_38==K_CONTAINS||LA133_38==K_IN||LA133_38==141||(LA133_38 >= 150 && LA133_38 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 38, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TEXT:
					{
					int LA133_39 = input.LA(3);
					if ( (LA133_39==143||LA133_39==145) ) {
						alt133=6;
					}
					else if ( (LA133_39==K_CONTAINS||LA133_39==K_IN||LA133_39==141||(LA133_39 >= 150 && LA133_39 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 39, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMESTAMP:
					{
					int LA133_40 = input.LA(3);
					if ( (LA133_40==143||LA133_40==145) ) {
						alt133=6;
					}
					else if ( (LA133_40==K_CONTAINS||LA133_40==K_IN||LA133_40==141||(LA133_40 >= 150 && LA133_40 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 40, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_UUID:
					{
					int LA133_41 = input.LA(3);
					if ( (LA133_41==143||LA133_41==145) ) {
						alt133=6;
					}
					else if ( (LA133_41==K_CONTAINS||LA133_41==K_IN||LA133_41==141||(LA133_41 >= 150 && LA133_41 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 41, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARCHAR:
					{
					int LA133_42 = input.LA(3);
					if ( (LA133_42==143||LA133_42==145) ) {
						alt133=6;
					}
					else if ( (LA133_42==K_CONTAINS||LA133_42==K_IN||LA133_42==141||(LA133_42 >= 150 && LA133_42 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 42, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_VARINT:
					{
					int LA133_43 = input.LA(3);
					if ( (LA133_43==143||LA133_43==145) ) {
						alt133=6;
					}
					else if ( (LA133_43==K_CONTAINS||LA133_43==K_IN||LA133_43==141||(LA133_43 >= 150 && LA133_43 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 43, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TIMEUUID:
					{
					int LA133_44 = input.LA(3);
					if ( (LA133_44==143||LA133_44==145) ) {
						alt133=6;
					}
					else if ( (LA133_44==K_CONTAINS||LA133_44==K_IN||LA133_44==141||(LA133_44 >= 150 && LA133_44 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 44, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_COUNT:
				case K_KEY:
				case K_TTL:
				case K_WRITETIME:
					{
					int LA133_45 = input.LA(3);
					if ( (LA133_45==143||LA133_45==145) ) {
						alt133=6;
					}
					else if ( (LA133_45==K_CONTAINS||LA133_45==K_IN||LA133_45==141||(LA133_45 >= 150 && LA133_45 <= 154)) ) {
						alt133=7;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 133, 45, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case K_TOKEN:
				case 142:
					{
					alt133=7;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 22, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 133, 0, input);
				throw nvae;
			}
			switch (alt133) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1052:7: name= cident type= relationType t= term
					{
					pushFollow(FOLLOW_cident_in_relation6929);
					name=cident();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation6933);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation6937);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, type, t)); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1053:7: K_TOKEN l= tupleOfIdentifiers type= relationType t= term
					{
					match(input,K_TOKEN,FOLLOW_K_TOKEN_in_relation6947); 
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation6951);
					l=tupleOfIdentifiers();
					state._fsp--;

					pushFollow(FOLLOW_relationType_in_relation6955);
					type=relationType();
					state._fsp--;

					pushFollow(FOLLOW_term_in_relation6959);
					t=term();
					state._fsp--;


					            for (ColumnIdentifier.Raw id : l)
					                clauses.add(new SingleColumnRelation(id, type, t, true));
					        
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1058:7: name= cident K_IN marker= inMarker
					{
					pushFollow(FOLLOW_cident_in_relation6979);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation6981); 
					pushFollow(FOLLOW_inMarker_in_relation6985);
					marker=inMarker();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, Operator.IN, marker)); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1060:7: name= cident K_IN inValues= singleColumnInValues
					{
					pushFollow(FOLLOW_cident_in_relation7005);
					name=cident();
					state._fsp--;

					match(input,K_IN,FOLLOW_K_IN_in_relation7007); 
					pushFollow(FOLLOW_singleColumnInValues_in_relation7011);
					inValues=singleColumnInValues();
					state._fsp--;

					 clauses.add(SingleColumnRelation.createInRelation(name, inValues)); 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1062:7: name= cident K_CONTAINS ( K_KEY )? t= term
					{
					pushFollow(FOLLOW_cident_in_relation7031);
					name=cident();
					state._fsp--;

					match(input,K_CONTAINS,FOLLOW_K_CONTAINS_in_relation7033); 
					 Operator rt = Operator.CONTAINS; 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1062:67: ( K_KEY )?
					int alt130=2;
					int LA130_0 = input.LA(1);
					if ( (LA130_0==K_KEY) ) {
						alt130=1;
					}
					switch (alt130) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1062:68: K_KEY
							{
							match(input,K_KEY,FOLLOW_K_KEY_in_relation7038); 
							 rt = Operator.CONTAINS_KEY; 
							}
							break;

					}

					pushFollow(FOLLOW_term_in_relation7054);
					t=term();
					state._fsp--;

					 clauses.add(new SingleColumnRelation(name, rt, t)); 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1064:7: ids= tupleOfIdentifiers ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					{
					pushFollow(FOLLOW_tupleOfIdentifiers_in_relation7066);
					ids=tupleOfIdentifiers();
					state._fsp--;

					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1065:7: ( K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples ) |type= relationType literal= tupleLiteral |type= relationType tupleMarker= markerForTuple )
					int alt132=3;
					switch ( input.LA(1) ) {
					case K_IN:
						{
						alt132=1;
						}
						break;
					case 152:
						{
						int LA132_2 = input.LA(2);
						if ( (LA132_2==142) ) {
							alt132=2;
						}
						else if ( (LA132_2==QMARK||LA132_2==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 150:
						{
						int LA132_3 = input.LA(2);
						if ( (LA132_3==142) ) {
							alt132=2;
						}
						else if ( (LA132_3==QMARK||LA132_3==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 151:
						{
						int LA132_4 = input.LA(2);
						if ( (LA132_4==142) ) {
							alt132=2;
						}
						else if ( (LA132_4==QMARK||LA132_4==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 153:
						{
						int LA132_5 = input.LA(2);
						if ( (LA132_5==142) ) {
							alt132=2;
						}
						else if ( (LA132_5==QMARK||LA132_5==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 154:
						{
						int LA132_6 = input.LA(2);
						if ( (LA132_6==142) ) {
							alt132=2;
						}
						else if ( (LA132_6==QMARK||LA132_6==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case 141:
						{
						int LA132_7 = input.LA(2);
						if ( (LA132_7==142) ) {
							alt132=2;
						}
						else if ( (LA132_7==QMARK||LA132_7==148) ) {
							alt132=3;
						}

						else {
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 132, 7, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 132, 0, input);
						throw nvae;
					}
					switch (alt132) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1065:9: K_IN ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							{
							match(input,K_IN,FOLLOW_K_IN_in_relation7076); 
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1066:11: ( '(' ')' |tupleInMarker= inMarkerForTuple |literals= tupleOfTupleLiterals |markers= tupleOfMarkersForTuples )
							int alt131=4;
							int LA131_0 = input.LA(1);
							if ( (LA131_0==142) ) {
								switch ( input.LA(2) ) {
								case 143:
									{
									alt131=1;
									}
									break;
								case 142:
									{
									alt131=3;
									}
									break;
								case QMARK:
								case 148:
									{
									alt131=4;
									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										input.consume();
										NoViableAltException nvae =
											new NoViableAltException("", 131, 1, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}
							else if ( (LA131_0==QMARK||LA131_0==148) ) {
								alt131=2;
							}

							else {
								NoViableAltException nvae =
									new NoViableAltException("", 131, 0, input);
								throw nvae;
							}

							switch (alt131) {
								case 1 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1066:13: '(' ')'
									{
									match(input,142,FOLLOW_142_in_relation7090); 
									match(input,143,FOLLOW_143_in_relation7092); 
									 clauses.add(MultiColumnRelation.createInRelation(ids, new ArrayList<Tuples.Literal>())); 
									}
									break;
								case 2 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1068:13: tupleInMarker= inMarkerForTuple
									{
									pushFollow(FOLLOW_inMarkerForTuple_in_relation7124);
									tupleInMarker=inMarkerForTuple();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createSingleMarkerInRelation(ids, tupleInMarker)); 
									}
									break;
								case 3 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1070:13: literals= tupleOfTupleLiterals
									{
									pushFollow(FOLLOW_tupleOfTupleLiterals_in_relation7158);
									literals=tupleOfTupleLiterals();
									state._fsp--;


									                  clauses.add(MultiColumnRelation.createInRelation(ids, literals));
									              
									}
									break;
								case 4 :
									// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1074:13: markers= tupleOfMarkersForTuples
									{
									pushFollow(FOLLOW_tupleOfMarkersForTuples_in_relation7192);
									markers=tupleOfMarkersForTuples();
									state._fsp--;

									 clauses.add(MultiColumnRelation.createInRelation(ids, markers)); 
									}
									break;

							}

							}
							break;
						case 2 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1077:9: type= relationType literal= tupleLiteral
							{
							pushFollow(FOLLOW_relationType_in_relation7234);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_tupleLiteral_in_relation7238);
							literal=tupleLiteral();
							state._fsp--;


							              clauses.add(MultiColumnRelation.createNonInRelation(ids, type, literal));
							          
							}
							break;
						case 3 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1081:9: type= relationType tupleMarker= markerForTuple
							{
							pushFollow(FOLLOW_relationType_in_relation7264);
							type=relationType();
							state._fsp--;

							pushFollow(FOLLOW_markerForTuple_in_relation7268);
							tupleMarker=markerForTuple();
							state._fsp--;

							 clauses.add(MultiColumnRelation.createNonInRelation(ids, type, tupleMarker)); 
							}
							break;

					}

					}
					break;
				case 7 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1084:7: '(' relation[$clauses] ')'
					{
					match(input,142,FOLLOW_142_in_relation7298); 
					pushFollow(FOLLOW_relation_in_relation7300);
					relation(clauses);
					state._fsp--;

					match(input,143,FOLLOW_143_in_relation7303); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "relation"



	// $ANTLR start "inMarker"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1087:1: inMarker returns [AbstractMarker.INRaw marker] : ( QMARK | ':' name= ident );
	public final AbstractMarker.INRaw inMarker() throws RecognitionException {
		AbstractMarker.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1088:5: ( QMARK | ':' name= ident )
			int alt134=2;
			int LA134_0 = input.LA(1);
			if ( (LA134_0==QMARK) ) {
				alt134=1;
			}
			else if ( (LA134_0==148) ) {
				alt134=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 134, 0, input);
				throw nvae;
			}

			switch (alt134) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1088:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarker7324); 
					 marker = newINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1089:7: ':' name= ident
					{
					match(input,148,FOLLOW_148_in_inMarker7334); 
					pushFollow(FOLLOW_ident_in_inMarker7338);
					name=ident();
					state._fsp--;

					 marker = newINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarker"



	// $ANTLR start "tupleOfIdentifiers"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1092:1: tupleOfIdentifiers returns [List<ColumnIdentifier.Raw> ids] : '(' n1= cident ( ',' ni= cident )* ')' ;
	public final List<ColumnIdentifier.Raw> tupleOfIdentifiers() throws RecognitionException {
		List<ColumnIdentifier.Raw> ids = null;


		ColumnIdentifier.Raw n1 =null;
		ColumnIdentifier.Raw ni =null;

		 ids = new ArrayList<ColumnIdentifier.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1094:5: ( '(' n1= cident ( ',' ni= cident )* ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1094:7: '(' n1= cident ( ',' ni= cident )* ')'
			{
			match(input,142,FOLLOW_142_in_tupleOfIdentifiers7370); 
			pushFollow(FOLLOW_cident_in_tupleOfIdentifiers7374);
			n1=cident();
			state._fsp--;

			 ids.add(n1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1094:39: ( ',' ni= cident )*
			loop135:
			while (true) {
				int alt135=2;
				int LA135_0 = input.LA(1);
				if ( (LA135_0==145) ) {
					alt135=1;
				}

				switch (alt135) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1094:40: ',' ni= cident
					{
					match(input,145,FOLLOW_145_in_tupleOfIdentifiers7379); 
					pushFollow(FOLLOW_cident_in_tupleOfIdentifiers7383);
					ni=cident();
					state._fsp--;

					 ids.add(ni); 
					}
					break;

				default :
					break loop135;
				}
			}

			match(input,143,FOLLOW_143_in_tupleOfIdentifiers7389); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ids;
	}
	// $ANTLR end "tupleOfIdentifiers"



	// $ANTLR start "singleColumnInValues"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1097:1: singleColumnInValues returns [List<Term.Raw> terms] : '(' (t1= term ( ',' ti= term )* )? ')' ;
	public final List<Term.Raw> singleColumnInValues() throws RecognitionException {
		List<Term.Raw> terms = null;


		Term.Raw t1 =null;
		Term.Raw ti =null;

		 terms = new ArrayList<Term.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:5: ( '(' (t1= term ( ',' ti= term )* )? ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:7: '(' (t1= term ( ',' ti= term )* )? ')'
			{
			match(input,142,FOLLOW_142_in_singleColumnInValues7419); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:11: (t1= term ( ',' ti= term )* )?
			int alt137=2;
			int LA137_0 = input.LA(1);
			if ( (LA137_0==BOOLEAN||LA137_0==FLOAT||LA137_0==HEXNUMBER||(LA137_0 >= IDENT && LA137_0 <= INTEGER)||LA137_0==K_ALL||LA137_0==K_AS||LA137_0==K_ASCII||(LA137_0 >= K_BIGINT && LA137_0 <= K_BOOLEAN)||LA137_0==K_CLUSTERING||(LA137_0 >= K_COMPACT && LA137_0 <= K_CONTAINS)||LA137_0==K_COUNTER||(LA137_0 >= K_CUSTOM && LA137_0 <= K_DECIMAL)||(LA137_0 >= K_DISTINCT && LA137_0 <= K_DOUBLE)||(LA137_0 >= K_EXISTS && LA137_0 <= K_FLOAT)||LA137_0==K_FROZEN||(LA137_0 >= K_INET && LA137_0 <= K_INFINITY)||LA137_0==K_INT||LA137_0==K_KEYS||LA137_0==K_KEYSPACES||(LA137_0 >= K_LIST && LA137_0 <= K_MAP)||LA137_0==K_NAN||LA137_0==K_NOSUPERUSER||LA137_0==K_NULL||(LA137_0 >= K_PASSWORD && LA137_0 <= K_PERMISSIONS)||(LA137_0 >= K_STATIC && LA137_0 <= K_TIMEUUID)||(LA137_0 >= K_TOKEN && LA137_0 <= K_TRIGGER)||(LA137_0 >= K_TUPLE && LA137_0 <= K_TYPE)||(LA137_0 >= K_USER && LA137_0 <= K_USERS)||(LA137_0 >= K_UUID && LA137_0 <= K_VARINT)||LA137_0==QMARK||LA137_0==STRING_LITERAL||LA137_0==UUID||LA137_0==142||LA137_0==146||LA137_0==148||LA137_0==155||LA137_0==158) ) {
				alt137=1;
			}
			switch (alt137) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:13: t1= term ( ',' ti= term )*
					{
					pushFollow(FOLLOW_term_in_singleColumnInValues7427);
					t1=term();
					state._fsp--;

					 terms.add(t1); 
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:43: ( ',' ti= term )*
					loop136:
					while (true) {
						int alt136=2;
						int LA136_0 = input.LA(1);
						if ( (LA136_0==145) ) {
							alt136=1;
						}

						switch (alt136) {
						case 1 :
							// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1099:44: ',' ti= term
							{
							match(input,145,FOLLOW_145_in_singleColumnInValues7432); 
							pushFollow(FOLLOW_term_in_singleColumnInValues7436);
							ti=term();
							state._fsp--;

							 terms.add(ti); 
							}
							break;

						default :
							break loop136;
						}
					}

					}
					break;

			}

			match(input,143,FOLLOW_143_in_singleColumnInValues7445); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return terms;
	}
	// $ANTLR end "singleColumnInValues"



	// $ANTLR start "tupleOfTupleLiterals"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1102:1: tupleOfTupleLiterals returns [List<Tuples.Literal> literals] : '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' ;
	public final List<Tuples.Literal> tupleOfTupleLiterals() throws RecognitionException {
		List<Tuples.Literal> literals = null;


		Tuples.Literal t1 =null;
		Tuples.Literal ti =null;

		 literals = new ArrayList<>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1104:5: ( '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1104:7: '(' t1= tupleLiteral ( ',' ti= tupleLiteral )* ')'
			{
			match(input,142,FOLLOW_142_in_tupleOfTupleLiterals7475); 
			pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7479);
			t1=tupleLiteral();
			state._fsp--;

			 literals.add(t1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1104:50: ( ',' ti= tupleLiteral )*
			loop138:
			while (true) {
				int alt138=2;
				int LA138_0 = input.LA(1);
				if ( (LA138_0==145) ) {
					alt138=1;
				}

				switch (alt138) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1104:51: ',' ti= tupleLiteral
					{
					match(input,145,FOLLOW_145_in_tupleOfTupleLiterals7484); 
					pushFollow(FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7488);
					ti=tupleLiteral();
					state._fsp--;

					 literals.add(ti); 
					}
					break;

				default :
					break loop138;
				}
			}

			match(input,143,FOLLOW_143_in_tupleOfTupleLiterals7494); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return literals;
	}
	// $ANTLR end "tupleOfTupleLiterals"



	// $ANTLR start "markerForTuple"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1107:1: markerForTuple returns [Tuples.Raw marker] : ( QMARK | ':' name= ident );
	public final Tuples.Raw markerForTuple() throws RecognitionException {
		Tuples.Raw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1108:5: ( QMARK | ':' name= ident )
			int alt139=2;
			int LA139_0 = input.LA(1);
			if ( (LA139_0==QMARK) ) {
				alt139=1;
			}
			else if ( (LA139_0==148) ) {
				alt139=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 139, 0, input);
				throw nvae;
			}

			switch (alt139) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1108:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_markerForTuple7515); 
					 marker = newTupleBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1109:7: ':' name= ident
					{
					match(input,148,FOLLOW_148_in_markerForTuple7525); 
					pushFollow(FOLLOW_ident_in_markerForTuple7529);
					name=ident();
					state._fsp--;

					 marker = newTupleBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "markerForTuple"



	// $ANTLR start "tupleOfMarkersForTuples"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1112:1: tupleOfMarkersForTuples returns [List<Tuples.Raw> markers] : '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' ;
	public final List<Tuples.Raw> tupleOfMarkersForTuples() throws RecognitionException {
		List<Tuples.Raw> markers = null;


		Tuples.Raw m1 =null;
		Tuples.Raw mi =null;

		 markers = new ArrayList<Tuples.Raw>(); 
		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:5: ( '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:7: '(' m1= markerForTuple ( ',' mi= markerForTuple )* ')'
			{
			match(input,142,FOLLOW_142_in_tupleOfMarkersForTuples7561); 
			pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7565);
			m1=markerForTuple();
			state._fsp--;

			 markers.add(m1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:51: ( ',' mi= markerForTuple )*
			loop140:
			while (true) {
				int alt140=2;
				int LA140_0 = input.LA(1);
				if ( (LA140_0==145) ) {
					alt140=1;
				}

				switch (alt140) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1114:52: ',' mi= markerForTuple
					{
					match(input,145,FOLLOW_145_in_tupleOfMarkersForTuples7570); 
					pushFollow(FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7574);
					mi=markerForTuple();
					state._fsp--;

					 markers.add(mi); 
					}
					break;

				default :
					break loop140;
				}
			}

			match(input,143,FOLLOW_143_in_tupleOfMarkersForTuples7580); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return markers;
	}
	// $ANTLR end "tupleOfMarkersForTuples"



	// $ANTLR start "inMarkerForTuple"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1117:1: inMarkerForTuple returns [Tuples.INRaw marker] : ( QMARK | ':' name= ident );
	public final Tuples.INRaw inMarkerForTuple() throws RecognitionException {
		Tuples.INRaw marker = null;


		ColumnIdentifier name =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1118:5: ( QMARK | ':' name= ident )
			int alt141=2;
			int LA141_0 = input.LA(1);
			if ( (LA141_0==QMARK) ) {
				alt141=1;
			}
			else if ( (LA141_0==148) ) {
				alt141=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 141, 0, input);
				throw nvae;
			}

			switch (alt141) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1118:7: QMARK
					{
					match(input,QMARK,FOLLOW_QMARK_in_inMarkerForTuple7601); 
					 marker = newTupleINBindVariables(null); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1119:7: ':' name= ident
					{
					match(input,148,FOLLOW_148_in_inMarkerForTuple7611); 
					pushFollow(FOLLOW_ident_in_inMarkerForTuple7615);
					name=ident();
					state._fsp--;

					 marker = newTupleINBindVariables(name); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return marker;
	}
	// $ANTLR end "inMarkerForTuple"



	// $ANTLR start "comparatorType"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1122:1: comparatorType returns [CQL3Type.Raw t] : (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL );
	public final CQL3Type.Raw comparatorType() throws RecognitionException {
		CQL3Type.Raw t = null;


		Token s=null;
		CQL3Type n =null;
		CQL3Type.Raw c =null;
		CQL3Type.Raw tt =null;
		UTName id =null;
		CQL3Type.Raw f =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1123:5: (n= native_type |c= collection_type |tt= tuple_type |id= userTypeName | K_FROZEN '<' f= comparatorType '>' |s= STRING_LITERAL )
			int alt142=6;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				int LA142_1 = input.LA(2);
				if ( (LA142_1==EOF||LA142_1==K_PRIMARY||LA142_1==K_STATIC||LA142_1==143||LA142_1==145||LA142_1==149||LA142_1==153) ) {
					alt142=1;
				}
				else if ( (LA142_1==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BIGINT:
				{
				int LA142_2 = input.LA(2);
				if ( (LA142_2==EOF||LA142_2==K_PRIMARY||LA142_2==K_STATIC||LA142_2==143||LA142_2==145||LA142_2==149||LA142_2==153) ) {
					alt142=1;
				}
				else if ( (LA142_2==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BLOB:
				{
				int LA142_3 = input.LA(2);
				if ( (LA142_3==EOF||LA142_3==K_PRIMARY||LA142_3==K_STATIC||LA142_3==143||LA142_3==145||LA142_3==149||LA142_3==153) ) {
					alt142=1;
				}
				else if ( (LA142_3==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 3, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_BOOLEAN:
				{
				int LA142_4 = input.LA(2);
				if ( (LA142_4==EOF||LA142_4==K_PRIMARY||LA142_4==K_STATIC||LA142_4==143||LA142_4==145||LA142_4==149||LA142_4==153) ) {
					alt142=1;
				}
				else if ( (LA142_4==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 4, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_COUNTER:
				{
				int LA142_5 = input.LA(2);
				if ( (LA142_5==EOF||LA142_5==K_PRIMARY||LA142_5==K_STATIC||LA142_5==143||LA142_5==145||LA142_5==149||LA142_5==153) ) {
					alt142=1;
				}
				else if ( (LA142_5==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 5, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DECIMAL:
				{
				int LA142_6 = input.LA(2);
				if ( (LA142_6==EOF||LA142_6==K_PRIMARY||LA142_6==K_STATIC||LA142_6==143||LA142_6==145||LA142_6==149||LA142_6==153) ) {
					alt142=1;
				}
				else if ( (LA142_6==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 6, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_DOUBLE:
				{
				int LA142_7 = input.LA(2);
				if ( (LA142_7==EOF||LA142_7==K_PRIMARY||LA142_7==K_STATIC||LA142_7==143||LA142_7==145||LA142_7==149||LA142_7==153) ) {
					alt142=1;
				}
				else if ( (LA142_7==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 7, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_FLOAT:
				{
				int LA142_8 = input.LA(2);
				if ( (LA142_8==EOF||LA142_8==K_PRIMARY||LA142_8==K_STATIC||LA142_8==143||LA142_8==145||LA142_8==149||LA142_8==153) ) {
					alt142=1;
				}
				else if ( (LA142_8==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 8, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INET:
				{
				int LA142_9 = input.LA(2);
				if ( (LA142_9==EOF||LA142_9==K_PRIMARY||LA142_9==K_STATIC||LA142_9==143||LA142_9==145||LA142_9==149||LA142_9==153) ) {
					alt142=1;
				}
				else if ( (LA142_9==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_INT:
				{
				int LA142_10 = input.LA(2);
				if ( (LA142_10==EOF||LA142_10==K_PRIMARY||LA142_10==K_STATIC||LA142_10==143||LA142_10==145||LA142_10==149||LA142_10==153) ) {
					alt142=1;
				}
				else if ( (LA142_10==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TEXT:
				{
				int LA142_11 = input.LA(2);
				if ( (LA142_11==EOF||LA142_11==K_PRIMARY||LA142_11==K_STATIC||LA142_11==143||LA142_11==145||LA142_11==149||LA142_11==153) ) {
					alt142=1;
				}
				else if ( (LA142_11==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMESTAMP:
				{
				int LA142_12 = input.LA(2);
				if ( (LA142_12==EOF||LA142_12==K_PRIMARY||LA142_12==K_STATIC||LA142_12==143||LA142_12==145||LA142_12==149||LA142_12==153) ) {
					alt142=1;
				}
				else if ( (LA142_12==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 12, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_UUID:
				{
				int LA142_13 = input.LA(2);
				if ( (LA142_13==EOF||LA142_13==K_PRIMARY||LA142_13==K_STATIC||LA142_13==143||LA142_13==145||LA142_13==149||LA142_13==153) ) {
					alt142=1;
				}
				else if ( (LA142_13==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 13, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARCHAR:
				{
				int LA142_14 = input.LA(2);
				if ( (LA142_14==EOF||LA142_14==K_PRIMARY||LA142_14==K_STATIC||LA142_14==143||LA142_14==145||LA142_14==149||LA142_14==153) ) {
					alt142=1;
				}
				else if ( (LA142_14==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 14, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_VARINT:
				{
				int LA142_15 = input.LA(2);
				if ( (LA142_15==EOF||LA142_15==K_PRIMARY||LA142_15==K_STATIC||LA142_15==143||LA142_15==145||LA142_15==149||LA142_15==153) ) {
					alt142=1;
				}
				else if ( (LA142_15==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 15, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_TIMEUUID:
				{
				int LA142_16 = input.LA(2);
				if ( (LA142_16==EOF||LA142_16==K_PRIMARY||LA142_16==K_STATIC||LA142_16==143||LA142_16==145||LA142_16==149||LA142_16==153) ) {
					alt142=1;
				}
				else if ( (LA142_16==147) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 16, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_MAP:
				{
				int LA142_17 = input.LA(2);
				if ( (LA142_17==150) ) {
					alt142=2;
				}
				else if ( (LA142_17==EOF||LA142_17==K_PRIMARY||LA142_17==K_STATIC||LA142_17==143||LA142_17==145||LA142_17==147||LA142_17==149||LA142_17==153) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 17, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_LIST:
				{
				int LA142_18 = input.LA(2);
				if ( (LA142_18==150) ) {
					alt142=2;
				}
				else if ( (LA142_18==EOF||LA142_18==K_PRIMARY||LA142_18==K_STATIC||LA142_18==143||LA142_18==145||LA142_18==147||LA142_18==149||LA142_18==153) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 18, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case K_SET:
				{
				alt142=2;
				}
				break;
			case K_TUPLE:
				{
				int LA142_20 = input.LA(2);
				if ( (LA142_20==150) ) {
					alt142=3;
				}
				else if ( (LA142_20==EOF||LA142_20==K_PRIMARY||LA142_20==K_STATIC||LA142_20==143||LA142_20==145||LA142_20==147||LA142_20==149||LA142_20==153) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 20, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case IDENT:
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_COUNT:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_KEY:
			case K_KEYS:
			case K_KEYSPACES:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TTL:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
			case K_WRITETIME:
			case QUOTED_NAME:
				{
				alt142=4;
				}
				break;
			case K_FROZEN:
				{
				int LA142_22 = input.LA(2);
				if ( (LA142_22==150) ) {
					alt142=5;
				}
				else if ( (LA142_22==EOF||LA142_22==K_PRIMARY||LA142_22==K_STATIC||LA142_22==143||LA142_22==145||LA142_22==147||LA142_22==149||LA142_22==153) ) {
					alt142=4;
				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 142, 22, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			case STRING_LITERAL:
				{
				alt142=6;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 142, 0, input);
				throw nvae;
			}
			switch (alt142) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1123:7: n= native_type
					{
					pushFollow(FOLLOW_native_type_in_comparatorType7640);
					n=native_type();
					state._fsp--;

					 t = CQL3Type.Raw.from(n); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1124:7: c= collection_type
					{
					pushFollow(FOLLOW_collection_type_in_comparatorType7656);
					c=collection_type();
					state._fsp--;

					 t = c; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1125:7: tt= tuple_type
					{
					pushFollow(FOLLOW_tuple_type_in_comparatorType7668);
					tt=tuple_type();
					state._fsp--;

					 t = tt; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1126:7: id= userTypeName
					{
					pushFollow(FOLLOW_userTypeName_in_comparatorType7684);
					id=userTypeName();
					state._fsp--;

					 t = CQL3Type.Raw.userType(id); 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1127:7: K_FROZEN '<' f= comparatorType '>'
					{
					match(input,K_FROZEN,FOLLOW_K_FROZEN_in_comparatorType7696); 
					match(input,150,FOLLOW_150_in_comparatorType7698); 
					pushFollow(FOLLOW_comparatorType_in_comparatorType7702);
					f=comparatorType();
					state._fsp--;

					match(input,153,FOLLOW_153_in_comparatorType7704); 

					        try {
					            t = CQL3Type.Raw.frozen(f);
					        } catch (InvalidRequestException e) {
					            addRecognitionError(e.getMessage());
					        }
					      
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1135:7: s= STRING_LITERAL
					{
					s=(Token)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_comparatorType7722); 

					        try {
					            t = CQL3Type.Raw.from(new CQL3Type.Custom((s!=null?s.getText():null)));
					        } catch (SyntaxException e) {
					            addRecognitionError("Cannot parse type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        } catch (ConfigurationException e) {
					            addRecognitionError("Error setting type " + (s!=null?s.getText():null) + ": " + e.getMessage());
					        }
					      
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "comparatorType"



	// $ANTLR start "native_type"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1147:1: native_type returns [CQL3Type t] : ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID );
	public final CQL3Type native_type() throws RecognitionException {
		CQL3Type t = null;


		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:5: ( K_ASCII | K_BIGINT | K_BLOB | K_BOOLEAN | K_COUNTER | K_DECIMAL | K_DOUBLE | K_FLOAT | K_INET | K_INT | K_TEXT | K_TIMESTAMP | K_UUID | K_VARCHAR | K_VARINT | K_TIMEUUID )
			int alt143=16;
			switch ( input.LA(1) ) {
			case K_ASCII:
				{
				alt143=1;
				}
				break;
			case K_BIGINT:
				{
				alt143=2;
				}
				break;
			case K_BLOB:
				{
				alt143=3;
				}
				break;
			case K_BOOLEAN:
				{
				alt143=4;
				}
				break;
			case K_COUNTER:
				{
				alt143=5;
				}
				break;
			case K_DECIMAL:
				{
				alt143=6;
				}
				break;
			case K_DOUBLE:
				{
				alt143=7;
				}
				break;
			case K_FLOAT:
				{
				alt143=8;
				}
				break;
			case K_INET:
				{
				alt143=9;
				}
				break;
			case K_INT:
				{
				alt143=10;
				}
				break;
			case K_TEXT:
				{
				alt143=11;
				}
				break;
			case K_TIMESTAMP:
				{
				alt143=12;
				}
				break;
			case K_UUID:
				{
				alt143=13;
				}
				break;
			case K_VARCHAR:
				{
				alt143=14;
				}
				break;
			case K_VARINT:
				{
				alt143=15;
				}
				break;
			case K_TIMEUUID:
				{
				alt143=16;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 143, 0, input);
				throw nvae;
			}
			switch (alt143) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1148:7: K_ASCII
					{
					match(input,K_ASCII,FOLLOW_K_ASCII_in_native_type7751); 
					 t = CQL3Type.Native.ASCII; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1149:7: K_BIGINT
					{
					match(input,K_BIGINT,FOLLOW_K_BIGINT_in_native_type7765); 
					 t = CQL3Type.Native.BIGINT; 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1150:7: K_BLOB
					{
					match(input,K_BLOB,FOLLOW_K_BLOB_in_native_type7778); 
					 t = CQL3Type.Native.BLOB; 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1151:7: K_BOOLEAN
					{
					match(input,K_BOOLEAN,FOLLOW_K_BOOLEAN_in_native_type7793); 
					 t = CQL3Type.Native.BOOLEAN; 
					}
					break;
				case 5 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1152:7: K_COUNTER
					{
					match(input,K_COUNTER,FOLLOW_K_COUNTER_in_native_type7805); 
					 t = CQL3Type.Native.COUNTER; 
					}
					break;
				case 6 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1153:7: K_DECIMAL
					{
					match(input,K_DECIMAL,FOLLOW_K_DECIMAL_in_native_type7817); 
					 t = CQL3Type.Native.DECIMAL; 
					}
					break;
				case 7 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1154:7: K_DOUBLE
					{
					match(input,K_DOUBLE,FOLLOW_K_DOUBLE_in_native_type7829); 
					 t = CQL3Type.Native.DOUBLE; 
					}
					break;
				case 8 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1155:7: K_FLOAT
					{
					match(input,K_FLOAT,FOLLOW_K_FLOAT_in_native_type7842); 
					 t = CQL3Type.Native.FLOAT; 
					}
					break;
				case 9 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1156:7: K_INET
					{
					match(input,K_INET,FOLLOW_K_INET_in_native_type7856); 
					 t = CQL3Type.Native.INET;
					}
					break;
				case 10 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1157:7: K_INT
					{
					match(input,K_INT,FOLLOW_K_INT_in_native_type7871); 
					 t = CQL3Type.Native.INT; 
					}
					break;
				case 11 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1158:7: K_TEXT
					{
					match(input,K_TEXT,FOLLOW_K_TEXT_in_native_type7887); 
					 t = CQL3Type.Native.TEXT; 
					}
					break;
				case 12 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1159:7: K_TIMESTAMP
					{
					match(input,K_TIMESTAMP,FOLLOW_K_TIMESTAMP_in_native_type7902); 
					 t = CQL3Type.Native.TIMESTAMP; 
					}
					break;
				case 13 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1160:7: K_UUID
					{
					match(input,K_UUID,FOLLOW_K_UUID_in_native_type7912); 
					 t = CQL3Type.Native.UUID; 
					}
					break;
				case 14 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1161:7: K_VARCHAR
					{
					match(input,K_VARCHAR,FOLLOW_K_VARCHAR_in_native_type7927); 
					 t = CQL3Type.Native.VARCHAR; 
					}
					break;
				case 15 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1162:7: K_VARINT
					{
					match(input,K_VARINT,FOLLOW_K_VARINT_in_native_type7939); 
					 t = CQL3Type.Native.VARINT; 
					}
					break;
				case 16 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1163:7: K_TIMEUUID
					{
					match(input,K_TIMEUUID,FOLLOW_K_TIMEUUID_in_native_type7952); 
					 t = CQL3Type.Native.TIMEUUID; 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "native_type"



	// $ANTLR start "collection_type"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1166:1: collection_type returns [CQL3Type.Raw pt] : ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' );
	public final CQL3Type.Raw collection_type() throws RecognitionException {
		CQL3Type.Raw pt = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw t2 =null;
		CQL3Type.Raw t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1167:5: ( K_MAP '<' t1= comparatorType ',' t2= comparatorType '>' | K_LIST '<' t= comparatorType '>' | K_SET '<' t= comparatorType '>' )
			int alt144=3;
			switch ( input.LA(1) ) {
			case K_MAP:
				{
				alt144=1;
				}
				break;
			case K_LIST:
				{
				alt144=2;
				}
				break;
			case K_SET:
				{
				alt144=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}
			switch (alt144) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1167:7: K_MAP '<' t1= comparatorType ',' t2= comparatorType '>'
					{
					match(input,K_MAP,FOLLOW_K_MAP_in_collection_type7976); 
					match(input,150,FOLLOW_150_in_collection_type7979); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7983);
					t1=comparatorType();
					state._fsp--;

					match(input,145,FOLLOW_145_in_collection_type7985); 
					pushFollow(FOLLOW_comparatorType_in_collection_type7989);
					t2=comparatorType();
					state._fsp--;

					match(input,153,FOLLOW_153_in_collection_type7991); 

					            // if we can't parse either t1 or t2, antlr will "recover" and we may have t1 or t2 null.
					            if (t1 != null && t2 != null)
					                pt = CQL3Type.Raw.map(t1, t2);
					        
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1173:7: K_LIST '<' t= comparatorType '>'
					{
					match(input,K_LIST,FOLLOW_K_LIST_in_collection_type8009); 
					match(input,150,FOLLOW_150_in_collection_type8011); 
					pushFollow(FOLLOW_comparatorType_in_collection_type8015);
					t=comparatorType();
					state._fsp--;

					match(input,153,FOLLOW_153_in_collection_type8017); 
					 if (t != null) pt = CQL3Type.Raw.list(t); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1175:7: K_SET '<' t= comparatorType '>'
					{
					match(input,K_SET,FOLLOW_K_SET_in_collection_type8035); 
					match(input,150,FOLLOW_150_in_collection_type8038); 
					pushFollow(FOLLOW_comparatorType_in_collection_type8042);
					t=comparatorType();
					state._fsp--;

					match(input,153,FOLLOW_153_in_collection_type8044); 
					 if (t != null) pt = CQL3Type.Raw.set(t); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pt;
	}
	// $ANTLR end "collection_type"



	// $ANTLR start "tuple_type"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1179:1: tuple_type returns [CQL3Type.Raw t] : K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' ;
	public final CQL3Type.Raw tuple_type() throws RecognitionException {
		CQL3Type.Raw t = null;


		CQL3Type.Raw t1 =null;
		CQL3Type.Raw tn =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1180:5: ( K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>' )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1180:7: K_TUPLE '<' t1= comparatorType ( ',' tn= comparatorType )* '>'
			{
			match(input,K_TUPLE,FOLLOW_K_TUPLE_in_tuple_type8075); 
			match(input,150,FOLLOW_150_in_tuple_type8077); 
			 List<CQL3Type.Raw> types = new ArrayList<>(); 
			pushFollow(FOLLOW_comparatorType_in_tuple_type8092);
			t1=comparatorType();
			state._fsp--;

			 types.add(t1); 
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1181:47: ( ',' tn= comparatorType )*
			loop145:
			while (true) {
				int alt145=2;
				int LA145_0 = input.LA(1);
				if ( (LA145_0==145) ) {
					alt145=1;
				}

				switch (alt145) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1181:48: ',' tn= comparatorType
					{
					match(input,145,FOLLOW_145_in_tuple_type8097); 
					pushFollow(FOLLOW_comparatorType_in_tuple_type8101);
					tn=comparatorType();
					state._fsp--;

					 types.add(tn); 
					}
					break;

				default :
					break loop145;
				}
			}

			match(input,153,FOLLOW_153_in_tuple_type8113); 
			 t = CQL3Type.Raw.tuple(types); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return t;
	}
	// $ANTLR end "tuple_type"


	public static class username_return extends ParserRuleReturnScope {
	};


	// $ANTLR start "username"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1185:1: username : ( IDENT | STRING_LITERAL );
	public final CqlParser.username_return username() throws RecognitionException {
		CqlParser.username_return retval = new CqlParser.username_return();
		retval.start = input.LT(1);

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1186:5: ( IDENT | STRING_LITERAL )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:
			{
			if ( input.LA(1)==IDENT||input.LA(1)==STRING_LITERAL ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "username"



	// $ANTLR start "non_type_ident"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1192:1: non_type_ident returns [ColumnIdentifier id] : (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY );
	public final ColumnIdentifier non_type_ident() throws RecognitionException {
		ColumnIdentifier id = null;


		Token t=null;
		Token kk=null;
		String k =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:5: (t= IDENT |t= QUOTED_NAME |k= basic_unreserved_keyword |kk= K_KEY )
			int alt146=4;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt146=1;
				}
				break;
			case QUOTED_NAME:
				{
				alt146=2;
				}
				break;
			case K_ALL:
			case K_AS:
			case K_CLUSTERING:
			case K_COMPACT:
			case K_CONTAINS:
			case K_CUSTOM:
			case K_DISTINCT:
			case K_EXISTS:
			case K_FILTERING:
			case K_FROZEN:
			case K_KEYS:
			case K_KEYSPACES:
			case K_LIST:
			case K_MAP:
			case K_NOSUPERUSER:
			case K_PASSWORD:
			case K_PERMISSION:
			case K_PERMISSIONS:
			case K_STATIC:
			case K_STORAGE:
			case K_SUPERUSER:
			case K_TRIGGER:
			case K_TUPLE:
			case K_TYPE:
			case K_USER:
			case K_USERS:
			case K_VALUES:
				{
				alt146=3;
				}
				break;
			case K_KEY:
				{
				alt146=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 146, 0, input);
				throw nvae;
			}
			switch (alt146) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1193:7: t= IDENT
					{
					t=(Token)match(input,IDENT,FOLLOW_IDENT_in_non_type_ident8165); 
					 if (reservedTypeNames.contains((t!=null?t.getText():null))) addRecognitionError("Invalid (reserved) user type name " + (t!=null?t.getText():null)); id = new ColumnIdentifier((t!=null?t.getText():null), false); 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1194:7: t= QUOTED_NAME
					{
					t=(Token)match(input,QUOTED_NAME,FOLLOW_QUOTED_NAME_in_non_type_ident8196); 
					 id = new ColumnIdentifier((t!=null?t.getText():null), true); 
					}
					break;
				case 3 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1195:7: k= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_non_type_ident8221);
					k=basic_unreserved_keyword();
					state._fsp--;

					 id = new ColumnIdentifier(k, false); 
					}
					break;
				case 4 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1196:7: kk= K_KEY
					{
					kk=(Token)match(input,K_KEY,FOLLOW_K_KEY_in_non_type_ident8233); 
					 id = new ColumnIdentifier((kk!=null?kk.getText():null), false); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return id;
	}
	// $ANTLR end "non_type_ident"



	// $ANTLR start "unreserved_keyword"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1199:1: unreserved_keyword returns [String str] : (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) );
	public final String unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;
		String u =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1200:5: (u= unreserved_function_keyword |k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY ) )
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==K_ALL||LA147_0==K_AS||LA147_0==K_ASCII||(LA147_0 >= K_BIGINT && LA147_0 <= K_BOOLEAN)||LA147_0==K_CLUSTERING||(LA147_0 >= K_COMPACT && LA147_0 <= K_CONTAINS)||LA147_0==K_COUNTER||(LA147_0 >= K_CUSTOM && LA147_0 <= K_DECIMAL)||(LA147_0 >= K_DISTINCT && LA147_0 <= K_DOUBLE)||(LA147_0 >= K_EXISTS && LA147_0 <= K_FLOAT)||LA147_0==K_FROZEN||LA147_0==K_INET||LA147_0==K_INT||LA147_0==K_KEYS||LA147_0==K_KEYSPACES||(LA147_0 >= K_LIST && LA147_0 <= K_MAP)||LA147_0==K_NOSUPERUSER||(LA147_0 >= K_PASSWORD && LA147_0 <= K_PERMISSIONS)||(LA147_0 >= K_STATIC && LA147_0 <= K_TIMEUUID)||LA147_0==K_TRIGGER||(LA147_0 >= K_TUPLE && LA147_0 <= K_TYPE)||(LA147_0 >= K_USER && LA147_0 <= K_USERS)||(LA147_0 >= K_UUID && LA147_0 <= K_VARINT)) ) {
				alt147=1;
			}
			else if ( (LA147_0==K_COUNT||LA147_0==K_KEY||LA147_0==K_TTL||LA147_0==K_WRITETIME) ) {
				alt147=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 147, 0, input);
				throw nvae;
			}

			switch (alt147) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1200:7: u= unreserved_function_keyword
					{
					pushFollow(FOLLOW_unreserved_function_keyword_in_unreserved_keyword8276);
					u=unreserved_function_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1201:7: k= ( K_TTL | K_COUNT | K_WRITETIME | K_KEY )
					{
					k=input.LT(1);
					if ( input.LA(1)==K_COUNT||input.LA(1)==K_KEY||input.LA(1)==K_TTL||input.LA(1)==K_WRITETIME ) {
						input.consume();
						state.errorRecovery=false;
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						throw mse;
					}
					 str = (k!=null?k.getText():null); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_keyword"



	// $ANTLR start "unreserved_function_keyword"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1204:1: unreserved_function_keyword returns [String str] : (u= basic_unreserved_keyword |t= native_type );
	public final String unreserved_function_keyword() throws RecognitionException {
		String str = null;


		String u =null;
		CQL3Type t =null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1205:5: (u= basic_unreserved_keyword |t= native_type )
			int alt148=2;
			int LA148_0 = input.LA(1);
			if ( (LA148_0==K_ALL||LA148_0==K_AS||LA148_0==K_CLUSTERING||(LA148_0 >= K_COMPACT && LA148_0 <= K_CONTAINS)||LA148_0==K_CUSTOM||LA148_0==K_DISTINCT||(LA148_0 >= K_EXISTS && LA148_0 <= K_FILTERING)||LA148_0==K_FROZEN||LA148_0==K_KEYS||LA148_0==K_KEYSPACES||(LA148_0 >= K_LIST && LA148_0 <= K_MAP)||LA148_0==K_NOSUPERUSER||(LA148_0 >= K_PASSWORD && LA148_0 <= K_PERMISSIONS)||(LA148_0 >= K_STATIC && LA148_0 <= K_SUPERUSER)||LA148_0==K_TRIGGER||(LA148_0 >= K_TUPLE && LA148_0 <= K_TYPE)||(LA148_0 >= K_USER && LA148_0 <= K_USERS)||LA148_0==K_VALUES) ) {
				alt148=1;
			}
			else if ( (LA148_0==K_ASCII||(LA148_0 >= K_BIGINT && LA148_0 <= K_BOOLEAN)||LA148_0==K_COUNTER||LA148_0==K_DECIMAL||LA148_0==K_DOUBLE||LA148_0==K_FLOAT||LA148_0==K_INET||LA148_0==K_INT||(LA148_0 >= K_TEXT && LA148_0 <= K_TIMEUUID)||LA148_0==K_UUID||(LA148_0 >= K_VARCHAR && LA148_0 <= K_VARINT)) ) {
				alt148=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 148, 0, input);
				throw nvae;
			}

			switch (alt148) {
				case 1 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1205:7: u= basic_unreserved_keyword
					{
					pushFollow(FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword8331);
					u=basic_unreserved_keyword();
					state._fsp--;

					 str = u; 
					}
					break;
				case 2 :
					// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1206:7: t= native_type
					{
					pushFollow(FOLLOW_native_type_in_unreserved_function_keyword8343);
					t=native_type();
					state._fsp--;

					 str = t.toString(); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "unreserved_function_keyword"



	// $ANTLR start "basic_unreserved_keyword"
	// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1209:1: basic_unreserved_keyword returns [String str] : k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE ) ;
	public final String basic_unreserved_keyword() throws RecognitionException {
		String str = null;


		Token k=null;

		try {
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1210:5: (k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE ) )
			// /tmp/tmp.7xEBtuOBsR/cassandra/src/java/org/apache/cassandra/cql3/Cql.g:1210:7: k= ( K_KEYS | K_AS | K_CLUSTERING | K_COMPACT | K_STORAGE | K_TYPE | K_VALUES | K_MAP | K_LIST | K_FILTERING | K_PERMISSION | K_PERMISSIONS | K_KEYSPACES | K_ALL | K_USER | K_USERS | K_SUPERUSER | K_NOSUPERUSER | K_PASSWORD | K_EXISTS | K_CUSTOM | K_TRIGGER | K_DISTINCT | K_CONTAINS | K_STATIC | K_FROZEN | K_TUPLE )
			{
			k=input.LT(1);
			if ( input.LA(1)==K_ALL||input.LA(1)==K_AS||input.LA(1)==K_CLUSTERING||(input.LA(1) >= K_COMPACT && input.LA(1) <= K_CONTAINS)||input.LA(1)==K_CUSTOM||input.LA(1)==K_DISTINCT||(input.LA(1) >= K_EXISTS && input.LA(1) <= K_FILTERING)||input.LA(1)==K_FROZEN||input.LA(1)==K_KEYS||input.LA(1)==K_KEYSPACES||(input.LA(1) >= K_LIST && input.LA(1) <= K_MAP)||input.LA(1)==K_NOSUPERUSER||(input.LA(1) >= K_PASSWORD && input.LA(1) <= K_PERMISSIONS)||(input.LA(1) >= K_STATIC && input.LA(1) <= K_SUPERUSER)||input.LA(1)==K_TRIGGER||(input.LA(1) >= K_TUPLE && input.LA(1) <= K_TYPE)||(input.LA(1) >= K_USER && input.LA(1) <= K_USERS)||input.LA(1)==K_VALUES ) {
				input.consume();
				state.errorRecovery=false;
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			 str = (k!=null?k.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return str;
	}
	// $ANTLR end "basic_unreserved_keyword"

	// Delegated rules



	public static final BitSet FOLLOW_cqlStatement_in_query72 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_query75 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_EOF_in_query79 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selectStatement_in_cqlStatement113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_cqlStatement138 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_cqlStatement163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_batchStatement_in_cqlStatement188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_cqlStatement214 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_useStatement_in_cqlStatement239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_truncateStatement_in_cqlStatement267 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createKeyspaceStatement_in_cqlStatement290 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTableStatement_in_cqlStatement307 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createIndexStatement_in_cqlStatement326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropKeyspaceStatement_in_cqlStatement345 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTableStatement_in_cqlStatement363 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropIndexStatement_in_cqlStatement384 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTableStatement_in_cqlStatement405 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterKeyspaceStatement_in_cqlStatement425 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_grantStatement_in_cqlStatement442 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_revokeStatement_in_cqlStatement467 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listPermissionsStatement_in_cqlStatement491 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createUserStatement_in_cqlStatement506 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterUserStatement_in_cqlStatement526 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropUserStatement_in_cqlStatement547 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_listUsersStatement_in_cqlStatement569 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTriggerStatement_in_cqlStatement590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTriggerStatement_in_cqlStatement607 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_createTypeStatement_in_cqlStatement626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_alterTypeStatement_in_cqlStatement646 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dropTypeStatement_in_cqlStatement667 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USE_in_useStatement702 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_keyspaceName_in_useStatement706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SELECT_in_selectStatement740 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000010000001L});
	public static final BitSet FOLLOW_K_DISTINCT_in_selectStatement746 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000010000001L});
	public static final BitSet FOLLOW_selectClause_in_selectStatement755 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_COUNT_in_selectStatement775 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_selectStatement777 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_selectCountClause_in_selectStatement781 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_selectStatement783 = new BitSet(new long[]{0x0200000040000000L});
	public static final BitSet FOLLOW_K_AS_in_selectStatement788 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_selectStatement792 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_selectStatement807 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_selectStatement811 = new BitSet(new long[]{0x0000000004000002L,0x0010000000100200L});
	public static final BitSet FOLLOW_K_WHERE_in_selectStatement821 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_whereClause_in_selectStatement825 = new BitSet(new long[]{0x0000000004000002L,0x0000000000100200L});
	public static final BitSet FOLLOW_K_ORDER_in_selectStatement838 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_K_BY_in_selectStatement840 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement842 = new BitSet(new long[]{0x0000000004000002L,0x0000000000000200L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_selectStatement847 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_orderByClause_in_selectStatement849 = new BitSet(new long[]{0x0000000004000002L,0x0000000000000200L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_LIMIT_in_selectStatement866 = new BitSet(new long[]{0x0000000004200000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_intValue_in_selectStatement870 = new BitSet(new long[]{0x0000000004000002L});
	public static final BitSet FOLLOW_K_ALLOW_in_selectStatement885 = new BitSet(new long[]{0x0080000000000000L});
	public static final BitSet FOLLOW_K_FILTERING_in_selectStatement887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_selector_in_selectClause924 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_selectClause929 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_selector_in_selectClause933 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_156_in_selectClause945 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selector978 = new BitSet(new long[]{0x0000000040000002L});
	public static final BitSet FOLLOW_K_AS_in_selector981 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_selector985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1026 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_WRITETIME_in_unaliasedSelector1072 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_unaliasedSelector1074 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1078 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_unaliasedSelector1080 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_TTL_in_unaliasedSelector1106 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_unaliasedSelector1114 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_unaliasedSelector1120 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_functionName_in_unaliasedSelector1148 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_selectionFunctionArgs_in_unaliasedSelector1152 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_unaliasedSelector1167 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_unaliasedSelector1171 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_142_in_selectionFunctionArgs1199 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_selectionFunctionArgs1201 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_selectionFunctionArgs1211 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1215 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_selectionFunctionArgs1231 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_unaliasedSelector_in_selectionFunctionArgs1235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_selectionFunctionArgs1248 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_156_in_selectCountClause1271 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_selectCountClause1293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relation_in_whereClause1329 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_whereClause1333 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_relation_in_whereClause1335 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_cident_in_orderByClause1366 = new BitSet(new long[]{0x0004000080000002L});
	public static final BitSet FOLLOW_K_ASC_in_orderByClause1371 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_orderByClause1375 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INSERT_in_insertStatement1413 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_K_INTO_in_insertStatement1415 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_insertStatement1419 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_insertStatement1431 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_insertStatement1435 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_insertStatement1442 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_insertStatement1446 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_insertStatement1453 = new BitSet(new long[]{0x0000000000000000L,0x0002000000000000L});
	public static final BitSet FOLLOW_K_VALUES_in_insertStatement1463 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_insertStatement1475 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_insertStatement1479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_insertStatement1485 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_insertStatement1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_insertStatement1496 = new BitSet(new long[]{0x2000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_K_IF_in_insertStatement1509 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_insertStatement1511 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_insertStatement1513 = new BitSet(new long[]{0x0000000000000002L,0x0000800000000000L});
	public static final BitSet FOLLOW_usingClause_in_insertStatement1530 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClause1560 = new BitSet(new long[]{0x0000000000000000L,0x0000008200000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1562 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_usingClause1567 = new BitSet(new long[]{0x0000000000000000L,0x0000008200000000L});
	public static final BitSet FOLLOW_usingClauseObjective_in_usingClause1569 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseObjective1591 = new BitSet(new long[]{0x0000000000200000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective1595 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TTL_in_usingClauseObjective1605 = new BitSet(new long[]{0x0000000000200000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseObjective1609 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UPDATE_in_updateStatement1643 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_updateStatement1647 = new BitSet(new long[]{0x0000000000000000L,0x0000800010000000L});
	public static final BitSet FOLLOW_usingClause_in_updateStatement1657 = new BitSet(new long[]{0x0000000000000000L,0x0000000010000000L});
	public static final BitSet FOLLOW_K_SET_in_updateStatement1669 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement1671 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_updateStatement1675 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnOperation_in_updateStatement1677 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_K_WHERE_in_updateStatement1688 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_whereClause_in_updateStatement1692 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_updateStatement1702 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_EXISTS_in_updateStatement1706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_updateStatement1714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions1756 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_updateConditions1761 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnCondition_in_updateConditions1763 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_DELETE_in_deleteStatement1800 = new BitSet(new long[]{0x07D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_deleteSelection_in_deleteStatement1806 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_deleteStatement1819 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_deleteStatement1823 = new BitSet(new long[]{0x0000000000000000L,0x0010800000000000L});
	public static final BitSet FOLLOW_usingClauseDelete_in_deleteStatement1833 = new BitSet(new long[]{0x0000000000000000L,0x0010000000000000L});
	public static final BitSet FOLLOW_K_WHERE_in_deleteStatement1845 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_whereClause_in_deleteStatement1849 = new BitSet(new long[]{0x2000000000000002L});
	public static final BitSet FOLLOW_K_IF_in_deleteStatement1859 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_EXISTS_in_deleteStatement1863 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateConditions_in_deleteStatement1871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection1918 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_deleteSelection1933 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_deleteOp_in_deleteSelection1937 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_cident_in_deleteOp1964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_deleteOp1991 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
	public static final BitSet FOLLOW_155_in_deleteOp1993 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_deleteOp1997 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_157_in_deleteOp1999 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_USING_in_usingClauseDelete2019 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_usingClauseDelete2021 = new BitSet(new long[]{0x0000000000200000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_intValue_in_usingClauseDelete2025 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BEGIN_in_batchStatement2059 = new BitSet(new long[]{0x0000200400000000L,0x0000040000000000L});
	public static final BitSet FOLLOW_K_UNLOGGED_in_batchStatement2069 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_COUNTER_in_batchStatement2075 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2088 = new BitSet(new long[]{0x0002000020000000L,0x0000880000000004L});
	public static final BitSet FOLLOW_usingClause_in_batchStatement2092 = new BitSet(new long[]{0x0002000020000000L,0x0000080000000004L});
	public static final BitSet FOLLOW_batchStatementObjective_in_batchStatement2112 = new BitSet(new long[]{0x0002000020000000L,0x0000080000000004L,0x0000000000200000L});
	public static final BitSet FOLLOW_149_in_batchStatement2114 = new BitSet(new long[]{0x0002000020000000L,0x0000080000000004L});
	public static final BitSet FOLLOW_K_APPLY_in_batchStatement2128 = new BitSet(new long[]{0x0000000400000000L});
	public static final BitSet FOLLOW_K_BATCH_in_batchStatement2130 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_insertStatement_in_batchStatementObjective2161 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_updateStatement_in_batchStatementObjective2174 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_deleteStatement_in_batchStatementObjective2187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createKeyspaceStatement2222 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_createKeyspaceStatement2224 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_createKeyspaceStatement2227 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createKeyspaceStatement2229 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createKeyspaceStatement2231 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_keyspaceName_in_createKeyspaceStatement2240 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createKeyspaceStatement2248 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_properties_in_createKeyspaceStatement2250 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTableStatement2285 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_createTableStatement2287 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_createTableStatement2290 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createTableStatement2292 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTableStatement2294 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTableStatement2309 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_cfamDefinition_in_createTableStatement2319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_cfamDefinition2338 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E1E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2340 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_cfamDefinition2345 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E1E08D69L,0x0000000000028001L});
	public static final BitSet FOLLOW_cfamColumns_in_cfamDefinition2347 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_cfamDefinition2354 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_cfamDefinition2364 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2366 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_cfamDefinition2371 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfamProperty_in_cfamDefinition2373 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_ident_in_cfamColumns2399 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_cfamColumns2403 = new BitSet(new long[]{0x0000000000000002L,0x0000000021000000L});
	public static final BitSet FOLLOW_K_STATIC_in_cfamColumns2408 = new BitSet(new long[]{0x0000000000000002L,0x0000000001000000L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2425 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns2427 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PRIMARY_in_cfamColumns2439 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
	public static final BitSet FOLLOW_K_KEY_in_cfamColumns2441 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_cfamColumns2443 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_pkDef_in_cfamColumns2445 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_cfamColumns2449 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_cfamColumns2453 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_cfamColumns2460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_pkDef2480 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_pkDef2490 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_pkDef2496 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_pkDef2502 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_pkDef2506 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_pkDef2513 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_cfamProperty2533 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COMPACT_in_cfamProperty2542 = new BitSet(new long[]{0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_K_STORAGE_in_cfamProperty2544 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CLUSTERING_in_cfamProperty2554 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_K_ORDER_in_cfamProperty2556 = new BitSet(new long[]{0x0000008000000000L});
	public static final BitSet FOLLOW_K_BY_in_cfamProperty2558 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_cfamProperty2560 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2562 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_cfamProperty2566 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfamOrdering_in_cfamProperty2568 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_cfamProperty2573 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_cfamOrdering2601 = new BitSet(new long[]{0x0004000080000000L});
	public static final BitSet FOLLOW_K_ASC_in_cfamOrdering2604 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DESC_in_cfamOrdering2608 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTypeStatement2647 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_createTypeStatement2649 = new BitSet(new long[]{0x25D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_createTypeStatement2652 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createTypeStatement2654 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTypeStatement2656 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_userTypeName_in_createTypeStatement2674 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_createTypeStatement2687 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2689 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_createTypeStatement2694 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000028001L});
	public static final BitSet FOLLOW_typeColumns_in_createTypeStatement2696 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_createTypeStatement2703 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_typeColumns2723 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_typeColumns2727 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createIndexStatement2762 = new BitSet(new long[]{0x8000800000000000L});
	public static final BitSet FOLLOW_K_CUSTOM_in_createIndexStatement2765 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_K_INDEX_in_createIndexStatement2771 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E88D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_createIndexStatement2774 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createIndexStatement2776 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createIndexStatement2778 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E88D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_idxName_in_createIndexStatement2794 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ON_in_createIndexStatement2799 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_createIndexStatement2803 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_createIndexStatement2805 = new BitSet(new long[]{0x0DD9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_indexIdent_in_createIndexStatement2809 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_createIndexStatement2811 = new BitSet(new long[]{0x0000000000000002L,0x0020800000000000L});
	public static final BitSet FOLLOW_K_USING_in_createIndexStatement2822 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createIndexStatement2826 = new BitSet(new long[]{0x0000000000000002L,0x0020000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_createIndexStatement2841 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_properties_in_createIndexStatement2843 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_indexIdent2877 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYS_in_indexIdent2902 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_indexIdent2904 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_indexIdent2908 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_indexIdent2910 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FULL_in_indexIdent2920 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_indexIdent2922 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_indexIdent2926 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_indexIdent2928 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createTriggerStatement2963 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_createTriggerStatement2965 = new BitSet(new long[]{0x25D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_createTriggerStatement2968 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createTriggerStatement2970 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createTriggerStatement2972 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_createTriggerStatement2982 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ON_in_createTriggerStatement2993 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_createTriggerStatement2997 = new BitSet(new long[]{0x0000000000000000L,0x0000800000000000L});
	public static final BitSet FOLLOW_K_USING_in_createTriggerStatement2999 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_createTriggerStatement3003 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTriggerStatement3044 = new BitSet(new long[]{0x0000000000000000L,0x0000002000000000L});
	public static final BitSet FOLLOW_K_TRIGGER_in_dropTriggerStatement3046 = new BitSet(new long[]{0x25D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_dropTriggerStatement3049 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTriggerStatement3051 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_dropTriggerStatement3061 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ON_in_dropTriggerStatement3064 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTriggerStatement3068 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterKeyspaceStatement3108 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_alterKeyspaceStatement3110 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_keyspaceName_in_alterKeyspaceStatement3114 = new BitSet(new long[]{0x0000000000000000L,0x0020000000000000L});
	public static final BitSet FOLLOW_K_WITH_in_alterKeyspaceStatement3124 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_properties_in_alterKeyspaceStatement3126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3162 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_alterTableStatement3164 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_alterTableStatement3168 = new BitSet(new long[]{0x0020000009000000L,0x0020000002000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTableStatement3182 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3186 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTableStatement3188 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTableStatement3208 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3214 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_alterTableStatement3218 = new BitSet(new long[]{0x0000000000000002L,0x0000000020000000L});
	public static final BitSet FOLLOW_K_STATIC_in_alterTableStatement3223 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_alterTableStatement3241 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3246 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_WITH_in_alterTableStatement3286 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_properties_in_alterTableStatement3289 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTableStatement3322 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3376 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement3378 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3382 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTableStatement3403 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3407 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTableStatement3409 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_alterTableStatement3413 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3459 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3461 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_userTypeName_in_alterTypeStatement3465 = new BitSet(new long[]{0x0000000009000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_K_ALTER_in_alterTypeStatement3479 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3483 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_alterTypeStatement3485 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3489 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ADD_in_alterTypeStatement3505 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3511 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_alterTypeStatement3515 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_RENAME_in_alterTypeStatement3538 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3576 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3578 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3582 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_alterTypeStatement3605 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3609 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_K_TO_in_alterTypeStatement3611 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_alterTypeStatement3615 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropKeyspaceStatement3682 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000080L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dropKeyspaceStatement3684 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_dropKeyspaceStatement3687 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropKeyspaceStatement3689 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_keyspaceName_in_dropKeyspaceStatement3698 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTableStatement3732 = new BitSet(new long[]{0x0000020000000000L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dropTableStatement3734 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_dropTableStatement3737 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTableStatement3739 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_dropTableStatement3748 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropTypeStatement3782 = new BitSet(new long[]{0x0000000000000000L,0x0000020000000000L});
	public static final BitSet FOLLOW_K_TYPE_in_dropTypeStatement3784 = new BitSet(new long[]{0x25D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_dropTypeStatement3787 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropTypeStatement3789 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_userTypeName_in_dropTypeStatement3798 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropIndexStatement3832 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_K_INDEX_in_dropIndexStatement3834 = new BitSet(new long[]{0x25D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_IF_in_dropIndexStatement3837 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropIndexStatement3839 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_indexName_in_dropIndexStatement3848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TRUNCATE_in_truncateStatement3879 = new BitSet(new long[]{0x05D9BF7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_truncateStatement3882 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_truncateStatement3888 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_GRANT_in_grantStatement3913 = new BitSet(new long[]{0x002040020A000000L,0x0000000008001000L});
	public static final BitSet FOLLOW_permissionOrAll_in_grantStatement3925 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ON_in_grantStatement3933 = new BitSet(new long[]{0x05D9BF7142100000L,0x804F63A7E0E08DE9L,0x0000000000000001L});
	public static final BitSet FOLLOW_resource_in_grantStatement3945 = new BitSet(new long[]{0x0000000000000000L,0x0000000800000000L});
	public static final BitSet FOLLOW_K_TO_in_grantStatement3953 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_grantStatement3965 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_REVOKE_in_revokeStatement3996 = new BitSet(new long[]{0x002040020A000000L,0x0000000008001000L});
	public static final BitSet FOLLOW_permissionOrAll_in_revokeStatement4008 = new BitSet(new long[]{0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_K_ON_in_revokeStatement4016 = new BitSet(new long[]{0x05D9BF7142100000L,0x804F63A7E0E08DE9L,0x0000000000000001L});
	public static final BitSet FOLLOW_resource_in_revokeStatement4028 = new BitSet(new long[]{0x0200000000000000L});
	public static final BitSet FOLLOW_K_FROM_in_revokeStatement4036 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_revokeStatement4048 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listPermissionsStatement4086 = new BitSet(new long[]{0x002040020A000000L,0x0000000008001000L});
	public static final BitSet FOLLOW_permissionOrAll_in_listPermissionsStatement4098 = new BitSet(new long[]{0x0000000000000002L,0x00000000000C4000L});
	public static final BitSet FOLLOW_K_ON_in_listPermissionsStatement4108 = new BitSet(new long[]{0x05D9BF7142100000L,0x804F63A7E0E08DE9L,0x0000000000000001L});
	public static final BitSet FOLLOW_resource_in_listPermissionsStatement4110 = new BitSet(new long[]{0x0000000000000002L,0x0000000000044000L});
	public static final BitSet FOLLOW_K_OF_in_listPermissionsStatement4125 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_listPermissionsStatement4127 = new BitSet(new long[]{0x0000000000000002L,0x0000000000004000L});
	public static final BitSet FOLLOW_K_NORECURSIVE_in_listPermissionsStatement4142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_permission4178 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_permissionOrAll4227 = new BitSet(new long[]{0x0000000000000002L,0x0000000000800000L});
	public static final BitSet FOLLOW_K_PERMISSIONS_in_permissionOrAll4231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_permission_in_permissionOrAll4252 = new BitSet(new long[]{0x0000000000000002L,0x0000000000400000L});
	public static final BitSet FOLLOW_K_PERMISSION_in_permissionOrAll4256 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dataResource_in_resource4284 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALL_in_dataResource4307 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
	public static final BitSet FOLLOW_K_KEYSPACES_in_dataResource4309 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEYSPACE_in_dataResource4319 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_keyspaceName_in_dataResource4325 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COLUMNFAMILY_in_dataResource4337 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_columnFamilyName_in_dataResource4346 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_CREATE_in_createUserStatement4386 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_USER_in_createUserStatement4388 = new BitSet(new long[]{0x2000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_IF_in_createUserStatement4391 = new BitSet(new long[]{0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_K_NOT_in_createUserStatement4393 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_createUserStatement4395 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_createUserStatement4401 = new BitSet(new long[]{0x0000000000000002L,0x0020000080008000L});
	public static final BitSet FOLLOW_K_WITH_in_createUserStatement4411 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_userOptions_in_createUserStatement4413 = new BitSet(new long[]{0x0000000000000002L,0x0000000080008000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_createUserStatement4427 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_createUserStatement4433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ALTER_in_alterUserStatement4478 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_USER_in_alterUserStatement4480 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_alterUserStatement4482 = new BitSet(new long[]{0x0000000000000002L,0x0020000080008000L});
	public static final BitSet FOLLOW_K_WITH_in_alterUserStatement4492 = new BitSet(new long[]{0x0000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_userOptions_in_alterUserStatement4494 = new BitSet(new long[]{0x0000000000000002L,0x0000000080008000L});
	public static final BitSet FOLLOW_K_SUPERUSER_in_alterUserStatement4508 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NOSUPERUSER_in_alterUserStatement4514 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DROP_in_dropUserStatement4559 = new BitSet(new long[]{0x0000000000000000L,0x0000200000000000L});
	public static final BitSet FOLLOW_K_USER_in_dropUserStatement4561 = new BitSet(new long[]{0x2000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_K_IF_in_dropUserStatement4564 = new BitSet(new long[]{0x0040000000000000L});
	public static final BitSet FOLLOW_K_EXISTS_in_dropUserStatement4566 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_username_in_dropUserStatement4572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_listUsersStatement4597 = new BitSet(new long[]{0x0000000000000000L,0x0000400000000000L});
	public static final BitSet FOLLOW_K_USERS_in_listUsersStatement4599 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userOption_in_userOptions4619 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_PASSWORD_in_userOption4640 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_userOption4644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cident4675 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cident4700 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cident4719 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ident4745 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ident4770 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ident4789 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_keyspaceName4822 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_indexName4856 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_indexName4859 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_idxName_in_indexName4863 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ksName_in_columnFamilyName4895 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_columnFamilyName4898 = new BitSet(new long[]{0x05D9BD7142100000L,0x804F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cfName_in_columnFamilyName4902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_userTypeName4927 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
	public static final BitSet FOLLOW_147_in_userTypeName4929 = new BitSet(new long[]{0x04C88D0042100000L,0x00026320E0E08D60L,0x0000000000000001L});
	public static final BitSet FOLLOW_non_type_ident_in_userTypeName4935 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_ksName4957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_ksName4982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_ksName5001 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_ksName5011 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_cfName5033 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_cfName5058 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_cfName5077 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_cfName5087 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_idxName5109 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_idxName5134 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_idxName5153 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_idxName5163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_constant5188 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_constant5200 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_constant5219 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BOOLEAN_in_constant5240 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UUID_in_constant5259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HEXNUMBER_in_constant5281 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_146_in_constant5299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002002L});
	public static final BitSet FOLLOW_set_in_constant5308 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_158_in_mapLiteral5337 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x00000000C8144048L});
	public static final BitSet FOLLOW_term_in_mapLiteral5355 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_mapLiteral5357 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_mapLiteral5361 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080020000L});
	public static final BitSet FOLLOW_145_in_mapLiteral5367 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_mapLiteral5371 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_mapLiteral5373 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_mapLiteral5377 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080020000L});
	public static final BitSet FOLLOW_159_in_mapLiteral5393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_setOrMapLiteral5417 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5421 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_setOrMapLiteral5437 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5441 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_setOrMapLiteral5443 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5447 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_setOrMapLiteral5482 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_setOrMapLiteral5486 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_155_in_collectionLiteral5520 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000068144048L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5538 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020020000L});
	public static final BitSet FOLLOW_145_in_collectionLiteral5544 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5548 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020020000L});
	public static final BitSet FOLLOW_157_in_collectionLiteral5564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_158_in_collectionLiteral5574 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_collectionLiteral5578 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080120000L});
	public static final BitSet FOLLOW_setOrMapLiteral_in_collectionLiteral5582 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_159_in_collectionLiteral5587 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_158_in_collectionLiteral5605 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080000000L});
	public static final BitSet FOLLOW_159_in_collectionLiteral5607 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_158_in_usertypeLiteral5651 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_usertypeLiteral5655 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_usertypeLiteral5657 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral5661 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080020000L});
	public static final BitSet FOLLOW_145_in_usertypeLiteral5667 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_usertypeLiteral5671 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_148_in_usertypeLiteral5673 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_usertypeLiteral5677 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000080020000L});
	public static final BitSet FOLLOW_159_in_usertypeLiteral5684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_tupleLiteral5721 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_tupleLiteral5725 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_tupleLiteral5731 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_tupleLiteral5735 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_tupleLiteral5742 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_value5765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collectionLiteral_in_value5787 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_usertypeLiteral_in_value5800 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleLiteral_in_value5815 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_NULL_in_value5831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_value5855 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_value5859 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_value5877 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INTEGER_in_intValue5923 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_intValue5937 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_intValue5941 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_intValue5952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_functionName5985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_functionName6019 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_functionName6029 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function6076 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_function6078 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_function6080 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_functionName_in_function6110 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_142_in_function6112 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_functionArgs_in_function6116 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_function6118 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_functionArgs6151 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_functionArgs6157 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_functionArgs6161 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_value_in_term6189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_function_in_term6226 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_term6258 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_term6262 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_term6264 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_term6268 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnOperation6291 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000009000000L});
	public static final BitSet FOLLOW_columnOperationDifferentiator_in_columnOperation6293 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_152_in_columnOperationDifferentiator6312 = new BitSet(new long[]{0x05D9BD7142344040L,0x804F63B7E0E2AD6BL,0x0000000048144049L});
	public static final BitSet FOLLOW_normalColumnOperation_in_columnOperationDifferentiator6314 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_155_in_columnOperationDifferentiator6323 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_columnOperationDifferentiator6327 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_157_in_columnOperationDifferentiator6329 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_specializedColumnOperation_in_columnOperationDifferentiator6331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation6352 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000010000L});
	public static final BitSet FOLLOW_144_in_normalColumnOperation6355 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6380 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000050000L});
	public static final BitSet FOLLOW_set_in_normalColumnOperation6384 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_normalColumnOperation6394 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_normalColumnOperation6412 = new BitSet(new long[]{0x0000000000200000L});
	public static final BitSet FOLLOW_INTEGER_in_normalColumnOperation6416 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_152_in_specializedColumnOperation6442 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_specializedColumnOperation6446 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_columnCondition6479 = new BitSet(new long[]{0x4000000000000000L,0x0000000000000000L,0x000000000FC02000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition6493 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_columnCondition6497 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition6511 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000104000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition6529 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition6549 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_155_in_columnCondition6577 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_columnCondition6581 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000020000000L});
	public static final BitSet FOLLOW_157_in_columnCondition6583 = new BitSet(new long[]{0x4000000000000000L,0x0000000000000000L,0x0000000007C02000L});
	public static final BitSet FOLLOW_relationType_in_columnCondition6601 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_columnCondition6605 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_IN_in_columnCondition6623 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000104000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_columnCondition6645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarker_in_columnCondition6669 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_property_in_properties6731 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_K_AND_in_properties6735 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_property_in_properties6737 = new BitSet(new long[]{0x0000000010000002L});
	public static final BitSet FOLLOW_ident_in_property6760 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_property6762 = new BitSet(new long[]{0x05D9BD7142244040L,0x004F63A7E0E0AD6BL,0x0000000000040048L});
	public static final BitSet FOLLOW_propertyValue_in_property6766 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ident_in_property6778 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_152_in_property6780 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_mapLiteral_in_property6784 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_constant_in_propertyValue6809 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_keyword_in_propertyValue6831 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_152_in_relationType6854 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_150_in_relationType6865 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_151_in_relationType6876 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_153_in_relationType6886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_154_in_relationType6897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_141_in_relationType6907 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6929 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000007C02000L});
	public static final BitSet FOLLOW_relationType_in_relation6933 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_relation6937 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TOKEN_in_relation6947 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation6951 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000007C02000L});
	public static final BitSet FOLLOW_relationType_in_relation6955 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_relation6959 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation6979 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation6981 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_inMarker_in_relation6985 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation7005 = new BitSet(new long[]{0x4000000000000000L});
	public static final BitSet FOLLOW_K_IN_in_relation7007 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_singleColumnInValues_in_relation7011 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_cident_in_relation7031 = new BitSet(new long[]{0x0000080000000000L});
	public static final BitSet FOLLOW_K_CONTAINS_in_relation7033 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD6BL,0x0000000048144048L});
	public static final BitSet FOLLOW_K_KEY_in_relation7038 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_relation7054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfIdentifiers_in_relation7066 = new BitSet(new long[]{0x4000000000000000L,0x0000000000000000L,0x0000000007C02000L});
	public static final BitSet FOLLOW_K_IN_in_relation7076 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000104000L});
	public static final BitSet FOLLOW_142_in_relation7090 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_relation7092 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_inMarkerForTuple_in_relation7124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfTupleLiterals_in_relation7158 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tupleOfMarkersForTuples_in_relation7192 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation7234 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_tupleLiteral_in_relation7238 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_relationType_in_relation7264 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_markerForTuple_in_relation7268 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_relation7298 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63B7E0E08D69L,0x0000000000004001L});
	public static final BitSet FOLLOW_relation_in_relation7300 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000008000L});
	public static final BitSet FOLLOW_143_in_relation7303 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarker7324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_inMarker7334 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_inMarker7338 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_tupleOfIdentifiers7370 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers7374 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_tupleOfIdentifiers7379 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_cident_in_tupleOfIdentifiers7383 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_tupleOfIdentifiers7389 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_singleColumnInValues7419 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x000000004814C048L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues7427 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_singleColumnInValues7432 = new BitSet(new long[]{0x05D9AD7142344040L,0x800F6337E0E2AD4BL,0x0000000048144048L});
	public static final BitSet FOLLOW_term_in_singleColumnInValues7436 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_singleColumnInValues7445 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_tupleOfTupleLiterals7475 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7479 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_tupleOfTupleLiterals7484 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000004000L});
	public static final BitSet FOLLOW_tupleLiteral_in_tupleOfTupleLiterals7488 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_tupleOfTupleLiterals7494 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_markerForTuple7515 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_markerForTuple7525 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_markerForTuple7529 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_142_in_tupleOfMarkersForTuples7561 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7565 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_145_in_tupleOfMarkersForTuples7570 = new BitSet(new long[]{0x0000000000000000L,0x8000000000000000L,0x0000000000100000L});
	public static final BitSet FOLLOW_markerForTuple_in_tupleOfMarkersForTuples7574 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000028000L});
	public static final BitSet FOLLOW_143_in_tupleOfMarkersForTuples7580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QMARK_in_inMarkerForTuple7601 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_148_in_inMarkerForTuple7611 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7E0E08D69L,0x0000000000000001L});
	public static final BitSet FOLLOW_ident_in_inMarkerForTuple7615 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_comparatorType7640 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_collection_type_in_comparatorType7656 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_tuple_type_in_comparatorType7668 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_userTypeName_in_comparatorType7684 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FROZEN_in_comparatorType7696 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_150_in_comparatorType7698 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_comparatorType7702 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_153_in_comparatorType7704 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_LITERAL_in_comparatorType7722 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_ASCII_in_native_type7751 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BIGINT_in_native_type7765 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BLOB_in_native_type7778 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_BOOLEAN_in_native_type7793 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_COUNTER_in_native_type7805 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DECIMAL_in_native_type7817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_DOUBLE_in_native_type7829 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_FLOAT_in_native_type7842 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INET_in_native_type7856 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_INT_in_native_type7871 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TEXT_in_native_type7887 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMESTAMP_in_native_type7902 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_UUID_in_native_type7912 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARCHAR_in_native_type7927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_VARINT_in_native_type7939 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TIMEUUID_in_native_type7952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_MAP_in_collection_type7976 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_150_in_collection_type7979 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7983 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_145_in_collection_type7985 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type7989 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_153_in_collection_type7991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_LIST_in_collection_type8009 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_150_in_collection_type8011 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type8015 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_153_in_collection_type8017 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_SET_in_collection_type8035 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_150_in_collection_type8038 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_collection_type8042 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002000000L});
	public static final BitSet FOLLOW_153_in_collection_type8044 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_TUPLE_in_tuple_type8075 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000400000L});
	public static final BitSet FOLLOW_150_in_tuple_type8077 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type8092 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002020000L});
	public static final BitSet FOLLOW_145_in_tuple_type8097 = new BitSet(new long[]{0x05D9BD7142100000L,0x004F63A7F0E08D69L,0x0000000000000009L});
	public static final BitSet FOLLOW_comparatorType_in_tuple_type8101 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000002020000L});
	public static final BitSet FOLLOW_153_in_tuple_type8113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_non_type_ident8165 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUOTED_NAME_in_non_type_ident8196 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_non_type_ident8221 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_K_KEY_in_non_type_ident8233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_unreserved_function_keyword_in_unreserved_keyword8276 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_unreserved_keyword8292 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_basic_unreserved_keyword_in_unreserved_function_keyword8331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_native_type_in_unreserved_function_keyword8343 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_set_in_basic_unreserved_keyword8381 = new BitSet(new long[]{0x0000000000000002L});
}
