/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.component.mock.MockExpressionClauseSupport;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;

public class MockExpressionClause<T>
implements Expression,
Predicate {
    private MockExpressionClauseSupport<T> delegate;

    public MockExpressionClause(T result) {
        this.delegate = new MockExpressionClauseSupport<T>(result);
    }

    public T expression(Expression expression) {
        return this.delegate.expression(expression);
    }

    public T constant(Object value) {
        return this.delegate.constant(value);
    }

    public T exchange() {
        return this.delegate.exchange();
    }

    public T exchange(final Function<Exchange, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange);
            }
        });
    }

    public T message() {
        return this.inMessage();
    }

    public T message(Function<Message, Object> function) {
        return this.inMessage(function);
    }

    public T inMessage() {
        return this.delegate.inMessage();
    }

    public T inMessage(final Function<Message, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn());
            }
        });
    }

    public T outMessage(final Function<Message, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut());
            }
        });
    }

    public T body() {
        return this.delegate.body();
    }

    public T body(final Function<Object, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody());
            }
        });
    }

    public T body(final Supplier<Object> supplier) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return supplier.get();
            }
        });
    }

    public T body(final BiFunction<Object, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(), exchange.getIn().getHeaders());
            }
        });
    }

    public T body(Class<?> expectedType) {
        return this.delegate.body(expectedType);
    }

    public <B> T body(final Class<B> expectedType, final Function<B, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(expectedType));
            }
        });
    }

    public <B> T body(final Class<B> expectedType, final BiFunction<B, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getIn().getBody(expectedType), exchange.getIn().getHeaders());
            }
        });
    }

    public T outBody(final Function<Object, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut().getBody());
            }
        });
    }

    public T outBody(final BiFunction<Object, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut().getBody(), exchange.getOut().getHeaders());
            }
        });
    }

    public <B> T outBody(final Class<B> expectedType, final Function<B, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut().getBody(expectedType));
            }
        });
    }

    public <B> T outBody(final Class<B> expectedType, final BiFunction<B, Map<String, Object>, Object> function) {
        return this.delegate.expression((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return function.apply(exchange.getOut().getBody(expectedType), exchange.getOut().getHeaders());
            }
        });
    }

    public T header(String name) {
        return this.delegate.header(name);
    }

    public T headers() {
        return this.delegate.headers();
    }

    public T exchangeProperty(String name) {
        return this.delegate.exchangeProperty(name);
    }

    public T exchangeProperties() {
        return this.delegate.exchangeProperties();
    }

    public T method(String bean) {
        return this.delegate.method(bean);
    }

    public T method(String bean, String method) {
        return this.delegate.method(bean, method);
    }

    public T groovy(String text) {
        return this.delegate.groovy(text);
    }

    public T jsonpath(String text) {
        return this.delegate.jsonpath(text);
    }

    public T ognl(String text) {
        return this.delegate.ognl(text);
    }

    public T mvel(String text) {
        return this.delegate.mvel(text);
    }

    public T ref(String ref) {
        return this.delegate.ref(ref);
    }

    public T spel(String text) {
        return this.delegate.spel(text);
    }

    public T simple(String text) {
        return this.delegate.simple(text);
    }

    public T xpath(String text) {
        return this.delegate.xpath(text);
    }

    public T xquery(String text) {
        return this.delegate.xquery(text);
    }

    public T language(String language, String expression) {
        return this.delegate.language(language, expression);
    }

    public Expression getExpressionValue() {
        return this.delegate.getExpressionValue();
    }

    public ExpressionFactory getExpressionType() {
        return this.delegate.getExpressionType();
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.getExpressionValue() != null) {
            return (T)this.getExpressionValue().evaluate(exchange, type);
        }
        Expression exp = this.delegate.getExpressionType().createExpression(exchange.getContext());
        return (T)exp.evaluate(exchange, type);
    }

    public boolean matches(Exchange exchange) {
        if (this.getExpressionValue() != null) {
            return new ExpressionToPredicateAdapter(this.getExpressionValue()).matches(exchange);
        }
        Expression exp = this.delegate.getExpressionType().createExpression(exchange.getContext());
        return new ExpressionToPredicateAdapter(exp).matches(exchange);
    }
}

