/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.iterators.AggregatingIterator;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.accumulo.core.iterators.user.AgeOffFilter;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.iterators.user.ReqVisFilter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;

public class SetIterCommand
extends Shell.Command {
    private Option allScopeOpt;
    private Option mincScopeOpt;
    private Option majcScopeOpt;
    private Option scanScopeOpt;
    private Option nameOpt;
    private Option priorityOpt;
    private Option aggTypeOpt;
    private Option ageoffTypeOpt;
    private Option regexTypeOpt;
    private Option versionTypeOpt;
    private Option reqvisTypeOpt;
    private Option classnameTypeOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ShellCommandException {
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        int priority = Integer.parseInt(cl.getOptionValue(this.priorityOpt.getOpt()));
        HashMap<String, String> options = new HashMap<String, String>();
        String classname = cl.getOptionValue(this.classnameTypeOpt.getOpt());
        if (cl.hasOption(this.aggTypeOpt.getOpt())) {
            String deprecatedClassName;
            Shell.log.warn((Object)"aggregators are deprecated");
            classname = deprecatedClassName = AggregatingIterator.class.getName();
        } else if (cl.hasOption(this.regexTypeOpt.getOpt())) {
            classname = RegExFilter.class.getName();
        } else if (cl.hasOption(this.ageoffTypeOpt.getOpt())) {
            classname = AgeOffFilter.class.getName();
        } else if (cl.hasOption(this.versionTypeOpt.getOpt())) {
            classname = VersioningIterator.class.getName();
        } else if (cl.hasOption(this.reqvisTypeOpt.getOpt())) {
            classname = ReqVisFilter.class.getName();
        }
        ClassLoader classloader = shellState.getClassLoader(cl, shellState);
        String configuredName = SetIterCommand.setUpOptions(classloader, shellState.getReader(), classname, options);
        String name = cl.getOptionValue(this.nameOpt.getOpt(), null);
        if (null == name && null == configuredName) {
            throw new IllegalArgumentException("No provided or default name for iterator");
        }
        if (null == name) {
            name = configuredName;
        }
        if (namespaces) {
            try {
                this.setNamespaceProperties(cl, shellState, priority, options, classname, name);
            }
            catch (NamespaceNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        } else if (tables) {
            this.setTableProperties(cl, shellState, priority, options, classname, name);
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        return 0;
    }

    protected void setTableProperties(CommandLine cl, Shell shellState, int priority, Map<String, String> options, String classname, String name) throws AccumuloException, AccumuloSecurityException, ShellCommandException, TableNotFoundException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        ScanCommand.ensureTserversCanLoadIterator(shellState, tableName, classname);
        String aggregatorClass = options.get("aggregatorClass");
        String deprecatedAggregatorClassName = Aggregator.class.getName();
        if (aggregatorClass != null && !shellState.getConnector().tableOperations().testClassLoad(tableName, aggregatorClass, deprecatedAggregatorClassName)) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + aggregatorClass + " as type " + deprecatedAggregatorClassName);
        }
        Iterator<Map.Entry<String, String>> i = options.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            i.remove();
        }
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.mincScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.minc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.majcScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.majc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.scanScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.scan);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        IteratorSetting setting = new IteratorSetting(priority, name, classname, options);
        shellState.getConnector().tableOperations().attachIterator(tableName, setting, scopes);
    }

    protected void setNamespaceProperties(CommandLine cl, Shell shellState, int priority, Map<String, String> options, String classname, String name) throws AccumuloException, AccumuloSecurityException, ShellCommandException, NamespaceNotFoundException {
        String namespace = OptUtil.getNamespaceOpt(cl, shellState);
        if (!shellState.getConnector().namespaceOperations().testClassLoad(namespace, classname, SortedKeyValueIterator.class.getName())) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + classname + " as type " + SortedKeyValueIterator.class.getName());
        }
        String aggregatorClass = options.get("aggregatorClass");
        String deprecatedAggregatorClassName = Aggregator.class.getName();
        if (aggregatorClass != null && !shellState.getConnector().namespaceOperations().testClassLoad(namespace, aggregatorClass, deprecatedAggregatorClassName)) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + aggregatorClass + " as type " + deprecatedAggregatorClassName);
        }
        Iterator<Map.Entry<String, String>> i = options.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            i.remove();
        }
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.mincScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.minc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.majcScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.majc);
        }
        if (cl.hasOption(this.allScopeOpt.getOpt()) || cl.hasOption(this.scanScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.scan);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        IteratorSetting setting = new IteratorSetting(priority, name, classname, options);
        shellState.getConnector().namespaceOperations().attachIterator(namespace, setting, scopes);
    }

    private static String setUpOptions(ClassLoader classloader, ConsoleReader reader, String className, Map<String, String> options) throws IOException, ShellCommandException {
        String iteratorName;
        SortedKeyValueIterator untypedInstance;
        Class<SortedKeyValueIterator> clazz;
        try {
            clazz = classloader.loadClass(className).asSubclass(SortedKeyValueIterator.class);
            untypedInstance = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            StringBuilder msg = new StringBuilder("Unable to load ").append(className);
            if (className.indexOf(46) < 0) {
                msg.append("; did you use a fully qualified package name?");
            } else {
                msg.append("; class not found.");
            }
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, msg.toString());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ClassCastException e) {
            StringBuilder msg = new StringBuilder(50);
            msg.append(className).append(" loaded successfully but does not implement SortedKeyValueIterator.");
            msg.append(" This class cannot be used with this command.");
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, msg.toString());
        }
        SortedKeyValueIterator skvi = untypedInstance;
        OptionDescriber iterOptions = null;
        if (OptionDescriber.class.isAssignableFrom(skvi.getClass())) {
            iterOptions = (OptionDescriber)skvi;
        }
        if (null != iterOptions) {
            OptionDescriber.IteratorOptions itopts = iterOptions.describeOptions();
            iteratorName = itopts.getName();
            if (iteratorName == null) {
                throw new IllegalArgumentException(className + " described its default distinguishing name as null");
            }
            String shortClassName = className;
            if (className.contains(".")) {
                shortClassName = className.substring(className.lastIndexOf(46) + 1);
            }
            HashMap localOptions = new HashMap();
            do {
                String input;
                String prompt;
                for (String key : localOptions.keySet()) {
                    options.remove(key);
                }
                localOptions.clear();
                reader.println((CharSequence)itopts.getDescription());
                if (itopts.getNamedOptions() != null) {
                    for (Map.Entry e : itopts.getNamedOptions().entrySet()) {
                        prompt = Shell.repeat("-", 10) + "> set " + shortClassName + " parameter " + (String)e.getKey() + ", " + (String)e.getValue() + ": ";
                        reader.flush();
                        input = reader.readLine(prompt);
                        if (input == null) {
                            reader.println();
                            throw new IOException("Input stream closed");
                        }
                        localOptions.put(e.getKey(), input);
                    }
                }
                if (itopts.getUnnamedOptionDescriptions() != null) {
                    block8: for (String desc : itopts.getUnnamedOptionDescriptions()) {
                        reader.println((CharSequence)(Shell.repeat("-", 10) + "> entering options: " + desc));
                        input = "start";
                        prompt = Shell.repeat("-", 10) + "> set " + shortClassName + " option (<name> <value>, hit enter to skip): ";
                        while (true) {
                            reader.flush();
                            input = reader.readLine(prompt);
                            if (input == null) {
                                reader.println();
                                throw new IOException("Input stream closed");
                            }
                            if ((input = new String(input)).length() == 0) continue block8;
                            String[] sa = input.split(" ", 2);
                            localOptions.put(sa[0], sa[1]);
                        }
                    }
                }
                options.putAll(localOptions);
                if (iterOptions.validateOptions(options)) continue;
                reader.println((CharSequence)("invalid options for " + clazz.getName()));
            } while (!iterOptions.validateOptions(options));
        } else {
            reader.flush();
            reader.println((CharSequence)"The iterator class does not implement OptionDescriber. Consider this for better iterator configuration using this setiter command.");
            iteratorName = reader.readLine("Name for iterator (enter to skip): ");
            if (null == iteratorName) {
                reader.println();
                throw new IOException("Input stream closed");
            }
            if (StringUtils.isWhitespace((String)iteratorName)) {
                iteratorName = null;
            }
            reader.flush();
            reader.println((CharSequence)"Optional, configure name-value options for iterator:");
            String prompt = Shell.repeat("-", 10) + "> set option (<name> <value>, hit enter to skip): ";
            HashMap<String, String> localOptions = new HashMap<String, String>();
            while (true) {
                reader.flush();
                String input = reader.readLine(prompt);
                if (input == null) {
                    reader.println();
                    throw new IOException("Input stream closed");
                }
                if (StringUtils.isWhitespace((String)input)) break;
                String[] sa = input.split(" ", 2);
                localOptions.put(sa[0], sa[1]);
            }
            options.putAll(localOptions);
        }
        return iteratorName;
    }

    @Override
    public String description() {
        return "sets a table-specific or namespace-specific iterator";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.priorityOpt = new Option("p", "priority", true, "the order in which the iterator is applied");
        this.priorityOpt.setArgName("pri");
        this.priorityOpt.setRequired(true);
        this.nameOpt = new Option("n", "name", true, "iterator to set");
        this.nameOpt.setArgName("itername");
        this.allScopeOpt = new Option("all", "all-scopes", false, "applied at scan time, minor and major compactions");
        this.mincScopeOpt = new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "applied at minor compaction");
        this.majcScopeOpt = new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "applied at major compaction");
        this.scanScopeOpt = new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "applied at scan time");
        OptionGroup typeGroup = new OptionGroup();
        this.classnameTypeOpt = new Option("class", "class-name", true, "a java class that implements SortedKeyValueIterator");
        this.classnameTypeOpt.setArgName("name");
        this.aggTypeOpt = new Option("agg", "aggregator", false, "an aggregating type");
        this.regexTypeOpt = new Option("regex", "regular-expression", false, "a regex matching iterator");
        this.versionTypeOpt = new Option("vers", "version", false, "a versioning iterator");
        this.reqvisTypeOpt = new Option("reqvis", "require-visibility", false, "an iterator that omits entries with empty visibilities");
        this.ageoffTypeOpt = new Option("ageoff", "ageoff", false, "an aging off iterator");
        typeGroup.addOption(this.classnameTypeOpt);
        typeGroup.addOption(this.aggTypeOpt);
        typeGroup.addOption(this.regexTypeOpt);
        typeGroup.addOption(this.versionTypeOpt);
        typeGroup.addOption(this.reqvisTypeOpt);
        typeGroup.addOption(this.ageoffTypeOpt);
        typeGroup.setRequired(true);
        OptionGroup tableGroup = new OptionGroup();
        tableGroup.addOption(OptUtil.tableOpt("table to configure iterators on"));
        tableGroup.addOption(OptUtil.namespaceOpt("namespace to configure iterators on"));
        o.addOption(this.priorityOpt);
        o.addOption(this.nameOpt);
        o.addOption(this.allScopeOpt);
        o.addOption(this.mincScopeOpt);
        o.addOption(this.majcScopeOpt);
        o.addOption(this.scanScopeOpt);
        o.addOptionGroup(typeGroup);
        o.addOptionGroup(tableGroup);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

