/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.io.InputStream;
import java.util.Collections;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.resource.Get;

public class ProcessInstanceDiagramResource
extends BaseProcessInstanceResource {
    @Get
    public InputRepresentation getProcessInstanceDiagram() {
        ProcessInstance processInstance = this.getProcessInstanceFromRequest();
        ProcessDefinitionEntity pde = (ProcessDefinitionEntity)((RepositoryServiceImpl)ActivitiUtil.getRepositoryService()).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        if (pde != null && pde.isGraphicalNotationDefined()) {
            BpmnModel bpmnModel = ActivitiUtil.getRepositoryService().getBpmnModel(pde.getId());
            ProcessEngineConfiguration processEngineConfiguration = ActivitiUtil.getProcessEngine().getProcessEngineConfiguration();
            ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
            InputStream resource = diagramGenerator.generateDiagram(bpmnModel, "png", ActivitiUtil.getRuntimeService().getActiveActivityIds(processInstance.getId()), Collections.emptyList(), processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getClassLoader(), 1.0);
            InputRepresentation output = new InputRepresentation(resource, MediaType.IMAGE_PNG);
            return output;
        }
        throw new ActivitiIllegalArgumentException("Process instance with id '" + processInstance.getId() + "' has no graphical notation defined.");
    }
}

