/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.identity;

import org.activiti.engine.IdentityService;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.identity.LegacyStateResponse;
import org.restlet.data.Status;
import org.restlet.resource.Delete;

public class LegacyUserGroupsDeleteResource
extends SecuredResource {
    @Delete
    public LegacyStateResponse deleteGroup() {
        if (!this.authenticate()) {
            return null;
        }
        String userId = (String)this.getRequest().getAttributes().get("userId");
        String groupId = (String)this.getRequest().getAttributes().get("groupId");
        if (userId == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No userId provided.");
            return new LegacyStateResponse().setSuccess(false);
        }
        if (groupId == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No groupId provided.");
            return new LegacyStateResponse().setSuccess(false);
        }
        IdentityService identityService = ActivitiUtil.getIdentityService();
        if (identityService.createUserQuery().userId(userId).singleResult() == null) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "The user '" + userId + "' does not exist.");
            return new LegacyStateResponse().setSuccess(false);
        }
        Group group = (Group)identityService.createGroupQuery().groupMember(userId).groupId(groupId).singleResult();
        if (group != null) {
            identityService.deleteMembership(userId, groupId);
        }
        return new LegacyStateResponse().setSuccess(true);
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

