/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.User;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserInfoRequest;
import org.activiti.rest.service.api.identity.UserInfoResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class UserInfoCollectionResource
extends BaseUserResource {
    @Get
    public List<UserInfoResponse> getUserInfo() {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        RestResponseFactory factory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        ArrayList<UserInfoResponse> responses = new ArrayList<UserInfoResponse>();
        for (String key : ActivitiUtil.getIdentityService().getUserInfoKeys(user.getId())) {
            responses.add(factory.createUserInfoResponse(this, key, null, user.getId()));
        }
        return responses;
    }

    @Post
    public UserInfoResponse setUserInfo(UserInfoRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        User user = this.getUserFromRequest();
        if (request.getKey() == null) {
            throw new ActivitiIllegalArgumentException("The key cannot be null.");
        }
        if (request.getValue() == null) {
            throw new ActivitiIllegalArgumentException("The value cannot be null.");
        }
        String existingValue = ActivitiUtil.getIdentityService().getUserInfo(user.getId(), request.getKey());
        if (existingValue != null) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "User info with key '" + request.getKey() + "' already exists for this user.", null, null);
        }
        ActivitiUtil.getIdentityService().setUserInfo(user.getId(), request.getKey(), request.getValue());
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserInfoResponse(this, request.getKey(), request.getValue(), user.getId());
    }
}

