/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.HashMap;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.UserQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.identity.UserPaginateList;
import org.activiti.rest.service.api.identity.UserRequest;
import org.activiti.rest.service.api.identity.UserResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class UserCollectionResource
extends SecuredResource {
    protected static HashMap<String, QueryProperty> properties = new HashMap();

    @Get(value="json")
    public DataResponse getUsers() {
        if (!this.authenticate()) {
            return null;
        }
        UserQuery query = ActivitiUtil.getIdentityService().createUserQuery();
        Form form = this.getQuery();
        Set names = form.getNames();
        if (names.contains("id")) {
            query.userId(this.getQueryParameter("id", form));
        }
        if (names.contains("firstName")) {
            query.userFirstName(this.getQueryParameter("firstName", form));
        }
        if (names.contains("lastName")) {
            query.userLastName(this.getQueryParameter("lastName", form));
        }
        if (names.contains("email")) {
            query.userEmail(this.getQueryParameter("email", form));
        }
        if (names.contains("firstNameLike")) {
            query.userFirstNameLike(this.getQueryParameter("firstNameLike", form));
        }
        if (names.contains("lastNameLike")) {
            query.userLastNameLike(this.getQueryParameter("lastNameLike", form));
        }
        if (names.contains("emailLike")) {
            query.userEmailLike(this.getQueryParameter("emailLike", form));
        }
        if (names.contains("memberOfGroup")) {
            query.memberOfGroup(this.getQueryParameter("memberOfGroup", form));
        }
        if (names.contains("potentialStarter")) {
            query.potentialStarter(this.getQueryParameter("potentialStarter", form));
        }
        return new UserPaginateList(this).paginateList(form, (Query)query, "id", properties);
    }

    @Post
    public UserResponse createUser(UserRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        if (request.getId() == null) {
            throw new ActivitiIllegalArgumentException("Id cannot be null.");
        }
        if (ActivitiUtil.getIdentityService().createUserQuery().userId(request.getId()).count() > 0L) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "A user with id '" + request.getId() + "' already exists.", null, null);
        }
        User created = ActivitiUtil.getIdentityService().newUser(request.getId());
        created.setEmail(request.getEmail());
        created.setFirstName(request.getFirstName());
        created.setLastName(request.getLastName());
        created.setPassword(request.getPassword());
        ActivitiUtil.getIdentityService().saveUser(created);
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createUserResponse(this, created, true);
    }

    static {
        properties.put("id", (QueryProperty)UserQueryProperty.USER_ID);
        properties.put("firstName", (QueryProperty)UserQueryProperty.FIRST_NAME);
        properties.put("lastName", (QueryProperty)UserQueryProperty.LAST_NAME);
        properties.put("email", (QueryProperty)UserQueryProperty.EMAIL);
    }
}

