/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.history.HistoricTaskInstanceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class HistoricTaskInstanceResource
extends SecuredResource {
    @Get
    public HistoricTaskInstanceResponse getTaskInstance() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createHistoricTaskInstanceResponse(this, this.getHistoricTaskInstanceFromRequest());
    }

    @Delete
    public void deleteTaskInstance() {
        if (!this.authenticate()) {
            return;
        }
        String taskId = this.getAttribute("taskId");
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("The taskId cannot be null");
        }
        ActivitiUtil.getHistoryService().deleteHistoricTaskInstance(taskId);
    }

    protected HistoricTaskInstance getHistoricTaskInstanceFromRequest() {
        String taskId = this.getAttribute("taskId");
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("The taskId cannot be null");
        }
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)ActivitiUtil.getHistoryService().createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        if (taskInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a task instance with id '" + taskId + "'.", HistoricTaskInstance.class);
        }
        return taskInstance;
    }
}

