/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class HistoricProcessInstanceCommentResource
extends SecuredResource {
    @Get
    public CommentResponse getComment() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest();
        String commentId = this.getAttribute("commentId");
        if (commentId == null) {
            throw new ActivitiIllegalArgumentException("CommentId is required.");
        }
        Comment comment = ActivitiUtil.getTaskService().getComment(commentId);
        if (comment == null || comment.getProcessInstanceId() == null || !comment.getProcessInstanceId().equals(instance.getId())) {
            throw new ActivitiObjectNotFoundException("Process instance '" + instance.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestComment(this, comment);
    }

    @Delete
    public void deleteComment() {
        if (!this.authenticate()) {
            return;
        }
        HistoricProcessInstance instance = this.getHistoricProcessInstanceFromRequest();
        String commentId = this.getAttribute("commentId");
        if (commentId == null) {
            throw new ActivitiIllegalArgumentException("CommentId is required.");
        }
        Comment comment = ActivitiUtil.getTaskService().getComment(commentId);
        if (comment == null || comment.getProcessInstanceId() == null || !comment.getProcessInstanceId().equals(instance.getId())) {
            throw new ActivitiObjectNotFoundException("Process instance '" + instance.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        ActivitiUtil.getTaskService().deleteComment(commentId);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        return processInstance;
    }
}

