/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class AddIdentityLinkForProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String userId;
    protected String type;

    public AddIdentityLinkForProcessInstanceCmd(String processInstanceId, String userId, String type) {
        this.validateParams(processInstanceId, userId);
        this.processInstanceId = processInstanceId;
        this.userId = userId;
        this.type = type;
    }

    protected void validateParams(String processInstanceId, String userId) {
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        if (userId == null) {
            throw new ActivitiIllegalArgumentException("userId cannot be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstance = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process instance with id " + this.processInstanceId, ExecutionEntity.class);
        }
        processInstance.addIdentityLink(this.userId, this.type);
        return null;
    }
}

