/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.XMLStreamReaderUtil;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.converter.util.CommaSplitter;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.alfresco.AlfrescoUserTask;
import org.apache.commons.lang3.StringUtils;

public class UserTaskXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();
    protected static final List<ExtensionAttribute> defaultUserTaskAttributes = Arrays.asList(new ExtensionAttribute("http://activiti.org/bpmn", "formKey"), new ExtensionAttribute("http://activiti.org/bpmn", "dueDate"), new ExtensionAttribute("http://activiti.org/bpmn", "assignee"), new ExtensionAttribute("http://activiti.org/bpmn", "priority"), new ExtensionAttribute("http://activiti.org/bpmn", "candidateUsers"), new ExtensionAttribute("http://activiti.org/bpmn", "candidateGroups"), new ExtensionAttribute("http://activiti.org/bpmn", "category"), new ExtensionAttribute("http://activiti.org/bpmn", "skipExpression"));

    public UserTaskXMLConverter() {
        HumanPerformerParser humanPerformerParser = new HumanPerformerParser();
        this.childParserMap.put(humanPerformerParser.getElementName(), humanPerformerParser);
        PotentialOwnerParser potentialOwnerParser = new PotentialOwnerParser();
        this.childParserMap.put(potentialOwnerParser.getElementName(), potentialOwnerParser);
        CustomIdentityLinkParser customIdentityLinkParser = new CustomIdentityLinkParser();
        this.childParserMap.put(customIdentityLinkParser.getElementName(), customIdentityLinkParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return UserTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "userTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String expression;
        String formKey = xtr.getAttributeValue("http://activiti.org/bpmn", "formKey");
        UserTask userTask = null;
        if (StringUtils.isNotEmpty((CharSequence)formKey) && model.getUserTaskFormTypes() != null && model.getUserTaskFormTypes().contains(formKey)) {
            userTask = new AlfrescoUserTask();
        }
        if (userTask == null) {
            userTask = new UserTask();
        }
        BpmnXMLUtil.addXMLLocation(userTask, xtr);
        userTask.setDueDate(xtr.getAttributeValue("http://activiti.org/bpmn", "dueDate"));
        userTask.setCategory(xtr.getAttributeValue("http://activiti.org/bpmn", "category"));
        userTask.setFormKey(formKey);
        userTask.setAssignee(xtr.getAttributeValue("http://activiti.org/bpmn", "assignee"));
        userTask.setOwner(xtr.getAttributeValue("http://activiti.org/bpmn", "owner"));
        userTask.setPriority(xtr.getAttributeValue("http://activiti.org/bpmn", "priority"));
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue("http://activiti.org/bpmn", "candidateUsers"))) {
            expression = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateUsers");
            userTask.getCandidateUsers().addAll(this.parseDelimitedList(expression));
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue("http://activiti.org/bpmn", "candidateGroups"))) {
            expression = xtr.getAttributeValue("http://activiti.org/bpmn", "candidateGroups");
            userTask.getCandidateGroups().addAll(this.parseDelimitedList(expression));
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue("http://activiti.org/bpmn", "skipExpression"))) {
            expression = xtr.getAttributeValue("http://activiti.org/bpmn", "skipExpression");
            userTask.setSkipExpression(expression);
        }
        BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)userTask, defaultElementAttributes, defaultActivityAttributes, defaultUserTaskAttributes);
        this.parseChildElements(this.getXMLElementName(), (BaseElement)userTask, this.childParserMap, model, xtr);
        return userTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        this.writeQualifiedAttribute("assignee", userTask.getAssignee(), xtw);
        this.writeQualifiedAttribute("owner", userTask.getOwner(), xtw);
        this.writeQualifiedAttribute("candidateUsers", this.convertToDelimitedString(userTask.getCandidateUsers()), xtw);
        this.writeQualifiedAttribute("candidateGroups", this.convertToDelimitedString(userTask.getCandidateGroups()), xtw);
        this.writeQualifiedAttribute("dueDate", userTask.getDueDate(), xtw);
        this.writeQualifiedAttribute("category", userTask.getCategory(), xtw);
        this.writeQualifiedAttribute("formKey", userTask.getFormKey(), xtw);
        if (userTask.getPriority() != null) {
            this.writeQualifiedAttribute("priority", userTask.getPriority().toString(), xtw);
        }
        if (userTask.getSkipExpression() != null) {
            this.writeQualifiedAttribute("skipExpression", userTask.getSkipExpression(), xtw);
        }
        BpmnXMLUtil.writeCustomAttributes(userTask.getAttributes().values(), xtw, defaultElementAttributes, defaultActivityAttributes, defaultUserTaskAttributes);
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        didWriteExtensionStartElement = this.writeFormProperties((FlowElement)userTask, didWriteExtensionStartElement, xtw);
        didWriteExtensionStartElement = this.writeCustomIdentities(element, didWriteExtensionStartElement, xtw);
        return didWriteExtensionStartElement;
    }

    protected boolean writeCustomIdentities(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        UserTask userTask = (UserTask)element;
        if (userTask.getCustomUserIdentityLinks().isEmpty() && userTask.getCustomGroupIdentityLinks().isEmpty()) {
            return didWriteExtensionStartElement;
        }
        if (!didWriteExtensionStartElement) {
            xtw.writeStartElement("extensionElements");
            didWriteExtensionStartElement = true;
        }
        HashSet identityLinkTypes = new HashSet();
        identityLinkTypes.addAll(userTask.getCustomUserIdentityLinks().keySet());
        identityLinkTypes.addAll(userTask.getCustomGroupIdentityLinks().keySet());
        for (String identityType : identityLinkTypes) {
            this.writeCustomIdentities(userTask, identityType, (Set)userTask.getCustomUserIdentityLinks().get(identityType), (Set)userTask.getCustomGroupIdentityLinks().get(identityType), xtw);
        }
        return didWriteExtensionStartElement;
    }

    protected void writeCustomIdentities(UserTask userTask, String identityType, Set<String> users, Set<String> groups, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("activiti", "customResource", "http://activiti.org/bpmn");
        this.writeDefaultAttribute("name", identityType, xtw);
        ArrayList<String> identityList = new ArrayList<String>();
        if (users != null) {
            for (String userId : users) {
                identityList.add("user(" + userId + ")");
            }
        }
        if (groups != null) {
            for (String groupId : groups) {
                identityList.add("group(" + groupId + ")");
            }
        }
        String delimitedString = this.convertToDelimitedString(identityList);
        xtw.writeStartElement("resourceAssignmentExpression");
        xtw.writeStartElement("formalExpression");
        xtw.writeCharacters(delimitedString);
        xtw.writeEndElement();
        xtw.writeEndElement();
        xtw.writeEndElement();
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    public class CustomIdentityLinkParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "customResource";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String identityLinkType = xtr.getAttributeValue("http://activiti.org/bpmn", "name");
            if (identityLinkType == null) {
                identityLinkType = xtr.getAttributeValue(null, "name");
            }
            if (identityLinkType == null) {
                return;
            }
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((CharSequence)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                List<String> assignmentList = CommaSplitter.splitCommas(xtr.getElementText());
                for (String assignmentValue : assignmentList) {
                    if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                    String userPrefix = "user(";
                    String groupPrefix = "group(";
                    if (assignmentValue.startsWith(userPrefix)) {
                        assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).addCustomUserIdentityLink(assignmentValue, identityLinkType);
                        continue;
                    }
                    if (assignmentValue.startsWith(groupPrefix)) {
                        assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).addCustomGroupIdentityLink(assignmentValue, identityLinkType);
                        continue;
                    }
                    ((UserTask)parentElement).addCustomGroupIdentityLink(assignmentValue, identityLinkType);
                }
            }
        }
    }

    public class PotentialOwnerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "potentialOwner";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((CharSequence)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                List<String> assignmentList = CommaSplitter.splitCommas(xtr.getElementText());
                for (String assignmentValue : assignmentList) {
                    if (assignmentValue == null || (assignmentValue = assignmentValue.trim()).length() == 0) continue;
                    String userPrefix = "user(";
                    String groupPrefix = "group(";
                    if (assignmentValue.startsWith(userPrefix)) {
                        assignmentValue = assignmentValue.substring(userPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).getCandidateUsers().add(assignmentValue);
                        continue;
                    }
                    if (assignmentValue.startsWith(groupPrefix)) {
                        assignmentValue = assignmentValue.substring(groupPrefix.length(), assignmentValue.length() - 1).trim();
                        ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                        continue;
                    }
                    ((UserTask)parentElement).getCandidateGroups().add(assignmentValue);
                }
            }
        }
    }

    public class HumanPerformerParser
    extends BaseChildElementParser {
        @Override
        public String getElementName() {
            return "humanPerformer";
        }

        @Override
        public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
            String expression;
            String resourceElement = XMLStreamReaderUtil.moveDown(xtr);
            if (StringUtils.isNotEmpty((CharSequence)resourceElement) && "resourceAssignmentExpression".equals(resourceElement) && StringUtils.isNotEmpty((CharSequence)(expression = XMLStreamReaderUtil.moveDown(xtr))) && "formalExpression".equals(expression)) {
                ((UserTask)parentElement).setAssignee(xtr.getElementText());
            }
        }
    }
}

