/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BooleanDataObject;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DateDataObject;
import org.activiti.bpmn.model.DoubleDataObject;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.IntegerDataObject;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.LongDataObject;
import org.activiti.bpmn.model.StringDataObject;
import org.activiti.bpmn.model.ValuedDataObject;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ValuedDataObjectXMLConverter
extends BaseBpmnXMLConverter {
    protected boolean didWriteExtensionStartElement = false;

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ValuedDataObject.class;
    }

    @Override
    protected String getXMLElementName() {
        return "dataObject";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        StringDataObject dataObject = null;
        ItemDefinition itemSubjectRef = new ItemDefinition();
        String structureRef = xtr.getAttributeValue(null, "itemSubjectRef");
        if (StringUtils.isNotEmpty((CharSequence)structureRef) && structureRef.contains(":")) {
            String dataType = structureRef.substring(structureRef.indexOf(58) + 1);
            if (dataType.equals("string")) {
                dataObject = new StringDataObject();
            } else if (dataType.equals("int")) {
                dataObject = new IntegerDataObject();
            } else if (dataType.equals("long")) {
                dataObject = new LongDataObject();
            } else if (dataType.equals("double")) {
                dataObject = new DoubleDataObject();
            } else if (dataType.equals("boolean")) {
                dataObject = new BooleanDataObject();
            } else if (dataType.equals("datetime")) {
                dataObject = new DateDataObject();
            }
        } else {
            dataObject = new StringDataObject();
            structureRef = "xsd:string";
        }
        if (dataObject != null) {
            dataObject.setId(xtr.getAttributeValue(null, "id"));
            dataObject.setName(xtr.getAttributeValue(null, "name"));
            BpmnXMLUtil.addXMLLocation((BaseElement)dataObject, xtr);
            itemSubjectRef.setStructureRef(structureRef);
            dataObject.setItemSubjectRef(itemSubjectRef);
            this.parseChildElements(this.getXMLElementName(), (BaseElement)dataObject, model, xtr);
            List valuesElement = (List)dataObject.getExtensionElements().get("value");
            if (valuesElement != null && valuesElement.size() > 0) {
                ExtensionElement valueElement = (ExtensionElement)valuesElement.get(0);
                if (StringUtils.isNotEmpty((CharSequence)valueElement.getElementText())) {
                    if (dataObject instanceof DateDataObject) {
                        dataObject.setValue((Object)DateTime.parse((String)valueElement.getElementText(), (DateTimeFormatter)ISODateTimeFormat.dateOptionalTimeParser()).toDate());
                    } else {
                        dataObject.setValue((Object)valueElement.getElementText());
                    }
                }
                dataObject.getExtensionElements().remove("value");
            }
        }
        return dataObject;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (dataObject.getItemSubjectRef() != null && StringUtils.isNotEmpty((CharSequence)dataObject.getItemSubjectRef().getStructureRef())) {
            this.writeDefaultAttribute("itemSubjectRef", dataObject.getItemSubjectRef().getStructureRef(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ValuedDataObject dataObject = (ValuedDataObject)element;
        if (StringUtils.isNotEmpty((CharSequence)dataObject.getId()) && dataObject.getValue() != null) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            xtw.writeStartElement("activiti", "value", "http://activiti.org/bpmn");
            if (dataObject.getValue() != null) {
                String value = null;
                if (dataObject instanceof DateDataObject) {
                    DateTime dateTime = new DateTime((Object)((Date)dataObject.getValue()));
                    value = ISODateTimeFormat.dateTimeNoMillis().print((ReadableInstant)dateTime);
                } else {
                    value = dataObject.getValue().toString();
                }
                xtw.writeCharacters(value);
            }
            xtw.writeEndElement();
        }
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }
}

