/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import proguard.util.ObjectUtil;

public class ArrayUtil {
    public static boolean equal(byte[] array1, byte[] array2, int size) {
        for (int index = 0; index < size; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(short[] array1, short[] array2, int size) {
        for (int index = 0; index < size; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(int[] array1, int[] array2, int size) {
        for (int index = 0; index < size; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Object[] array1, Object[] array2, int size) {
        for (int index = 0; index < size; ++index) {
            if (array1[index].equals(array2[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalOrNull(Object[] array1, Object[] array2) {
        return array1 == null ? array2 == null : ArrayUtil.equalOrNull(array1, array2, array1.length);
    }

    public static boolean equalOrNull(Object[] array1, Object[] array2, int size) {
        return array1 == null ? array2 == null : array2 != null && ArrayUtil.equalOrNull(array1, array2, size);
    }

    public static int hashCode(byte[] array, int size) {
        int hashCode = 0;
        for (int index = 0; index < size; ++index) {
            hashCode ^= array[index];
        }
        return hashCode;
    }

    public static int hashCode(short[] array, int size) {
        int hashCode = 0;
        for (int index = 0; index < size; ++index) {
            hashCode ^= array[index];
        }
        return hashCode;
    }

    public static int hashCode(int[] array, int size) {
        int hashCode = 0;
        for (int index = 0; index < size; ++index) {
            hashCode ^= array[index];
        }
        return hashCode;
    }

    public static int hashCode(Object[] array, int size) {
        int hashCode = 0;
        for (int index = 0; index < size; ++index) {
            hashCode ^= array[index].hashCode();
        }
        return hashCode;
    }

    public static int hashCodeOrNull(Object[] array) {
        return array == null ? 0 : ArrayUtil.hashCode(array, array.length);
    }

    public static int hashCodeOrNull(Object[] array, int size) {
        return array == null ? 0 : ArrayUtil.hashCode(array, size);
    }

    public static int compare(byte[] array1, int size1, byte[] array2, int size2) {
        int minSize = Math.min(size1, size2);
        for (int index = 0; index < minSize; ++index) {
            if (array1[index] < array2[index]) {
                return -1;
            }
            if (array1[index] <= array2[index]) continue;
            return 1;
        }
        return size1 < size2 ? -1 : (size1 == size2 ? 0 : 1);
    }

    public static int compare(short[] array1, int size1, short[] array2, int size2) {
        int minSize = Math.min(size1, size2);
        for (int index = 0; index < minSize; ++index) {
            if (array1[index] < array2[index]) {
                return -1;
            }
            if (array1[index] <= array2[index]) continue;
            return 1;
        }
        return size1 < size2 ? -1 : (size1 == size2 ? 0 : 1);
    }

    public static int compare(int[] array1, int size1, int[] array2, int size2) {
        int minSize = Math.min(size1, size2);
        for (int index = 0; index < minSize; ++index) {
            if (array1[index] < array2[index]) {
                return -1;
            }
            if (array1[index] <= array2[index]) continue;
            return 1;
        }
        return size1 < size2 ? -1 : (size1 == size2 ? 0 : 1);
    }

    public static int compare(Comparable[] array1, int size1, Comparable[] array2, int size2) {
        int minSize = Math.min(size1, size2);
        for (int index = 0; index < minSize; ++index) {
            int comparison = ObjectUtil.compare(array1[index], array2[index]);
            if (comparison == 0) continue;
            return comparison;
        }
        return size1 < size2 ? -1 : (size1 == size2 ? 0 : 1);
    }

    public static boolean[] extendArray(boolean[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        boolean[] newArray = new boolean[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static boolean[] ensureArraySize(boolean[] array, int size, boolean initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = new boolean[size];
            if (initialValue) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }

    public static byte[] add(byte[] array, int size, byte element) {
        array = ArrayUtil.extendArray(array, size + 1);
        array[size] = element;
        return array;
    }

    public static byte[] insert(byte[] array, int size, int index, byte element) {
        array = ArrayUtil.extendArray(array, size + 1);
        System.arraycopy(array, index, array, index + 1, size - index);
        array[index] = element;
        return array;
    }

    public static void remove(byte[] array, int size, int index) {
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[size - 1] = 0;
    }

    public static byte[] extendArray(byte[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        byte[] newArray = new byte[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static byte[] ensureArraySize(byte[] array, int size, byte initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = new byte[size];
            if (initialValue != 0) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }

    public static short[] add(short[] array, int size, short element) {
        array = ArrayUtil.extendArray(array, size + 1);
        array[size] = element;
        return array;
    }

    public static short[] insert(short[] array, int size, int index, short element) {
        array = ArrayUtil.extendArray(array, size + 1);
        System.arraycopy(array, index, array, index + 1, size - index);
        array[index] = element;
        return array;
    }

    public static void remove(short[] array, int size, int index) {
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[size - 1] = 0;
    }

    public static short[] extendArray(short[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        short[] newArray = new short[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static short[] ensureArraySize(short[] array, int size, short initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = new short[size];
            if (initialValue != 0) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }

    public static int[] add(int[] array, int size, int element) {
        array = ArrayUtil.extendArray(array, size + 1);
        array[size] = element;
        return array;
    }

    public static int[] insert(int[] array, int size, int index, int element) {
        array = ArrayUtil.extendArray(array, size + 1);
        System.arraycopy(array, index, array, index + 1, size - index);
        array[index] = element;
        return array;
    }

    public static void remove(int[] array, int size, int index) {
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[size - 1] = 0;
    }

    public static int[] extendArray(int[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        int[] newArray = new int[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] ensureArraySize(int[] array, int size, int initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = new int[size];
            if (initialValue != 0) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }

    public static long[] add(long[] array, int size, long element) {
        array = ArrayUtil.extendArray(array, size + 1);
        array[size] = element;
        return array;
    }

    public static long[] insert(long[] array, int size, int index, long element) {
        array = ArrayUtil.extendArray(array, size + 1);
        System.arraycopy(array, index, array, index + 1, size - index);
        array[index] = element;
        return array;
    }

    public static void remove(long[] array, int size, int index) {
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[size - 1] = 0L;
    }

    public static long[] extendArray(long[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        long[] newArray = new long[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] ensureArraySize(long[] array, int size, long initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = new long[size];
            if (initialValue != 0L) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }

    public static Object[] add(Object[] array, int size, Object element) {
        array = ArrayUtil.extendArray(array, size + 1);
        array[size] = element;
        return array;
    }

    public static Object[] insert(Object[] array, int size, int index, Object element) {
        array = ArrayUtil.extendArray(array, size + 1);
        System.arraycopy(array, index, array, index + 1, size - index);
        array[index] = element;
        return array;
    }

    public static void remove(Object[] array, int size, int index) {
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[size - 1] = null;
    }

    public static Object[] extendArray(Object[] array, int size) {
        if (array.length >= size) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static Object[] ensureArraySize(Object[] array, int size, Object initialValue) {
        if (array.length >= size) {
            Arrays.fill(array, 0, size, initialValue);
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            if (initialValue != null) {
                Arrays.fill(array, 0, size, initialValue);
            }
        }
        return array;
    }
}

