/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.MethodOptimizationInfo;

public class ParameterUsageMarker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final boolean DEBUG = false;
    private final boolean markThisParameter;
    private final boolean markAllParameters;
    private final PartialEvaluator partialEvaluator = new PartialEvaluator();

    public ParameterUsageMarker() {
        this(false, false);
    }

    public ParameterUsageMarker(boolean markThisParameter, boolean markAllParameters) {
        this.markThisParameter = markThisParameter;
        this.markAllParameters = markAllParameters;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int parameterSize = ClassUtil.internalMethodParameterSize(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
        if (parameterSize > 0) {
            int accessFlags = programMethod.getAccessFlags();
            if (this.markThisParameter && (accessFlags & 8) == 0) {
                ParameterUsageMarker.markParameterUsed(programMethod, 0);
            }
            if (this.markAllParameters) {
                ParameterUsageMarker.markUsedParameters(programMethod, (accessFlags & 8) != 0 ? -1L : -2L);
            }
            if ((accessFlags & 0x100) != 0) {
                ParameterUsageMarker.markUsedParameters(programMethod, -1L);
            } else if ((accessFlags & 0x400) != 0) {
                ParameterUsageMarker.markParameterUsed(programMethod, 0);
            } else {
                if ((accessFlags & 8) == 0 && ((accessFlags & 0x20) != 0 || programClass.mayHaveImplementations(programMethod) || programMethod.getName(programClass).equals("<init>"))) {
                    ParameterUsageMarker.markParameterUsed(programMethod, 0);
                }
                programMethod.attributesAccept(programClass, this);
            }
        }
        ParameterUsageMarker.setParameterSize(programMethod, parameterSize);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (libraryClass.mayHaveImplementations(libraryMethod)) {
            ParameterUsageMarker.markUsedParameters(libraryMethod, -1L);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        Value producer;
        int parameterIndex;
        if (this.partialEvaluator.isTraced(offset) && variableInstruction.isLoad() && (parameterIndex = variableInstruction.variableIndex) < codeAttribute.u2maxLocals && (producer = this.partialEvaluator.getVariablesBefore(offset).getProducerValue(parameterIndex)) != null && producer.instructionOffsetValue().contains(-1)) {
            ParameterUsageMarker.markParameterUsed(method, parameterIndex);
            if (variableInstruction.isCategory2()) {
                ParameterUsageMarker.markParameterUsed(method, parameterIndex + 1);
            }
        }
    }

    private static void setParameterSize(Method method, int parameterSize) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setParameterSize(parameterSize);
        }
    }

    public static int getParameterSize(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null ? info.getParameterSize() : 0;
    }

    public static void markParameterUsed(Method method, int variableIndex) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setParameterUsed(variableIndex);
        }
    }

    public static void markUsedParameters(Method method, long usedParameters) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setUsedParameters(info.getUsedParameters() | usedParameters);
        }
    }

    public static boolean isParameterUsed(Method method, int variableIndex) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.isParameterUsed(variableIndex);
    }

    public static long getUsedParameters(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info != null ? info.getUsedParameters() : -1L;
    }
}

