/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.base.filter.DateValueFilter;
import com.mingsoft.base.filter.DoubleValueFilter;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IDictBiz;
import com.mingsoft.mdiy.entity.DictEntity;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/dict"})
public class DictAction
extends BaseAction {
    @Autowired
    private IDictBiz dictBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/mdiy/dict/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        dict.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List dictList = this.dictBiz.query((BaseEntity)dict);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (dict.getDictId() != null) {
            BaseEntity dictEntity = this.dictBiz.getEntity(dict.getDictId());
            model.addAttribute("dictEntity", (Object)dictEntity);
        }
        return this.view("/mdiy/dict/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (dict.getDictId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("dict.id")}));
            return;
        }
        DictEntity _dict = (DictEntity)this.dictBiz.getEntity(dict.getDictId());
        this.outJson(response, (BaseEntity)_dict);
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:save"})
    public void save(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        dict.setAppId(BasicUtil.getAppId());
        if (this.dictBiz.getByTypeAndLabel(dict.getDictType(), dict.getDictLabel()) != null) {
            this.outJson(response, null, false, this.getResString("diy.dict.type.and.label.repeat"));
            return;
        }
        this.dictBiz.saveEntity((BaseEntity)dict);
        this.outJson(response, true);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:del"})
    public void delete(@RequestBody List<DictEntity> dicts, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[dicts.size()];
        for (int i = 0; i < dicts.size(); ++i) {
            ids[i] = dicts.get(i).getDictId();
        }
        this.dictBiz.delete(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:update"})
    public void update(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        DictEntity _dict = this.dictBiz.getByTypeAndLabel(dict.getDictType(), dict.getDictLabel());
        if (_dict != null && !_dict.getDictId().equals(dict.getDictId())) {
            this.outJson(response, null, false, this.getResString("diy.dict.type.and.label.repeat"));
            return;
        }
        this.dictBiz.updateEntity((BaseEntity)dict);
        this.outJson(response, true);
    }
}

